/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.management;

import com.sun.messaging.jmq.management.DefaultTrustManager;
import java.io.IOException;
import java.net.Socket;
import java.rmi.server.RMISocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.rmi.ssl.SslRMIClientSocketFactory;

public class MQRMIClientSocketFactory
extends SslRMIClientSocketFactory {
    boolean debug = false;
    boolean isBrokerHostTrusted = true;
    boolean useSSL = false;
    String hostname = null;

    public MQRMIClientSocketFactory(String string, boolean bl, boolean bl2) {
        this.isBrokerHostTrusted = bl;
        this.hostname = string;
        this.useSSL = bl2;
    }

    public Socket createSocket(String string, int n) throws IOException {
        Socket socket = null;
        String string2 = this.hostname;
        if (string2 == null || string2.equals("*")) {
            string2 = string;
        }
        try {
            socket = this.useSSL ? this.makeSSLSocket(string2, n) : RMISocketFactory.getDefaultSocketFactory().createSocket(string2, n);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
        return socket;
    }

    public String toString() {
        return "hostname=" + this.hostname + ",isBrokerHostTrusted=" + this.isBrokerHostTrusted + ",useSSL=" + this.useSSL;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MQRMIClientSocketFactory)) {
            return false;
        }
        MQRMIClientSocketFactory mQRMIClientSocketFactory = (MQRMIClientSocketFactory)object;
        if (this.hostname != null ? mQRMIClientSocketFactory.hostname == null || !mQRMIClientSocketFactory.hostname.equals(this.hostname) : mQRMIClientSocketFactory.hostname != null) {
            return false;
        }
        if (this.isBrokerHostTrusted != mQRMIClientSocketFactory.isBrokerHostTrusted) {
            return false;
        }
        return this.useSSL == mQRMIClientSocketFactory.useSSL;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private SSLSocket makeSSLSocket(String string, int n) throws Exception {
        SSLSocketFactory sSLSocketFactory;
        if (this.isBrokerHostTrusted) {
            sSLSocketFactory = this.getTrustSocketFactory();
            if (this.debug) {
                System.err.println("Broker is trusted ...");
            }
        } else {
            sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        if (this.debug) {
            System.err.println("Create connection using SSL protocol ...");
            System.err.println("Broker Host: " + string);
            System.err.println("Broker Port: " + n);
        }
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n);
        boolean bl = true;
        String string2 = System.getProperty("imqTcpNoDelay", "true");
        if (string2.equals("false")) {
            bl = false;
        } else {
            sSLSocket.setTcpNoDelay(bl);
        }
        return sSLSocket;
    }

    private SSLSocketFactory getTrustSocketFactory() throws Exception {
        SSLSocketFactory sSLSocketFactory = null;
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        TrustManager[] trustManagerArray = new TrustManager[]{new DefaultTrustManager()};
        sSLContext.init(null, trustManagerArray, null);
        sSLSocketFactory = sSLContext.getSocketFactory();
        return sSLSocketFactory;
    }
}

