/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.ClusterTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.BaseTransactionManager;
import com.sun.messaging.jmq.jmsserver.persist.file.ClusterTransaction2PCompleteEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.ClusterTransaction2PPrepareEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.ClusterTransactionEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionLogManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ClusterTransactionManager
extends BaseTransactionManager {
    Map<TransactionUID, ClusterTransaction> incompleteTransactions = new HashMap<TransactionUID, ClusterTransaction>();

    ClusterTransactionManager(TransactionLogManager transactionLogManager) {
        super(transactionLogManager);
    }

    void processStoredTxnOnStartup(BaseTransaction baseTransaction) {
        Object object;
        if (Store.getDEBUG()) {
            object = this.getPrefix() + " processStoredTxnOnStartup " + baseTransaction;
            logger.log(4, (String)object);
        }
        object = baseTransaction.getTid();
        int n = baseTransaction.getState();
        if (n == 6 || n == 7) {
            this.addToCompleteStored(baseTransaction);
        } else if (n == 5) {
            this.addToIncompleteStored(baseTransaction);
        }
    }

    TransactionEvent generateEvent(BaseTransaction baseTransaction, boolean bl) throws IOException, BrokerException {
        Object object;
        if (Store.getDEBUG()) {
            object = this.getPrefix() + " generateEvent " + baseTransaction;
            logger.log(4, (String)object);
        }
        object = null;
        if (bl) {
            object = new ClusterTransaction2PCompleteEvent();
        } else if (baseTransaction.getState() == 5) {
            object = new ClusterTransaction2PPrepareEvent();
        } else {
            throw new UnsupportedOperationException();
        }
        ((ClusterTransactionEvent)object).clusterTransaction = (ClusterTransaction)baseTransaction;
        return object;
    }

    void processTxn(BaseTransaction baseTransaction) throws IOException, BrokerException {
        int n;
        if (Store.getDEBUG()) {
            String string = this.getPrefix() + " processTxn " + baseTransaction;
            logger.log(4, string);
        }
        if ((n = baseTransaction.getState()) != 5) {
            throw new UnsupportedOperationException();
        }
        this.addToIncompleteUnstored(baseTransaction);
    }

    BaseTransaction processTxnCompletion(TransactionUID transactionUID, int n) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            String string = this.getPrefix() + " processTxnCompletion " + transactionUID;
            logger.log(4, string);
        }
        boolean bl = false;
        return this.processTxnCompletion(transactionUID, n, bl);
    }

    void updateTransactionBrokerState(TransactionUID transactionUID, int n, TransactionBroker transactionBroker, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            Globals.getLogger().log(4, this.getPrefix() + " updateTransactionBrokerState " + transactionUID);
        }
        ClusterTransaction clusterTransaction = null;
        boolean bl2 = false;
        clusterTransaction = (ClusterTransaction)this.incompleteUnstored.get(transactionUID);
        if (clusterTransaction == null && (clusterTransaction = (ClusterTransaction)this.incompleteStored.get(transactionUID)) != null) {
            bl2 = true;
        }
        if (clusterTransaction != null) {
            boolean bl3 = this.updateTransactionBrokerState(transactionBroker, clusterTransaction);
            if (bl3) {
                clusterTransaction.getTransactionDetails().setComplete(true);
                if (!bl2) {
                    this.removeFromIncompleteUnstored(transactionUID);
                } else {
                    this.removeFromIncompleteStored(transactionUID);
                    this.addToCompleteStored(clusterTransaction);
                    try {
                        this.updateStoredCompletion(transactionUID, true);
                    }
                    catch (IOException iOException) {
                        throw new BrokerException("Could not update completion state of stored cluster transaction " + transactionUID, iOException);
                    }
                }
            }
        } else {
            logger.log(32, "Could not find matching cluster transaction for " + transactionUID);
        }
    }

    boolean updateTransactionBrokerState(TransactionBroker transactionBroker, ClusterTransaction clusterTransaction) {
        TransactionBroker[] transactionBrokerArray = clusterTransaction.getTransactionBrokers();
        TransactionBroker transactionBroker2 = null;
        BrokerAddress brokerAddress = transactionBroker.getBrokerAddress();
        boolean bl = true;
        for (int i = 0; i < transactionBrokerArray.length; ++i) {
            BrokerAddress brokerAddress2 = transactionBrokerArray[i].getCurrentBrokerAddress();
            if (brokerAddress2 == null) continue;
            if (brokerAddress2.equals(brokerAddress)) {
                transactionBroker2 = transactionBrokerArray[i];
                continue;
            }
            bl &= transactionBrokerArray[i].isCompleted();
        }
        transactionBroker2.setCompleted(true);
        return bl;
    }

    void replayTransactionEvent(TransactionEvent transactionEvent, HashSet hashSet) throws BrokerException, IOException {
        if (Store.getDEBUG()) {
            Globals.getLogger().log(4, this.getPrefix() + " replayTransactionEvent");
        }
        ClusterTransactionEvent clusterTransactionEvent = (ClusterTransactionEvent)transactionEvent;
        ClusterTransaction clusterTransaction = clusterTransactionEvent.clusterTransaction;
        int n = clusterTransaction.getState();
        TransactionUID transactionUID = clusterTransaction.getTid();
        if (clusterTransactionEvent.getSubType() == 1) {
            if (this.incompleteStored.containsKey(transactionUID)) {
                if (Store.getDEBUG()) {
                    String string = this.getPrefix() + " found matching txn in prepared store on replay " + clusterTransaction;
                    Globals.getLogger().log(4, string);
                }
            } else {
                this.addToIncompleteUnstored(clusterTransaction);
            }
        } else if (clusterTransactionEvent.getSubType() == 2) {
            BaseTransaction baseTransaction = null;
            if (this.incompleteUnstored.containsKey(transactionUID)) {
                baseTransaction = this.removeFromIncompleteUnstored(transactionUID);
            } else if (this.incompleteStored.containsKey(transactionUID)) {
                baseTransaction = this.removeFromIncompleteStored(transactionUID);
                this.updateStoredState(transactionUID, n);
                this.addToCompleteStored(baseTransaction);
            } else if (this.completeStored.containsKey(transactionUID)) {
                baseTransaction = (BaseTransaction)this.completeStored.get(transactionUID);
            }
            if (baseTransaction != null) {
                if (n == 6) {
                    this.transactionLogManager.replayTransactionWork(baseTransaction.getTransactionWork(), transactionUID, hashSet);
                }
            } else {
                logger.log(32, "Could not find prepared work for completing two-phase transaction " + clusterTransaction.getTid());
            }
        }
    }

    String getPrefix() {
        return "ClusterTransactionManager: " + Thread.currentThread().getName();
    }
}

