/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.bridge.BridgeServiceManager;
import com.sun.messaging.bridge.service.JMSBridgeStore;
import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.StoreManager;
import com.sun.messaging.jmq.jmsserver.persist.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConnectionPool;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.JDBCStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.PropertyDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.StoreSessionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.UpgradeHAStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.UpgradeStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.VersionDAO;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DBTool
implements DBConstants {
    static final String SQLFILEDIR_PROP = "imq.persist.jdbcsqlfile.dirpath";
    static final String SQLFILENAME_PROP = "imq.persist.jdbcsqlfile.name";
    static final String STORE_PROPERTY_HABROKERS = "imq.cluster.haBrokers";
    static final String STORE_PROPERTY_SUPPORT_JMSBRIDGE = "imq.bridge.jmsbridge.tables";
    private static int EXTRA_CMD_SPECIFIED = 0;
    private static int BAD_CMD_ARG = 1;
    private static int BAD_OPT = 2;
    private static int BAD_OPT_ARG = 3;
    private static int MISSING_OPT_ARG = 4;
    private static int MISSING_CMD_ARG = 5;
    private static int MISSING_OPT = 6;
    private static String CMD_NAME = "dbmgrcmd";
    private static String CREATE_ALL_CMD = "createall";
    private static String CREATE_TBL_CMD = "createtbl";
    private static String DELETE_TBL_CMD = "deletetbl";
    private static String RECREATE_TBL_CMD = "recreatetbl";
    private static String REMOVE_BKR_CMD = "removebkr";
    private static String REMOVE_JMSBRIDGE_CMD = "removejmsbridge";
    private static String DUMP_CMD = "dump";
    private static String DROPTBL_CMD = "droptbl";
    private static String RESET_CMD = "reset";
    private static String BACKUP_CMD = "backup";
    private static String RESTORE_CMD = "restore";
    private static String UPGRADE_STORE_CMD = "upgradestore";
    private static String UPGRADE_HASTORE_CMD = "upgradehastore";
    private static String QUERY_CMD = "query";
    private static String ARG_NAME = "dbmgrarg";
    private static String CREATE_CMD_STR = "create";
    private static String DELETE_CMD_STR = "delete";
    private static String RECREATE_CMD_STR = "recreate";
    private static String REMOVE_CMD_STR = "remove";
    private static String UPGRADE_CMD_STR = "upgrade";
    private static String ARGU_ALL = "all";
    private static String ARGU_TBL = "tbl";
    private static String ARGU_BKR = "bkr";
    private static String ARGU_JMSBRIDGE = "jmsbridge";
    private static String ARGU_OLDTBL = "oldtbl";
    private static String ARGU_LCK = "lck";
    private static String ARGU_STORE = "store";
    private static String ARGU_HASTORE = "hastore";
    private static String OPT_H = "-h";
    private static String OPT_LH = "-help";
    private static String OPT_V = "-v";
    private static String OPT_LV = "-version";
    private static String OPT_B = "-b";
    private static String OPT_N = "-n";
    private static String OPT_U = "-u";
    private static String OPT_P = "-p";
    private static String OPT_PW = "-pw";
    private static String OPT_PASSFILE = "-passfile";
    private static String OPT_D = "-D";
    private static String OPT_VARHOME = "-varhome";
    private static String OPT_VERBOSE = "-verbose";
    private static String OPT_DEBUG = "-debug";
    private static String OPT_DIR = "-dir";
    private static String OPT_FORCE = "-f";
    private static String JMSBRIDGE_NAME_PROPERTY = "jmsbridge.name";
    private static BrokerResources br = Globals.getBrokerResources();
    private static BrokerConfig config;
    private static Logger logger;
    private Version version = new Version();
    private DBManager dbmgr = null;
    private boolean standalone = true;
    private boolean cliPasswdSpecified = false;
    private boolean debugSpecified = false;
    private boolean forceSpecified = false;

    DBTool(boolean bl) {
        this.standalone = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doCreate(boolean bl) throws BrokerException {
        Connection connection = null;
        try {
            block14: {
                try {
                    if (bl) {
                        connection = this.dbmgr.connectToCreate();
                        connection.setAutoCommit(true);
                    } else {
                        connection = this.dbmgr.newConnection(true);
                    }
                    boolean bl2 = false;
                    int n = this.dbmgr.checkStoreExists(connection);
                    if (n > 0) {
                        throw new BrokerException(br.getKString("B3210"));
                    }
                    if (n < 0) {
                        bl2 = true;
                    }
                    DBTool.createTables(connection, bl2);
                    if (!this.standalone) break block14;
                    if (Globals.getHAEnabled()) {
                        System.out.println(br.getString("B1165", Globals.getClusterID()));
                    } else {
                        System.out.println(br.getString("B1046"));
                    }
                }
                catch (Throwable throwable) {
                    String string;
                    if (bl) {
                        string = this.dbmgr.getCreateDBURL();
                        throw new BrokerException(br.getKString("B3073", string, throwable));
                    }
                    string = this.dbmgr.getOpenDBURL();
                    throw new BrokerException(br.getKString("B3073", string, throwable));
                }
            }
            Object var6_7 = null;
            if (bl) return;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (bl) throw throwable;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "Unable to close JDBC resources", sQLException));
            }
        }
        try {}
        catch (SQLException sQLException) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "Unable to close JDBC resources", sQLException));
        }
        connection.close();
    }

    static void createTables(Connection connection) throws BrokerException {
        DBTool.createTables(connection, false);
    }

    static void createTables(Connection connection, boolean bl) throws BrokerException {
        DBTool.createTables(connection, bl, null);
    }

    static void createTables(Connection connection, boolean bl, ArrayList arrayList) throws BrokerException {
        BaseDAO baseDAO;
        DBManager dBManager = DBManager.getDBManager();
        DAOFactory dAOFactory = dBManager.getDAOFactory();
        Iterator iterator = null;
        iterator = arrayList != null ? arrayList.iterator() : dAOFactory.getAllDAOs().iterator();
        block8: while (iterator.hasNext()) {
            baseDAO = (BaseDAO)iterator.next();
            try {
                Util.RetryStrategy retryStrategy = null;
                while (true) {
                    try {
                        baseDAO.createTable(connection);
                        continue block8;
                    }
                    catch (Exception exception) {
                        if (retryStrategy == null) {
                            retryStrategy = new Util.RetryStrategy();
                        }
                        retryStrategy.assertShouldRetry(exception);
                        continue;
                    }
                    break;
                }
            }
            catch (BrokerException brokerException) {
                if (Globals.getHAEnabled()) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (dBManager.checkStoreExists(connection) > 0) {
                    if (arrayList == null) {
                        Globals.getLogger().log(16, "B3073", (Object)Globals.getBrokerResources().getString("B3210"));
                        bl = true;
                        break;
                    }
                    Globals.getLogger().log(16, "B3073", (Object)Globals.getBrokerResources().getString("B3237", baseDAO.getTableName()));
                    break;
                }
                if (bl) {
                    Globals.getLogger().log(16, brokerException.toString(), brokerException.getCause());
                    continue;
                }
                throw brokerException;
            }
        }
        if (arrayList != null) {
            return;
        }
        baseDAO = dAOFactory.getVersionDAO();
        try {
            if (bl) {
                int n = baseDAO.getStoreVersion(connection);
                if (n != 410) {
                    baseDAO.insert(connection, 410);
                }
            } else {
                baseDAO.insert(connection, 410);
            }
        }
        catch (BrokerException brokerException) {
            if (Globals.getHAEnabled()) {
                int n = baseDAO.getStoreVersion(connection);
                if (n != 410) {
                    throw brokerException;
                }
            }
            throw brokerException;
        }
        if (!Globals.getHAEnabled()) {
            String string = Globals.getBrokerID();
            StoreSessionDAO storeSessionDAO = dAOFactory.getStoreSessionDAO();
            if (storeSessionDAO.getStoreSession(connection, string) <= 0L) {
                storeSessionDAO.insert(connection, string, new UID().longValue());
            }
        }
        PropertyDAO propertyDAO = dAOFactory.getPropertyDAO();
        propertyDAO.update(connection, STORE_PROPERTY_SUPPORT_JMSBRIDGE, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateStoreVersion410IfNecessary(Connection connection) throws BrokerException {
        try {
            DBManager dBManager;
            DAOFactory dAOFactory;
            VersionDAO versionDAO;
            int n;
            if (!Globals.getHAEnabled()) {
                DBManager.lockTables(connection, true);
            }
            if ((n = (versionDAO = (dAOFactory = (dBManager = DBManager.getDBManager()).getDAOFactory()).getVersionDAO()).getStoreVersion(connection)) != 410) {
                throw new BrokerException(br.getKString("B3092", String.valueOf(n), String.valueOf(410)));
            }
            PropertyDAO propertyDAO = dAOFactory.getPropertyDAO();
            if (!propertyDAO.hasProperty(connection, STORE_PROPERTY_SUPPORT_JMSBRIDGE)) {
                ArrayList<BaseDAO> arrayList = new ArrayList<BaseDAO>();
                arrayList.add(dAOFactory.getTMLogRecordDAOJMSBG());
                arrayList.add(dAOFactory.getJMSBGDAO());
                DBTool.createTables(connection, false, arrayList);
                propertyDAO.update(connection, STORE_PROPERTY_SUPPORT_JMSBRIDGE, true);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!Globals.getHAEnabled()) {
                DBManager.lockTables(connection, false);
            }
            throw throwable;
        }
        if (!Globals.getHAEnabled()) {
            DBManager.lockTables(connection, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReset() throws BrokerException {
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            DBManager.lockTables(connection, false);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Util.close(null, null, connection);
            throw throwable;
        }
        Util.close(null, null, connection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doDelete(String string) throws BrokerException {
        boolean bl = false;
        Connection connection = null;
        try {
            block17: {
                try {
                    connection = this.dbmgr.getConnection(true);
                    if (string == null || string.length() == 0) {
                        boolean bl2 = false;
                        int n = this.dbmgr.checkStoreExists(connection);
                        if (n > 0) {
                            if (!this.forceSpecified && Globals.getHAEnabled() && this.dbmgr.isHAClusterActive(connection)) {
                                throw new BrokerException(br.getKString("B3209", this.dbmgr.getClusterID()));
                            }
                            try {
                                if (!this.forceSpecified) {
                                    DBManager.lockTables(connection, true);
                                }
                            }
                            catch (BrokerException brokerException) {
                                if (brokerException.getStatusCode() != 404) throw brokerException;
                                bl2 = true;
                            }
                        } else {
                            if (n >= 0) throw new BrokerException(br.getKString("B3211"));
                            bl2 = true;
                        }
                        bl = DBTool.dropTables(connection, null, bl2);
                    } else if (string.equals(ARGU_OLDTBL)) {
                        int n = -1;
                        if (DBTool.checkVersion(connection, "IMQSV37" + this.dbmgr.getBrokerID())) {
                            n = 370;
                        } else {
                            if (!DBTool.checkVersion(connection, "IMQSV35" + this.dbmgr.getBrokerID())) throw new BrokerException("Old persistent store (version 370) not found");
                            n = 350;
                        }
                        bl = DBTool.dropTables(connection, this.dbmgr.getTableNames(n));
                    }
                    if (!this.standalone || !bl) break block17;
                    if (Globals.getHAEnabled()) {
                        System.out.println(br.getString("B1166", Globals.getClusterID()));
                        break block17;
                    }
                    System.out.println(br.getString("B1051"));
                }
                catch (Exception exception) {
                    throw new BrokerException(br.getKString("B3075", this.dbmgr.getOpenDBURL()), exception);
                }
            }
            Object var8_9 = null;
            Util.close(null, null, connection);
            return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            Util.close(null, null, connection);
            throw throwable;
        }
    }

    static boolean dropTables(Connection connection, String[] stringArray) throws SQLException, BrokerException {
        return DBTool.dropTables(connection, stringArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean dropTables(Connection connection, String[] stringArray, boolean bl) throws SQLException, BrokerException {
        boolean bl2 = false;
        try {
            block15: {
                if (stringArray != null && stringArray.length > 0) {
                    Statement statement = null;
                    try {
                        statement = connection.createStatement();
                        for (String string : stringArray) {
                            Globals.getLogger().logToAll(8, br.getString("B1164", string));
                            statement.executeUpdate("DROP TABLE " + string);
                        }
                        Object var9_15 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_16 = null;
                        Util.close(null, statement, null);
                        throw throwable;
                    }
                    Util.close(null, statement, null);
                    {
                        break block15;
                    }
                }
                DAOFactory dAOFactory = DBManager.getDBManager().getDAOFactory();
                block10: for (BaseDAO baseDAO : dAOFactory.getAllDAOs()) {
                    try {
                        Util.RetryStrategy retryStrategy = null;
                        while (true) {
                            try {
                                baseDAO.dropTable(connection);
                                continue block10;
                            }
                            catch (Exception exception) {
                                if (retryStrategy == null) {
                                    retryStrategy = new Util.RetryStrategy();
                                }
                                retryStrategy.assertShouldRetry(exception);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (BrokerException brokerException) {
                        if (bl) {
                            Globals.getLogger().log(16, brokerException.toString(), brokerException.getCause());
                            continue;
                        }
                        throw brokerException;
                    }
                }
            }
            bl2 = true;
        }
        catch (SQLException sQLException) {
            Globals.getLogger().log(32, "B3075", (Object)sQLException.toString(), (Throwable)sQLException);
            throw sQLException;
        }
        catch (BrokerException brokerException) {
            Globals.getLogger().log(32, "B3075", (Object)brokerException.toString(), (Throwable)brokerException);
            throw brokerException;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean checkVersion(Connection connection, String string) throws BrokerException {
        String string2 = "SELECT * FROM " + string;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string2);
            }
            catch (SQLException sQLException) {
                boolean bl = false;
                Object var8_6 = null;
                Util.close(resultSet, statement, null);
                return bl;
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            Util.close(resultSet, statement, null);
            throw throwable;
        }
        Util.close(resultSet, statement, null);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRecreate() throws BrokerException {
        Connection connection = null;
        try {
            block15: {
                try {
                    connection = this.dbmgr.getConnection(true);
                    boolean bl = false;
                    boolean bl2 = false;
                    int n = this.dbmgr.checkStoreExists(connection);
                    if (n > 0) {
                        if (!this.forceSpecified && Globals.getHAEnabled() && this.dbmgr.isHAClusterActive(connection)) {
                            throw new BrokerException(br.getKString("B3209", this.dbmgr.getClusterID()));
                        }
                        try {
                            if (!this.forceSpecified) {
                                DBManager.lockTables(connection, true);
                            }
                        }
                        catch (BrokerException brokerException) {
                            if (brokerException.getStatusCode() != 404) throw brokerException;
                            bl2 = true;
                        }
                    } else if (n < 0) {
                        bl2 = true;
                    } else {
                        bl = true;
                    }
                    if (!bl) {
                        DBTool.dropTables(connection, null, bl2);
                    }
                    DBTool.createTables(connection, false);
                    if (!this.standalone) break block15;
                    if (Globals.getHAEnabled()) {
                        System.out.println(br.getString("B1165", Globals.getClusterID()));
                        break block15;
                    }
                    System.out.println(br.getString("B1046"));
                }
                catch (Throwable throwable) {
                    throw new BrokerException(br.getKString("B3076", this.dbmgr.getOpenDBURL()), throwable);
                }
            }
            Object var7_7 = null;
            Util.close(null, null, connection);
            return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            Util.close(null, null, connection);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemoveBkr() throws BrokerException {
        String string = Globals.getBrokerID();
        Connection connection = null;
        String string2 = null;
        try {
            try {
                connection = this.dbmgr.getConnection(true);
                DBManager.lockTables(connection, true);
                try {
                    block12: {
                        DAOFactory dAOFactory = this.dbmgr.getDAOFactory();
                        BrokerDAO brokerDAO = dAOFactory.getBrokerDAO();
                        BrokerState brokerState = brokerDAO.getState(connection, string);
                        if (!brokerState.isActiveState()) {
                            try {
                                connection.setAutoCommit(false);
                                dAOFactory.getConsumerStateDAO().deleteAll(connection);
                                dAOFactory.getMessageDAO().deleteAll(connection);
                                dAOFactory.getDestinationDAO().deleteAll(connection);
                                dAOFactory.getTransactionDAO().deleteAll(connection);
                                dAOFactory.getStoreSessionDAO().deleteByBrokerID(connection, string);
                                brokerDAO.delete(connection, string);
                                dAOFactory.getTMLogRecordDAOJMSBG().deleteAll(connection);
                                dAOFactory.getJMSBGDAO().deleteAll(connection);
                                connection.commit();
                                Object var8_8 = null;
                            }
                            catch (Throwable throwable) {
                                Object var8_9 = null;
                                connection.setAutoCommit(true);
                                throw throwable;
                            }
                            connection.setAutoCommit(true);
                            {
                                break block12;
                            }
                        }
                        string2 = br.getString("B3182", string, "broker is still active - " + brokerState);
                    }
                    Object var10_11 = null;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    DBManager.lockTables(connection, false);
                    throw throwable;
                }
                DBManager.lockTables(connection, false);
                Object var12_14 = null;
            }
            catch (Exception exception) {
                throw new BrokerException(br.getKString("B3183", string), exception);
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            Util.close(null, null, connection);
            throw throwable;
        }
        Util.close(null, null, connection);
        if (this.standalone) {
            if (string2 == null) {
                System.out.println(br.getString("B1167", string));
            } else {
                System.out.println(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRemoveJMSBridge(String string) throws BrokerException {
        String string2;
        Connection connection;
        block16: {
            block15: {
                if (string == null) {
                    try {
                        this.checkArg(null, null, OPT_N, 0, 0);
                    }
                    catch (ParserException parserException) {
                        this.handleParserException(parserException);
                        this.exit(1);
                    }
                }
                String string3 = Globals.getBrokerID();
                connection = null;
                string2 = null;
                try {
                    try {
                        if (!this.askConfirmation("Removing JMS Bridge " + string + ".")) {
                            Object var13_6 = null;
                            break block15;
                        }
                        connection = this.dbmgr.getConnection(true);
                        DBManager.lockTables(connection, true);
                        try {
                            DAOFactory dAOFactory = this.dbmgr.getDAOFactory();
                            BrokerDAO brokerDAO = dAOFactory.getBrokerDAO();
                            BrokerState brokerState = brokerDAO.getState(connection, string3);
                            if (!brokerState.isActiveState()) {
                                try {
                                    connection.setAutoCommit(false);
                                    dAOFactory.getJMSBGDAO().delete(connection, string, null);
                                    dAOFactory.getTMLogRecordDAOJMSBG().deleteAllByName(connection, string, null);
                                    connection.commit();
                                    Object var9_13 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var9_14 = null;
                                    connection.setAutoCommit(true);
                                    throw throwable;
                                }
                                connection.setAutoCommit(true);
                            } else {
                                string2 = br.getString("B3238");
                            }
                            Object var11_16 = null;
                        }
                        catch (Throwable throwable) {
                            Object var11_17 = null;
                            DBManager.lockTables(connection, false);
                            throw throwable;
                        }
                        DBManager.lockTables(connection, false);
                        break block16;
                    }
                    catch (Exception exception) {
                        throw new BrokerException(br.getString("B3239", string, exception.getMessage()), exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var13_8 = null;
                    Util.close(null, null, connection);
                    throw throwable;
                }
            }
            Util.close(null, null, connection);
            return;
        }
        Object var13_7 = null;
        Util.close(null, null, connection);
        if (!this.standalone) return;
        if (string2 == null) {
            System.out.println(br.getString("B1323", string));
            return;
        }
        System.out.println(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpgrade(boolean bl) throws BrokerException {
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            if (bl) {
                new UpgradeHAStore().upgradeStore(connection);
            } else {
                JDBCStore jDBCStore = (JDBCStore)StoreManager.getStore();
                int n = -1;
                if (jDBCStore.checkOldStoreVersion(connection, this.dbmgr.getTableName("MQVER40"), "STORE_VERSION", 400)) {
                    n = 400;
                } else if (jDBCStore.checkOldStoreVersion(connection, "IMQSV37" + this.dbmgr.getBrokerID(), "STOREVERSION", 370)) {
                    n = 370;
                } else if (jDBCStore.checkOldStoreVersion(connection, "IMQSV35" + this.dbmgr.getBrokerID(), "STOREVERSION", 350)) {
                    n = 350;
                } else {
                    throw new BrokerException("Old persistent store (version 400) not found");
                }
                new UpgradeStore(jDBCStore, n).upgradeStore(connection);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Util.close(null, null, connection);
            throw throwable;
        }
        Util.close(null, null, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDump(String string) throws SQLException, BrokerException {
        int n = 410;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        String[] stringArray = null;
        if (n != 410 && ((stringArray = this.dbmgr.getTableNames(n)) == null || stringArray.length == 0)) {
            throw new BrokerException("version " + string + " not supported");
        }
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            DBTool.doDump(connection, stringArray);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            Util.close(null, null, connection);
            throw throwable;
        }
        Util.close(null, null, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doDump(Connection connection, String[] stringArray) throws BrokerException, SQLException {
        block8: {
            if (stringArray != null && stringArray.length > 0) {
                Statement statement = null;
                try {
                    statement = connection.createStatement();
                    for (int i = 0; i < stringArray.length; ++i) {
                        ResultSet resultSet = null;
                        String string = stringArray[i];
                        String string2 = "SELECT COUNT(*) FROM " + string;
                        try {
                            resultSet = statement.executeQuery(string2);
                            if (resultSet.next()) {
                                System.out.println(string + ": number of row=" + resultSet.getInt(1));
                            }
                            resultSet.close();
                            continue;
                        }
                        catch (SQLException sQLException) {
                            SQLException sQLException2 = DBManager.wrapSQLException("[" + string2 + "]", sQLException);
                            logger.log(32, "failed to dump tables", (Throwable)sQLException2);
                        }
                    }
                    Object var10_12 = null;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    Util.close(null, statement, null);
                    throw throwable;
                }
                Util.close(null, statement, null);
                {
                    break block8;
                }
            }
            DAOFactory dAOFactory = DBManager.getDBManager().getDAOFactory();
            for (BaseDAO baseDAO : dAOFactory.getAllDAOs()) {
                System.out.println(baseDAO.getDebugInfo(connection).toString());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doDropTablesByPattern(String string) throws BrokerException {
        Connection connection;
        block10: {
            block9: {
                block8: {
                    connection = null;
                    try {
                        try {
                            connection = this.dbmgr.getConnection(true);
                            Map map = this.dbmgr.getTableNamesFromDB(connection, string);
                            String[] stringArray = map.values().toArray(new String[0]);
                            if (stringArray == null || stringArray.length == 0) {
                                System.out.println("There were no tables that match the name pattern 'MQ*" + string + "'.");
                                Object var8_6 = null;
                                break block8;
                            }
                            System.out.println("Tables matching the name pattern 'MQ*" + string + "':");
                            int n = stringArray.length;
                            for (int i = 0; i < n; ++i) {
                                System.out.println("\t" + stringArray[i]);
                            }
                            if (!this.askConfirmation("Remove all tables that match 'MQ*" + string + "'.")) {
                                break block9;
                            }
                            DBTool.dropTables(connection, stringArray, true);
                            break block10;
                        }
                        catch (Exception exception) {
                            System.err.println("Failed to drop tables by name pattern: " + exception.getMessage());
                            throw new BrokerException(br.getKString("B3075", "table name pattern '" + string + "'"), exception);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        Util.close(null, null, connection);
                        throw throwable;
                    }
                }
                Util.close(null, null, connection);
                return;
            }
            Object var8_7 = null;
            Util.close(null, null, connection);
            return;
        }
        Object var8_8 = null;
        Util.close(null, null, connection);
    }

    private boolean askConfirmation(String string) throws IOException {
        if (this.forceSpecified) {
            return true;
        }
        System.out.println(string + "\nDo you wish to proceed? [y/n] ");
        System.out.flush();
        String string2 = new BufferedReader(new InputStreamReader(System.in)).readLine();
        return "y".equalsIgnoreCase(string2) || "yes".equalsIgnoreCase(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private void doBackup() throws BrokerException {
        block27: {
            Object[] objectArray2;
            if (!Globals.getHAEnabled()) {
                throw new BrokerException(br.getKString("B1230", this.dbmgr.getBrokerID()));
            }
            Properties properties = System.getProperties();
            String string = Globals.getClusterID();
            String string2 = (String)properties.get("imq.backupdir") + File.separator + string;
            logger.logToAll(8, "Backup persistent store for HA cluster " + string);
            FileStore fileStore = new FileStore(string2, false);
            fileStore.clearAll(false);
            JDBCStore jDBCStore = null;
            jDBCStore = (JDBCStore)StoreManager.getStore();
            Properties properties2 = jDBCStore.getAllProperties();
            for (Object[] objectArray2 : properties2.entrySet()) {
                fileStore.updateProperty((String)objectArray2.getKey(), objectArray2.getValue(), false);
            }
            Iterator<Map.Entry<Object, Object>> iterator = null;
            properties2 = null;
            objectArray2 = jDBCStore.getAllConfigRecords();
            ArrayList arrayList = (ArrayList)objectArray2[0];
            ArrayList arrayList2 = (ArrayList)objectArray2[1];
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                fileStore.storeConfigChangeRecord((Long)arrayList.get(i), (byte[])arrayList2.get(i), false);
            }
            objectArray2 = null;
            arrayList = null;
            arrayList2 = null;
            Consumer[] consumerArray = jDBCStore.getAllInterests();
            for (n = 0; n < consumerArray.length; ++n) {
                fileStore.storeInterest(consumerArray[n], false);
            }
            consumerArray = null;
            HashMap hashMap = jDBCStore.getAllBrokerInfos(true);
            ArrayList arrayList3 = new ArrayList(hashMap.values());
            fileStore.updateProperty(STORE_PROPERTY_HABROKERS, arrayList3, false);
            for (HABrokerInfo hABrokerInfo : arrayList3) {
                Object var35_45;
                String string3 = hABrokerInfo.getId();
                logger.logToAll(8, "Backup persistent data for broker " + string3);
                Store store = null;
                JMSBridgeStore jMSBridgeStore = null;
                try {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object6;
                    Object object7;
                    Object object82;
                    int n2;
                    String string4 = string2 + File.separator + string3;
                    store = new FileStore(string4, false);
                    ((FileStore)store).clearAll(false);
                    Destination[] destinationArray = jDBCStore.getAllDestinations(string3);
                    int n3 = destinationArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        object82 = destinationArray[n2].getDestinationUID();
                        object7 = ((FileStore)store).getDestination((DestinationUID)object82);
                        if (object7 != null) continue;
                        ((FileStore)store).storeDestination(destinationArray[n2], false);
                    }
                    n3 = destinationArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        object82 = jDBCStore.messageEnumeration(destinationArray[n2]);
                        while (object82.hasMoreElements()) {
                            object7 = destinationArray[n2].getDestinationUID();
                            object4 = jDBCStore.getInterestStates((DestinationUID)object7, (SysMessageID)(object6 = (object5 = (TransactionAcknowledgement[])object82.nextElement()).getSysMessageID()));
                            if (object4 == null || ((HashMap)object4).isEmpty()) {
                                ((FileStore)store).storeMessage((DestinationUID)object7, (Packet)object5, false);
                                continue;
                            }
                            int n4 = ((HashMap)object4).size();
                            object3 = new ConsumerUID[n4];
                            object2 = new int[n4];
                            object = ((HashMap)object4).entrySet().iterator();
                            int n5 = 0;
                            while (object.hasNext()) {
                                Map.Entry entry = object.next();
                                object3[n5] = (ConsumerUID)entry.getKey();
                                object2[n5] = (Integer)entry.getValue();
                                ++n5;
                            }
                            ((FileStore)store).storeMessage((DestinationUID)object7, (Packet)object5, (ConsumerUID[])object3, (int[])object2, false);
                        }
                    }
                    Collection collection = jDBCStore.getTransactions(string3);
                    for (Object object82 : collection) {
                        object7 = jDBCStore.getTransactionInfo((TransactionUID)object82);
                        object5 = jDBCStore.getTransactionAcks((TransactionUID)object82);
                        ((FileStore)store).storeTransaction((TransactionUID)object82, (TransactionInfo)object7, false);
                        int n6 = ((TransactionAcknowledgement[])object5).length;
                        for (int i = 0; i < n6; ++i) {
                            ((FileStore)store).storeTransactionAck((TransactionUID)object82, object5[i], false);
                        }
                    }
                    object82 = new Properties();
                    ((Properties)object82).setProperty("instanceRootDir", string4);
                    ((Properties)object82).setProperty("reset", "true");
                    ((Properties)object82).setProperty("logdomain", "imqdbmgr");
                    jMSBridgeStore = (JMSBridgeStore)BridgeServiceManager.getExportedService("com.sun.messaging.bridge.service.JMSBridgeStore", "JMS", (Properties)object82);
                    object7 = jDBCStore.getJMSBridgesByBroker(string3, null);
                    object5 = null;
                    object6 = object7.iterator();
                    while (object6.hasNext()) {
                        object5 = (String)object6.next();
                        jMSBridgeStore.addJMSBridge((String)object5, true, null);
                    }
                    jMSBridgeStore.closeJMSBridgeStore();
                    jMSBridgeStore = null;
                    object4 = jDBCStore.getNamesByBroker(string3, null);
                    Collections.sort(object4);
                    String string5 = null;
                    object3 = null;
                    object6 = object4.iterator();
                    while (object6.hasNext()) {
                        string5 = (String)object6.next();
                        if (object3 != null && object3.equals(string5)) continue;
                        object3 = string5;
                        ((Properties)object82).setProperty("jmsbridge", string5);
                        if (jMSBridgeStore != null) {
                            jMSBridgeStore.closeJMSBridgeStore();
                            jMSBridgeStore = null;
                        }
                        jMSBridgeStore = (JMSBridgeStore)BridgeServiceManager.getExportedService("com.sun.messaging.bridge.service.JMSBridgeStore", "JMS", (Properties)object82);
                        object2 = jDBCStore.getTMLogRecordsByNameByBroker(string5, string3, null);
                        object = null;
                        Iterator iterator2 = object2.iterator();
                        while (iterator2.hasNext()) {
                            object = (byte[])object6.next();
                            jMSBridgeStore.storeTMLogRecord(null, (byte[])object, (String)object3, true, null);
                        }
                    }
                    var35_45 = null;
                }
                catch (Throwable throwable) {
                    var35_45 = null;
                    store.close();
                    if (jMSBridgeStore != null) {
                        jMSBridgeStore.closeJMSBridgeStore();
                    }
                    throw throwable;
                }
                store.close();
                if (jMSBridgeStore == null) continue;
                jMSBridgeStore.closeJMSBridgeStore();
                {
                }
            }
            logger.logToAll(8, "Backup persistent store complete.");
            Object var37_47 = null;
            if (fileStore == null) break block27;
            try {
                fileStore.close();
                break block27;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            {
                break block27;
                catch (Throwable throwable) {
                    throw new BrokerException(br.getString("B3124"));
                }
            }
            catch (Throwable throwable) {
                Object var37_48 = null;
                if (fileStore != null) {
                    try {
                        fileStore.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                StoreManager.releaseStore(true);
                throw throwable;
            }
        }
        StoreManager.releaseStore(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private void doRestore() throws BrokerException {
        block31: {
            Object object;
            Object[] objectArray2;
            if (!Globals.getHAEnabled()) {
                throw new BrokerException(br.getKString("B1230", this.dbmgr.getBrokerID()));
            }
            Properties properties = System.getProperties();
            String string = Globals.getClusterID();
            String string2 = (String)properties.get("imq.backupdir") + File.separator + string;
            logger.logToAll(8, "Restore persistent store for HA cluster " + string + " from backup dir: " + string2);
            FileStore fileStore = new FileStore(string2, false);
            JDBCStore jDBCStore = null;
            this.doRecreate();
            jDBCStore = (JDBCStore)StoreManager.getStore();
            List list = null;
            Properties properties2 = fileStore.getAllProperties();
            for (Object[] objectArray2 : properties2.entrySet()) {
                object = (String)objectArray2.getKey();
                if (((String)object).equals(STORE_PROPERTY_HABROKERS)) {
                    list = (List)objectArray2.getValue();
                    continue;
                }
                jDBCStore.updateProperty((String)object, objectArray2.getValue(), false);
            }
            Iterator<Map.Entry<Object, Object>> iterator = null;
            properties2 = null;
            if (list == null || list.isEmpty()) {
                throw new BrokerException(br.getKString("B4221"));
            }
            objectArray2 = fileStore.getAllConfigRecords();
            object = (ArrayList)objectArray2[0];
            ArrayList arrayList = (ArrayList)objectArray2[1];
            int n = ((ArrayList)object).size();
            for (int i = 0; i < n; ++i) {
                jDBCStore.storeConfigChangeRecord((Long)((ArrayList)object).get(i), (byte[])arrayList.get(i), false);
            }
            objectArray2 = null;
            object = null;
            arrayList = null;
            Consumer[] consumerArray = fileStore.getAllInterests();
            for (n = 0; n < consumerArray.length; ++n) {
                jDBCStore.storeInterest(consumerArray[n], false);
            }
            consumerArray = null;
            for (HABrokerInfo hABrokerInfo : list) {
                jDBCStore.addBrokerInfo(hABrokerInfo, false);
            }
            for (HABrokerInfo hABrokerInfo : list) {
                Object var36_44;
                String string3 = hABrokerInfo.getId();
                long l = hABrokerInfo.getSessionID();
                logger.logToAll(8, "Restore persistent data for broker " + string3);
                Store store = null;
                JMSBridgeStore jMSBridgeStore = null;
                try {
                    Object object2;
                    Object[] objectArray3;
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object62;
                    int n2;
                    String string4 = string2 + File.separator + string3;
                    store = new FileStore(string4, false);
                    Destination[] destinationArray = ((FileStore)store).getAllDestinations();
                    int n3 = destinationArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        object62 = destinationArray[n2].getDestinationUID();
                        object5 = jDBCStore.getDestination((DestinationUID)object62);
                        if (object5 != null) continue;
                        jDBCStore.storeDestination(destinationArray[n2], l);
                    }
                    n3 = destinationArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        object62 = ((FileStore)store).messageEnumeration(destinationArray[n2]);
                        while (object62.hasMoreElements()) {
                            object5 = destinationArray[n2].getDestinationUID();
                            HashMap hashMap = ((FileStore)store).getInterestStates((DestinationUID)object5, (SysMessageID)(object4 = (object3 = (TransactionAcknowledgement[])object62.nextElement()).getSysMessageID()));
                            if (hashMap == null || hashMap.isEmpty()) {
                                jDBCStore.storeMessage((DestinationUID)object5, (Packet)object3, null, null, l, false);
                                continue;
                            }
                            int n4 = hashMap.size();
                            objectArray3 = new ConsumerUID[n4];
                            object2 = new int[n4];
                            Iterator iterator2 = hashMap.entrySet().iterator();
                            int n5 = 0;
                            while (iterator2.hasNext()) {
                                Map.Entry entry = iterator2.next();
                                objectArray3[n5] = (ConsumerUID)entry.getKey();
                                object2[n5] = (Integer)entry.getValue();
                                ++n5;
                            }
                            jDBCStore.storeMessage((DestinationUID)object5, (Packet)object3, (ConsumerUID[])objectArray3, (int[])object2, l, false);
                        }
                    }
                    Collection collection = ((FileStore)store).getTransactions(string3);
                    for (Object object62 : collection) {
                        object5 = ((FileStore)store).getTransactionInfo((TransactionUID)object62);
                        object3 = ((FileStore)store).getTransactionAcks((TransactionUID)object62);
                        jDBCStore.storeTransaction((TransactionUID)object62, (TransactionInfo)object5, l);
                        int n6 = ((TransactionAcknowledgement[])object3).length;
                        for (int i = 0; i < n6; ++i) {
                            jDBCStore.storeTransactionAck((TransactionUID)object62, object3[i], false);
                        }
                    }
                    object62 = new Properties();
                    ((Properties)object62).setProperty("instanceRootDir", string4);
                    ((Properties)object62).setProperty("reset", "false");
                    ((Properties)object62).setProperty("logdomain", "imqdbmgr");
                    jMSBridgeStore = (JMSBridgeStore)BridgeServiceManager.getExportedService("com.sun.messaging.bridge.service.JMSBridgeStore", "JMS", (Properties)object62);
                    object5 = jMSBridgeStore.getJMSBridges(null);
                    object3 = null;
                    object4 = object5.iterator();
                    while (object4.hasNext()) {
                        object3 = (String)object4.next();
                        jDBCStore.addJMSBridge((String)object3, true, null);
                    }
                    jMSBridgeStore.closeJMSBridgeStore();
                    jMSBridgeStore = null;
                    object3 = null;
                    object4 = object5.iterator();
                    while (object4.hasNext()) {
                        object3 = (String)object4.next();
                        ((Properties)object62).setProperty("jmsbridge", (String)object3);
                        if (jMSBridgeStore != null) {
                            jMSBridgeStore.closeJMSBridgeStore();
                            jMSBridgeStore = null;
                        }
                        jMSBridgeStore = (JMSBridgeStore)BridgeServiceManager.getExportedService("com.sun.messaging.bridge.service.JMSBridgeStore", "JMS", (Properties)object62);
                        List list2 = jMSBridgeStore.getTMLogRecordKeysByName((String)object3, null);
                        String string5 = null;
                        objectArray3 = null;
                        object2 = list2.iterator();
                        while (object2.hasNext()) {
                            string5 = (String)object4.next();
                            objectArray3 = jMSBridgeStore.getTMLogRecord(string5, (String)object3, null);
                            if (objectArray3 == null) {
                                logger.logToAll(8, "JMSBridge TM log record not found for " + string5);
                                continue;
                            }
                            jDBCStore.storeTMLogRecord(string5, (byte[])objectArray3, (String)object3, true, null);
                        }
                    }
                    var36_44 = null;
                }
                catch (Throwable throwable) {
                    var36_44 = null;
                    store.close();
                    if (jMSBridgeStore != null) {
                        jMSBridgeStore.closeJMSBridgeStore();
                    }
                    throw throwable;
                }
                store.close();
                if (jMSBridgeStore == null) continue;
                jMSBridgeStore.closeJMSBridgeStore();
                {
                }
            }
            logger.logToAll(8, "Restore persistent store complete.");
            Object var38_46 = null;
            if (fileStore == null) break block31;
            try {
                fileStore.close();
                break block31;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            {
                break block31;
                catch (Throwable throwable) {
                    throw new BrokerException(br.getString("B3124"));
                }
            }
            catch (Throwable throwable) {
                Object var38_47 = null;
                if (fileStore != null) {
                    try {
                        fileStore.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                StoreManager.releaseStore(true);
                throw throwable;
            }
        }
        StoreManager.releaseStore(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQuery() throws BrokerException {
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            if (Globals.getHAEnabled()) {
                System.out.println(br.getString("B1202", Globals.getBrokerID(), Globals.getClusterID()));
            } else {
                System.out.println(br.getString("B1042"));
            }
            DBTool.updateStoreVersion410IfNecessary(connection);
            int n = this.dbmgr.checkStoreExists(connection);
            if (n == 0) {
                System.out.println(br.getString("B3132"));
            } else if (n > 0) {
                System.out.println(br.getString("B3210"));
            } else {
                System.out.println(br.getString("B3213"));
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Util.close(null, null, connection);
            throw throwable;
        }
        Util.close(null, null, connection);
    }

    private boolean printHelp(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(OPT_H) && !stringArray[i].equals(OPT_LH)) continue;
            return true;
        }
        return false;
    }

    private boolean printVersion(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(OPT_V) && !stringArray[i].equals(OPT_LV)) continue;
            return true;
        }
        return false;
    }

    private void checkArg(String string, String string2, int n, int n2) throws ParserException {
        this.checkArg(string, string2, null, n, n2);
    }

    private void checkArg(String string, String string2, String string3, int n, int n2) throws ParserException {
        if (n >= n2) {
            ParserException parserException;
            if (string != null) {
                parserException = new ParserException(MISSING_CMD_ARG);
                parserException.cmd = string;
            } else if (string3 != null) {
                parserException = new ParserException(MISSING_OPT);
                parserException.opt = string3;
            } else {
                parserException = new ParserException(MISSING_OPT_ARG);
                parserException.opt = string2;
            }
            throw parserException;
        }
    }

    private void throwParserException(int n, String string, String string2, String string3, String string4) throws ParserException {
        ParserException parserException = new ParserException(n);
        parserException.cmd = string;
        parserException.cmdarg = string2;
        parserException.opt = string3;
        parserException.optarg = string4;
        throw parserException;
    }

    private void handleParserException(ParserException parserException) {
        if (parserException.reason == MISSING_CMD_ARG) {
            System.out.println(br.getString("B3083", parserException.cmd));
        } else if (parserException.reason == MISSING_OPT_ARG) {
            System.out.println(br.getString("B3080", parserException.opt));
        } else if (parserException.reason == MISSING_OPT) {
            System.out.println(br.getString("B3240", parserException.opt));
        } else if (parserException.reason == BAD_CMD_ARG) {
            System.out.println(br.getString("B3078", parserException.cmd, parserException.cmdarg));
        } else if (parserException.reason == BAD_OPT) {
            if (parserException.opt.equals(OPT_P)) {
                System.out.println(br.getString("B3217", parserException.opt));
            } else {
                System.out.println(br.getString("B3079", parserException.opt));
            }
        } else if (parserException.reason == BAD_OPT_ARG) {
            System.out.println(br.getString("B3081", parserException.opt, parserException.optarg));
        } else if (parserException.reason == EXTRA_CMD_SPECIFIED) {
            System.out.println(br.getString("B3077", parserException.cmd));
        }
    }

    private Properties parseArgs(String[] stringArray) throws ParserException {
        Properties properties = System.getProperties();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(CREATE_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_ALL)) {
                    properties.put(CMD_NAME, CREATE_ALL_CMD);
                } else if (stringArray[i].equals(ARGU_TBL)) {
                    properties.put(CMD_NAME, CREATE_TBL_CMD);
                } else {
                    this.throwParserException(BAD_CMD_ARG, CREATE_CMD_STR, stringArray[i], null, null);
                }
            } else if (stringArray[i].equals(DELETE_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_TBL)) {
                    properties.put(CMD_NAME, DELETE_TBL_CMD);
                } else if (stringArray[i].equals(ARGU_OLDTBL)) {
                    properties.put(CMD_NAME, DELETE_TBL_CMD);
                    properties.put(ARG_NAME, ARGU_OLDTBL);
                } else {
                    this.throwParserException(BAD_CMD_ARG, DELETE_CMD_STR, stringArray[i], null, null);
                }
            } else if (stringArray[i].equals(RECREATE_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_TBL)) {
                    properties.put(CMD_NAME, RECREATE_TBL_CMD);
                } else {
                    this.throwParserException(BAD_CMD_ARG, RECREATE_CMD_STR, stringArray[i], null, null);
                }
            } else if (stringArray[i].equals(REMOVE_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_BKR)) {
                    properties.put(CMD_NAME, REMOVE_BKR_CMD);
                } else if (stringArray[i].equals(ARGU_JMSBRIDGE)) {
                    properties.put(CMD_NAME, REMOVE_JMSBRIDGE_CMD);
                } else {
                    this.throwParserException(BAD_CMD_ARG, REMOVE_CMD_STR, stringArray[i], null, null);
                }
            } else if (stringArray[i].equals(DUMP_CMD)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                properties.put(CMD_NAME, DUMP_CMD);
                properties.put(ARG_NAME, stringArray[i]);
            } else if (stringArray[i].equals(DROPTBL_CMD)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                properties.put(CMD_NAME, DROPTBL_CMD);
                properties.put(ARG_NAME, stringArray[i]);
            } else if (stringArray[i].equals(RESET_CMD)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_LCK)) {
                    properties.put(CMD_NAME, RESET_CMD);
                } else {
                    this.throwParserException(BAD_CMD_ARG, RESET_CMD, stringArray[i], null, null);
                }
            } else if (stringArray[i].equals(BACKUP_CMD)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(OPT_DIR)) {
                    properties.put(CMD_NAME, BACKUP_CMD);
                    this.checkArg(stringArray[i], null, ++i, stringArray.length);
                    properties.put("imq.backupdir", stringArray[i]);
                } else {
                    this.throwParserException(BAD_CMD_ARG, BACKUP_CMD, stringArray[i], null, null);
                }
            } else if (stringArray[i].equals(RESTORE_CMD)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(OPT_DIR)) {
                    properties.put(CMD_NAME, RESTORE_CMD);
                    this.checkArg(stringArray[i], null, ++i, stringArray.length);
                    properties.put("imq.backupdir", stringArray[i]);
                } else {
                    this.throwParserException(BAD_CMD_ARG, RESTORE_CMD, stringArray[i], null, null);
                }
            } else if (stringArray[i].equals(UPGRADE_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_STORE)) {
                    properties.put(CMD_NAME, UPGRADE_STORE_CMD);
                } else if (stringArray[i].equals(ARGU_HASTORE)) {
                    properties.put(CMD_NAME, UPGRADE_HASTORE_CMD);
                } else {
                    this.throwParserException(BAD_CMD_ARG, UPGRADE_CMD_STR, stringArray[i], null, null);
                }
            } else if (stringArray[i].equals(QUERY_CMD)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                properties.put(CMD_NAME, QUERY_CMD);
            } else if (stringArray[i].equals(OPT_B)) {
                this.checkArg(null, OPT_B, ++i, stringArray.length);
                properties.put("imq.instancename", stringArray[i]);
            } else if (stringArray[i].equals(OPT_N)) {
                this.checkArg(null, OPT_N, ++i, stringArray.length);
                properties.put("imq.brokerid", stringArray[i]);
                properties.put(JMSBRIDGE_NAME_PROPERTY, stringArray[i]);
            } else if (stringArray[i].equals(OPT_U)) {
                this.checkArg(null, OPT_U, ++i, stringArray.length);
                properties.put("imq.persist.jdbc.user", stringArray[i]);
            } else if (stringArray[i].equals(OPT_PW)) {
                this.checkArg(null, OPT_PW, ++i, stringArray.length);
                properties.put("imq.persist.jdbc.password", stringArray[i]);
                this.cliPasswdSpecified = true;
            } else if (stringArray[i].equals(OPT_PASSFILE)) {
                this.checkArg(null, OPT_PASSFILE, ++i, stringArray.length);
                File file = null;
                try {
                    file = new File(stringArray[i]).getCanonicalFile();
                }
                catch (Exception exception) {
                    this.throwParserException(BAD_OPT, null, null, stringArray[i], null);
                }
                properties.put("imq.passfile.enabled", "true");
                properties.put("imq.passfile.dirpath", file.getParent());
                properties.put("imq.passfile.name", file.getName());
            } else if (!stringArray[i].equals(OPT_VERBOSE)) {
                if (stringArray[i].equals(OPT_DEBUG)) {
                    this.debugSpecified = true;
                } else if (stringArray[i].equals(OPT_FORCE)) {
                    this.forceSpecified = true;
                } else if (stringArray[i].equals(OPT_VARHOME)) {
                    ++i;
                } else if (stringArray[i].startsWith(OPT_D)) {
                    int n = 0;
                    String string = null;
                    String string2 = "";
                    n = stringArray[i].indexOf(61);
                    if (stringArray[i].length() <= 2) continue;
                    if (n < 0) {
                        string = stringArray[i].substring(2);
                    } else if (n == stringArray[i].length() - 1) {
                        string = stringArray[i].substring(2, n);
                    } else {
                        string = stringArray[i].substring(2, n);
                        string2 = stringArray[i].substring(n + 1);
                    }
                    properties.put(string, string2);
                } else {
                    this.throwParserException(BAD_OPT, null, null, stringArray[i], null);
                }
            }
            if (properties.getProperty(REMOVE_JMSBRIDGE_CMD) == null || properties.getProperty(JMSBRIDGE_NAME_PROPERTY) != null) continue;
            this.checkArg(null, null, OPT_N, 0, 0);
        }
        return properties;
    }

    private void parsePassfile() throws FileNotFoundException {
        Properties properties;
        String string = null;
        String string2 = null;
        String string3 = null;
        string3 = config.getProperty("imq.passfile.enabled");
        if (string3 == null || !string3.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return;
        }
        string = config.getProperty("imq.passfile.dirpath");
        string2 = string != null ? (string = StringUtil.expandVariables((String)string, (Properties)config)) : config.getProperty("imq.etchome") + File.separator + "security";
        String string4 = string2 + File.separator + config.getProperty("imq.passfile.name");
        File file = new File(string4);
        if (file.exists()) {
            properties = new Properties();
            try {
                FileInputStream fileInputStream = new FileInputStream(string4);
                properties.load(fileInputStream);
            }
            catch (IOException iOException) {
                logger.log(32, br.getKString("B4023"), (Throwable)iOException);
            }
        } else {
            throw new FileNotFoundException(br.getKString("B3020", string4));
        }
        config.putAll((Map)properties);
    }

    private void exit(int n) {
        if (this.standalone) {
            DBConnectionPool.close();
            System.exit(n);
        }
    }

    void doCommand(String[] stringArray) throws SQLException, BrokerException, FileNotFoundException {
        String string;
        String string2;
        String string3;
        if (stringArray.length == 0) {
            System.out.println(this.version.getBanner(true));
            System.out.println(br.getString("B0011"));
            this.exit(0);
        }
        if (this.printHelp(stringArray)) {
            System.out.println(br.getString("B0011"));
            this.exit(0);
        }
        if (this.printVersion(stringArray)) {
            System.out.println(this.version.getBanner(true));
            System.out.println(br.getString("B1003") + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.home"));
            System.out.println(br.getString("B1054") + System.getProperty("java.class.path"));
            this.exit(0);
        }
        Properties properties = null;
        try {
            properties = this.parseArgs(stringArray);
        }
        catch (ParserException parserException) {
            this.handleParserException(parserException);
            this.exit(1);
        }
        properties.setProperty("imq.persist.jdbc.connection.limit", "2");
        if (this.cliPasswdSpecified) {
            System.err.println(br.getString("B2088", OPT_PW));
            System.err.println("");
        }
        if ((string3 = properties.getProperty("imq.instancename")) != null && string3.length() > 0) {
            Globals.pathinit(null);
            string2 = Globals.JMQ_INSTANCES_HOME + File.separator + string3;
            if (!new File(string2).exists()) {
                System.err.println(br.getString("B3119", string3));
                System.exit(1);
            }
        }
        Globals.init(properties, false, false);
        config = Globals.getConfig();
        logger = Globals.getLogger();
        this.parsePassfile();
        string2 = config.getProperty("imq.persist.jdbc.dbVendor");
        String string4 = "imq.persist.jdbc." + string2;
        String string5 = properties.getProperty("imq.persist.jdbc.user");
        if (string5 != null && string5.length() > 0) {
            config.put(string4 + ".user", string5);
        }
        if ((string = properties.getProperty("imq.persist.jdbc.password")) != null && string.length() > 0) {
            config.put(string4 + ".password", string);
        }
        this.dbmgr = DBManager.getDBManager();
        String string6 = properties.getProperty(CMD_NAME);
        String string7 = this.dbmgr.getBrokerID();
        String string8 = CREATE_ALL_CMD.equals(string6) ? this.dbmgr.getCreateDBURL() : this.dbmgr.getOpenDBURL();
        if (string8 == null) {
            string8 = "not specified";
        }
        if ((string5 = this.dbmgr.getUser()) == null) {
            string5 = "not specified";
        }
        Object[] objectArray = new String[]{String.valueOf(410), string7, string8, string5};
        logger.logToAll(8, br.getString("B1067", objectArray));
        if (CREATE_ALL_CMD.equals(string6)) {
            this.doCreate(true);
        } else if (CREATE_TBL_CMD.equals(string6)) {
            this.doCreate(false);
        } else if (DELETE_TBL_CMD.equals(string6)) {
            this.doDelete(properties.getProperty(ARG_NAME));
        } else if (RECREATE_TBL_CMD.equals(string6)) {
            this.doRecreate();
        } else if (REMOVE_BKR_CMD.equals(string6)) {
            this.doRemoveBkr();
        } else if (REMOVE_JMSBRIDGE_CMD.equals(string6)) {
            this.doRemoveJMSBridge(properties.getProperty(JMSBRIDGE_NAME_PROPERTY));
        } else if (DUMP_CMD.equals(string6)) {
            String string9 = properties.getProperty(ARG_NAME);
            this.doDump(string9);
        } else if (DROPTBL_CMD.equals(string6)) {
            String string10 = properties.getProperty(ARG_NAME);
            this.doDropTablesByPattern(string10);
        } else if (RESET_CMD.equals(string6)) {
            this.doReset();
        } else if (BACKUP_CMD.equals(string6)) {
            this.doBackup();
        } else if (RESTORE_CMD.equals(string6)) {
            this.doRestore();
        } else if (UPGRADE_STORE_CMD.equals(string6)) {
            this.doUpgrade(false);
        } else if (UPGRADE_HASTORE_CMD.equals(string6)) {
            this.doUpgrade(true);
        } else if (QUERY_CMD.equals(string6)) {
            this.doQuery();
        } else if (string6 == null) {
            System.out.println(br.getString("B3105"));
        } else {
            System.out.println(br.getString("B3104", string6));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        int n = 0;
        DBTool dBTool = new DBTool(true);
        try {
            try {
                dBTool.doCommand(stringArray);
            }
            catch (Exception exception) {
                if (exception instanceof BrokerException) {
                    logger.log(32, exception.getMessage(), exception.getCause());
                } else {
                    logger.log(32, exception.getMessage());
                }
                if (dBTool.debugSpecified) {
                    exception.printStackTrace();
                }
                n = 1;
                Object var5_4 = null;
                if (dBTool.dbmgr != null) {
                    dBTool.dbmgr.close();
                }
            }
            Object var5_3 = null;
            if (dBTool.dbmgr != null) {
                dBTool.dbmgr.close();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (dBTool.dbmgr != null) {
                dBTool.dbmgr.close();
            }
            throw throwable;
        }
        System.exit(n);
    }

    private static class ParserException
    extends Exception {
        String cmd;
        String cmdarg;
        String opt;
        String optarg;
        int reason;

        ParserException(int n) {
            this.reason = n;
        }
    }
}

