/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="jms-ping")
@Scoped(value=PerLookup.class)
@I18n(value="jms-ping")
public class JMSPing
implements AdminCommand {
    @Param(optional=true)
    String target = "server";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JMSPing.class);
    @Inject
    private ConnectorRuntime connectorRuntime;
    @Inject
    Configs configs;
    @Inject
    Domain domain;
    @Inject
    CommandRunner commandRunner;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Server targetServer = this.domain.getServerNamed(this.target);
        String configRef = targetServer.getConfigRef();
        JmsService jmsservice = null;
        for (Config c : this.configs.getConfig()) {
            if (!configRef.equals(c.getName())) continue;
            jmsservice = c.getJmsService();
        }
        String defaultJmshostStr = jmsservice.getDefaultJmsHost();
        JmsHost defaultJmsHost = null;
        for (JmsHost jmshost : jmsservice.getJmsHost()) {
            if (!defaultJmshostStr.equals(jmshost.getName())) continue;
            defaultJmsHost = jmshost;
        }
        String tmpJMSResource = "test_jms_adapter";
        ActionReport subReport = report.addSubActionsReport();
        this.createJMSResource(defaultJmsHost, subReport, tmpJMSResource);
        if (ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) {
            report.setMessage(localStrings.getLocalString("jms-ping.cannotCreateJMSResource", "Unable to create a temporary Connection Factory to the JMS Host"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            boolean value = this.pingConnectionPool(tmpJMSResource);
            if (!value) {
                report.setMessage(localStrings.getLocalString("jms-ping.pingConnectionPoolFailed", "Pinging to the JMS Host failed."));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            } else {
                report.setMessage(localStrings.getLocalString("jms-ping.pingConnectionPoolSuccess", "JMS-ping command executed successfully"));
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            }
        }
        catch (ResourceException e) {
            report.setMessage(localStrings.getLocalString("jms-ping.pingConnectionPoolException", "An exception occured while trying to ping the JMS Host.", new Object[]{e.getMessage()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        this.deleteJMSResource(subReport, tmpJMSResource);
        if (ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) {
            report.setMessage(localStrings.getLocalString("jms-ping.cannotdeleteJMSResource", "Unable to delete the temporary JMS Resource " + tmpJMSResource + ". Please delete this manually.", new Object[]{tmpJMSResource}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
    }

    void createJMSResource(JmsHost defaultJmsHost, ActionReport subReport, String tmpJMSResource) {
        String userName = defaultJmsHost.getAdminUserName();
        String password = defaultJmsHost.getAdminPassword();
        String host = defaultJmsHost.getHost();
        String port = defaultJmsHost.getPort();
        Properties aoAttrList = new Properties();
        Properties properties = new Properties();
        properties.put("imqDefaultUsername", userName);
        properties.put("imqDefaultPassword", password);
        properties.put("AddressList", "mq\\\\://" + host + "\\\\:" + port);
        String propString = "";
        for (Map.Entry<Object, Object> prop : properties.entrySet()) {
            propString = propString + prop.getKey() + "=" + prop.getValue() + ":";
        }
        propString = propString.substring(0, propString.length());
        aoAttrList.put("property", propString);
        aoAttrList.setProperty("restype", "javax.jms.QueueConnectionFactory");
        aoAttrList.setProperty("DEFAULT", tmpJMSResource);
        this.commandRunner.doCommand("create-jms-resource", aoAttrList, subReport);
    }

    boolean pingConnectionPool(String tmpJMSResource) throws ResourceException {
        return this.connectorRuntime.pingConnectionPool(tmpJMSResource);
    }

    void deleteJMSResource(ActionReport subReport, String tmpJMSResource) {
        Properties aoAttrList = new Properties();
        aoAttrList.setProperty("DEFAULT", tmpJMSResource);
        this.commandRunner.doCommand("delete-jms-resource", aoAttrList, subReport);
    }
}

