/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.timer.WakeupableTimer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;

class TransactionReaper
implements Runnable {
    TransactionList translist = null;
    Logger logger = Globals.getLogger();
    Vector committed = new Vector();
    Vector noremoves = new Vector();
    Map clusterPCommitted = Collections.synchronizedMap(new LinkedHashMap());
    Vector remoteCommitted = new Vector();
    Vector remoteRCommitted = new Vector();
    WakeupableTimer reapTimer = null;

    public TransactionReaper(TransactionList transactionList) {
        this.translist = transactionList;
    }

    public void addLocalTransaction(TransactionUID transactionUID, boolean bl) {
        if (bl) {
            this.noremoves.add(transactionUID);
        }
        this.committed.add(transactionUID);
        this.createTimer();
        if (this.committed.size() > TransactionList.TXN_REAPLIMIT) {
            this.reapTimer.wakeup();
        }
    }

    public void addClusterTransaction(TransactionUID transactionUID, boolean bl) {
        this.clusterPCommitted.put(transactionUID, false);
        if (bl) {
            this.noremoves.add(transactionUID);
        }
        this.createTimer();
        this.reapTimer.wakeup();
    }

    public void addCompletedClusterTransaction(TransactionUID transactionUID) {
        this.committed.add(transactionUID);
        this.createTimer();
        if (this.committed.size() > TransactionList.TXN_REAPLIMIT) {
            this.reapTimer.wakeup();
        }
    }

    public void addRemoteTransaction(TransactionUID transactionUID, boolean bl) {
        if (!bl) {
            this.remoteCommitted.add(transactionUID);
        } else {
            this.remoteRCommitted.add(transactionUID);
        }
        this.createTimer();
        if (this.remoteCommitted.size() > TransactionList.TXN_REAPLIMIT || this.remoteRCommitted.size() > TransactionList.TXN_REAPLIMIT) {
            this.reapTimer.wakeup();
        }
    }

    public boolean hasRemoteTransaction(TransactionUID transactionUID) {
        if (this.remoteCommitted.contains(transactionUID)) {
            return true;
        }
        return this.remoteRCommitted.contains(transactionUID);
    }

    public synchronized void wakeupReaperTimer() {
        if (this.reapTimer != null) {
            this.reapTimer.wakeup();
        }
    }

    private synchronized void createTimer() {
        if (this.reapTimer == null) {
            try {
                String string = Globals.getBrokerResources().getKString("B1285", TransactionList.TXN_REAPLIMIT, TransactionList.TXN_REAPINTERVAL / 1000L);
                String string2 = Globals.getBrokerResources().getKString("B1286");
                this.reapTimer = new WakeupableTimer("TransactionReaper", (Runnable)this, TransactionList.TXN_REAPINTERVAL, TransactionList.TXN_REAPINTERVAL, string, string2, (Object)this.logger);
            }
            catch (Exception exception) {
                this.logger.log(16, "B3100", (Object)"Unable to start transaction reaper thread ", (Throwable)exception);
            }
        }
    }

    public synchronized void destroy() {
        if (this.reapTimer != null) {
            this.reapTimer.cancel();
            this.reapTimer = null;
        }
        this.committed.clear();
        this.remoteCommitted.clear();
        this.remoteRCommitted.clear();
    }

    public Hashtable getDebugState(TransactionUID transactionUID) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.committed.contains(transactionUID)) {
            hashtable.put(transactionUID.toString(), TransactionState.toString(6));
            return hashtable;
        }
        if (this.clusterPCommitted.get(transactionUID) != null) {
            hashtable.put(transactionUID.toString() + "(cluster)", TransactionState.toString(6));
            return hashtable;
        }
        if (this.remoteCommitted.contains(transactionUID)) {
            hashtable.put(transactionUID.toString() + "(remote)", TransactionState.toString(6));
            return hashtable;
        }
        if (this.remoteRCommitted.contains(transactionUID)) {
            hashtable.put(transactionUID.toString() + "(remote-r)", TransactionState.toString(6));
            return hashtable;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Serializable serializable2;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("comittedCount", new Integer(this.committed.size()));
        for (Serializable serializable2 : this.committed) {
            hashtable.put(((TransactionUID)serializable2).toString(), TransactionState.toString(6));
        }
        serializable2 = null;
        Object object2 = this.clusterPCommitted;
        synchronized (object2) {
            serializable2 = new ArrayList(this.clusterPCommitted.keySet());
            Iterator iterator = serializable2.iterator();
            while (iterator.hasNext()) {
                TransactionUID transactionUID = (TransactionUID)iterator.next();
                hashtable.put(transactionUID.toString() + "(cluster)", TransactionState.toString(6));
            }
        }
        hashtable.put("noremovesCount", new Integer(this.noremoves.size()));
        for (Object object2 : this.noremoves) {
            hashtable.put(((TransactionUID)object2).toString(), TransactionState.toString(6));
        }
        for (Object object2 : this.remoteCommitted) {
            hashtable.put(((TransactionUID)object2).toString() + "(remote)", TransactionState.toString(6));
        }
        for (Object object2 : this.remoteRCommitted) {
            hashtable.put(((TransactionUID)object2).toString() + "(remote-r)", TransactionState.toString(6));
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.translist.isLoadComplete()) {
            try {
                this.logger.log(8, Globals.getBrokerResources().getString("B1327"));
                this.translist.loadCompleteLatch.await();
            }
            catch (InterruptedException interruptedException) {
                this.logger.log(16, "Transaction reaper thread is interrupted in waiting for transaction loading completion");
                return;
            }
        }
        ArrayList arrayList = null;
        Object object = this.translist.newlyActivatedBrokers;
        synchronized (this.translist.newlyActivatedBrokers) {
            arrayList = new ArrayList(this.translist.newlyActivatedBrokers);
            this.translist.newlyActivatedBrokers.clear();
            // ** MonitorExit[var2_3] (shouldn't be in output)
            if (arrayList.size() > 0 || this.clusterPCommitted.containsValue(false)) {
                object = null;
                Object object2 = this.clusterPCommitted;
                synchronized (object2) {
                    object = new ArrayList(this.clusterPCommitted.keySet());
                }
                object2 = null;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    object2 = (TransactionUID)iterator.next();
                    try {
                        TransactionBroker[] transactionBrokerArray = this.translist.getClusterTransactionBrokers((TransactionUID)object2);
                        if (transactionBrokerArray == null) continue;
                        boolean bl = true;
                        BrokerAddress brokerAddress = null;
                        for (int i = 0; i < transactionBrokerArray.length; ++i) {
                            Boolean bl2;
                            if (transactionBrokerArray[i].isCompleted()) continue;
                            bl = false;
                            brokerAddress = transactionBrokerArray[i].getCurrentBrokerAddress();
                            if (brokerAddress != null) {
                                if (brokerAddress.equals(Globals.getMyAddress()) && brokerAddress.equals(transactionBrokerArray[i].getBrokerAddress())) {
                                    try {
                                        this.translist.completeClusterTransactionBrokerState((TransactionUID)object2, 6, brokerAddress, true);
                                    }
                                    catch (Exception exception) {
                                        this.logger.logStack(16, "Unable to update transaction broker state for " + brokerAddress + ", TUID=" + object2, (Throwable)exception);
                                    }
                                    if (!Globals.getHAEnabled()) continue;
                                }
                                bl2 = (Boolean)this.clusterPCommitted.get(object2);
                                if (arrayList.size() == 0 && bl2 != null && bl2.booleanValue() || arrayList.size() == 0 && !brokerAddress.equals(Globals.getMyAddress()) || arrayList.size() > 0 && !arrayList.contains((Object)brokerAddress.getMQAddress()) && !brokerAddress.equals(Globals.getMyAddress())) continue;
                                if (TransactionList.DEBUG_CLUSTER_TXN) {
                                    this.logger.log(8, "txnReaperThread: sendClusterTransactionInfo for TID=" + object2 + " to " + brokerAddress);
                                }
                                Globals.getClusterBroadcast().sendClusterTransactionInfo(object2.longValue(), brokerAddress);
                                continue;
                            }
                            bl2 = (Boolean)this.clusterPCommitted.get(object2);
                            if (bl2 == null || bl2.booleanValue()) continue;
                            this.logger.log(8, Globals.getBrokerResources().getKString("B2205", ((TransactionUID)object2).toString(), transactionBrokerArray[i].toString()));
                        }
                        this.clusterPCommitted.put(object2, true);
                        if (!bl) continue;
                        this.committed.add(object2);
                        this.clusterPCommitted.remove(object2);
                    }
                    catch (Exception exception) {
                        this.logger.logStack(16, exception.getMessage(), (Throwable)exception);
                    }
                }
            }
            object = this.committed.toArray(new TransactionUID[0]);
            int n = ((TransactionUID[])object).length - TransactionList.TXN_REAPLIMIT;
            for (int i = 0; i < n; ++i) {
                if (TransactionList.DEBUG_CLUSTER_TXN) {
                    this.logger.log(8, "Cleaning up committed transaction " + object[i]);
                }
                try {
                    this.translist.reapTransactionID((TransactionUID)object[i], this.noremoves.contains(object[i]));
                    this.committed.remove(object[i]);
                    this.noremoves.remove(object[i]);
                    continue;
                }
                catch (Exception exception) {
                    this.logger.logStack(16, "Failed to cleanup committed transaction " + object[i], (Throwable)exception);
                }
            }
            for (n = this.remoteCommitted.size() - TransactionList.TXN_REAPLIMIT; n > 0; --n) {
                TransactionUID transactionUID = (TransactionUID)this.remoteCommitted.firstElement();
                this.remoteCommitted.remove(transactionUID);
                if (!TransactionList.DEBUG_CLUSTER_TXN) continue;
                this.logger.log(8, "Cleaned up committed remote transaction " + transactionUID);
            }
            for (n = this.remoteRCommitted.size() - TransactionList.TXN_REAPLIMIT; n > 0; --n) {
                TransactionUID transactionUID = (TransactionUID)this.remoteRCommitted.firstElement();
                this.remoteRCommitted.remove(transactionUID);
                if (!TransactionList.DEBUG_CLUSTER_TXN) continue;
                this.logger.log(8, "Cleaned up committed remote transaction " + transactionUID + ".");
            }
            return;
        }
    }
}

