/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.ClusterTransaction;
import com.sun.messaging.jmq.jmsserver.data.RemoteTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessageAck;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class TransactionListLoader {
    Logger logger = Globals.getLogger();
    Store store = null;
    TransactionList transactionList;
    static boolean loaded = false;

    public TransactionListLoader(Store store, TransactionList transactionList) {
        this.store = store;
        this.transactionList = transactionList;
    }

    public void loadTransactions() throws BrokerException, IOException {
        this.logger.log(8, "B1136");
        this.loadLocalTransactions();
        this.loadClusterTransactions();
        this.loadRemoteTransactions();
    }

    private static void loadDestinations() throws BrokerException {
        if (!loaded) {
            loaded = true;
            Destination.loadDestinations();
            Iterator iterator = Destination.getAllDestinations();
            while (iterator.hasNext()) {
                Destination destination = (Destination)iterator.next();
                destination.load();
            }
        }
    }

    public void loadLocalTransactions() throws BrokerException, IOException {
        List<BaseTransaction> list = this.store.getIncompleteTransactions(1);
        String string = " loading " + list.size() + " incomplete Local transactions:  ";
        this.logger.log(4, string);
        for (BaseTransaction baseTransaction : list) {
            TransactionUID transactionUID = baseTransaction.getTid();
            string = " loadTransactions: processing local transaction " + transactionUID;
            this.logger.log(4, string);
            TransactionState transactionState = baseTransaction.getTransactionState();
            this.transactionList.addTransactionID(transactionUID, transactionState, false);
            TransactionWork transactionWork = baseTransaction.getTransactionWork();
            this.handleTransactionWork(transactionUID, transactionWork);
        }
    }

    public void loadClusterTransactions() throws BrokerException, IOException {
        List<BaseTransaction> list = this.store.getIncompleteTransactions(3);
        String string = " loading " + list.size() + " incomplete cluster transactions:  ";
        this.logger.log(4, string);
        for (ClusterTransaction clusterTransaction : list) {
            TransactionUID transactionUID = clusterTransaction.getTid();
            string = " loadTransactions: processing cluster transaction " + transactionUID;
            this.logger.log(4, string);
            TransactionState transactionState = clusterTransaction.getTransactionState();
            this.transactionList.addTransactionID(transactionUID, transactionState, false);
            TransactionBroker[] transactionBrokerArray = clusterTransaction.getTransactionBrokers();
            this.transactionList.logClusterTransaction(transactionUID, transactionState, transactionBrokerArray, true, false);
            TransactionWork transactionWork = clusterTransaction.getTransactionWork();
            this.handleTransactionWork(transactionUID, transactionWork);
        }
    }

    public void loadRemoteTransactions() throws BrokerException, IOException {
        List<BaseTransaction> list = this.store.getIncompleteTransactions(2);
        String string = " loading " + list.size() + " incomplete remote transactions:  ";
        this.logger.log(4, string);
        for (RemoteTransaction remoteTransaction : list) {
            TransactionUID transactionUID = remoteTransaction.getTid();
            TransactionState transactionState = remoteTransaction.getTransactionState();
            TransactionAcknowledgement[] transactionAcknowledgementArray = remoteTransaction.getTxnAcks();
            string = " loadTransactions: processing remote transaction " + transactionUID + " state= " + transactionState;
            this.logger.log(4, string);
            BrokerAddress brokerAddress = remoteTransaction.getTxnHomeBroker();
            this.transactionList.logRemoteTransaction(transactionUID, transactionState, transactionAcknowledgementArray, brokerAddress, true, true, false);
            for (int i = 0; i < transactionAcknowledgementArray.length; ++i) {
                TransactionAcknowledgement transactionAcknowledgement = transactionAcknowledgementArray[i];
                this.unrouteLoadedTransactionAckMessage(transactionAcknowledgement.getSysMessageID(), transactionAcknowledgement.getStoredConsumerUID());
            }
        }
    }

    void handleTransactionWork(TransactionUID transactionUID, TransactionWork transactionWork) throws BrokerException {
        this.handleSentMessages(transactionWork);
        this.handleMessageAcks(transactionUID, transactionWork);
    }

    void handleSentMessages(TransactionWork transactionWork) throws BrokerException {
        for (int i = 0; i < transactionWork.numSentMessages(); ++i) {
            TransactionWorkMessage transactionWorkMessage = transactionWork.getSentMessages().get(i);
            Packet packet = transactionWorkMessage.getMessage();
            DestinationUID destinationUID = transactionWorkMessage.getDestUID();
            PacketReference packetReference = PacketReference.createReference(packet, destinationUID, null);
            Destination destination = Destination.getDestination(destinationUID);
            destination.load();
            this.logger.log(4, " loadTransactions: processing prepared sent message " + packet.getMessageID());
            boolean bl = destination.queueMessage(packetReference, true);
            this.transactionList.addMessage(packetReference.getTransactionID(), packetReference.getSysMessageID(), true);
        }
    }

    void handleMessageAcks(TransactionUID transactionUID, TransactionWork transactionWork) throws BrokerException {
        for (int i = 0; i < transactionWork.numMessageAcknowledgments(); ++i) {
            TransactionWorkMessageAck transactionWorkMessageAck = transactionWork.getMessageAcknowledgments().get(i);
            this.handleAck(transactionUID, transactionWorkMessageAck.getSysMessageID(), transactionWorkMessageAck.getConsumerID());
        }
    }

    void handleAck(TransactionUID transactionUID, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        this.logger.log(4, " loadTransactions: processing prepared acknowledged message " + sysMessageID);
        this.transactionList.addAcknowledgement(transactionUID, sysMessageID, consumerUID, consumerUID, true, false);
        this.transactionList.addOrphanAck(transactionUID, sysMessageID, consumerUID, consumerUID);
        this.unrouteLoadedTransactionAckMessage(sysMessageID, consumerUID);
    }

    void unrouteLoadedTransactionAckMessage(SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        this.logger.log(4, " trying to unroute prepared acknowledged message " + sysMessageID);
        TransactionListLoader.loadDestinations();
        PacketReference packetReference = Destination.get(sysMessageID);
        Destination destination = packetReference.getDestination();
        destination.unrouteLoadedTransactionAckMessage(packetReference, consumerUID);
    }
}

