/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadWrite;
import com.sun.messaging.jmq.jmsserver.management.util.ConsumerUtil;
import java.util.HashSet;
import java.util.Iterator;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class ConsumerManagerConfig
extends MQMBeanReadWrite {
    private static MBeanAttributeInfo[] attrs;
    private static MBeanParameterInfo[] purgeSignature;
    private static MBeanOperationInfo[] ops;

    public Integer getNumConsumers() {
        return new Integer(ConsumerUtil.getNumConsumersNoChildren());
    }

    public String[] getConsumerIDs() throws MBeanException {
        int n = this.getNumConsumers();
        if (n <= 0) {
            return null;
        }
        String[] stringArray = new String[n];
        Iterator iterator = new HashSet(ConsumerUtil.getAllConsumersNoChildren().values()).iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Consumer consumer = (Consumer)iterator.next();
            long l = consumer.getConsumerUID().longValue();
            try {
                String string;
                stringArray[n2] = string = Long.toString(l);
            }
            catch (Exception exception) {
                this.handleOperationException("getConsumerIDs", exception);
            }
            ++n2;
        }
        return stringArray;
    }

    public void purge(String string) throws MBeanException {
        ConsumerUID consumerUID = null;
        try {
            consumerUID = new ConsumerUID(Long.parseLong(string));
        }
        catch (Exception exception) {
            this.handleOperationException("purge", exception);
        }
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (!consumer.isDurableSubscriber()) {
            this.logger.log(8, "Purge not supported for non durable subscribers.");
            return;
        }
        if (consumer instanceof Subscription) {
            Subscription subscription = (Subscription)consumer;
            try {
                subscription.purge();
            }
            catch (Exception exception) {
                this.handleOperationException("purge", exception);
            }
        }
    }

    public String getMBeanName() {
        return "ConsumerManagerConfig";
    }

    public String getMBeanDescription() {
        return mbr.getString("MB1068");
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return null;
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[1];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("NumConsumers", Integer.class.getName(), mbr.getString("MB1069"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[1];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("consumerID", String.class.getName(), mbr.getString("MB1074"));
        purgeSignature = mBeanParameterInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[2];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getConsumerIDs", mbr.getString("MB1070"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("purge", mbr.getString("MB1073"), purgeSignature, Void.TYPE.getName(), 0);
        ops = mBeanOperationInfoArray;
    }
}

