/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.management.util.ConsumerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.CompositeData;

public class ConsumerManagerMonitor
extends MQMBeanReadOnly {
    private static MBeanAttributeInfo[] attrs;
    private static MBeanParameterInfo[] getConsumerInfoByIDSignature;
    private static MBeanParameterInfo[] numWildcardConsumersSignature;
    private static MBeanOperationInfo[] ops;

    public Integer getNumConsumers() {
        return new Integer(ConsumerUtil.getNumConsumersNoChildren());
    }

    public Integer getNumWildcardConsumers() throws MBeanException {
        int n = Consumer.getNumWildcardConsumers();
        return new Integer(n);
    }

    public Integer getNumWildcardConsumers(String string) throws MBeanException {
        int n = Consumer.getNumWildcardConsumers();
        if (n <= 0) {
            return new Integer(0);
        }
        Iterator iterator = Consumer.getWildcardConsumers();
        if (iterator == null) {
            return new Integer(0);
        }
        int n2 = 0;
        while (iterator.hasNext()) {
            ConsumerUID consumerUID = (ConsumerUID)iterator.next();
            Consumer consumer = Consumer.getConsumer(consumerUID);
            if (string != null) {
                DestinationUID destinationUID = consumer.getDestinationUID();
                if (!destinationUID.getName().equals(string)) continue;
                ++n2;
                continue;
            }
            ++n2;
        }
        return new Integer(n2);
    }

    public String[] getConsumerWildcards() throws MBeanException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = null;
        int n = Consumer.getNumWildcardConsumers();
        if (n <= 0) {
            return null;
        }
        Iterator iterator = Consumer.getWildcardConsumers();
        if (iterator == null) {
            return null;
        }
        while (iterator.hasNext()) {
            ConsumerUID consumerUID = (ConsumerUID)iterator.next();
            Consumer consumer = Consumer.getConsumer(consumerUID);
            if (!consumer.isWildcard()) continue;
            DestinationUID destinationUID = consumer.getDestinationUID();
            arrayList.add(destinationUID.getName());
        }
        if (arrayList.size() > 0) {
            stringArray = new String[arrayList.size()];
            stringArray = arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    public String[] getConsumerIDs() {
        return ConsumerUtil.getConsumerIDs();
    }

    public CompositeData[] getConsumerInfo() throws MBeanException {
        CompositeData[] compositeDataArray = null;
        try {
            compositeDataArray = ConsumerUtil.getConsumerInfo();
        }
        catch (Exception exception) {
            this.handleOperationException("getConsumerInfo", exception);
        }
        return compositeDataArray;
    }

    public CompositeData getConsumerInfoByID(String string) throws MBeanException {
        CompositeData compositeData = null;
        try {
            compositeData = ConsumerUtil.getConsumerInfo(string);
        }
        catch (Exception exception) {
            this.handleOperationException("getConsumerInfoByID", exception);
        }
        return compositeData;
    }

    public String getMBeanName() {
        return "ConsumerManagerMonitor";
    }

    public String getMBeanDescription() {
        return mbr.getString("MB1075");
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return null;
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[2];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("NumConsumers", Integer.class.getName(), mbr.getString("MB1069"), true, false, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("NumWildcardConsumers", Integer.class.getName(), mbr.getString("MB1253"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[1];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("consumerID", String.class.getName(), mbr.getString("MB1074"));
        getConsumerInfoByIDSignature = mBeanParameterInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[1];
        mBeanParameterInfoArray2[0] = new MBeanParameterInfo("wildcard", String.class.getName(), mbr.getString("MB1251"));
        numWildcardConsumersSignature = mBeanParameterInfoArray2;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[5];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getConsumerIDs", mbr.getString("MB1070"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("getConsumerInfo", mbr.getString("MB1071"), null, CompositeData[].class.getName(), 0);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("getConsumerInfoByID", mbr.getString("MB1072"), getConsumerInfoByIDSignature, CompositeData.class.getName(), 0);
        mBeanOperationInfoArray[3] = new MBeanOperationInfo("getConsumerWildcards", mbr.getString("MB1254"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[4] = new MBeanOperationInfo("getNumWildcardConsumers", mbr.getString("MB1255"), numWildcardConsumersSignature, Integer.class.getName(), 0);
        ops = mBeanOperationInfoArray;
    }
}

