/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.PacketProperties;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class ClusterDestInfo {
    private Destination d = null;
    private GPacket pkt = null;
    private String destName = null;
    private int destType = -1;

    private ClusterDestInfo(Destination destination) {
        this.d = destination;
    }

    private ClusterDestInfo(GPacket gPacket) {
        assert (gPacket.getType() == 15 || gPacket.getType() == 13);
        this.pkt = gPacket;
        this.destName = (String)gPacket.getProp((Object)"N");
        this.destType = (Integer)gPacket.getProp((Object)"DT");
    }

    public static ClusterDestInfo newInstance(Destination destination) {
        return new ClusterDestInfo(destination);
    }

    public static ClusterDestInfo newInstance(GPacket gPacket) {
        return new ClusterDestInfo(gPacket);
    }

    public GPacket getGPacket(short s, boolean bl) {
        assert (this.d != null);
        assert (s == 15 || s == 13);
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType(s);
        gPacket.putProp((Object)"N", (Object)this.d.getDestinationName());
        gPacket.putProp((Object)"DT", (Object)new Integer(this.d.getType()));
        switch (s) {
            case 15: {
                break;
            }
            case 13: {
                Object object;
                if (DestType.isTemporary((int)this.d.getType()) && (object = this.d.getConnectionUID()) != null) {
                    gPacket.putProp((Object)"connectionUID", (Object)new Long(object.longValue()));
                }
                if ((object = this.d.getDestinationProperties()) == null) {
                    object = new HashMap();
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    PacketProperties.write((Map)object, (OutputStream)byteArrayOutputStream);
                    byteArrayOutputStream.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                gPacket.setPayload(ByteBuffer.wrap(byArray));
            }
        }
        if (bl) {
            gPacket.putProp((Object)"M", (Object)true);
        }
        return gPacket;
    }

    public DestinationUID getDestUID() throws BrokerException {
        assert (this.destName != null);
        return DestinationUID.getUID(this.destName, DestType.isQueue((int)this.destType));
    }

    public int getDestType() {
        assert (this.pkt != null);
        return this.destType;
    }

    public String getDestName() {
        assert (this.pkt != null);
        return this.destName;
    }

    public Hashtable getDestProps() throws IOException, ClassNotFoundException {
        assert (this.pkt != null);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.pkt.getPayload().array());
        return PacketProperties.parseProperties((InputStream)byteArrayInputStream);
    }
}

