/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.jmsservice.JMSServiceException;
import com.sun.messaging.jmq.jmsservice.JMSServiceReply;
import com.sun.messaging.jmq.util.XidImpl;
import com.sun.messaging.jms.ra.DirectConnection;
import com.sun.messaging.jms.ra.ResourceAdapter;
import com.sun.messaging.jms.ra.util.DirectXAResourceMap;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class DirectXAResource
implements XAResource {
    private JMSService jmsservice;
    private DirectConnection dc;
    private long connectionId;
    private long transactionId = 0L;
    private XidImpl xid = null;
    private int id = 0;
    private boolean isEnlisted = false;
    private boolean usedByMDB = false;
    private JMSService.TransactionState xar_state = null;
    private HashMap<String, Long> transactionIds = null;
    private static final transient String _className = "com.sun.messaging.jms.ra.DirectXAResource";
    private static final transient String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    private static final transient String _lgrNameJMSXAResource = "javax.resourceadapter.mqjmsra.xa";
    private static final transient Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    private static final transient Logger _loggerJX = Logger.getLogger("javax.resourceadapter.mqjmsra.xa");
    private static final transient String _lgrMIDPrefix = "MQJMSRA_DXA";
    private static final transient String _lgrMID_EET = "MQJMSRA_DXA1001: ";
    private static final transient String _lgrMID_INF = "MQJMSRA_DXA1101: ";
    private static final transient String _lgrMID_WRN = "MQJMSRA_DXA2001: ";
    private static final transient String _lgrMID_ERR = "MQJMSRA_DXA3001: ";
    private static final transient String _lgrMID_EXC = "MQJMSRA_DXA4001: ";
    private static int idCounter = 0;
    protected static int _logLevel;
    protected static boolean _logFINE;

    public DirectXAResource(DirectConnection directConnection, JMSService jMSService, long l) {
        Object[] objectArray = new Object[]{directConnection, jMSService, l};
        _loggerOC.entering(_className, "constructor()", objectArray);
        this.dc = directConnection;
        this.jmsservice = jMSService;
        this.connectionId = directConnection.getConnectionId();
        this.isEnlisted = false;
        this.xar_state = JMSService.TransactionState.UNKNOWN;
        this.id = ++idCounter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void commit(Xid xid, boolean bl) throws XAException {
        String string = "commit()";
        if (_logFINE) {
            _loggerJX.fine(_lgrMID_INF + string + ":onePhase=" + bl + ":transactionId=" + this.transactionId);
        }
        JMSServiceReply jMSServiceReply = null;
        try {
            block11: {
                try {
                    jMSServiceReply = this.jmsservice.commitTransaction(this.connectionId, this.transactionId, xid, bl ? 0x40000000 : 0);
                    this.setEnlisted(false);
                    this.xar_state = JMSService.TransactionState.COMMITED;
                    if (!_logFINE) break block11;
                    _loggerJX.fine(_lgrMID_INF + string + ":connectionId=" + this.connectionId + ":committed transactionId=" + this.transactionId);
                }
                catch (JMSServiceException jMSServiceException) {
                    String string2;
                    JMSServiceReply.Status status = jMSServiceException.getJMSServiceReply().getStatus();
                    switch (status) {
                        case CONFLICT: {
                            string2 = "CONFLICT: " + jMSServiceException.getCause().toString();
                            break;
                        }
                        default: {
                            string2 = "Unknown JMSService server error " + status + ": " + jMSServiceException.getCause().toString();
                        }
                    }
                    String string3 = "commitTransaction (XA) on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " and onePhase:" + bl + " due to " + string2;
                    _loggerOC.severe(string3);
                    XAException xAException = new XAException(-3);
                    xAException.initCause(jMSServiceException);
                    this.xar_state = JMSService.TransactionState.FAILED;
                    throw xAException;
                }
            }
            Object var11_5 = null;
            boolean bl2 = false;
            XidImpl xidImpl = this.xid;
            DirectXAResource[] directXAResourceArray = DirectXAResourceMap.getXAResources(this.xid, bl2);
            for (int i = 0; i < directXAResourceArray.length; ++i) {
                DirectXAResource directXAResource = directXAResourceArray[i];
                directXAResource.clearTransactionInfo();
            }
            DirectXAResourceMap.unregister(xidImpl);
            return;
        }
        catch (Throwable throwable) {
            Object var11_6 = null;
            boolean bl3 = false;
            XidImpl xidImpl2 = this.xid;
            DirectXAResource[] directXAResourceArray = DirectXAResourceMap.getXAResources(this.xid, bl3);
            int i = 0;
            while (true) {
                if (i >= directXAResourceArray.length) {
                    DirectXAResourceMap.unregister(xidImpl2);
                    throw throwable;
                }
                DirectXAResource directXAResource = directXAResourceArray[i];
                directXAResource.clearTransactionInfo();
                ++i;
            }
        }
    }

    public void clearTransactionInfo() {
        this.transactionId = 0L;
        this.xid = null;
    }

    public synchronized void end(Xid xid, int n) throws XAException {
        String string = "end()";
        if (_logFINE) {
            _loggerJX.fine(_lgrMID_INF + string + ":flags=" + n + ":transactionId=" + this.transactionId);
        }
        JMSServiceReply jMSServiceReply = null;
        try {
            jMSServiceReply = this.jmsservice.endTransaction(this.connectionId, this.transactionId, xid, n);
            this.xar_state = JMSService.TransactionState.COMPLETE;
            if (_logFINE) {
                _loggerJX.fine(_lgrMID_INF + string + ":connectionId=" + this.connectionId + ":ended transactionId=" + this.transactionId);
            }
        }
        catch (JMSServiceException jMSServiceException) {
            String string2;
            JMSServiceReply.Status status = jMSServiceException.getJMSServiceReply().getStatus();
            switch (status) {
                case CONFLICT: {
                    string2 = "CONFLICT: " + jMSServiceException.getCause().toString();
                    break;
                }
                default: {
                    string2 = "Unknown JMSService server error " + status + ": " + jMSServiceException.getCause().toString();
                }
            }
            String string3 = "endTransaction (XA) on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " and flags=" + n + " due to " + string2;
            _loggerOC.severe(string3);
            XAException xAException = new XAException(-3);
            xAException.initCause(jMSServiceException);
            this.xar_state = JMSService.TransactionState.FAILED;
            throw xAException;
        }
    }

    public void forget(Xid xid) throws XAException {
        if (_logFINE) {
            _loggerJX.warning("MQJMSRA_DXA1101: forget()UNSUPPORTED:Xid=" + xid.toString());
        }
        XidImpl xidImpl = new XidImpl(xid);
        DirectXAResourceMap.unregister(xidImpl);
        if (this.xid != null && this.xid.equals(xidImpl)) {
            this.clearTransactionInfo();
        }
    }

    public int getTransactionTimeout() throws XAException {
        if (_logFINE) {
            _loggerJX.fine("MQJMSRA_DXA1101: getTransactionTimeout() = 0");
        }
        return 0;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (_logFINE) {
            _loggerJX.fine("MQJMSRA_DXA1101: isSameRM()");
        }
        return ResourceAdapter.isXAJoinAllowed() && xAResource instanceof DirectXAResource;
    }

    public synchronized int prepare(Xid xid) throws XAException {
        String string = "prepare()";
        if (_logFINE) {
            _loggerJX.fine(_lgrMID_INF + string + ":transactionId=" + this.transactionId);
        }
        int n = 0;
        JMSServiceReply jMSServiceReply = null;
        try {
            jMSServiceReply = this.jmsservice.prepareTransaction(this.connectionId, this.transactionId, xid);
            if (_logFINE) {
                _loggerJX.fine(_lgrMID_INF + string + ":connectionId=" + this.connectionId + ":prepared transactionId=" + this.transactionId);
            }
        }
        catch (JMSServiceException jMSServiceException) {
            String string2;
            JMSServiceReply.Status status = jMSServiceException.getJMSServiceReply().getStatus();
            switch (status) {
                case CONFLICT: {
                    string2 = "CONFLICT: " + jMSServiceException.getCause().toString();
                    break;
                }
                default: {
                    string2 = "Unknown JMSService server error " + status + ": " + jMSServiceException.getCause().toString();
                }
            }
            String string3 = "prepareTransaction (XA) on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " due to " + string2;
            _loggerOC.severe(string3);
            XAException xAException = new XAException(-3);
            xAException.initCause(jMSServiceException);
            throw xAException;
        }
        return n;
    }

    public Xid[] recover(int n) throws XAException {
        if (_logFINE) {
            _loggerJX.fine("MQJMSRA_DXA1101: recover():flags=" + n);
        }
        Xid[] xidArray = null;
        try {
            xidArray = this.jmsservice.recoverXATransactions(this.connectionId, n);
        }
        catch (JMSServiceException jMSServiceException) {
            String string;
            JMSServiceReply.Status status = jMSServiceException.getJMSServiceReply().getStatus();
            switch (status) {
                case CONFLICT: {
                    string = "CONFLICT: " + jMSServiceException.getCause().toString();
                    break;
                }
                default: {
                    string = "Unknown JMSService server error " + status + ": " + jMSServiceException.getCause().toString();
                }
            }
            String string2 = "recoverXATransactions (XA) on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " due to " + string;
            _loggerOC.severe(string2);
            XAException xAException = new XAException(-3);
            xAException.initCause(jMSServiceException);
            throw xAException;
        }
        return xidArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void rollback(Xid xid) throws XAException {
        String string = "rollback()";
        if (_logFINE) {
            _loggerJX.fine(_lgrMID_INF + string + ":transactionId=" + this.transactionId);
        }
        JMSServiceReply jMSServiceReply = null;
        try {
            block11: {
                try {
                    jMSServiceReply = this.jmsservice.rollbackTransaction(this.connectionId, this.transactionId, xid, true, true);
                    this.setEnlisted(false);
                    this.xar_state = JMSService.TransactionState.ROLLEDBACK;
                    if (!_logFINE) break block11;
                    _loggerJX.fine(_lgrMID_INF + string + ":connectionId=" + this.connectionId + ":rolled back transactionId=" + this.transactionId);
                }
                catch (JMSServiceException jMSServiceException) {
                    String string2;
                    JMSServiceReply.Status status = jMSServiceException.getJMSServiceReply().getStatus();
                    switch (status) {
                        case CONFLICT: {
                            string2 = "CONFLICT: " + jMSServiceException.getCause().toString();
                            break;
                        }
                        default: {
                            string2 = "Unknown JMSService server error " + status + ": " + jMSServiceException.getCause().toString();
                        }
                    }
                    String string3 = "rollbackTransaction (XA) on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + ":transactionId=" + this.transactionId + " due to " + string2;
                    _loggerOC.severe(string3);
                    XAException xAException = new XAException(-3);
                    xAException.initCause(jMSServiceException);
                    this.xar_state = JMSService.TransactionState.FAILED;
                    throw xAException;
                }
            }
            Object var10_4 = null;
            boolean bl = false;
            DirectXAResource[] directXAResourceArray = DirectXAResourceMap.getXAResources(this.xid, bl);
            XidImpl xidImpl = this.xid;
            for (int i = 0; i < directXAResourceArray.length; ++i) {
                DirectXAResource directXAResource = directXAResourceArray[i];
                directXAResource.clearTransactionInfo();
            }
            DirectXAResourceMap.unregister(xidImpl);
            return;
        }
        catch (Throwable throwable) {
            Object var10_5 = null;
            boolean bl2 = false;
            DirectXAResource[] directXAResourceArray = DirectXAResourceMap.getXAResources(this.xid, bl2);
            XidImpl xidImpl2 = this.xid;
            int i = 0;
            while (true) {
                if (i >= directXAResourceArray.length) {
                    DirectXAResourceMap.unregister(xidImpl2);
                    throw throwable;
                }
                DirectXAResource directXAResource = directXAResourceArray[i];
                directXAResource.clearTransactionInfo();
                ++i;
            }
        }
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        if (_logFINE) {
            _loggerJX.fine("MQJMSRA_DXA1101: setTransactionTimeout()=" + n + ":returning false.");
        }
        return false;
    }

    public synchronized void start(Xid xid, int n) throws XAException {
        JMSServiceReply jMSServiceReply = null;
        long l = 0L;
        String string = "start()";
        if (_logFINE) {
            _loggerJX.fine(_lgrMID_INF + string + ":flags=" + n + ":connectioId=" + this.connectionId);
        }
        try {
            jMSServiceReply = this.jmsservice.startTransaction(this.connectionId, 0L, xid, n, JMSService.TransactionAutoRollback.UNSPECIFIED, 0L);
            try {
                l = jMSServiceReply.getJMQTransactionID();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                String string2 = "MQJMSRA_DXA4001: JMSServiceException:Missing JMQTransactionID";
                XAException xAException = new XAException(-7);
                xAException.initCause(noSuchFieldException);
                _loggerOC.severe(string2);
                throw xAException;
            }
        }
        catch (JMSServiceException jMSServiceException) {
            String string3;
            JMSServiceReply.Status status = jMSServiceException.getJMSServiceReply().getStatus();
            switch (status) {
                case NOT_IMPLEMENTED: {
                    string3 = "TransactionAutoRollback not implemented.";
                    break;
                }
                case CONFLICT: {
                    string3 = "CONFLICT: " + jMSServiceException.getCause().toString();
                    break;
                }
                default: {
                    string3 = "Unknown JMSService server error " + status + ": " + jMSServiceException.getCause().toString();
                }
            }
            String string4 = "startTransaction (XA) on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " due to " + string3;
            _loggerOC.severe(string4);
            XAException xAException = new XAException(-7);
            xAException.initCause(jMSServiceException);
            throw xAException;
        }
        assert (l != 0L);
        if (this.transactionId == 0L && this.xid == null) {
            this.transactionId = l;
            this.xid = new XidImpl(xid);
        } else if (this.xid.equals(xid)) {
            if (this.transactionId != l) {
                System.out.println("DXAR:start():Warning:Received diff txId for same Xid:switching transactionId:\nDXAR TXid=" + this.transactionId + "\ngot  TXid=" + l + "\nFor   Xid=" + this.xid.toString());
                this.transactionId = l;
            }
        } else {
            System.out.println("DXAR:start():Warning:Received diff Xid for open txnId:switching transactionId:\nDXAR  Xid=" + this.xid.toString() + "\nDXAR TXid=" + this.transactionId + "\ngot   Xid=" + xid.toString() + "\ngot  TXid=" + l);
            this.transactionId = l;
            this.xid = new XidImpl(xid);
        }
        boolean bl = (n & 0) == 0;
        DirectXAResourceMap.register(this.xid, this, bl);
        this.setEnlisted(true);
        this.xar_state = JMSService.TransactionState.STARTED;
        if (_logFINE) {
            _loggerJX.fine(_lgrMID_INF + string + ":connectionId=" + this.connectionId + ":started transactionId=" + this.transactionId);
        }
    }

    public synchronized void setEnlisted(boolean bl) {
        this.isEnlisted = bl;
        if (!this.usedByMDB && this.dc != null) {
            this.dc.setEnlisted(bl);
        }
    }

    protected void _setUsedByMDB(boolean bl) {
        this.usedByMDB = bl;
    }

    public synchronized boolean isEnlisted() {
        return this.isEnlisted;
    }

    public synchronized void setRollback(boolean bl, Throwable throwable) {
    }

    public int _getId() {
        return this.id;
    }

    public long _getTransactionId() {
        return this.transactionId;
    }

    static {
        _logFINE = false;
        Level level = _loggerJX.getLevel();
        if (level != null && (_logLevel = level.intValue()) <= Level.FINE.intValue()) {
            _logFINE = true;
        }
    }
}

