/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.Destination;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Consumer;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;

public abstract class TemporaryDestination
extends Destination {
    protected ConnectionImpl connection = null;
    private boolean isDeleted = false;

    protected TemporaryDestination(ConnectionImpl connectionImpl, String string) throws JMSException {
        super("temporary_destination://" + string + connectionImpl.getClientIDOrIPAddress() + "/" + connectionImpl.getProtocolHandler().getLocalPort() + "/" + connectionImpl.getTempDestSequence());
        this.connection = connectionImpl;
        connectionImpl.protocolHandler.createDestination(this);
        connectionImpl.addTempDest(this);
    }

    protected TemporaryDestination(String string) throws JMSException {
        super(string);
    }

    protected TemporaryDestination() throws JMSException {
    }

    public boolean isTemporary() {
        return true;
    }

    public void delete() throws JMSException {
        if (this.isDeleted) {
            return;
        }
        if (this.connection == null) {
            String string = AdministeredObject.cr.getKString("C4039");
            throw new JMSException(string, "C4039");
        }
        this.checkConsumer();
        this.connection.decreaseTempDestCounter();
        this.isDeleted = true;
        this.connection.getProtocolHandler().deleteDestination(this);
    }

    public static void checkTemporaryDestinationConsumerAllowed(ConnectionImpl connectionImpl, javax.jms.Destination destination) throws JMSException {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (destination instanceof TemporaryQueue) {
            string = ((Queue)destination).getQueueName();
            string2 = "temporary_destination://queue/";
        } else if (destination instanceof TemporaryTopic) {
            string = ((Topic)destination).getTopicName();
            string2 = "temporary_destination://topic/";
        }
        if (string != null) {
            string3 = connectionImpl.getClientIDOrIPAddress() + "/" + connectionImpl.getProtocolHandler().getLocalPort() + "/";
            if (!string.startsWith(string2 + string3)) {
                String string4 = AdministeredObject.cr.getKString("C4020", string);
                throw new JMSException(string4, "C4020");
            }
        }
    }

    protected void checkConsumer() throws JMSException {
        boolean bl = false;
        String string = this.getName();
        Object[] objectArray = this.connection.interestTable.toArray();
        Consumer consumer = null;
        String string2 = null;
        Destination destination = null;
        for (int i = 0; i < objectArray.length; ++i) {
            consumer = (Consumer)objectArray[i];
            destination = (Destination)consumer.getDestination();
            string2 = destination.getName();
            if (!string.equals(string2)) continue;
            bl = true;
            break;
        }
        if (bl) {
            String string3 = AdministeredObject.cr.getKString("C4039");
            throw new JMSException(string3, "C4039");
        }
    }

    public boolean checkSendCreateDest(javax.jms.Destination destination, ConnectionImpl connectionImpl) {
        try {
            TemporaryDestination.checkTemporaryDestinationConsumerAllowed(connectionImpl, destination);
        }
        catch (JMSException jMSException) {
            return false;
        }
        return true;
    }

    protected boolean isDeleted() {
        return this.isDeleted;
    }
}

