/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

public class TransactionDetails {
    private int type;
    private TransactionUID tid;
    private JMQXid xid;
    private int state;
    private boolean complete;

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        this.state = n;
    }

    public TransactionUID getTid() {
        return this.tid;
    }

    public void setTid(TransactionUID transactionUID) {
        this.tid = transactionUID;
    }

    public void readContent(DataInputStream dataInputStream) throws IOException, BrokerException {
        this.type = dataInputStream.readByte();
        long l = dataInputStream.readLong();
        TransactionUID transactionUID = new TransactionUID(l);
        this.setTid(transactionUID);
        int n = dataInputStream.readInt();
        this.setState(n);
        int n2 = dataInputStream.readInt();
        this.complete = n2 == 1;
        this.readXid(dataInputStream);
    }

    public void writeContent(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.type);
        dataOutputStream.writeLong(this.getTid().longValue());
        dataOutputStream.writeInt(this.getState());
        if (this.complete) {
            dataOutputStream.writeInt(1);
        } else {
            dataOutputStream.writeInt(0);
        }
        this.writeXid(dataOutputStream);
    }

    protected void readXid(DataInputStream dataInputStream) throws IOException {
        boolean bl = dataInputStream.readBoolean();
        if (bl) {
            this.xid = JMQXid.read((DataInput)dataInputStream);
        }
    }

    protected void writeXid(DataOutputStream dataOutputStream) throws IOException {
        if (this.getXid() == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            this.xid.write((DataOutput)dataOutputStream);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("type=").append(this.type);
        stringBuffer.append(" state=").append(TransactionState.toString(this.state));
        stringBuffer.append(" txnId = ").append(this.getTid());
        return new String(stringBuffer);
    }

    public JMQXid getXid() {
        return this.xid;
    }

    public void setXid(JMQXid jMQXid) {
        this.xid = jMQXid;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean bl) {
        this.complete = bl;
    }
}

