/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.ExpirationInfo;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerDownException;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.memory.MemoryGlobals;
import com.sun.messaging.jmq.util.lists.Ordered;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.lists.Sized;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class PacketReference
implements Sized,
Ordered {
    private static ConsumerUID queueUID = null;
    private static boolean PREPEND_ID = Globals.getConfig().getBooleanProperty("imq.fix.JMSMessageID", false);
    private boolean commit2pwait = Globals.getConfig().getBooleanProperty("imq.cluster.2pcommitAckWaitReply", false);
    private static boolean DEBUG;
    private static boolean DEBUG_CLUSTER_TXN;
    private boolean isStored = false;
    private boolean neverStore = false;
    private boolean isStoredWithInterest = false;
    private HashMap attachedData = null;
    private boolean destroyed = false;
    private SysMessageID msgid;
    transient ConnectionUID con_uid;
    private long creationtime;
    private long lastaccesstime;
    private int sequence;
    private boolean persist;
    private Set lbit_set = null;
    private boolean sendMessageDeliveredAck = false;
    private long size;
    private Hashtable props;
    private HashMap headers;
    private Object pktPtr;
    private int priority = 4;
    boolean isQueue = false;
    boolean invalid = false;
    boolean overrided = false;
    Object lockObject = new Object();
    boolean canLock = false;
    boolean locked = false;
    boolean overriding = false;
    Thread lockOwner = null;
    DestinationUID destination = null;
    ExpirationInfo expire = null;
    boolean isExpired = false;
    long timestamp = 0L;
    TransactionUID transactionid;
    transient boolean overrideRedeliver = false;
    transient BrokerAddress addr = null;
    transient Destination d = null;
    transient String clientID = null;
    int interestCnt;
    int deliveredCnt;
    int ackCnt;
    int deadCnt;
    Map ackInfo = null;
    private static final int INITIAL = 0;
    private static final int ROUTED = 1;
    private static final int DELIVERED = 2;
    private static final int CONSUMED = 3;
    private static final int ACKED = 4;
    private static final int DEAD = 5;
    ConsumerUID lastDead = null;
    long order = 0L;
    Set deliveredMsgAcks = new HashSet();
    Hashtable remoteConsumerUIDs = new Hashtable();

    public long getOrder() {
        return this.order;
    }

    public void setOrder(long l) {
        this.order = l;
    }

    public static ConsumerUID getQueueUID() {
        return queueUID;
    }

    public static PacketReference createReference(Packet packet, DestinationUID destinationUID, Connection connection) throws BrokerException {
        PacketReference packetReference = new PacketReference(packet, destinationUID, connection);
        if (connection != null && packetReference.getExpiration() != null) {
            connection.checkClockSkew(packetReference.getTime(), packetReference.getTimestamp(), packetReference.getExpireTime());
        }
        return packetReference;
    }

    public static PacketReference createReference(Packet packet, Connection connection) throws BrokerException {
        return PacketReference.createReference(packet, null, connection);
    }

    public static void moveMessage(PacketReference packetReference, PacketReference packetReference2, Set set) throws BrokerException, IOException {
        if (set == null) {
            throw new RuntimeException("Internal error: moving message to null targets not supported");
        }
        if (!packetReference.isStored && packetReference.persist) {
            packetReference2.store(set);
            return;
        }
        Object var3_3 = null;
        Object var4_4 = null;
        ReturnInfo returnInfo = PacketReference.calculateConsumerInfo(set, packetReference.persist);
        packetReference2.ackInfo = returnInfo.ackInfo;
        packetReference2.ackCnt = returnInfo.ackInfo.size();
        if (returnInfo.uids == null || returnInfo.uids.length == 0) {
            packetReference2.neverStore = true;
            packetReference2.isStored = false;
            packetReference2.isStoredWithInterest = false;
            return;
        }
        if (packetReference.isStored && packetReference.persist && !packetReference.neverStore) {
            Globals.getStore().moveMessage(packetReference2.getPacket(), packetReference.getDestinationUID(), packetReference2.getDestinationUID(), returnInfo.uids, returnInfo.states, Destination.PERSIST_SYNC);
            packetReference2.isStored = true;
            packetReference2.isStoredWithInterest = true;
            packetReference.isStored = false;
            packetReference.isStoredWithInterest = false;
        } else if (packetReference.persist) {
            Globals.getStore().storeMessage(packetReference2.getDestinationUID(), packetReference2.getPacket(), returnInfo.uids, returnInfo.states, Destination.PERSIST_SYNC);
            packetReference2.isStored = true;
            packetReference2.isStoredWithInterest = true;
            packetReference2.neverStore = false;
        } else {
            packetReference2.isStored = false;
            packetReference2.isStoredWithInterest = false;
            packetReference2.neverStore = true;
        }
    }

    private static ReturnInfo calculateConsumerInfo(Collection collection, boolean bl) {
        Object object;
        if (collection.isEmpty()) {
            return null;
        }
        ReturnInfo returnInfo = new ReturnInfo();
        returnInfo.ackInfo = Collections.synchronizedMap(new HashMap());
        ArrayList<ConsumerUID> arrayList = bl ? new ArrayList<ConsumerUID>() : null;
        Iterator iterator = collection.iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            object = iterator.next();
            ConsumerUID consumerUID = null;
            consumerUID = object instanceof Consumer ? ((Consumer)object).getStoredConsumerUID() : (ConsumerUID)object;
            ++returnInfo.interestCnt;
            boolean bl3 = false;
            if (arrayList != null && consumerUID.shouldStore()) {
                arrayList.add(consumerUID);
                bl3 = true;
            }
            ConsumerMessagePair consumerMessagePair = new ConsumerMessagePair(consumerUID, bl3);
            returnInfo.ackInfo.put(consumerUID, consumerMessagePair);
        }
        if (arrayList != null) {
            object = new ConsumerUID[]{};
            returnInfo.uids = (ConsumerUID[])arrayList.toArray((T[])object);
            returnInfo.states = new int[returnInfo.uids.length];
            for (int i = 0; i < returnInfo.states.length; ++i) {
                returnInfo.states[i] = 0;
            }
        }
        return returnInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PacketReference(Packet packet, DestinationUID destinationUID, Connection connection) throws BrokerException {
        this.lastaccesstime = this.creationtime = System.currentTimeMillis();
        this.msgid = (SysMessageID)packet.getSysMessageID().clone();
        this.isQueue = packet.getIsQueue();
        this.persist = packet.getPersistent();
        this.priority = packet.getPriority();
        this.sequence = packet.getSequence();
        this.timestamp = packet.getTimestamp();
        if (packet.getRedelivered()) {
            this.overrideRedeliver = true;
        }
        if (connection != null) {
            this.clientID = (String)connection.getClientData("client id");
        }
        this.setExpireTime(packet.getExpiration());
        this.size = packet.getPacketSize();
        String string = packet.getDestination();
        this.con_uid = connection == null ? null : connection.getConnectionUID();
        this.destination = destinationUID != null ? destinationUID : DestinationUID.getUID(string, this.isQueue);
        long l = packet.getTransactionID();
        PacketReference packetReference = this;
        synchronized (packetReference) {
            this.setPacketObject(false, packet);
        }
        this.transactionid = l != 0L ? new TransactionUID(l) : null;
    }

    public void setSequence(int n) {
        this.sequence = n;
    }

    public String getClientID() {
        return this.clientID;
    }

    private ConsumerMessagePair getAck(Object object) {
        ConsumerUID consumerUID = null;
        if (object instanceof ConsumerUID) {
            consumerUID = (ConsumerUID)object;
        } else if (object instanceof Consumer) {
            consumerUID = ((Consumer)object).getConsumerUID();
        } else {
            throw new RuntimeException("Bogus ID");
        }
        if (this.ackInfo == null) {
            throw new RuntimeException("Internal Error: No AckInfo for message " + this.getSysMessageID());
        }
        return (ConsumerMessagePair)this.ackInfo.get(consumerUID);
    }

    public void setDestination(Destination destination) {
        this.d = destination;
    }

    public Destination getDestination() {
        if (this.d == null) {
            this.d = Destination.getDestination(this.destination);
        }
        return this.d;
    }

    boolean isStored() {
        return this.isStored;
    }

    public void setBrokerAddress(BrokerAddress brokerAddress) {
        this.addr = brokerAddress;
    }

    public BrokerAddress getAddress() {
        return this.addr;
    }

    public boolean isLocal() {
        return this.addr == null || this.addr == Globals.getMyAddress();
    }

    public String toString() {
        return "PacketReference[" + this.msgid + "]";
    }

    public synchronized boolean getMessageDeliveredAck(ConsumerUID consumerUID) {
        return !this.deliveredMsgAcks.isEmpty() && this.deliveredMsgAcks.contains(consumerUID);
    }

    public synchronized ConsumerUID[] getConsumersForMsgDelivered() {
        return this.deliveredMsgAcks.toArray(new ConsumerUID[0]);
    }

    public synchronized void removeMessageDeliveredAck(ConsumerUID consumerUID) {
        this.deliveredMsgAcks.remove(consumerUID);
    }

    public synchronized void addMessageDeliveredAck(ConsumerUID consumerUID) {
        this.deliveredMsgAcks.add(consumerUID);
    }

    public void addRemoteConsumerUID(ConsumerUID consumerUID, ConnectionUID connectionUID) {
        this.remoteConsumerUIDs.put(consumerUID, connectionUID);
    }

    public Hashtable getRemoteConsumerUIDs() {
        return this.remoteConsumerUIDs;
    }

    private void setExpireTime(long l) {
        this.expire = l == 0L ? null : new ExpirationInfo(this.msgid, l);
    }

    public long getExpireTime() {
        if (this.expire == null) {
            return 0L;
        }
        return this.expire.getExpireTime();
    }

    public ExpirationInfo getExpiration() {
        return this.expire;
    }

    public void overrided() {
        this.overrided = true;
    }

    public boolean isOverrided() {
        return this.overrided;
    }

    public void overriding() {
        this.overriding = true;
    }

    public boolean isOverriding() {
        return this.overriding;
    }

    public void lock() {
        this.canLock = true;
        this.locked = true;
        this.lockOwner = Thread.currentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        Object object = this.lockObject;
        synchronized (object) {
            this.locked = false;
            this.lockOwner = null;
            this.lockObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketReference checkLock(boolean bl) {
        if (!this.canLock) {
            return this;
        }
        Object object = this.lockObject;
        synchronized (object) {
            if (this.locked && this.lockOwner != null && Thread.currentThread() == this.lockOwner) {
                return this;
            }
            while (bl && this.locked) {
                Globals.getLogger().log(8, "Wait for reference : " + this);
                try {
                    this.lockObject.wait(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.locked) {
                return null;
            }
        }
        return this;
    }

    public void setInvalid() {
        this.invalid = true;
    }

    private Packet getPacketObject() {
        assert (this.pktPtr == null || this.pktPtr instanceof SoftReference || this.pktPtr instanceof Packet) : this.pktPtr;
        Object object = this.pktPtr;
        if (object == null) {
            return null;
        }
        if (object instanceof SoftReference) {
            return (Packet)((SoftReference)this.pktPtr).get();
        }
        return (Packet)this.pktPtr;
    }

    private void setPacketObject(boolean bl, Packet packet) {
        assert (Thread.holdsLock(this));
        this.pktPtr = bl ? new SoftReference<Packet>(packet) : packet;
    }

    private void makePacketSoftRef() {
        assert (Thread.holdsLock(this));
        Object object = this.pktPtr;
        if (object != null && object instanceof Packet) {
            this.pktPtr = new SoftReference<Object>(object);
        }
    }

    public void setNeverStore(boolean bl) {
        this.neverStore = bl;
    }

    public long byteSize() {
        return this.size;
    }

    public void setStoredWithInterest(boolean bl) {
        this.isStoredWithInterest = bl;
    }

    public synchronized void setLoaded() {
        this.isStored = true;
        this.makePacketSoftRef();
    }

    public ConnectionUID getProducingConnectionUID() {
        return this.con_uid;
    }

    public int getPriority() {
        return this.priority;
    }

    public TransactionUID getTransactionID() {
        return this.transactionid;
    }

    public boolean getIsQueue() {
        return this.isQueue;
    }

    public long getTime() {
        return this.creationtime;
    }

    public long getSequence() {
        return this.sequence;
    }

    public synchronized void setLastBit(ConsumerUID consumerUID) throws IllegalStateException {
        if (this.isInvalid() && this.isDestroyed()) {
            throw new IllegalStateException(Globals.getBrokerResources().getString("B4117", "reference has been destroyed"));
        }
        if (this.lbit_set == null) {
            this.lbit_set = new HashSet();
        }
        this.lbit_set.add(consumerUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("AckCount", String.valueOf(this.ackCnt));
        hashtable.put("DeadCount", String.valueOf(this.deadCnt));
        hashtable.put("ackInfo[#]", String.valueOf(this.ackInfo.size()));
        hashtable.put("interestCount", String.valueOf(this.interestCnt));
        Vector<String> vector = new Vector<String>();
        Map map = this.ackInfo;
        synchronized (map) {
            for (Object k : this.ackInfo.keySet()) {
                ConsumerMessagePair consumerMessagePair = this.getAck(k);
                vector.add(consumerMessagePair.toString());
            }
        }
        if (!vector.isEmpty()) {
            hashtable.put("Acks", vector);
        }
        return hashtable;
    }

    public synchronized boolean isLast(ConsumerUID consumerUID) {
        if (this.lbit_set == null) {
            return false;
        }
        return this.lbit_set.contains(consumerUID);
    }

    public synchronized void removeIsLast(ConsumerUID consumerUID) {
        if (this.lbit_set == null) {
            return;
        }
        this.lbit_set.remove(consumerUID);
        if (this.lbit_set.isEmpty() && this.invalid) {
            this.destroy();
        }
    }

    public synchronized boolean getLBitSet() {
        return this.lbit_set != null && !this.lbit_set.isEmpty();
    }

    public DestinationUID getDestinationUID() {
        return this.destination;
    }

    public String getDestinationName() {
        return this.destination.getName();
    }

    public synchronized Packet getPacket() {
        Packet packet = this.getPacketObject();
        if (packet != null || this.destroyed) {
            return packet;
        }
        assert (this.persist);
        if (!this.persist) {
            return null;
        }
        packet = this.recoverPacket();
        assert (packet != null);
        this.setPacketObject(true, packet);
        return packet;
    }

    private Packet recoverPacket() {
        assert (Thread.holdsLock(this));
        assert (this.pktPtr == null || this.pktPtr instanceof SoftReference && ((Reference)this.pktPtr).get() == null);
        try {
            Packet packet = Globals.getStore().getMessage(this.destination, this.msgid);
            assert (packet != null);
            return packet;
        }
        catch (BrokerException brokerException) {
            assert (false) : brokerException;
            Globals.getLogger().logStack(32, "B3144", (Object)this.msgid.toString(), (Throwable)brokerException);
            return null;
        }
    }

    public synchronized Hashtable getProperties() throws ClassNotFoundException {
        if (this.destroyed || this.invalid) {
            return new Hashtable();
        }
        this.lastaccesstime = System.currentTimeMillis();
        Packet packet = this.getPacketObject();
        if (this.props == null && !this.destroyed) {
            if (packet == null) {
                packet = this.getPacket();
            }
            try {
                this.props = packet.getProperties();
            }
            catch (IOException iOException) {
                Globals.getLogger().log(8, "Internal Exception: ", (Throwable)iOException);
                this.props = new Hashtable();
            }
            catch (ClassNotFoundException classNotFoundException) {
                assert (false);
                throw classNotFoundException;
            }
        }
        return this.props;
    }

    public synchronized HashMap getHeaders() {
        if (this.headers == null) {
            if (this.destroyed || this.invalid) {
                return new HashMap();
            }
            Packet packet = this.getPacketObject();
            assert (packet != null);
            this.headers = new HashMap();
            if (packet == null) {
                if (DEBUG) {
                    Globals.getLogger().log(4, "no packet for non-destroyed message " + this.msgid);
                }
                return this.headers;
            }
            this.headers.put("JMSPriority", new Integer(this.priority));
            this.headers.put("JMSMessageID", (PREPEND_ID ? "ID:" : "") + this.msgid.toString());
            this.headers.put("JMSTimestamp", new Long(this.timestamp));
            this.headers.put("JMSDeliveryMode", packet.getPersistent() ? "PERSISTENT" : "NON_PERSISTENT");
            this.headers.put("JMSCorrelationID", packet.getCorrelationID());
            this.headers.put("JMSType", packet.getMessageType());
        }
        return this.headers;
    }

    public SysMessageID getSysMessageID() {
        return this.msgid;
    }

    public String getSysMessageIDString() {
        HashMap hashMap = this.getHeaders();
        if (hashMap == null) {
            return null;
        }
        return (String)hashMap.get("JMSMessageID");
    }

    public long getCreateTime() {
        return this.creationtime;
    }

    public long getLastAccessTime() {
        return this.lastaccesstime;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long l) {
        this.timestamp = l;
    }

    public boolean isPersistent() {
        return this.persist;
    }

    public void overridePersistence(boolean bl) {
        this.persist = bl;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public synchronized boolean isInvalid() {
        return this.invalid;
    }

    public boolean mayExpire() {
        return this.expire == null;
    }

    public boolean isExpired() {
        if (this.expire == null) {
            return false;
        }
        return this.isExpired(System.currentTimeMillis());
    }

    public void overrideExpireTime(long l) {
        this.setExpireTime(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpired(long l) {
        if (this.isExpired) {
            return true;
        }
        if (this.expire == null) {
            return false;
        }
        boolean bl = this.expire.isExpired(l);
        if (bl) {
            PacketReference packetReference = this;
            synchronized (packetReference) {
                this.makePacketSoftRef();
            }
        }
        return bl;
    }

    void clearExpirationInfo() {
        this.isExpired = true;
        this.expire = null;
    }

    public boolean equals(Object object) {
        if (this.msgid == null) {
            return this.msgid == object;
        }
        if (object instanceof SysMessageID) {
            return this.msgid.equals(object);
        }
        if (object instanceof Packet) {
            return this.msgid.equals((Object)((Packet)object).getSysMessageID());
        }
        if (object instanceof PacketReference) {
            return this.msgid.equals((Object)((PacketReference)object).msgid);
        }
        return false;
    }

    public int hashCode() {
        return this.msgid == null ? 0 : this.msgid.hashCode();
    }

    public boolean matches(DestinationUID destinationUID) {
        return true;
    }

    public static String stateToString(int n) {
        switch (n) {
            case 0: {
                return "INITIAL";
            }
            case 1: {
                return "ROUTED";
            }
            case 2: {
                return "DELIVERED";
            }
            case 3: {
                return "CONSUMED";
            }
            case 4: {
                return "ACKED";
            }
            case 5: {
                return "DEAD";
            }
        }
        return "UNKNOWN";
    }

    public synchronized void store() throws BrokerException {
        if (!this.destroyed && this.persist && !this.neverStore && !this.isStored) {
            assert (this.pktPtr instanceof Packet);
            try {
                Globals.getStore().storeMessage(this.destination, this.getPacket(), Destination.PERSIST_SYNC);
                if (Globals.isNewTxnLogEnabled()) {
                    if (this.getPacket().getTransactionID() <= 0L) {
                        this.makePacketSoftRef();
                    }
                } else {
                    this.makePacketSoftRef();
                }
            }
            catch (IOException iOException) {
                throw new BrokerException(iOException.toString(), iOException);
            }
            catch (Exception exception) {
                Globals.getLogger().logStack(32, "B2011", (Object)this.msgid.toString(), (Throwable)exception);
                throw new BrokerException(exception.toString(), exception);
            }
            this.isStored = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Collection collection) throws BrokerException {
        block15: {
            if (this.destroyed || this.pktPtr == null) {
                return;
            }
            if (this.isStoredWithInterest) {
                return;
            }
            boolean bl = !this.neverStore && this.persist;
            ReturnInfo returnInfo = PacketReference.calculateConsumerInfo(collection, bl);
            if (this.ackInfo != null) {
                this.ackInfo.putAll(returnInfo.ackInfo);
            } else {
                this.ackInfo = returnInfo.ackInfo;
            }
            this.interestCnt = returnInfo.ackInfo.size();
            if (!bl) {
                return;
            }
            if (returnInfo.uids == null || returnInfo.uids.length == 0) {
                this.neverStore = true;
                return;
            }
            try {
                if (this.isStored && !this.neverStore && this.persist) {
                    Globals.getStore().storeInterestStates(this.destination, this.msgid, returnInfo.uids, returnInfo.states, Destination.PERSIST_SYNC, this.getPacket());
                    break block15;
                }
                assert (this.pktPtr instanceof Packet || this.pktPtr == null && this.destroyed) : "PktPtr is " + this.pktPtr.getClass();
                Globals.getStore().storeMessage(this.destination, (Packet)this.pktPtr, returnInfo.uids, returnInfo.states, Destination.PERSIST_SYNC);
                PacketReference packetReference = this;
                synchronized (packetReference) {
                    this.makePacketSoftRef();
                }
            }
            catch (IOException iOException) {
                throw new BrokerException(iOException.toString(), iOException);
            }
            catch (Exception exception) {
                Globals.getLogger().logStack(32, "B2011", (Object)this.msgid.toString(), (Throwable)exception);
                throw new BrokerException(exception.toString(), exception);
            }
        }
        this.isStored = true;
        this.isStoredWithInterest = true;
        assert (this.interestCnt != 0);
    }

    public ConsumerUID[] getRoutingForStore(Collection collection) throws BrokerException {
        boolean bl;
        if (this.destroyed || this.pktPtr == null) {
            return null;
        }
        boolean bl2 = bl = !this.neverStore && this.persist;
        if (!bl) {
            return null;
        }
        if (collection.isEmpty()) {
            return null;
        }
        ArrayList<ConsumerUID> arrayList = null;
        for (Object e : collection) {
            ConsumerUID consumerUID = null;
            consumerUID = e instanceof Consumer ? ((Consumer)e).getStoredConsumerUID() : (ConsumerUID)e;
            if (!consumerUID.shouldStore()) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<ConsumerUID>();
            }
            arrayList.add(consumerUID);
        }
        if (arrayList == null) {
            return null;
        }
        return arrayList.toArray(new ConsumerUID[0]);
    }

    public void add(Collection collection) {
        for (Object e : collection) {
            ConsumerUID consumerUID = null;
            ConsumerUID consumerUID2 = null;
            Session session = null;
            boolean bl = false;
            if (e instanceof ConsumerUID) {
                consumerUID = (ConsumerUID)e;
            } else {
                consumerUID = ((Consumer)e).getStoredConsumerUID();
                consumerUID2 = ((Consumer)e).getConsumerUID();
                if (consumerUID2 != null) {
                    session = Session.getSession(consumerUID2);
                }
            }
            if (consumerUID2 != null && (consumerUID2.getAckType() == 0 || session != null && session.isTransacted())) {
                bl = true;
            }
            if (!bl) {
                ++this.interestCnt;
            }
            if (this.ackInfo == null) {
                this.ackInfo = Collections.synchronizedMap(new HashMap());
            }
            ConsumerMessagePair consumerMessagePair = new ConsumerMessagePair(consumerUID, false);
            consumerMessagePair.setState(1);
            if (bl) {
                if (this.ackInfo.get(consumerUID) == null) {
                    ++this.interestCnt;
                } else {
                    this.overriding();
                }
            }
            this.ackInfo.put(consumerUID, consumerMessagePair);
        }
    }

    public void update(ConsumerUID[] consumerUIDArray, int[] nArray) {
        this.update(consumerUIDArray, nArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) {
        assert (this.isStored);
        assert (consumerUIDArray != null);
        assert (nArray != null);
        assert (consumerUIDArray.length == nArray.length);
        assert (this.ackInfo == null);
        assert (consumerUIDArray.length != 0);
        PacketReference packetReference = this;
        synchronized (packetReference) {
            this.interestCnt += consumerUIDArray.length;
        }
        for (int i = 0; i < consumerUIDArray.length; ++i) {
            ConsumerUID consumerUID = consumerUIDArray[i];
            assert (consumerUIDArray[i] != null);
            assert (nArray[i] >= 0 && nArray[i] <= 2);
            if (nArray[i] == 2) continue;
            if (this.ackInfo == null) {
                this.ackInfo = Collections.synchronizedMap(new HashMap());
            }
            ConsumerMessagePair consumerMessagePair = new ConsumerMessagePair(consumerUID, true);
            this.ackInfo.put(consumerUID, consumerMessagePair);
            consumerMessagePair.setState(nArray[i] == 0 ? 1 : 3);
            if (!bl) continue;
            try {
                Globals.getStore().storeInterestStates(this.destination, this.msgid, consumerUIDArray, nArray, Destination.PERSIST_SYNC, (Packet)this.pktPtr);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        assert (this.interestCnt != 0);
    }

    public void debug(String string) {
        if (string == null) {
            string = "";
        }
        Globals.getLogger().log(8, string + "Message " + this.msgid);
        Globals.getLogger().log(8, string + "size " + this.ackInfo.size());
        for (ConsumerMessagePair consumerMessagePair : this.ackInfo.values()) {
            Globals.getLogger().log(8, string + "\t " + consumerMessagePair);
        }
    }

    public void routed(ConsumerUID consumerUID) throws BrokerException, IOException {
        if (this.destroyed || this.invalid) {
            Globals.getLogger().log(4, "route on destroyed ref " + this.msgid + ":" + consumerUID);
            return;
        }
    }

    public int getCompleteCnt() {
        return this.ackCnt + this.deadCnt;
    }

    public int getDeliverCnt() {
        return this.deliveredCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SysMessageID replacePacket(Hashtable hashtable, byte[] byArray) throws BrokerException, IOException {
        ConsumerUID[] consumerUIDArray;
        if (this.deliveredCnt > 0) {
            throw new BrokerException("Unable to replace already delivered message");
        }
        if (this.ackCnt > 0) {
            throw new BrokerException("Unable to replace partially acknowledged message");
        }
        Packet packet = this.getPacket();
        Packet packet2 = new Packet();
        packet2.fill(packet);
        packet2.updateSequenceNumber();
        packet2.updateTimestamp();
        packet2.setMessageBody(byArray);
        this.headers = null;
        Hashtable<String, String> hashtable2 = null;
        try {
            hashtable2 = this.getProperties();
            if (hashtable2 == null) {
                hashtable2 = new Hashtable<String, String>();
            }
            if (hashtable != null) {
                Globals.getLogger().log(4, "Warning although properties have been changed on the message it will not be rerouted");
                hashtable2.putAll(hashtable);
            }
            hashtable2.put("JMSOrigMessageID", (PREPEND_ID ? "ID:" : "") + this.msgid.toString());
            if (this.getHeaders() != null) {
                Hashtable hashtable3 = new Hashtable();
                consumerUIDArray = this.getHeaders();
                for (Object object2 : consumerUIDArray.keySet()) {
                    Iterator iterator = consumerUIDArray.get(object2);
                    if (iterator == null) continue;
                    hashtable3.put(object2, iterator);
                }
            }
            packet2.setProperties(hashtable2);
        }
        catch (Exception exception) {
            Globals.getLogger().logStack(8, "Internal Error updating properties", (Throwable)exception);
        }
        this.setPacketObject(true, packet2);
        if (this.isStoredWithInterest) {
            int n = 0;
            consumerUIDArray = null;
            Object object = null;
            if (this.ackInfo != null) {
                Object object2;
                object2 = this.ackInfo;
                synchronized (object2) {
                    for (ConsumerMessagePair consumerMessagePair : this.ackInfo.values()) {
                        if (!consumerMessagePair.stored) continue;
                        ++n;
                    }
                    consumerUIDArray = new ConsumerUID[n];
                    object = new int[n];
                    int n2 = 0;
                    for (ConsumerMessagePair consumerMessagePair : this.ackInfo.values()) {
                        if (consumerMessagePair.stored) {
                            consumerUIDArray[n2] = consumerMessagePair.uid;
                            object[n2] = consumerMessagePair.state;
                        }
                        ++n2;
                    }
                }
                Globals.getStore().storeMessage(this.destination, packet2, consumerUIDArray, (int[])object, Destination.PERSIST_SYNC);
            } else {
                Globals.getStore().storeMessage(this.destination, packet2, Destination.PERSIST_SYNC);
            }
        } else if (this.isStored) {
            Globals.getStore().storeMessage(this.destination, packet2, Destination.PERSIST_SYNC);
        }
        this.setPacketObject(this.persist, packet2);
        this.headers = null;
        hashtable = null;
        SysMessageID sysMessageID = this.msgid;
        this.msgid = (SysMessageID)packet2.getSysMessageID().clone();
        if (this.isStored || this.isStoredWithInterest) {
            Globals.getLogger().log(4, "Cleaning up the old replaced message");
            Globals.getStore().removeMessage(this.destination, sysMessageID, Destination.PERSIST_SYNC);
        }
        return this.msgid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delivered(ConsumerUID consumerUID, ConsumerUID consumerUID2, boolean bl, boolean bl2) throws BrokerException, IOException {
        PacketReference packetReference;
        if (this.destroyed || this.invalid) {
            Globals.getLogger().log(4, "delivered on destroyed ref " + this.msgid + ":" + consumerUID2);
            return true;
        }
        if (consumerUID.isNoAck()) {
            return this.acknowledged(consumerUID, consumerUID2, bl, bl2);
        }
        ConsumerMessagePair consumerMessagePair = this.getAck(consumerUID2);
        if (consumerMessagePair == null) {
            Globals.getLogger().log(4, "Received Unknown delivered:\n\tStoreUID: " + consumerUID2 + "\n\tConsumerUID: " + consumerUID + "\n\tConsumer: " + Consumer.getConsumer(consumerUID));
            this.debug("\t- ");
            return false;
        }
        if (consumerMessagePair.compareStateLT(2)) {
            packetReference = this;
            synchronized (packetReference) {
                ++this.deliveredCnt;
            }
        }
        consumerMessagePair.setStateIfLess(2, 2);
        if (consumerMessagePair.isStored() && bl2) {
            Globals.getStore().updateInterestState(this.destination, this.msgid, consumerUID2, 1, Destination.PERSIST_SYNC && bl, null, false);
        }
        packetReference = this;
        synchronized (packetReference) {
            if (this.deliveredCnt >= this.interestCnt && this.isStored && (MemoryGlobals.MEM_FREE_P_ACKED && this.persist || MemoryGlobals.MEM_FREE_NP_ACKED && !this.persist)) {
                this.unload();
            }
        }
        return false;
    }

    public int getRedeliverCount(ConsumerUID consumerUID) {
        ConsumerMessagePair consumerMessagePair = this.getAck(consumerUID);
        return consumerMessagePair == null ? 0 : consumerMessagePair.getRedeliverCount();
    }

    public void consumed(ConsumerUID consumerUID, boolean bl, boolean bl2) throws BrokerException, IOException {
        if (this.destroyed || this.invalid) {
            Globals.getLogger().log(4, "consumed on destroyed ref " + this.msgid + ":" + consumerUID);
            return;
        }
        if (bl2) {
            this.delivered(consumerUID, consumerUID, bl, true);
        }
        assert (this.ackInfo != null);
        ConsumerMessagePair consumerMessagePair = this.getAck(consumerUID);
        assert (consumerMessagePair != null);
        if (consumerMessagePair == null) {
            Globals.getLogger().log(32, "Internal Error: unknown interest for  consumed on " + this.msgid + consumerUID);
            return;
        }
        consumerMessagePair.incrementRedeliver();
        consumerMessagePair.setStateIfLess(3, 3);
    }

    public boolean matches(ConsumerUID consumerUID) {
        return this.getAck(consumerUID) != null;
    }

    public boolean isAcknowledged(ConsumerUID consumerUID) {
        ConsumerMessagePair consumerMessagePair = this.getAck(consumerUID);
        if (consumerMessagePair == null) {
            return true;
        }
        return consumerMessagePair.compareState(4);
    }

    public boolean isDelivered(ConsumerUID consumerUID) {
        ConsumerMessagePair consumerMessagePair = this.getAck(consumerUID);
        if (consumerMessagePair == null) {
            return true;
        }
        return consumerMessagePair.compareState(2) || consumerMessagePair.compareState(3);
    }

    public boolean removeDelivered(ConsumerUID consumerUID, boolean bl) {
        if (this.destroyed || this.invalid) {
            return true;
        }
        ConsumerMessagePair consumerMessagePair = this.getAck(consumerUID);
        assert (consumerMessagePair != null);
        if (consumerMessagePair == null) {
            Globals.getLogger().log(32, "Internal Error: unknown interest for  remove consumed on " + this.msgid + consumerUID);
            return false;
        }
        if (bl) {
            consumerMessagePair.decrementRedeliver();
        }
        consumerMessagePair.compareAndSetState(1, 2);
        return consumerMessagePair.getRedeliverCount() >= 20;
    }

    public boolean hasConsumerAcked(ConsumerUID consumerUID) {
        try {
            if (this.destroyed || this.invalid) {
                return true;
            }
            ConsumerMessagePair consumerMessagePair = this.getAck(consumerUID);
            if (consumerMessagePair != null && consumerMessagePair.getState() != 4) {
                return false;
            }
        }
        catch (Throwable throwable) {
            Globals.getLogger().logStack(32, "Internal Error checking ack on " + this.msgid + " for " + consumerUID, throwable);
            return false;
        }
        return true;
    }

    public boolean acknowledged(ConsumerUID consumerUID, ConsumerUID consumerUID2, boolean bl, boolean bl2) throws BrokerException, IOException {
        return this.acknowledged(consumerUID, consumerUID2, bl, bl2, null, null, true);
    }

    public boolean acknowledged(ConsumerUID consumerUID, ConsumerUID consumerUID2, boolean bl, boolean bl2, boolean bl3) throws BrokerException, IOException {
        return this.acknowledged(consumerUID, consumerUID2, bl, bl2, null, null, bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acknowledged(ConsumerUID consumerUID, ConsumerUID consumerUID2, boolean bl, boolean bl2, TransactionUID transactionUID, HashMap hashMap, boolean bl3) throws BrokerException, IOException {
        Long l = transactionUID == null ? null : new Long(transactionUID.longValue());
        try {
            block44: {
                if (this.destroyed || this.invalid) {
                    return true;
                }
                ConsumerMessagePair consumerMessagePair = this.getAck(consumerUID2);
                if (consumerMessagePair == null) {
                    Globals.getLogger().log(32, "Internal Error: Received Unknown ack " + consumerUID + " for message " + this.getSysMessageID());
                    Globals.getLogger().log(32, "AckInfo" + this.ackInfo.toString());
                    PacketReference packetReference = this;
                    synchronized (packetReference) {
                        return this.ackCnt + this.deadCnt >= this.interestCnt;
                    }
                }
                if (consumerMessagePair.setState(4)) {
                    SysMessageID[] sysMessageIDArray;
                    if (consumerMessagePair.isStored()) {
                        boolean bl4 = false;
                        sysMessageIDArray = Globals.getStore();
                        if (sysMessageIDArray.isJDBCStore()) {
                            bl4 = sysMessageIDArray.hasMessageBeenAcked(this.destination, this.msgid);
                        }
                        if (!bl4) {
                            try {
                                boolean bl5 = false;
                                PacketReference packetReference = this;
                                synchronized (packetReference) {
                                    bl5 = this.ackCnt + 1 + this.deadCnt >= this.interestCnt;
                                }
                                sysMessageIDArray.updateInterestState(this.destination, this.msgid, consumerUID2, 2, Destination.PERSIST_SYNC && bl, transactionUID, bl5);
                            }
                            catch (Exception exception) {
                                if (exception instanceof BrokerException && ((BrokerException)exception).getStatusCode() != 405 && ((BrokerException)exception).getStatusCode() != 404) {
                                    Globals.getLogger().log(16, "Update consumer " + consumerUID2 + " state failed for message " + this.msgid + ": " + exception.getMessage());
                                    throw exception;
                                }
                                Globals.getLogger().log(1, "Update consumer " + consumerUID2 + " state failed for message " + this.msgid + ": " + exception.getMessage());
                            }
                        }
                    }
                    if (!this.isLocal()) {
                        if (bl2) {
                            if (Globals.getClusterBroadcast().getClusterVersion() < 410) {
                                Globals.getClusterBroadcast().acknowledgeMessage(this.getAddress(), this.getSysMessageID(), consumerUID, 1, null, false);
                            } else if (l == null) {
                                Globals.getClusterBroadcast().acknowledgeMessage(this.getAddress(), this.getSysMessageID(), consumerUID, 1, null, bl && bl3);
                            } else {
                                BrokerAddress brokerAddress = this.getAddress();
                                if (hashMap == null || hashMap.get(brokerAddress) == null) {
                                    sysMessageIDArray = new SysMessageID[]{this.getSysMessageID()};
                                    ConsumerUID[] consumerUIDArray = new ConsumerUID[]{consumerUID};
                                    try {
                                        Globals.getClusterBroadcast().acknowledgeMessage2P(brokerAddress, sysMessageIDArray, consumerUIDArray, 1, null, l, true, !this.commit2pwait);
                                        hashMap.put(brokerAddress, "");
                                        if (this.commit2pwait) {
                                            Globals.getTransactionList().completeClusterTransactionBrokerState(transactionUID, 6, brokerAddress, true);
                                        }
                                    }
                                    catch (Exception exception) {
                                        if (exception instanceof BrokerDownException) {
                                            hashMap.put(brokerAddress, "");
                                        }
                                        if (DEBUG_CLUSTER_TXN) {
                                            Globals.getLogger().logStack(16, "Notify commit transaction [" + this.getSysMessageID() + ", " + consumerUID + "]TUID=" + l + " got response: " + exception.toString(), (Throwable)exception);
                                            break block44;
                                        }
                                        Globals.getLogger().log(16, "Notify commit transaction [" + this.getSysMessageID() + ", " + consumerUID + "]TUID=" + l + " got response: " + exception.toString(), (Throwable)exception);
                                    }
                                }
                            }
                        } else {
                            try {
                                Globals.getClusterBroadcast().acknowledgeMessage(this.getAddress(), this.getSysMessageID(), consumerUID, 5, null, false);
                            }
                            catch (BrokerException brokerException) {
                                Globals.getLogger().log(4, brokerException.getMessage());
                            }
                        }
                    }
                } else {
                    Consumer consumer = Consumer.getConsumer(consumerUID);
                    if (consumer == null || !consumer.isValid()) {
                        PacketReference packetReference = this;
                        synchronized (packetReference) {
                            return this.ackCnt + this.deadCnt >= this.interestCnt;
                        }
                    }
                    Exception exception = new Exception("double ack " + consumerMessagePair);
                    exception.fillInStackTrace();
                    Globals.getLogger().logStack(32, "Internal Error: received ack twice  on " + this.msgid + " for " + consumerUID + " state is = " + consumerMessagePair, (Throwable)exception);
                    PacketReference packetReference = this;
                    synchronized (packetReference) {
                        return this.ackCnt + this.deadCnt >= this.interestCnt;
                    }
                }
            }
            PacketReference packetReference = this;
            synchronized (packetReference) {
                ++this.ackCnt;
                return this.ackCnt + this.deadCnt >= this.interestCnt;
            }
        }
        catch (Throwable throwable) {
            Globals.getLogger().logStack(32, "Error in processing ack on " + this.msgid + " for " + consumerUID, throwable);
            if (throwable instanceof BrokerException) {
                throw (BrokerException)throwable;
            }
            throw new BrokerException("Unable to process ack", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acknowledgedOnReplay(ConsumerUID consumerUID, ConsumerUID consumerUID2) throws BrokerException, IOException {
        try {
            if (this.destroyed || this.invalid) {
                return true;
            }
            ConsumerMessagePair consumerMessagePair = this.getAck(consumerUID2);
            if (consumerMessagePair == null) {
                Globals.getLogger().log(32, "Internal Error: Received Unknown ack " + consumerUID + " for message " + this.getSysMessageID());
                Globals.getLogger().log(32, "AckInfo" + this.ackInfo.toString());
                PacketReference packetReference = this;
                synchronized (packetReference) {
                    return this.ackCnt + this.deadCnt >= this.interestCnt;
                }
            }
            consumerMessagePair.setState(4);
            ++this.ackCnt;
            return this.ackCnt + this.deadCnt >= this.interestCnt;
        }
        catch (Throwable throwable) {
            Globals.getLogger().logStack(32, "Error in processing ack on " + this.msgid + " for " + consumerUID, throwable);
            if (throwable instanceof BrokerException) {
                throw (BrokerException)throwable;
            }
            throw new BrokerException("Unable to process ack", throwable);
        }
    }

    public void overrideRedeliver() {
        if (!this.overrideRedeliver) {
            this.overrideRedeliver = true;
        }
    }

    public boolean getRedeliverFlag(ConsumerUID consumerUID) {
        if (this.destroyed || this.invalid) {
            Globals.getLogger().log(4, "redeliver for destroyed " + this.msgid + ":" + consumerUID);
            return true;
        }
        ConsumerMessagePair consumerMessagePair = this.getAck(consumerUID);
        assert (consumerMessagePair != null);
        if (consumerMessagePair == null) {
            return false;
        }
        if (this.overrideRedeliver) {
            return true;
        }
        return !consumerMessagePair.compareStateLT(2);
    }

    public boolean getConsumed(ConsumerUID consumerUID) {
        if (this.destroyed || this.invalid) {
            Globals.getLogger().log(4, "getConsumed for destroyed " + this.msgid + ":" + consumerUID);
            return true;
        }
        ConsumerMessagePair consumerMessagePair = this.getAck(consumerUID);
        if (consumerMessagePair == null) {
            Globals.getLogger().log(32, "Internal Error: unknown interest for  getConsumed on " + this.msgid + consumerUID);
            return true;
        }
        return consumerMessagePair.compareState(3);
    }

    public synchronized void clear() {
        this.props = null;
        if (this.pktPtr instanceof Reference) {
            ((Reference)this.pktPtr).clear();
            ((Reference)this.pktPtr).enqueue();
        }
        this.pktPtr = null;
        this.msgid = null;
    }

    public void remove() {
        if (this.isStored && !this.neverStore && this.persist) {
            try {
                Globals.getStore().removeMessage(this.destination, this.msgid, false);
                this.isStored = false;
            }
            catch (IOException iOException) {
                Globals.getLogger().logStack(32, "B3145", (Object)this.msgid.toString(), (Throwable)iOException);
            }
            catch (BrokerException brokerException) {
                Globals.getLogger().logStack(32, "B3145", (Object)this.msgid.toString(), (Throwable)brokerException);
            }
            this.isStored = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        assert (!this.getLBitSet());
        PacketReference packetReference = this;
        synchronized (packetReference) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
        }
        if (this.isStored) {
            try {
                Globals.getStore().removeMessage(this.destination, this.msgid, false);
                this.isStored = false;
            }
            catch (IOException iOException) {
                Globals.getLogger().logStack(32, "B3145", (Object)this.msgid.toString(), (Throwable)iOException);
            }
            catch (BrokerException brokerException) {
                Globals.getLogger().logStack(32, "B3145", (Object)this.msgid.toString(), (Throwable)brokerException);
            }
        }
        this.props = null;
        if (this.pktPtr instanceof Reference) {
            ((Reference)this.pktPtr).clear();
            ((Reference)this.pktPtr).enqueue();
        }
        this.pktPtr = null;
    }

    void unload() {
        if (this.pktPtr instanceof SoftReference) {
            ((SoftReference)this.pktPtr).clear();
        }
    }

    public String getDeadComment() {
        if (this.lastDead == null) {
            return null;
        }
        ConsumerMessagePair consumerMessagePair = this.getAck(this.lastDead);
        return consumerMessagePair == null ? null : consumerMessagePair.getDeadComment();
    }

    public int getDeadDeliverCnt() {
        if (this.lastDead == null) {
            return this.getDeliverCnt();
        }
        ConsumerMessagePair consumerMessagePair = this.getAck(this.lastDead);
        return consumerMessagePair == null ? this.getDeliverCnt() : consumerMessagePair.getRedeliverCount();
    }

    public Reason getDeadReason() {
        if (this.lastDead == null) {
            return null;
        }
        ConsumerMessagePair consumerMessagePair = this.getAck(this.lastDead);
        return consumerMessagePair == null ? null : consumerMessagePair.getDeadReason();
    }

    public String getDeadBroker() {
        if (this.lastDead == null) {
            return null;
        }
        ConsumerMessagePair consumerMessagePair = this.getAck(this.lastDead);
        return consumerMessagePair == null ? null : consumerMessagePair.getDeadBroker();
    }

    public Throwable getDeadException() {
        if (this.lastDead == null) {
            return null;
        }
        ConsumerMessagePair consumerMessagePair = this.getAck(this.lastDead);
        return consumerMessagePair == null ? null : consumerMessagePair.getDeadException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markDead(ConsumerUID consumerUID, String string, Throwable throwable, Reason reason, int n, String string2) throws BrokerException {
        Object object;
        ConsumerMessagePair consumerMessagePair = this.getAck(consumerUID);
        if (consumerMessagePair == null) {
            Globals.getLogger().log(4, "Received unknown dead message " + consumerUID);
            return false;
        }
        if (!this.isLocal()) {
            object = new Hashtable<String, Object>();
            if (string != null) {
                ((Hashtable)object).put("JMS_SUN_DMQ_UNDELIVERED_COMMENT", string);
            }
            if (n != -1) {
                ((Hashtable)object).put("JMQ_SUN_JMSQ_TempRedeliverCnt", new Integer(n));
            }
            if (throwable != null) {
                ((Hashtable)object).put("JMS_SUN_DMQ_UNDELIVERED_EXCEPTION", throwable);
            }
            if (reason != null) {
                ((Hashtable)object).put("REASON", new Integer(reason.intValue()));
            }
            if (string2 != null) {
                ((Hashtable)object).put("JMS_SUN_DMQ_DEAD_BROKER", string2);
            }
            Globals.getClusterBroadcast().acknowledgeMessage(this.getAddress(), this.getSysMessageID(), consumerUID, 7, (Map)object, true);
            consumerMessagePair.setState(4);
        } else {
            this.lastDead = consumerUID;
            consumerMessagePair.setState(5);
            consumerMessagePair.setDeadComment(string);
            consumerMessagePair.setDeadReason(reason);
            consumerMessagePair.setDeadException(throwable);
            consumerMessagePair.setDeadBroker(string2);
            if (n > -1) {
                consumerMessagePair.setRedeliverCount(n);
            }
        }
        object = this;
        synchronized (object) {
            ++this.deadCnt;
            return this.ackCnt + this.deadCnt >= this.interestCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDead() {
        PacketReference packetReference = this;
        synchronized (packetReference) {
            return this.deadCnt > 0 && this.ackCnt + this.deadCnt >= this.interestCnt;
        }
    }

    public static void ReplaceTest() {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            DestinationUID destinationUID = new DestinationUID("test", true);
            DestinationUID destinationUID2 = new DestinationUID("test", false);
            ConsumerUID consumerUID = new ConsumerUID(1);
            ConsumerUID consumerUID2 = new ConsumerUID(2);
            ConsumerUID[] consumerUIDArray = new ConsumerUID[]{consumerUID, consumerUID2};
            Consumer consumer = new Consumer(destinationUID, null, false, queueUID);
            ArrayList<Consumer> arrayList = new ArrayList<Consumer>();
            arrayList.add(consumer);
            Consumer consumer2 = new Consumer(destinationUID2, null, false, consumerUID);
            Consumer consumer3 = new Consumer(destinationUID2, null, false, consumerUID2);
            ArrayList<Consumer> arrayList2 = new ArrayList<Consumer>();
            arrayList2.add(consumer2);
            arrayList2.add(consumer3);
            try {
                Destination.createDestination("test", 1);
                Destination.createDestination("test", 2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Packet packet = new Packet();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("MyName", "MyValue");
            byte[] byArray = new byte[]{1};
            packet.setProperties(hashtable);
            packet.setMessageBody(byArray);
            packet.updateTimestamp();
            packet.updateSequenceNumber();
            System.out.println("----------------------------------");
            System.out.println("Test1: non-persist No Properties");
            System.out.println("----------------------------------");
            System.out.print("Initial Packet " + packet.getSysMessageID());
            PacketReference packetReference = PacketReference.createReference(packet, destinationUID, null);
            System.out.println("\t[Body=" + packetReference.getPacket().getMessageBodyByteBuffer().get() + "]");
            packetReference.store(arrayList);
            byte[] byArray2 = new byte[]{2};
            try {
                object4 = packetReference.replacePacket(null, byArray2);
                System.out.print("New ID " + object4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.out.println("\t[Body=" + packetReference.getPacket().getMessageBodyByteBuffer().get() + "]");
            System.out.println("----------------------------------");
            System.out.println("Test2: persist No Properties");
            System.out.println("----------------------------------");
            packet = new Packet();
            hashtable = new Hashtable();
            hashtable.put("MyName", "MyValue");
            object4 = new byte[]{3};
            byte[] byArray3 = new byte[]{4};
            packet.setMessageBody((byte[])object4);
            packet.setPersistent(true);
            packet.setProperties(hashtable);
            packet.updateTimestamp();
            packet.updateSequenceNumber();
            System.out.print("Initial Packet " + packet.getSysMessageID());
            packetReference = PacketReference.createReference(packet, destinationUID, null);
            packetReference.store(arrayList);
            System.out.println("\t[Body=" + packetReference.getPacket().getMessageBodyByteBuffer().get() + "]");
            try {
                object3 = packetReference.replacePacket(null, byArray3);
                System.out.print("New ID " + object3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.out.println("\t[Body=" + packetReference.getPacket().getMessageBodyByteBuffer().get() + "]");
            System.out.println("----------------------------------");
            System.out.println("Test3: Topic and 2 consumerUID");
            System.out.println("----------------------------------");
            packet = new Packet();
            hashtable = new Hashtable();
            hashtable.put("MyName", "MyValue");
            object3 = new byte[]{5};
            byte[] byArray4 = new byte[]{6};
            packet.setMessageBody((byte[])object3);
            packet.setPersistent(true);
            packet.setIsQueue(false);
            packet.setProperties(hashtable);
            packet.updateTimestamp();
            packet.updateSequenceNumber();
            System.out.print("Initial Packet " + packet.getSysMessageID());
            packetReference = PacketReference.createReference(packet, destinationUID, null);
            packetReference.store(arrayList2);
            System.out.println("\t[Body=" + packetReference.getPacket().getMessageBodyByteBuffer().get() + "]");
            try {
                object2 = packetReference.replacePacket(null, byArray4);
                System.out.print("New ID " + object2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.out.println("\t[Body=" + packetReference.getPacket().getMessageBodyByteBuffer().get() + "]");
            System.out.println("----------------------------------");
            System.out.println("Test4: Updating Properties");
            System.out.println("----------------------------------");
            packet = new Packet();
            hashtable = new Hashtable();
            hashtable.put("MyName", "MyValue");
            object2 = new byte[]{7};
            byte[] byArray5 = new byte[]{8};
            packet.setMessageBody((byte[])object2);
            packet.setPersistent(true);
            packet.setIsQueue(false);
            packet.setProperties(hashtable);
            packet.updateTimestamp();
            packet.updateSequenceNumber();
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            hashtable2.put("MyNewName", "MyNewValue");
            hashtable2.put("MyName", "***REPLACE***");
            System.out.print("Initial Packet " + packet.getSysMessageID());
            packetReference = PacketReference.createReference(packet, destinationUID, null);
            System.out.println(packetReference.getProperties());
            packetReference.store(arrayList2);
            System.out.println("\t[Body=" + packetReference.getPacket().getMessageBodyByteBuffer().get() + "]");
            try {
                object = packetReference.replacePacket(hashtable2, byArray5);
                System.out.print("New ID " + object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.out.println("\t[Body=" + packetReference.getPacket().getMessageBodyByteBuffer().get() + "]");
            System.out.println(packetReference.getProperties());
            System.out.println("----------------------------------");
            System.out.println("Test5: Message Delivered");
            System.out.println("----------------------------------");
            packet = new Packet();
            hashtable = new Hashtable();
            hashtable.put("MyName", "MyValue");
            object = new byte[]{9};
            byte[] byArray6 = new byte[]{10};
            packet.setMessageBody((byte[])object);
            packet.setPersistent(true);
            packet.setIsQueue(false);
            packet.setProperties(hashtable);
            packet.updateTimestamp();
            packet.updateSequenceNumber();
            hashtable2 = new Hashtable();
            hashtable2.put("MyNewName", "MyNewValue");
            hashtable2.put("MyName", "***REPLACE***");
            packetReference = PacketReference.createReference(packet, destinationUID, null);
            packetReference.store(arrayList2);
            packetReference.delivered(consumerUID2, consumerUID2, false, false);
            System.out.print("Initial Packet " + packet.getSysMessageID());
            System.out.println("\t[Body=" + packetReference.getPacket().getMessageBodyByteBuffer().get() + "]");
            try {
                SysMessageID sysMessageID = packetReference.replacePacket(hashtable2, byArray6);
                System.out.print("New ID " + sysMessageID);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.out.println("\t[Body=" + packetReference.getPacket().getMessageBodyByteBuffer().get() + "]");
            System.out.println(packetReference.getProperties());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("RUNNING TEST");
        PacketReference.ReplaceTest();
    }

    static {
        queueUID = new ConsumerUID(true);
        queueUID.setShouldStore(true);
        DEBUG = false;
        DEBUG_CLUSTER_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn") || DEBUG;
    }

    static class ReturnInfo {
        ConsumerUID[] uids;
        int[] states;
        int interestCnt;
        Map ackInfo;

        ReturnInfo() {
        }
    }

    static class ConsumerMessagePair {
        private ConsumerUID uid;
        private int state = 0;
        private int redeliverCnt = 0;
        private boolean stored;
        private String deadComment = null;
        private Reason deadReason = null;
        private Throwable deadException = null;
        private long timestamp = 0L;
        private String deadBroker = null;

        public ConsumerMessagePair(ConsumerUID consumerUID, boolean bl) {
            this.uid = consumerUID;
            this.stored = bl;
        }

        public synchronized int incrementRedeliver() {
            ++this.redeliverCnt;
            return this.redeliverCnt;
        }

        public synchronized int decrementRedeliver() {
            --this.redeliverCnt;
            return this.redeliverCnt;
        }

        public synchronized boolean setState(int n) {
            if (this.state == n) {
                return false;
            }
            this.state = n;
            this.timestamp = System.currentTimeMillis();
            return true;
        }

        public synchronized int getState() {
            return this.state;
        }

        public synchronized boolean compareAndSetState(int n, int n2) {
            if (this.state != n2) {
                return false;
            }
            this.timestamp = System.currentTimeMillis();
            this.state = n;
            return true;
        }

        public synchronized boolean compareState(int n) {
            return this.state == n;
        }

        public synchronized boolean compareStateGT(int n) {
            return this.state > n;
        }

        public synchronized boolean compareStateLT(int n) {
            return this.state < n;
        }

        public synchronized boolean setStateIfLess(int n, int n2) {
            if (this.compareStateLT(n2)) {
                return this.setState(n);
            }
            return false;
        }

        public boolean isStored() {
            return this.stored;
        }

        public int getRedeliverCount() {
            return this.redeliverCnt;
        }

        public void setRedeliverCount(int n) {
            this.redeliverCnt = n;
        }

        public void setDeadComment(String string) {
            this.deadComment = string;
        }

        public void setDeadReason(Reason reason) {
            this.deadReason = reason;
        }

        public String getDeadComment() {
            return this.deadComment;
        }

        public Reason getDeadReason() {
            return this.deadReason;
        }

        public Throwable getDeadException() {
            return this.deadException;
        }

        public void setDeadException(Throwable throwable) {
            this.deadException = throwable;
        }

        public void setDeadBroker(String string) {
            this.deadBroker = string;
        }

        public String getDeadBroker() {
            return this.deadBroker;
        }

        public String toString() {
            return ": CMPair[" + this.uid.longValue() + ":" + PacketReference.stateToString(this.state) + ":" + this.stored + "] - " + this.timestamp;
        }
    }
}

