/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.VRFileRAF;
import com.sun.messaging.jmq.io.VRFileWarning;
import com.sun.messaging.jmq.io.VRecord;
import com.sun.messaging.jmq.io.VRecordRAF;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.MsgStore;
import com.sun.messaging.jmq.jmsserver.persist.file.RandomAccessStore;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionWorkInfo;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PreparedTxnStore
extends RandomAccessStore {
    BrokerConfig config = Globals.getConfig();
    static final String USE_FILE_CHANNEL_PROP = "imq.persist.file.message.use_file_channel";
    static String VRFILE_NAME = "vrfile";
    String storeName = "incompleteTxnStore";
    private ConcurrentHashMap<TransactionUID, TransactionWorkInfo> transactionMap = new ConcurrentHashMap(1000);
    private AtomicBoolean loaded = new AtomicBoolean(false);
    protected float growthFactor = this.config.getPercentageProperty("imq.persist.file.message.vrfile.growth_factor", 0.5f);
    protected long threshold = this.config.getLongProperty("imq.persist.file.message.vrfile.threshold", 0L);
    protected float thresholdFactor = this.config.getPercentageProperty("imq.persist.file.message.vrfile.threshold_factor", 0.0f);
    private static FilenameFilter vrfileFilter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return !string.equals(VRFILE_NAME);
        }
    };
    private static Enumeration emptyEnum = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    };
    private int txnCount = 0;
    private long byteCount = 0L;
    private Object countLock = new Object();
    private VRFileRAF vrfile = null;
    int maxRecordSize = 0;

    PreparedTxnStore(MsgStore msgStore, File file, boolean bl) throws BrokerException {
        super(file, msgStore.msgfdlimit, msgStore.poollimit, msgStore.cleanratio);
        try {
            long l = msgStore.initialFileSize.getBytes();
            if (l > 0L) {
                this.maxRecordSize = (int)msgStore.maxRecordSize.getBytes();
                this.vrfile = new VRFileRAF(new File(file, VRFILE_NAME), l);
                this.vrfile.setBlockSize(msgStore.blockSize);
                try {
                    this.vrfile.setGrowthFactor(this.growthFactor);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.vrfile.setGrowthFactor(0.5f);
                    this.growthFactor = 0.5f;
                    this.logger.log(8, "Invalid growth_factor value. Using default value of 50%.");
                }
                try {
                    this.vrfile.setThreshold(this.threshold);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.vrfile.setThreshold(0L);
                    this.threshold = 0L;
                    this.logger.log(8, "Invalid threshold value. Using default value of 0.");
                }
                try {
                    this.vrfile.setThresholdFactor(this.thresholdFactor);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.vrfile.setThresholdFactor(0.0f);
                    this.thresholdFactor = 0.0f;
                    this.logger.log(8, "Invalid threshold_factor value. Using default value of 0%.");
                }
                try {
                    if (this.threshold != 0L || this.thresholdFactor != 0.0f) {
                        this.vrfile.checkGrowthFactorSanity();
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    String string = illegalStateException.getMessage();
                    this.logger.log(8, string);
                }
                try {
                    this.vrfile.setCookie(1L);
                    this.vrfile.open();
                    long l2 = this.vrfile.getFileCookie();
                    if (l2 < 1L) {
                        String string = "Existing file: " + this.storeName + "has older cookie version than current version. " + "Current version = " + 1L + ". Original file version = " + l2;
                        this.logger.log(16, string);
                    } else if (l2 > 1L) {
                        String string = "Existing file: " + this.storeName + " has newer cookie version than current version. " + "Current version = " + 1L + ". Original file version = " + l2;
                        this.logger.log(32, string);
                    }
                }
                catch (VRFileWarning vRFileWarning) {
                    this.logger.log(16, "possible data loss for " + this.storeName, (Throwable)vRFileWarning);
                }
            }
            this.initCounts();
        }
        catch (IOException iOException) {
            this.logger.log(32, "failed to load " + this.storeName, (Throwable)iOException);
            throw new BrokerException("failed to load " + this.storeName, iOException);
        }
        catch (Throwable throwable) {
            this.logger.log(32, "failed to load " + this.storeName, throwable);
            throw new BrokerException("failed to load " + this.storeName, throwable);
        }
        if (bl) {
            this.loadTransactions();
        }
    }

    public HashMap getStorageInfo() throws BrokerException {
        if (this.vrfile == null) {
            return new HashMap();
        }
        HashMap<String, Number> hashMap = new HashMap<String, Number>(3);
        long l = this.vrfile.getBytesUsed();
        long l2 = this.vrfile.getBytesFree();
        hashMap.put("diskUsed", new Long(l));
        hashMap.put("diskReserved", new Long(l + l2));
        hashMap.put("diskUtilizationRatio", new Integer((int)(this.vrfile.getUtilizationRatio() * 100.0f)));
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compact() throws BrokerException {
        if (this.vrfile == null) {
            return;
        }
        VRFileRAF vRFileRAF = this.vrfile;
        synchronized (vRFileRAF) {
            try {
                this.vrfile.close();
                try {
                    this.vrfile.compact();
                }
                catch (VRFileWarning vRFileWarning) {
                    this.logger.log(16, "possible data loss for " + this.storeName, (Throwable)vRFileWarning);
                }
                try {
                    this.vrfile.open();
                }
                catch (VRFileWarning vRFileWarning) {
                    this.logger.log(16, "possible data loss for " + this.storeName, (Throwable)vRFileWarning);
                }
                this.transactionMap.clear();
                Iterator iterator = this.vrfile.getRecords().iterator();
                TxnEnumeration txnEnumeration = new TxnEnumeration(this, iterator, emptyEnum);
                while (txnEnumeration.hasMoreElements()) {
                    txnEnumeration.nextElement();
                }
            }
            catch (IOException iOException) {
                throw new BrokerException("Failed to compact file: " + this.vrfile.getFile(), iOException);
            }
        }
    }

    TransactionWorkInfo storeTransaction(BaseTransaction baseTransaction, boolean bl) throws IOException, BrokerException {
        TransactionUID transactionUID = baseTransaction.getTid();
        if (this.transactionMap.containsKey(transactionUID)) {
            this.logger.log(32, "B3008", (Object)transactionUID, (Object)this.storeName);
            throw new BrokerException(this.br.getString("B3008", transactionUID, this.storeName));
        }
        try {
            byte[] byArray = baseTransaction.writeToBytes();
            int n = byArray.length;
            TransactionWorkInfo transactionWorkInfo = null;
            transactionWorkInfo = this.vrfile != null && (this.maxRecordSize == 0 || n < this.maxRecordSize) ? new TransactionWorkInfo(this, this.vrfile, baseTransaction, byArray, bl) : new TransactionWorkInfo(this, baseTransaction, byArray, bl);
            this.transactionMap.put(transactionWorkInfo.getID(), transactionWorkInfo);
            this.incrTxnCount(n);
            return transactionWorkInfo;
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4004", (Object)transactionUID.toString(), (Throwable)iOException);
            throw iOException;
        }
    }

    void removeTransaction(TransactionUID transactionUID, boolean bl) throws BrokerException {
        TransactionWorkInfo transactionWorkInfo = this.transactionMap.remove(transactionUID);
        if (transactionWorkInfo == null) {
            this.logger.log(32, "B3007", (Object)transactionUID, (Object)this.storeName);
            throw new BrokerException(this.br.getString("B3007", transactionUID, this.storeName));
        }
        try {
            transactionWorkInfo.free(bl);
        }
        catch (IOException iOException) {
            throw new BrokerException("failed to free transaction", iOException);
        }
        this.decrTxnCount(transactionWorkInfo.getSize());
    }

    void removeAllTransactions(boolean bl) throws IOException, BrokerException {
        if (this.vrfile != null) {
            this.vrfile.clear(false);
        }
        this.removeAllData(bl);
        this.transactionMap.clear();
        this.clearCounts();
    }

    void releasePreparedTxnDir(boolean bl) throws IOException {
        if (this.vrfile != null) {
            this.vrfile.clear(false);
            this.vrfile.close();
            this.vrfile = null;
        }
        this.reset(true);
        super.close(false);
        this.transactionMap.clear();
        this.clearCounts();
    }

    Enumeration<BaseTransaction> txnEnumeration() {
        if (this.loaded.get()) {
            if (Store.getDEBUG()) {
                String string = this.getPrefix() + " returning getTransactionIterator()";
                this.logger.log(4, string);
            }
            return new TxnEnumeration(this, this.getTransactionIterator());
        }
        Iterator iterator = null;
        if (this.vrfile != null) {
            iterator = this.vrfile.getRecords().iterator();
        }
        if (Store.getDEBUG()) {
            String string = this.getPrefix() + " returning getEnumeration()";
            this.logger.log(4, string);
        }
        return new TxnEnumeration(this, iterator, this.getEnumeration(false));
    }

    int getTransactionCount() throws BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(4, "PreparedTxnStore:getTransactionCount() " + this.txnCount);
        }
        return this.txnCount;
    }

    long getByteCount() throws BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(4, "PreparedTxnStore:getByteCount()");
        }
        return this.byteCount;
    }

    @Override
    protected void close(boolean bl) {
        if (this.vrfile != null) {
            this.vrfile.close();
        }
        super.close(bl);
        this.transactionMap.clear();
    }

    VRFileRAF getVRFile() {
        return this.vrfile;
    }

    public void loadTransactions() throws BrokerException {
        Enumeration<BaseTransaction> enumeration = this.txnEnumeration();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
        }
        this.logger.log(4, this.getPrefix() + " loaded " + this.transactionMap.size() + " transactions");
    }

    TransactionWorkInfo getTransactionInfo(TransactionUID transactionUID) throws BrokerException {
        TransactionWorkInfo transactionWorkInfo = this.transactionMap.get(transactionUID);
        if (transactionWorkInfo == null) {
            this.logger.log(32, "B3007", (Object)transactionUID, (Object)this.storeName);
            throw new BrokerException(this.br.getString("B3007", transactionUID, this.storeName));
        }
        return transactionWorkInfo;
    }

    @Override
    Object parseData(byte[] byArray, byte[] byArray2) throws IOException {
        TransactionWorkInfo transactionWorkInfo = new TransactionWorkInfo(this, byArray, byArray2);
        TransactionUID transactionUID = transactionWorkInfo.getID();
        this.transactionMap.put(transactionUID, transactionWorkInfo);
        return transactionUID;
    }

    @Override
    FilenameFilter getFilenameFilter() {
        return vrfileFilter;
    }

    private void cacheMessageInfo(TransactionWorkInfo transactionWorkInfo) {
        this.transactionMap.put(transactionWorkInfo.getID(), transactionWorkInfo);
    }

    private Iterator getTransactionIterator() {
        return this.transactionMap.keySet().iterator();
    }

    private void setLoadedFlag(boolean bl) {
        this.loaded.set(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrTxnCount(int n) throws BrokerException {
        Object object = this.countLock;
        synchronized (object) {
            ++this.txnCount;
            this.byteCount += (long)n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrTxnCount(int n) throws BrokerException {
        Object object = this.countLock;
        synchronized (object) {
            --this.txnCount;
            this.byteCount -= (long)n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCounts() {
        if (Store.getDEBUG()) {
            this.logger.log(4, "DstMsgStore:clearCounts for " + this.storeName);
        }
        Object object = this.countLock;
        synchronized (object) {
            this.txnCount = 0;
            this.byteCount = 0L;
        }
    }

    private void initCounts() throws BrokerException {
        Object object;
        Object object2;
        if (this.vrfile != null) {
            object2 = this.vrfile.getRecords();
            object = object2.iterator();
            while (object.hasNext()) {
                VRecordRAF vRecordRAF = (VRecordRAF)object.next();
                short s = vRecordRAF.getCookie();
                if (s == -1 || s != 0) {
                    String string = this.storeName + ": found a " + "corrupted message at vrecord(" + vRecordRAF + "), a message might be lost";
                    this.logger.log(16, string);
                    try {
                        this.vrfile.free((VRecord)vRecordRAF);
                    }
                    catch (IOException iOException) {
                        this.logger.log(32, "Failed to free the corrupted vrecord: " + iOException);
                    }
                    continue;
                }
                try {
                    ++this.txnCount;
                    this.byteCount += (long)vRecordRAF.readInt();
                }
                catch (Throwable throwable) {
                    this.logger.log(32, "B4148", (Object)this.vrfile.getFile(), throwable);
                    throw new BrokerException(this.br.getString("B4148", this.vrfile.getFile()), throwable);
                }
            }
        }
        object2 = super.getEnumeration(true);
        while (object2.hasMoreElements()) {
            ++this.txnCount;
            object = (Long)object2.nextElement();
            this.byteCount += ((Long)object).longValue();
        }
        if (Store.getDEBUG()) {
            this.logger.log(4, "DstMsgStore: initialized msg count=" + this.txnCount + "; byte count = " + this.byteCount);
        }
    }

    Hashtable getDebugState() {
        int n = 0;
        if (this.vrfile != null) {
            n = this.vrfile.getNRecords();
        }
        int n2 = this.txnCount - n;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put(this.storeName + ":messages in vrfile", String.valueOf(n));
        hashtable.put(this.storeName + ":messages in its own file", String.valueOf(n2));
        return hashtable;
    }

    boolean containsTransaction(TransactionUID transactionUID) {
        return this.transactionMap.containsKey(transactionUID);
    }

    BaseTransaction getTransaction(TransactionUID transactionUID) throws IOException, BrokerException {
        TransactionWorkInfo transactionWorkInfo = this.transactionMap.get(transactionUID);
        if (transactionWorkInfo == null) {
            this.logger.log(32, "B3007", (Object)transactionUID, (Object)this.storeName);
            throw new BrokerException(this.br.getString("B3007", transactionUID, this.storeName));
        }
        return transactionWorkInfo.getMessage();
    }

    void sync() throws BrokerException {
        try {
            this.vrfile.force();
        }
        catch (IOException iOException) {
            throw new BrokerException("Failed to synchronize data to disk for file: " + this.vrfile, iOException);
        }
    }

    void updateTransactionState(TransactionUID transactionUID, int n, boolean bl) throws IOException, BrokerException {
        this.getTransactionInfo(transactionUID).updateState(n, bl);
    }

    void updateTransactionCompletion(TransactionUID transactionUID, boolean bl, boolean bl2) throws IOException, BrokerException {
        int n = bl ? 1 : 0;
        this.getTransactionInfo(transactionUID).updateCompletion(n, bl2);
    }

    String getPrefix() {
        return "PreparedTxStore: " + Thread.currentThread().getName();
    }

    private static class TxnEnumeration
    implements Enumeration {
        PreparedTxnStore parent = null;
        Iterator itr = null;
        Iterator recitr = null;
        Enumeration msgEnum = null;
        Logger logger = Globals.getLogger();
        BrokerResources br = Globals.getBrokerResources();
        Object objToReturn = null;

        TxnEnumeration(PreparedTxnStore preparedTxnStore, Iterator iterator) {
            this.parent = preparedTxnStore;
            this.itr = iterator;
        }

        TxnEnumeration(PreparedTxnStore preparedTxnStore, Iterator iterator, Enumeration enumeration) {
            this.parent = preparedTxnStore;
            this.recitr = iterator;
            this.msgEnum = enumeration;
        }

        public boolean hasMoreElements() {
            Object var1_1 = null;
            if (this.itr != null) {
                if (this.itr.hasNext()) {
                    this.objToReturn = this.itr.next();
                    return true;
                }
                return false;
            }
            if (this.recitr != null) {
                while (this.recitr.hasNext()) {
                    try {
                        TransactionWorkInfo transactionWorkInfo = new TransactionWorkInfo(this.parent, (VRecordRAF)this.recitr.next());
                        this.objToReturn = transactionWorkInfo.getMessage();
                        this.parent.cacheMessageInfo(transactionWorkInfo);
                        return true;
                    }
                    catch (IOException iOException) {
                        this.logger.log(32, "B4143", (Object)this.parent.storeName, (Throwable)iOException);
                    }
                }
            }
            if (this.msgEnum.hasMoreElements()) {
                this.objToReturn = this.msgEnum.nextElement();
                return true;
            }
            this.parent.setLoadedFlag(true);
            return false;
        }

        public Object nextElement() {
            if (this.objToReturn != null) {
                Object object = null;
                if (this.objToReturn instanceof TransactionUID) {
                    try {
                        object = this.parent.getTransaction((TransactionUID)this.objToReturn);
                    }
                    catch (IOException iOException) {
                        this.logger.log(32, "B4005", this.objToReturn, (Object)this.parent.storeName, (Throwable)iOException);
                        throw new NoSuchElementException();
                    }
                    catch (BrokerException brokerException) {
                        this.logger.log(32, "B4005", this.objToReturn, (Object)this.parent.storeName, (Throwable)brokerException);
                        throw new NoSuchElementException();
                    }
                } else {
                    object = this.objToReturn;
                }
                this.objToReturn = null;
                return object;
            }
            throw new NoSuchElementException();
        }
    }
}

