/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConnectionPool;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.GenericDAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.HADBDAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.OracleDAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.LockFile;
import com.sun.messaging.jmq.util.Password;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;

public final class DBManager
implements DBConstants {
    static final String STORE_TYPE_PROP = "imq.persist.store";
    static final String JDBC_STORE_TYPE = "jdbc";
    static final String JDBC_PROP_PREFIX = "imq.persist.jdbc";
    static final String FALLBACK_USER_PROP = "imq.persist.jdbc.user";
    static final String FALLBACK_PWD_PROP = "imq.persist.jdbc.password";
    static final String TRANSACTION_RETRY_MAX_PROP = "imq.persist.jdbc.transaction.retry.max";
    static final String TRANSACTION_RETRY_DELAY_PROP = "imq.persist.jdbctransaction.retry.delay";
    static final int TRANSACTION_RETRY_MAX_DEFAULT = 5;
    static final long TRANSACTION_RETRY_DELAY_DEFAULT = 2000L;
    static final String BROKERID_PROP = "imq.brokerid";
    static final String TABLE_PROP_PREFIX = "imq.persist.jdbc.table";
    static final String UNKNOWN_VENDOR = "unknown";
    static final boolean DEFAULT_NEEDPASSWORD = false;
    String vendor = null;
    String vendorPropPrefix = null;
    String tablePropPrefix = null;
    String vendorProp = null;
    String driverProp = null;
    String openDBUrlProp = null;
    String createDBUrlProp = null;
    String closeDBUrlProp = null;
    String userProp = null;
    String passwordProp = null;
    String needPasswordProp = null;
    int txnRetryMax;
    long txnRetryDelay;
    private String driver = null;
    private String openDBUrl = null;
    private String createDBUrl = null;
    private String closeDBUrl = null;
    private String user = null;
    private String password = null;
    private boolean needPassword = true;
    private boolean isDataSource = false;
    private boolean isPoolDataSource = false;
    private Object dataSource = null;
    private boolean isHADB = false;
    private boolean isOracle = false;
    private boolean isOraDriver = false;
    private boolean isMysql = false;
    private boolean supportBatch = false;
    private String dbProductName = null;
    private String dbProductVersion = null;
    private String tableSuffix = null;
    private String clusterID = null;
    private String brokerID = null;
    private DAOFactory daoFactory = null;
    private BrokerConfig config = Globals.getConfig();
    private BrokerResources br = Globals.getBrokerResources();
    private Logger logger = Globals.getLogger();
    private static final Object lock = DBManager.class;
    private static DBManager dbMgr = null;
    private HashMap tableSchemas = new HashMap<K, V>();
    private static String[] v370tableNames = new String[]{"IMQSV37", "IMQCCREC37", "IMQDEST37", "IMQINT37", "IMQMSG37", "IMQPROPS37", "IMQILIST37", "IMQTXN37", "IMQTACK37"};
    private static String[] v350tableNames = new String[]{"IMQSV35", "IMQCCREC35", "IMQDEST35", "IMQINT35", "IMQMSG35", "IMQPROPS35", "IMQILIST35", "IMQTXN35", "IMQTACK35"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DBManager getDBManager() throws BrokerException {
        if (dbMgr != null) return dbMgr;
        Object object = lock;
        synchronized (object) {
            int n;
            block8: {
                if (dbMgr == null) {
                    dbMgr = new DBManager();
                    dbMgr.loadTableSchema();
                }
                DBConnectionPool.init(dbMgr);
                n = 0;
                Connection connection = null;
                try {
                    try {
                        connection = dbMgr.getConnection(true);
                        DatabaseMetaData databaseMetaData = connection.getMetaData();
                        DBManager.dbMgr.dbProductName = databaseMetaData.getDatabaseProductName();
                        DBManager.dbMgr.dbProductVersion = databaseMetaData.getDatabaseProductVersion();
                        DBManager.dbMgr.supportBatch = databaseMetaData.supportsBatchUpdates();
                        n = databaseMetaData.getMaxTableNameLength();
                        String string = databaseMetaData.getDriverVersion();
                        DBManager.dbMgr.isOraDriver = "oracle".equalsIgnoreCase(DBManager.dbMgr.dbProductName);
                        String string2 = new StringBuffer(256).append("DBManager: database product name=").append(DBManager.dbMgr.dbProductName).append(", database version number=").append(DBManager.dbMgr.dbProductVersion).append(", driver version number=").append(string).append(", supports batch updates=").append(DBManager.dbMgr.supportBatch).toString();
                        DBManager.dbMgr.logger.log(8, DBManager.dbMgr.dbProductName + ", " + DBManager.dbMgr.dbProductVersion + ", " + string);
                        DBManager.dbMgr.logger.log(Store.getDEBUG() ? 8 : 4, string2);
                    }
                    catch (SQLException sQLException) {
                        DBManager.dbMgr.logger.log(16, "B4164", (Throwable)sQLException);
                        Object var7_8 = null;
                        Util.close(null, null, connection);
                        break block8;
                    }
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    Util.close(null, null, connection);
                    throw throwable;
                }
                Util.close(null, null, connection);
            }
            if (n <= 0) return dbMgr;
            if (Globals.getHAEnabled()) {
                if (DBManager.dbMgr.clusterID.length() + 14 <= n) return dbMgr;
                throw new BrokerException(DBManager.dbMgr.br.getKString("B3179", DBManager.dbMgr.clusterID, 14));
            }
            if (DBManager.dbMgr.brokerID.length() + 14 <= n) return dbMgr;
            throw new BrokerException(DBManager.dbMgr.br.getKString("B3094", DBManager.dbMgr.brokerID, 14));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private DBManager() throws BrokerException {
        super();
        this.txnRetryMax = this.config.getIntProperty("imq.persist.jdbc.transaction.retry.max", 5);
        this.txnRetryDelay = this.config.getLongProperty("imq.persist.jdbctransaction.retry.delay", 2000L);
        var1_1 = this.config.getProperty("imq.persist.store");
        if (var1_1 == null || !var1_1.equals("jdbc")) {
            var1_1 = var1_1 == null ? "" : var1_1;
            throw new BrokerException(this.br.getKString("B3103", var1_1));
        }
        this.vendorProp = "imq.persist.jdbc.dbVendor";
        this.vendor = this.config.getProperty(this.vendorProp, "unknown");
        this.vendorPropPrefix = "imq.persist.jdbc." + this.vendor;
        this.tablePropPrefix = this.vendorPropPrefix + ".table";
        this.driverProp = this.vendorPropPrefix + ".driver";
        this.driver = this.config.getProperty(this.driverProp);
        if (this.driver == null || this.driver.length() == 0) {
            var2_2 = "imq.persist.jdbc.driver";
            this.driver = this.config.getProperty((String)var2_2);
            if (this.driver == null || this.driver.length() == 0) {
                throw new BrokerException(this.br.getKString("B3023", this.driverProp));
            }
            this.driverProp = var2_2;
        }
        this.openDBUrlProp = this.vendorPropPrefix + ".opendburl";
        this.openDBUrl = this.config.getProperty(this.openDBUrlProp);
        if (this.openDBUrl == null || this.openDBUrl.length() == 0) {
            var2_2 = "imq.persist.jdbc.opendburl";
            this.openDBUrl = this.config.getProperty((String)var2_2);
            this.openDBUrlProp = var2_2;
        }
        this.openDBUrl = StringUtil.expandVariables((String)this.openDBUrl, (Properties)this.config);
        this.createDBUrlProp = this.vendorPropPrefix + ".createdburl";
        this.createDBUrl = this.config.getProperty(this.createDBUrlProp);
        if (this.createDBUrl == null || this.createDBUrl.length() == 0) {
            var2_2 = "imq.persist.jdbc.createdburl";
            this.createDBUrl = this.config.getProperty((String)var2_2);
            if (this.createDBUrl != null) {
                this.createDBUrlProp = var2_2;
            }
        }
        this.createDBUrl = StringUtil.expandVariables((String)this.createDBUrl, (Properties)this.config);
        this.closeDBUrlProp = this.vendorPropPrefix + ".closedburl";
        this.closeDBUrl = this.config.getProperty(this.closeDBUrlProp);
        if (this.closeDBUrl == null || this.closeDBUrl.length() == 0) {
            var2_2 = "imq.persist.jdbc.closedburl";
            this.closeDBUrl = this.config.getProperty((String)var2_2);
            if (this.closeDBUrl != null) {
                this.closeDBUrlProp = var2_2;
            }
        }
        this.closeDBUrl = StringUtil.expandVariables((String)this.closeDBUrl, (Properties)this.config);
        this.userProp = this.vendorPropPrefix + ".user";
        this.user = this.config.getProperty(this.userProp);
        if (this.user == null) {
            this.user = this.config.getProperty("imq.persist.jdbc.user");
            if (this.user != null) {
                this.userProp = "imq.persist.jdbc.user";
            }
        }
        this.brokerID = Globals.getBrokerID();
        if (this.brokerID == null || this.brokerID.length() == 0 || !Util.isAlphanumericString(this.brokerID)) {
            throw new BrokerException(this.br.getKString("B3093", this.brokerID));
        }
        if (Globals.getHAEnabled()) {
            this.clusterID = Globals.getClusterID();
            if (this.clusterID == null || this.clusterID.length() == 0 || !Util.isAlphanumericString(this.clusterID)) {
                throw new BrokerException(this.br.getKString("B3178", this.clusterID));
            }
            this.tableSuffix = "C" + this.clusterID;
        } else {
            this.tableSuffix = "S" + this.brokerID;
        }
        this.fixOldTableNames();
        try {
            var2_2 = Class.forName(this.driver);
            var3_6 /* !! */  = var2_2.newInstance();
            if (var3_6 /* !! */  instanceof ConnectionPoolDataSource) {
                this.isDataSource = true;
                this.isPoolDataSource = true;
            } else if (var3_6 /* !! */  instanceof DataSource) {
                this.isDataSource = true;
            } else if (this.openDBUrl == null || this.openDBUrl.length() == 0) {
                throw new BrokerException(this.br.getKString("B3025", this.openDBUrlProp));
            }
            if (this.isDataSource) {
                this.dataSource = var3_6 /* !! */ ;
                this.initDataSource((Class)var2_2, this.dataSource);
            }
        }
        catch (InstantiationException var2_3) {
            throw new BrokerException(this.br.getKString("B3024", this.driver), var2_3);
        }
        catch (IllegalAccessException var2_4) {
            throw new BrokerException(this.br.getKString("B3024", this.driver), var2_4);
        }
        catch (ClassNotFoundException var2_5) {
            throw new BrokerException(this.br.getKString("B3024", this.driver), var2_5);
        }
        this.password = this.getPassword();
        if ("unknown".equals(this.vendor)) {
            block43: {
                var2_2 = null;
                var3_6 /* !! */  = null;
                try {
                    var2_2 = this.newConnection(true);
                    var4_7 = var2_2.getMetaData();
                    var3_6 /* !! */  = var4_7.getDatabaseProductName();
                    var6_9 = null;
                    ** if (var2_2 == null) goto lbl-1000
                }
                catch (Throwable var5_15) {
                    var6_11 = null;
                    if (var2_2 != null) {
                        try {
                            var2_2.close();
                        }
                        catch (SQLException var7_14) {
                            // empty catch block
                        }
                    }
                    throw var5_15;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var2_2.close();
                    }
                    catch (SQLException var7_12) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block43;
                    catch (Exception var4_8) {
                        var6_10 = null;
                        if (var2_2 != null) {
                            try {
                                var2_2.close();
                            }
                            catch (SQLException var7_13) {}
                        }
                    }
                }
            }
            if ("oracle".equalsIgnoreCase((String)var3_6 /* !! */ )) {
                this.vendor = "oracle";
                this.vendorPropPrefix = "imq.persist.jdbc." + this.vendor;
                this.tablePropPrefix = this.vendorPropPrefix + ".table";
            } else {
                throw new BrokerException(this.br.getKString("B3212"));
            }
        }
        if (this.vendor.equalsIgnoreCase("hadb")) {
            this.isHADB = true;
            this.checkHADBJDBCLogging();
        } else if (this.vendor.equalsIgnoreCase("oracle")) {
            this.isOracle = true;
        } else if (this.vendor.equalsIgnoreCase("mysql")) {
            this.isMysql = true;
        }
    }

    Connection connectToCreate() throws BrokerException {
        if (this.createDBUrl == null) {
            throw new BrokerException(this.br.getKString("B3025", this.createDBUrlProp));
        }
        Connection connection = null;
        try {
            connection = this.user == null ? DriverManager.getConnection(this.createDBUrl) : DriverManager.getConnection(this.createDBUrl, this.user, this.password);
            connection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException2) {
                    this.logger.logStack(16, Globals.getBrokerResources().getKString("B3100", "Unable to close JDBC resources", sQLException), (Throwable)sQLException);
                }
            }
            throw new BrokerException(this.br.getKString("B3026", this.createDBUrl), sQLException);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Connection getConnection(boolean bl) throws BrokerException {
        boolean bl2 = false;
        Connection connection = DBConnectionPool.getConnection();
        try {
            try {
                if (connection.getAutoCommit() != bl) {
                    connection.setAutoCommit(bl);
                }
            }
            catch (SQLException sQLException) {
                bl2 = true;
                throw new BrokerException(this.br.getKString("B4117", "Unable to set connection's auto-commit mode"), sQLException);
            }
            int n = -1;
            try {
                if (this.isHADB && (n = connection.getTransactionIsolation()) != 2) {
                    connection.setTransactionIsolation(2);
                }
            }
            catch (SQLException sQLException) {
                bl2 = true;
                throw new BrokerException(this.br.getKString("B4117", "Unable to set connection's transaction isolation level, current= " + n), sQLException);
            }
            Object var7_7 = null;
            if (!bl2) return connection;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!bl2) throw throwable;
            DBConnectionPool.freeConnection(connection);
            throw throwable;
        }
        DBConnectionPool.freeConnection(connection);
        return connection;
    }

    public void closeConnection(Connection connection) {
        if (connection != null) {
            DBConnectionPool.freeConnection(connection);
        }
    }

    Connection newConnection(boolean bl) throws BrokerException {
        Util.RetryStrategy retryStrategy = null;
        while (true) {
            try {
                Connection connection = null;
                try {
                    connection = this.dataSource != null ? (this.isPoolDataSource ? (this.user == null ? ((ConnectionPoolDataSource)this.dataSource).getPooledConnection().getConnection() : ((ConnectionPoolDataSource)this.dataSource).getPooledConnection(this.user, this.password).getConnection()) : (this.user == null ? ((DataSource)this.dataSource).getConnection() : ((DataSource)this.dataSource).getConnection(this.user, this.password))) : (this.user == null ? DriverManager.getConnection(this.openDBUrl) : DriverManager.getConnection(this.openDBUrl, this.user, this.password));
                    connection.setAutoCommit(bl);
                }
                catch (Exception exception) {
                    throw new BrokerException(this.br.getKString("B3026", this.openDBUrl), exception);
                }
                return connection;
            }
            catch (BrokerException brokerException) {
                if (retryStrategy == null) {
                    retryStrategy = new Util.RetryStrategy(this);
                }
                retryStrategy.assertShouldRetry(brokerException);
                continue;
            }
            break;
        }
    }

    public boolean supportsBatchUpdates() {
        return this.supportBatch;
    }

    public boolean isHADB() {
        return this.isHADB;
    }

    public boolean isMysql() {
        return this.isMysql;
    }

    public boolean isOracle() {
        return this.isOracle;
    }

    public boolean isOracleDriver() {
        return this.isOraDriver;
    }

    public boolean isHAClusterActive(Connection connection) throws BrokerException {
        boolean bl = false;
        BrokerDAO brokerDAO = DBManager.getDBManager().getDAOFactory().getBrokerDAO();
        HashMap hashMap = brokerDAO.getAllBrokerInfos(connection, false);
        Iterator iterator = hashMap.values().iterator();
        long l = System.currentTimeMillis();
        while (iterator.hasNext()) {
            long l2;
            HABrokerInfo hABrokerInfo = (HABrokerInfo)iterator.next();
            int n = hABrokerInfo.getState();
            if (!BrokerState.getState(n).isActiveState() || (l2 = hABrokerInfo.getHeartbeat()) + 180000L <= l) continue;
            bl = true;
            break;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DAOFactory getDAOFactory() {
        if (this.daoFactory == null) {
            Object object = lock;
            synchronized (object) {
                if (this.daoFactory == null) {
                    if (this.isHADB) {
                        this.logger.log(4, "Instantiating HADB DAO factory");
                        this.daoFactory = new HADBDAOFactory();
                    } else if (this.isOracle) {
                        this.logger.log(4, "Instantiating Oracle DAO factory");
                        this.daoFactory = new OracleDAOFactory();
                    } else {
                        this.logger.log(4, "Instantiating generic DAO factory");
                        this.daoFactory = new GenericDAOFactory();
                    }
                }
            }
        }
        return this.daoFactory;
    }

    public String getOpenDBURL() {
        return this.openDBUrl;
    }

    String getCreateDBURL() {
        return this.createDBUrl;
    }

    public String getBrokerID() {
        return this.brokerID;
    }

    String getClusterID() {
        return this.clusterID;
    }

    public String getUser() {
        return this.user;
    }

    public String getTableName(String string) {
        if (string == null || string.length() == 0) {
            throw new NullPointerException();
        }
        return string + this.tableSuffix;
    }

    public String getDriver() {
        return this.driver;
    }

    public void resetConnectionPool() throws BrokerException {
        DBConnectionPool.reset();
        DBConnectionPool.init(dbMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        DBConnectionPool.close();
        Object object = lock;
        synchronized (object) {
            block8: {
                if (this.closeDBUrl != null) {
                    try {
                        DriverManager.getConnection(this.closeDBUrl);
                    }
                    catch (SQLException sQLException) {
                        if (!Store.getDEBUG()) break block8;
                        this.logger.log(4, "B1052", (Object)this.closeDBUrl, (Throwable)sQLException);
                    }
                }
            }
            if (dbMgr != null) {
                if (DBManager.dbMgr.isOraDriver) {
                    Util.OracleBLOB_initialized = false;
                }
                dbMgr = null;
            }
        }
    }

    void printInfo(PrintStream printStream) {
        printStream.println("Configuration properties:");
        printStream.println(this.driverProp + "=" + this.driver);
        printStream.println(this.openDBUrlProp + "=" + this.openDBUrl);
        printStream.println(this.createDBUrlProp + "=" + this.createDBUrl);
        printStream.println(this.closeDBUrlProp + "=" + this.closeDBUrl);
        printStream.println(this.userProp + "=" + this.user);
        printStream.println(this.passwordProp + "=" + this.password);
        printStream.println(this.needPasswordProp + "=" + this.needPassword);
        printStream.println("brokerID=" + this.brokerID);
        printStream.println("clusterID=" + this.clusterID);
    }

    HashMap getTableSchema() {
        return this.tableSchemas;
    }

    String[] getTableNames(int n) {
        String[] stringArray = new String[]{};
        if (n == 410) {
            stringArray = this.tableSchemas.keySet().toArray(stringArray);
        } else if (n == 370) {
            stringArray = v370tableNames;
        } else if (n == 350) {
            stringArray = v350tableNames;
        }
        return stringArray;
    }

    int checkStoreExists(Connection connection) throws BrokerException {
        Map map = this.getTableNamesFromDB(connection, this.tableSuffix);
        int n = 0;
        int n2 = 0;
        Iterator iterator = this.getDAOFactory().getAllDAOs().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            ++n;
            String string = ((BaseDAO)iterator.next()).getTableName();
            if (map.containsKey(string.toLowerCase())) {
                ++n2;
                continue;
            }
            stringBuffer.append(string + " ");
        }
        if (n2 > 0 && n2 != n) {
            this.logger.log(16, this.br.getKString("B2221", stringBuffer.toString() + "[" + n + "," + n2 + ", " + this.tableSuffix + "]"));
            return -1;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Map getTableNamesFromDB(Connection connection, String string) throws BrokerException {
        ResultSet resultSet;
        if (string == null || string.trim().length() == 0) {
            string = this.tableSuffix;
        }
        string = string.toLowerCase();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Util.RetryStrategy retryStrategy = null;
        while (true) {
            Object var14_9;
            boolean bl = false;
            resultSet = null;
            try {
                try {
                    if (connection == null) {
                        connection = this.getConnection(true);
                        bl = true;
                    }
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    String[] stringArray = new String[]{"TABLE"};
                    resultSet = databaseMetaData.getTables(null, null, null, stringArray);
                    while (resultSet.next()) {
                        String string2;
                        String string3 = resultSet.getString("TABLE_NAME");
                        if (string3 == null) continue;
                        string3 = string3.trim();
                        char c = string3.charAt(0);
                        char c2 = string3.charAt(1);
                        if (c != 'm' && c != 'M' || c2 != 'q' && c2 != 'Q' || (string2 = string3.toLowerCase()).indexOf(string) <= -1) continue;
                        hashMap.put(string2, string3);
                    }
                    var14_9 = null;
                    if (!bl) return hashMap;
                    break;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(this);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    var14_9 = null;
                    if (!bl) continue;
                    Util.close(resultSet, null, connection);
                }
            }
            catch (Throwable throwable) {
                var14_9 = null;
                if (!bl) throw throwable;
                Util.close(resultSet, null, connection);
                throw throwable;
            }
        }
        Util.close(resultSet, null, connection);
        return hashMap;
    }

    static SQLException wrapSQLException(String string, SQLException sQLException) {
        SQLException sQLException2 = new SQLException(string + ": " + sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode());
        sQLException2.setNextException(sQLException);
        return sQLException2;
    }

    static IOException wrapIOException(String string, IOException iOException) {
        IOException iOException2 = new IOException(string + ": " + iOException.getMessage());
        iOException2.initCause(iOException);
        return iOException2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void lockTables(Connection connection, boolean bl) throws BrokerException {
        boolean bl2;
        Object object;
        Object object2;
        LockFile lockFile = LockFile.getCurrentLockFile();
        String string = null;
        if (lockFile != null) {
            string = lockFile.getInstance() + ":" + lockFile.getHost() + ":" + lockFile.getPort();
        } else {
            object2 = Globals.getBrokerHostName();
            if (object2 == null) {
                try {
                    object = InetAddress.getLocalHost();
                    object2 = ((InetAddress)object).getCanonicalHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    object2 = "";
                    Globals.getLogger().log(32, "B3152", (Throwable)unknownHostException);
                }
            }
            string = Globals.getConfigName() + ":" + (String)object2 + ":" + "imqdbmgr";
        }
        object2 = DBManager.getDBManager().getDAOFactory().getVersionDAO();
        object = object2.getLock(connection, 410);
        if (object == null) {
            if (bl) throw new BrokerException(Globals.getBrokerResources().getKString("B3206", object2.getTableName()), 404);
            Globals.getLogger().log(16, "B3206", (Object)object2.getTableName());
            object2.insert(connection, 410);
            return;
        }
        boolean bl3 = false;
        String string2 = null;
        String string3 = null;
        TableLock tableLock = new TableLock((String)object);
        if (tableLock.isNull) {
            if (bl) {
                bl3 = true;
                string2 = string;
            }
        } else if (DBManager.isOurLock(lockFile, tableLock)) {
            if (!bl) {
                bl3 = true;
                string3 = tableLock.lockstr;
            }
        } else if (DBManager.validLock(tableLock)) {
            if (bl || tableLock.port != 0) throw new BrokerException(DBManager.generateLockError(tableLock));
            bl3 = true;
            string3 = tableLock.lockstr;
        } else if (bl) {
            bl3 = true;
            string2 = string;
            string3 = tableLock.lockstr;
        } else {
            bl3 = true;
            string3 = tableLock.lockstr;
        }
        if (!bl3 || (bl2 = object2.updateLock(connection, 410, string2, string3))) return;
        if (string2 == null) {
            Globals.getLogger().log(32, "B3205");
        }
        object = object2.getLock(connection, 410);
        throw new BrokerException(DBManager.generateLockError(new TableLock((String)object)));
    }

    private static boolean isOurLock(LockFile lockFile, TableLock tableLock) {
        if (lockFile != null) {
            return lockFile.getPort() == tableLock.port && LockFile.equivalentHostNames(lockFile.getHost(), tableLock.host, false) && lockFile.getInstance().equals(tableLock.instance);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean validLock(TableLock tableLock) {
        boolean bl;
        if (tableLock.port == 0) {
            return true;
        }
        Socket socket = null;
        try {
            try {
                socket = new Socket(tableLock.host, tableLock.port);
                bl = true;
                Object var5_4 = null;
                if (socket == null) return bl;
            }
            catch (Exception exception) {
                boolean bl2 = false;
                Object var5_5 = null;
                if (socket == null) return bl2;
                try {
                    socket.close();
                    return bl2;
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (socket == null) throw throwable;
            try {}
            catch (Exception exception2) {
                throw throwable;
            }
            socket.close();
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return bl;
        }
        socket.close();
        return bl;
    }

    private void initDataSource(Class clazz, Object object) {
        String string = this.vendorPropPrefix + ".property.";
        List list = this.config.getPropertyNames(string);
        if (list.size() == 0 && Store.getDEBUG()) {
            this.logger.log(4, "DataSource properties not specified!");
        }
        Method[] methodArray = clazz.getMethods();
        Object[] objectArray = new Object[1];
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2;
            Exception exception;
            block14: {
                exception = null;
                string2 = null;
                String string3 = (String)iterator.next();
                String string4 = this.config.getProperty(string3).trim();
                if (string4.length() > 0) {
                    String string5 = string3.substring(string.length(), string3.length());
                    if (string5.equalsIgnoreCase("url") || string5.equalsIgnoreCase("serverList")) {
                        this.openDBUrl = string4;
                    } else {
                        this.logger.log(Store.getDEBUG() ? 8 : 4, string3 + "=" + string4);
                    }
                    String string6 = ("set" + string5).toLowerCase();
                    Method method = null;
                    Class<?> clazz2 = null;
                    for (Method method2 : methodArray) {
                        Class<?>[] classArray = method2.getParameterTypes();
                        if (!string6.equals(method2.getName().toLowerCase()) || classArray.length != 1) continue;
                        method = method2;
                        clazz2 = classArray[0];
                        break;
                    }
                    if (method != null) {
                        try {
                            if (clazz2.equals(Boolean.TYPE)) {
                                objectArray[0] = Boolean.valueOf(string4);
                                method.invoke(object, objectArray);
                                break block14;
                            }
                            if (clazz2.equals(Integer.TYPE)) {
                                objectArray[0] = Integer.valueOf(string4);
                                method.invoke(object, objectArray);
                                break block14;
                            }
                            if (clazz2.equals(String.class)) {
                                objectArray[0] = string4;
                                method.invoke(object, objectArray);
                                break block14;
                            }
                            string2 = "Invalid DataSource Property: " + string3 + ", value: " + string4;
                        }
                        catch (Exception exception2) {
                            exception = exception2;
                            string2 = "Unable to initialize DataSource Property: " + string3 + ", value: " + string4;
                        }
                    } else {
                        string2 = "Invalid DataSource Property: " + string3 + ", value: " + string4;
                    }
                } else {
                    string2 = "Invalid DataSource Property: " + string3 + ", value: " + string4;
                }
            }
            if (string2 == null) continue;
            this.logger.log(32, string2, exception);
        }
    }

    private void loadTableSchema() throws BrokerException {
        List list = this.config.getPropertyNames(this.tablePropPrefix);
        if (list.size() == 0) {
            throw new BrokerException("Table definition not found for " + this.vendor);
        }
        Collections.sort(list);
        Properties properties = new Properties();
        String string = this.vendorPropPrefix + "." + "tableoption";
        String string2 = this.config.getProperty(string, "").trim();
        properties.setProperty("tableoption", string2);
        if (string2 != null && !string2.equals("")) {
            this.logger.log(8, string + "=" + string2);
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Object object;
            String string3;
            String string4;
            int n;
            string = ((String)listIterator.next()).trim();
            string2 = this.config.getProperty(string).trim();
            int n2 = string.indexOf(".index.");
            if (n2 > 0) {
                n = string.indexOf(".table.");
                string4 = string.substring(n + 7, n2) + this.tableSuffix;
                string3 = string4 + string.substring(n2 + 7);
                properties.setProperty("name", string4);
                properties.setProperty("index", string3);
                object = StringUtil.expandVariables((String)string2, (Properties)properties);
                TableSchema tableSchema = (TableSchema)this.tableSchemas.get(string4);
                if (tableSchema == null) continue;
                tableSchema.addIndex(string3, (String)object);
                continue;
            }
            n = string.lastIndexOf(46);
            string4 = string.substring(n + 1) + this.tableSuffix;
            properties.setProperty("name", string4);
            string3 = StringUtil.expandVariables((String)string2, (Properties)properties);
            object = new TableSchema(string4, string3);
            this.tableSchemas.put(string4, object);
        }
        this.checkTables();
    }

    private void checkTables() throws BrokerException {
        for (BaseDAO baseDAO : this.getDAOFactory().getAllDAOs()) {
            String string = baseDAO.getTableName();
            TableSchema tableSchema = (TableSchema)this.tableSchemas.get(string);
            if (tableSchema == null || tableSchema.tableSQL.length() == 0) {
                throw new BrokerException(this.br.getKString("B3127", string));
            }
            if (!Store.getDEBUG()) continue;
            this.logger.log(4, string + ": '" + tableSchema.tableSQL + "'");
        }
    }

    private void fixOldTableNames() {
        int n;
        for (n = 0; n < v370tableNames.length; ++n) {
            DBManager.v370tableNames[n] = v370tableNames[n] + this.brokerID;
        }
        for (n = 0; n < v350tableNames.length; ++n) {
            DBManager.v350tableNames[n] = v350tableNames[n] + this.brokerID;
        }
    }

    private String getPassword() {
        String string;
        this.passwordProp = this.vendorPropPrefix + ".password";
        String string2 = this.config.getProperty(this.passwordProp);
        if (string2 == null && (string2 = this.config.getProperty(FALLBACK_PWD_PROP)) != null) {
            this.passwordProp = FALLBACK_PWD_PROP;
        }
        this.needPasswordProp = this.vendorPropPrefix + ".needpassword";
        if (this.config.getProperty(this.needPasswordProp) == null && this.config.getProperty(string = "imq.persist.jdbc.needpassword") != null) {
            this.needPasswordProp = string;
        }
        this.needPassword = this.config.getBooleanProperty(this.needPasswordProp, false);
        if (string2 == null && this.needPassword) {
            Password password = new Password();
            for (int i = 0; (string2 == null || string2.trim().equals("")) && i < 5; ++i) {
                System.err.print(this.br.getString("B0039", this.openDBUrl));
                System.err.flush();
                string2 = password.getPassword();
            }
        }
        return string2;
    }

    private void checkHADBJDBCLogging() {
        String string = this.config.getProperty("com.sun.hadb.jdbc.level");
        if (string != null && string.length() > 0) {
            String string2 = StringUtil.expandVariables((String)"${imq.instanceshome}${/}${imq.instancename}${/}log${/}hadbLog.txt", (Properties)this.config);
            this.logger.log(8, "Enable HADB's JDBC driver logging (level=" + string + "): " + string2);
            try {
                java.util.logging.Logger logger = java.util.logging.Logger.getLogger("com.sun.hadb.jdbc");
                FileHandler fileHandler = new FileHandler(string2, true);
                fileHandler.setFormatter(new SimpleFormatter());
                logger.addHandler(fileHandler);
                logger.setLevel(Level.parse(string));
            }
            catch (Exception exception) {
                this.logger.logStack(16, "Failed to enable HADB's JDBC driver logging", (Throwable)exception);
            }
        }
    }

    private static String generateLockError(TableLock tableLock) {
        BrokerResources brokerResources = Globals.getBrokerResources();
        if (tableLock.port != 0) {
            return brokerResources.getKString("B3155", tableLock.host, String.valueOf(tableLock.port));
        }
        return brokerResources.getKString("B3156");
    }

    static final class TableSchema {
        String tableName;
        String tableSQL;
        HashMap indexMap = new HashMap();

        TableSchema(String string, String string2) {
            this.tableName = string;
            this.tableSQL = string2;
        }

        void addIndex(String string, String string2) {
            if (string2 != null && string2.trim().length() > 0) {
                this.indexMap.put(string, string2);
            } else {
                Globals.getLogger().log(16, "SQL command to create the table index " + string + " for table " + this.tableName + " is null or empty");
            }
        }

        String getIndex(String string) {
            return (String)this.indexMap.get(string);
        }

        Iterator indexIterator() {
            return this.indexMap.keySet().iterator();
        }
    }

    private static class TableLock {
        String lockstr;
        String instance;
        String host;
        String portstr;
        int port = 0;
        boolean isNull = false;

        TableLock(String string) {
            this.lockstr = string;
            if (this.lockstr == null || this.lockstr.length() == 0) {
                this.isNull = true;
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(this.lockstr, " :\t\n\r\f");
                try {
                    this.instance = stringTokenizer.nextToken();
                    this.host = stringTokenizer.nextToken();
                    this.portstr = stringTokenizer.nextToken();
                    try {
                        this.port = Integer.parseInt(this.portstr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.port = 0;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    Globals.getLogger().log(16, "B2087", (Object)this.lockstr);
                    this.lockstr = null;
                    this.isNull = true;
                }
            }
        }
    }
}

