/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.auth.AuthCacheData;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQDualThreadConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.util.Properties;

public class IMQDualThreadService
extends IMQService {
    private static boolean DEBUG = false;
    Properties cfg = System.getProperties();
    BrokerConfig cprops = Globals.getConfig();
    protected PacketRouter router = null;
    private AuthCacheData authCacheData = new AuthCacheData();
    private ConnectionManager ConnectionList = Globals.getConnectionManager();

    public IMQDualThreadService(String string, int n, PacketRouter packetRouter) {
        super(string, n);
        this.router = packetRouter;
    }

    public synchronized void startService(boolean bl) {
        if (this.isServiceRunning()) {
            this.logger.log(4, "B3100", (Object)"unable to start service, already started.");
            return;
        }
        this.setState(2);
        Object[] objectArray = new String[]{this.getName(), "in-process connections", String.valueOf(this.getMinThreadpool()), String.valueOf(this.getMaxThreadpool())};
        this.logger.log(8, "B1004", objectArray);
        try {
            this.logger.log(8, "B1227", (Object)AccessController.getInstance(this.getName(), this.getServiceType()).getUserRepository(), (Object)this.getName());
        }
        catch (BrokerException brokerException) {
            this.logger.log(16, "B2135", (Object)this.getName(), (Object)brokerException.getMessage());
        }
        if (bl) {
            this.setServiceRunning(false);
            this.setState(4);
        } else {
            this.setServiceRunning(true);
            this.setState(3);
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService(boolean bl) {
        int n;
        Object object;
        Object object2 = this;
        synchronized (object2) {
            if (this.isShuttingDown()) {
                return;
            }
            object = new String[]{this.getName(), "none"};
            if (bl) {
                this.logger.log(8, "B1007", (Object[])object);
            } else if (!this.isShuttingDown()) {
                this.logger.log(8, "B1053", (Object[])object);
            }
            this.setShuttingDown(true);
        }
        if (this.getServiceType() == 0) {
            object2 = this.connectionList.getConnectionList(this);
            object = null;
            for (n = object2.size() - 1; n >= 0; --n) {
                object = (Connection)object2.get(n);
                ((Connection)object).stopConnection();
            }
        }
        object2 = this;
        synchronized (object2) {
            this.setState(5);
            this.notify();
        }
        if (!bl) {
            return;
        }
        if (this.getServiceType() == 0) {
            object2 = this.connectionList.getConnectionList(this);
            object = null;
            for (n = object2.size() - 1; n >= 0; --n) {
                object = (Connection)object2.get(n);
                ((Connection)object).destroyConnection(true, 1, Globals.getBrokerResources().getKString("B0060"));
            }
        }
        object2 = this;
        synchronized (object2) {
            this.setState(6);
            this.notify();
        }
        if (DEBUG) {
            this.logger.log(4, "Destroying Service {0} with protocol {1} ", (Object)this.getName(), (Object)"none");
        }
    }

    public void stopNewConnections() throws IOException, IllegalStateException {
        if (this.getState() != 3) {
            throw new IllegalStateException(Globals.getBrokerResources().getKString("B4254"));
        }
        this.setState(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNewConnections() throws IOException {
        if (this.getState() != 8 && this.getState() != 4) {
            throw new IllegalStateException(Globals.getBrokerResources().getKString("B4255"));
        }
        IMQDualThreadService iMQDualThreadService = this;
        synchronized (iMQDualThreadService) {
            this.setState(3);
            this.notify();
        }
    }

    public void pauseService(boolean bl) {
        if (!this.isServiceRunning()) {
            this.logger.log(4, "B3100", (Object)("unable to pause service " + this.name + ", already paused."));
            return;
        }
        Object[] objectArray = new String[]{this.getName(), "none"};
        this.logger.log(4, "B1005", objectArray);
        try {
            this.stopNewConnections();
        }
        catch (Exception exception) {
            this.logger.logStack(16, "B3100", (Object)("pausing service " + this), (Throwable)exception);
        }
        this.setState(4);
        this.setServiceRunning(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeService() {
        if (this.isServiceRunning()) {
            this.logger.log(4, "B3100", (Object)("unable to resume service " + this.name + ", already running."));
            return;
        }
        Object[] objectArray = new String[]{this.getName(), "none"};
        this.logger.log(4, "B1006", objectArray);
        try {
            this.startNewConnections();
        }
        catch (Exception exception) {
            this.logger.logStack(16, "B3100", (Object)("pausing service " + this), (Throwable)exception);
        }
        this.setServiceRunning(true);
        IMQDualThreadService iMQDualThreadService = this;
        synchronized (iMQDualThreadService) {
            this.setState(3);
            this.notify();
        }
    }

    public IMQDualThreadConnection createConnection() throws IOException, BrokerException {
        IMQDualThreadConnection iMQDualThreadConnection = new IMQDualThreadConnection(this, this.router);
        this.connectionList.addConnection(iMQDualThreadConnection);
        return iMQDualThreadConnection;
    }
}

