/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.service.stomp.StompConnection;
import com.sun.messaging.bridge.service.stomp.StompFrameMessage;
import com.sun.messaging.bridge.service.stomp.StompOutputHandler;
import com.sun.messaging.bridge.service.stomp.StompProtocolHandler;
import com.sun.messaging.bridge.service.stomp.StompServer;
import com.sun.messaging.bridge.service.stomp.UnrecoverableAckFailureException;
import com.sun.messaging.bridge.service.stomp.resources.StompBridgeResources;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;

public class StompSubscriberSession
implements MessageListener {
    private Logger _logger = null;
    private String _subid = null;
    private Session _session = null;
    private MessageConsumer _subscriber = null;
    private StompOutputHandler _out = null;
    private ArrayList<Message> _unacked = new ArrayList();
    private String _duraName = null;
    private StompConnection _stompc;
    private StompBridgeResources _sbr = null;
    private boolean _clientack = false;
    private int _ackfailureCount = 0;
    private int MAX_CONSECUTIVE_ACK_FAILURES = 3;

    public StompSubscriberSession(String string, int n, StompConnection stompConnection) throws Exception {
        this._stompc = stompConnection;
        this._subid = string;
        this._sbr = StompServer.getStompBridgeResources();
        this._session = stompConnection.getConnection().createSession(false, n);
        this._clientack = this._session.getAcknowledgeMode() == 2;
    }

    public void createSubscriber(Destination destination, String string, String string2, boolean bl, StompOutputHandler stompOutputHandler) throws Exception {
        this._logger = StompServer.logger();
        if (this._subscriber != null) {
            throw new IllegalStateException("createSubscriber(): Unexpected call");
        }
        this._out = stompOutputHandler;
        if (destination instanceof Queue) {
            this._subscriber = this._session.createConsumer(destination, string);
        } else if (string2 != null) {
            this._subscriber = this._session.createDurableSubscriber((Topic)destination, string2, string, bl);
            this._duraName = string2;
        } else {
            this._subscriber = this._session.createConsumer(destination, string, bl);
        }
        this._subscriber.setMessageListener((MessageListener)this);
    }

    public void closeSubscriber() throws Exception {
        if (this._subscriber != null) {
            this._subscriber.close();
        }
    }

    public Session getJMSSession() {
        return this._session;
    }

    public String getDuraName() {
        return this._duraName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        String string = "";
        try {
            if (this._clientack) {
                ArrayList<Message> arrayList = this._unacked;
                synchronized (arrayList) {
                    this._unacked.add(message);
                }
            }
            string = message.getJMSMessageID();
            this._out.sendToClient(this._stompc.toStompFrameMessage(message, this._subid, this._session));
        }
        catch (Throwable throwable) {
            try {
                block16: {
                    Object[] objectArray = new String[]{string, this._subid, throwable.getMessage()};
                    if (throwable instanceof ClosedChannelException) {
                        this._logger.log(Level.WARNING, this._sbr.getKString("BSS2009", objectArray));
                        RuntimeException runtimeException = new RuntimeException(throwable.getMessage());
                        runtimeException.initCause(throwable);
                        throw runtimeException;
                    }
                    this._logger.log(Level.WARNING, this._sbr.getKString("BSS2009", objectArray), throwable);
                    StompFrameMessage stompFrameMessage = null;
                    try {
                        stompFrameMessage = StompProtocolHandler.toStompErrorMessage("Subscriber[" + this._subid + "].onMessage", throwable, true);
                    }
                    catch (Throwable throwable2) {
                        this._logger.log(Level.WARNING, this._sbr.getKString("BSS3004", throwable.getMessage()), throwable2);
                        RuntimeException runtimeException = new RuntimeException(throwable.getMessage());
                        runtimeException.initCause(throwable);
                        throw runtimeException;
                    }
                    try {
                        this._out.sendToClient(stompFrameMessage);
                    }
                    catch (Throwable throwable3) {
                        if (throwable3 instanceof ClosedChannelException) {
                            this._logger.log(Level.WARNING, this._sbr.getKString("BSS3001", throwable.getMessage(), throwable3.getMessage()));
                            break block16;
                        }
                        this._logger.log(Level.WARNING, this._sbr.getKString("BSS3001", throwable.getMessage(), throwable3.getMessage()), throwable3);
                    }
                }
                RuntimeException runtimeException = new RuntimeException(throwable.getMessage());
                runtimeException.initCause(throwable);
                throw runtimeException;
            }
            catch (Throwable throwable4) {
                try {
                    this.closeSubscriber();
                }
                catch (Exception exception) {
                    this._logger.log(Level.FINE, "Close subscriber " + this + " failed:" + exception.getMessage(), exception);
                }
                throw throwable4;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(String string) throws Exception {
        if (this._session.getAcknowledgeMode() != 2) {
            throw new JMSException(this._sbr.getKString("BSS4027", string, this._subid));
        }
        ArrayList<Message> arrayList = this._unacked;
        synchronized (arrayList) {
            Message message = null;
            int n = this._unacked.size() - 1;
            boolean bl = false;
            int n2 = 0;
            for (n2 = n; n2 >= 0; --n2) {
                message = this._unacked.get(n2);
                if (!string.equals(message.getJMSMessageID())) continue;
                try {
                    ((MessageImpl)message).acknowledgeUpThroughThisMessage();
                    this._ackfailureCount = 0;
                }
                catch (Exception exception) {
                    ++this._ackfailureCount;
                    UnrecoverableAckFailureException unrecoverableAckFailureException = null;
                    if (exception instanceof JMSException && this._session instanceof SessionImpl && ((SessionImpl)this._session)._appCheckRemoteException((JMSException)((Object)exception))) {
                        unrecoverableAckFailureException = new UnrecoverableAckFailureException("An unrecoverable ACK failure has occurred in subscriber " + this);
                        unrecoverableAckFailureException.setLinkedException(exception);
                        throw unrecoverableAckFailureException;
                    }
                    if (this._ackfailureCount > this.MAX_CONSECUTIVE_ACK_FAILURES) {
                        unrecoverableAckFailureException = new UnrecoverableAckFailureException("Maximum consecutive ACK failures " + this.MAX_CONSECUTIVE_ACK_FAILURES + " has occurred in subscriber " + this);
                        unrecoverableAckFailureException.setLinkedException(exception);
                        throw unrecoverableAckFailureException;
                    }
                    throw exception;
                }
                bl = true;
                break;
            }
            if (bl) {
                for (int i = 0; i <= n2; ++i) {
                    this._unacked.remove(0);
                }
                return;
            }
        }
        throw new JMSException(this._sbr.getKString("BSS4028", string, this._subid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        try {
            this._subscriber.close();
        }
        catch (Exception exception) {
            try {
                this._session.close();
            }
            finally {
                ArrayList<Message> arrayList = this._unacked;
                synchronized (arrayList) {
                    this._unacked.clear();
                }
            }
        }
        finally {
            try {
                this._session.close();
            }
            finally {
                ArrayList<Message> arrayList = this._unacked;
                synchronized (arrayList) {
                    this._unacked.clear();
                }
            }
        }
    }
}

