/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service;

import com.sun.messaging.ConnectionFactory;
import com.sun.messaging.XAConnectionFactory;
import com.sun.messaging.bridge.BridgeBaseContext;
import com.sun.messaging.bridge.BridgeUtil;
import com.sun.messaging.bridge.service.JMSBridgeStore;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class BridgeContext {
    public static final String BRIDGE_PROP_PREFIX = "BRIDGE_PROP_PREFIX";
    public static final String KEYSTORE_FILE = "javax.net.ssl.keyStore";
    public static final String KEYSTORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String KEYSTORE_TYPE = "javax.net.ssl.keyStoreType";
    public static final String TRUSTSTORE_FILE = "javax.net.ssl.trustStore";
    public static final String TRUSTSTORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    public static final String TRUSTSTORE_TYPE = "javax.net.ssl.trustStoreType";
    public static final String KEYSTORE_ALGORITHM = "ssl.KeyManagerFactory.algorithm";
    public static final String TRUSTSTORE_ALGORITHM = "ssl.TrustManagerFactory.algorithm";
    public static final String SECURESOCKET_PROTOCOL = "securesocket.protocol";
    private BridgeBaseContext _bc;
    private String _name = null;
    private Properties _config = null;

    public BridgeContext(BridgeBaseContext bridgeBaseContext, String string) {
        this._bc = bridgeBaseContext;
        this._name = string;
        this._config = new Properties();
        Properties properties = this._bc.getBridgeConfig();
        String string2 = properties.getProperty("PROP_PREFIX") + "." + this._name;
        List<String> list = BridgeUtil.getPropertyNames(string2, properties);
        String string32 = null;
        for (String string32 : list) {
            this._config.put(string32, properties.getProperty(string32));
        }
        this._config.put(string2 + ".varhome", properties.getProperty(properties.getProperty("PROP_PREFIX") + ".varhome") + File.separator + this._name);
        this._config.put(string2 + ".libhome", properties.getProperty(properties.getProperty("PROP_PREFIX") + ".libhome"));
        this._config.put(BRIDGE_PROP_PREFIX, string2);
    }

    public boolean isEmbeded() {
        return this._bc.isEmbeded();
    }

    public boolean isEmbededBroker() {
        return this._bc.isEmbededBroker();
    }

    public Properties getConfig() {
        return this._config;
    }

    public String getRootDir() {
        return this._config.getProperty(this._config.getProperty(BRIDGE_PROP_PREFIX) + ".varhome");
    }

    public String getLibDir() {
        return this._config.getProperty(this._config.getProperty(BRIDGE_PROP_PREFIX) + ".libhome");
    }

    public String getProperty(String string) {
        return this._config.getProperty(this._config.getProperty(BRIDGE_PROP_PREFIX) + "." + string);
    }

    public javax.jms.ConnectionFactory getConnectionFactory(Properties properties) throws Exception {
        ConnectionFactory connectionFactory = new ConnectionFactory();
        if (properties != null) {
            String string = null;
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (string.equals("imqAddressList")) continue;
                connectionFactory.setProperty(string, properties.getProperty(string));
            }
        }
        connectionFactory.setProperty("imqAddressList", this._bc.getBrokerServiceAddress("tcp", "NORMAL"));
        return connectionFactory;
    }

    public javax.jms.XAConnectionFactory getXAConnectionFactory(Properties properties) throws Exception {
        XAConnectionFactory xAConnectionFactory = new XAConnectionFactory();
        if (properties != null) {
            String string = null;
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (string.equals("imqAddressList")) continue;
                xAConnectionFactory.setProperty(string, properties.getProperty(string));
            }
        }
        xAConnectionFactory.setProperty("imqAddressList", this._bc.getBrokerServiceAddress("tcp", "NORMAL"));
        return xAConnectionFactory;
    }

    public javax.jms.ConnectionFactory getAdminConnectionFactory(Properties properties) throws Exception {
        Object object;
        Object object2;
        ConnectionFactory connectionFactory = new ConnectionFactory();
        if (properties != null) {
            object2 = null;
            object = properties.propertyNames();
            while (object.hasMoreElements()) {
                object2 = (String)object.nextElement();
                if (((String)object2).equals("imqAddressList")) continue;
                connectionFactory.setProperty((String)object2, properties.getProperty((String)object2));
            }
        }
        connectionFactory.setProperty("imqAddressList", this._bc.getBrokerServiceAddress("tcp", "NORMAL"));
        object2 = this._bc.getBridgeConfig();
        object = ((Properties)object2).getProperty("PROP_PREFIX") + ".admin.user";
        String string = ((Properties)object2).getProperty("PROP_PREFIX") + ".admin.password";
        String string2 = ((Properties)object2).getProperty((String)object);
        String string3 = ((Properties)object2).getProperty(string);
        connectionFactory.setProperty("imqDefaultUsername", string2);
        connectionFactory.setProperty("imqDefaultPassword", string3);
        return connectionFactory;
    }

    public boolean handleGlobalError(Throwable throwable, String string) {
        return this._bc.handleGlobalError(throwable, string);
    }

    public void registerService(String string, String string2, int n, HashMap hashMap) {
        this._bc.registerService(this._name, string, string2, n, hashMap);
    }

    public Properties getDefaultSSLContextConfig() throws Exception {
        return this._bc.getDefaultSSLContextConfig(this._name);
    }

    public String getIdentityName() throws Exception {
        return this._bc.getIdentityName();
    }

    public String getTransactionManagerClass() throws Exception {
        String string;
        Properties properties = this._bc.getBridgeConfig();
        String string2 = properties.getProperty(string = properties.getProperty("PROP_PREFIX") + "." + this._name + ".tm.class");
        if (string2 != null) {
            return string2;
        }
        string = "PROP_PREFIX.tm.class";
        return properties.getProperty(string);
    }

    public Properties getTransactionManagerProps() throws Exception {
        List<String> list;
        Properties properties = new Properties();
        Properties properties2 = this._bc.getBridgeConfig();
        String string = "PROP_PREFIX.tm.props";
        List<String> list2 = BridgeUtil.getListProperty(string, properties2);
        string = properties2.getProperty("PROP_PREFIX") + "." + this._name + ".tm.props";
        List<String> list3 = BridgeUtil.getListProperty(string, properties2);
        if (list2 == null && list3 == null) {
            return properties;
        }
        if (list2 != null) {
            for (String string2 : list2) {
                list = BridgeUtil.breakToList(string2, "=");
                if (list.size() != 2) {
                    throw new IllegalArgumentException("Invalid element for broker property " + string);
                }
                properties.setProperty(list.get(0), list.get(1));
            }
        }
        if (list3 != null) {
            for (String string2 : list3) {
                list = BridgeUtil.breakToList(string2, "=");
                if (list.size() != 2) {
                    throw new IllegalArgumentException("Invalid element for broker property " + string);
                }
                properties.setProperty(list.get(0), list.get(1));
            }
        }
        return properties;
    }

    public boolean isJDBCStoreType() throws Exception {
        return this._bc.isJDBCStoreType();
    }

    public Object getJDBCStore(String string) throws Exception {
        if (string.toUpperCase().equals("JMS")) {
            return (JMSBridgeStore)this._bc.getJDBCStore();
        }
        return null;
    }

    public static String toString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public boolean allocateMemCheck(long l) {
        return this._bc.allocateMemCheck(l);
    }

    public void logError(String string, Throwable throwable) {
        this._bc.logError(string, throwable);
    }

    public void logWarn(String string, Throwable throwable) {
        this._bc.logWarn(string, throwable);
    }

    public void logInfo(String string, Throwable throwable) {
        this._bc.logInfo(string, throwable);
    }

    public void logDebug(String string, Throwable throwable) {
        this._bc.logDebug(string, throwable);
    }
}

