/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra.util;

import com.sun.messaging.jmq.jmsclient.XAResourceForJMQ;
import com.sun.messaging.jmq.util.XidImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.transaction.xa.XAException;

public class XAResourceMapForRAMC {
    private static HashMap<XidImpl, Set<XAResourceForJMQ>> resourceMap = new HashMap();

    public static synchronized void register(XidImpl xidImpl, XAResourceForJMQ xAResourceForJMQ, boolean bl) throws XAException {
        Set<XAResourceForJMQ> set = resourceMap.get(xidImpl);
        if (set == null) {
            if (bl) {
                XAException xAException = new XAException("Trying to add an XAResource using the JOIN flag when no existing XAResource has been added with this XID");
                xAException.errorCode = -5;
                throw xAException;
            }
            set = new HashSet<XAResourceForJMQ>();
            resourceMap.put(xidImpl, set);
        } else if (!bl) {
            XAException xAException = new XAException("Trying to add an XAResource to an existing xid without using the JOIN flag");
            xAException.errorCode = -8;
            throw xAException;
        }
        set.add(xAResourceForJMQ);
    }

    public static synchronized void unregister(XidImpl xidImpl) {
        resourceMap.remove(xidImpl);
    }

    public static synchronized void unregisterResource(XAResourceForJMQ xAResourceForJMQ, XidImpl xidImpl) {
        Set<XAResourceForJMQ> set = resourceMap.get(xidImpl);
        if (set != null) {
            set.remove(xAResourceForJMQ);
            if (set.size() == 0) {
                resourceMap.remove(xidImpl);
            }
        }
    }

    public static synchronized XAResourceForJMQ[] getXAResources(XidImpl xidImpl, boolean bl) throws XAException {
        Set<XAResourceForJMQ> set = resourceMap.get(xidImpl);
        if (set == null) {
            if (bl) {
                XAException xAException = new XAException("Unknown XID (was start() called?");
                throw xAException;
            }
            return new XAResourceForJMQ[0];
        }
        return set.toArray(new XAResourceForJMQ[set.size()]);
    }

    public static boolean isEmpty() {
        return resourceMap.isEmpty();
    }
}

