/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.Selector;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;

public class VerifyDestinationHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Hashtable<String, Object> hashtable;
        Packet packet2;
        block22: {
            block21: {
                int n = 200;
                String string = null;
                assert (packet.getPacketType() == 40);
                packet2 = new Packet(iMQConnection.useDirectBuffers());
                packet2.setConsumerID(packet.getConsumerID());
                packet2.setPacketType(41);
                hashtable = new Hashtable<String, Object>();
                Hashtable hashtable2 = null;
                String string2 = null;
                int n2 = 0;
                try {
                    hashtable2 = packet.getProperties();
                    String string3 = (String)hashtable2.get("JMQDestination");
                    Integer n3 = (Integer)hashtable2.get("JMQDestType");
                    assert (string3 != null);
                    assert (n3 != null);
                    n2 = n3 == null ? 0 : n3;
                    string2 = (String)hashtable2.get("JMQSelector");
                    if (string2 != null) {
                        Selector selector = Selector.compile((String)string2);
                        selector = null;
                    }
                    boolean bl = false;
                    Destination destination = null;
                    if (DestinationUID.isWildcard(string3)) {
                        packet2.setWildcard(true);
                        DestinationUID destinationUID = DestinationUID.getUID(string3, n2);
                        List list = Destination.findMatchingIDs(destinationUID);
                        if (list.isEmpty()) {
                            bl = true;
                        }
                    } else {
                        destination = Destination.getDestination(string3, DestType.isQueue((int)n2));
                        boolean bl2 = bl = destination == null;
                    }
                    if (bl) {
                        n = 404;
                        string = "destination not found";
                        hashtable.put("JMQCanCreate", Destination.canAutoCreate(DestType.isQueue((int)n2)));
                    } else if (destination != null) {
                        hashtable.put("JMQDestType", new Integer(destination.getType()));
                    }
                }
                catch (SelectorFormatException selectorFormatException) {
                    string = selectorFormatException.getMessage();
                    n = 400;
                    this.logger.log(16, "B2016", string2, (Throwable)selectorFormatException);
                }
                catch (IOException iOException) {
                    this.logger.log(32, "B3100", (Object)"Unable to verify destination - no properties", (Throwable)iOException);
                    string = iOException.getMessage();
                    n = 500;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.logger.logStack(32, "B3100", (Object)"Unable to verify destination -bad class", (Throwable)classNotFoundException);
                    string = classNotFoundException.getMessage();
                    n = 500;
                }
                catch (BrokerException brokerException) {
                    string = brokerException.getMessage();
                    n = brokerException.getStatusCode();
                    this.logger.logStack(4, "B3100", (Object)"Unable to verify destination ", (Throwable)brokerException);
                }
                catch (SecurityException securityException) {
                    string = securityException.getMessage();
                    n = 403;
                    this.logger.log(16, securityException.toString(), (Throwable)securityException);
                }
                hashtable.put("JMQStatus", new Integer(n));
                if (string != null) {
                    hashtable.put("JMQReason", string);
                }
                IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)iMQConnection;
                if (IMQBasicConnection.getDumpPacket()) break block21;
                IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)iMQConnection;
                if (!IMQBasicConnection.getDumpOutPacket()) break block22;
            }
            hashtable.put("JMQReqID", packet.getSysMessageID().toString());
        }
        packet2.setProperties(hashtable);
        iMQConnection.sendControlMessage(packet2);
        return true;
    }
}

