/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.JMQByteBufferInputStream;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.Hashtable;

public class VerifyTransactionHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;
    TransactionList translist = null;

    public VerifyTransactionHandler(TransactionList transactionList) {
        this.translist = transactionList;
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Hashtable<String, Object> hashtable;
        Packet packet2;
        block28: {
            block27: {
                int n = 200;
                String string = null;
                assert (packet.getPacketType() == 78);
                packet2 = new Packet(iMQConnection.useDirectBuffers());
                packet2.setConsumerID(packet.getConsumerID());
                packet2.setPacketType(79);
                hashtable = new Hashtable<String, Object>();
                Hashtable hashtable2 = null;
                TransactionUID transactionUID = null;
                JMQXid jMQXid = null;
                try {
                    long l;
                    hashtable2 = packet.getProperties();
                    Long l2 = (Long)hashtable2.get("JMQTransactionID");
                    if (l2 == null) {
                        throw new BrokerException("Bad/Missing transaction id");
                    }
                    ByteBuffer byteBuffer = packet.getMessageBodyByteBuffer();
                    if (byteBuffer != null) {
                        JMQByteBufferInputStream jMQByteBufferInputStream = new JMQByteBufferInputStream(byteBuffer);
                        try {
                            jMQXid = JMQXid.read((DataInput)new DataInputStream((InputStream)jMQByteBufferInputStream));
                        }
                        catch (IOException iOException) {
                            this.logger.log(32, "B3100", (Object)("Could not decode xid from packet " + PacketType.getString((int)packet.getPacketType()) + ":" + iOException));
                            BrokerException brokerException = new BrokerException(iOException.getMessage(), 400);
                            brokerException.initCause(iOException);
                            throw brokerException;
                        }
                    }
                    if ((l = l2.longValue()) != 0L) {
                        transactionUID = new TransactionUID(l);
                    } else if (jMQXid != null) {
                        transactionUID = this.translist.xidToUID(jMQXid);
                        if (transactionUID == null) {
                            String string2 = Globals.getBrokerResources().getKString("B2195", "" + jMQXid, PacketType.getString((int)packet.getPacketType()));
                            this.logger.log(16, string2);
                            throw new BrokerException("Unknown XID " + jMQXid, 404);
                        }
                    } else {
                        this.logger.log(32, "B3100", (Object)("No transaction ID in " + PacketType.getString((int)packet.getPacketType())));
                        throw new BrokerException("No transaction ID", 400);
                    }
                    TransactionState transactionState = this.translist.retrieveState(transactionUID, true);
                    if (transactionState == null) {
                        n = 410;
                    } else {
                        int n2 = transactionState.getState();
                        if (n2 != 5) {
                            throw new BrokerException("Transaction " + transactionUID + " is not PREPARED " + transactionState, 410);
                        }
                        Hashtable hashtable3 = this.translist.getTransactionMap(transactionUID, true);
                        if (hashtable3 != null) {
                            try {
                                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                                objectOutputStream.writeObject(hashtable3);
                                objectOutputStream.flush();
                                byteArrayOutputStream.flush();
                                packet2.setMessageBody(byteArrayOutputStream.toByteArray());
                                byteArrayOutputStream.close();
                            }
                            catch (Exception exception) {
                                this.logger.log(16, "B3100", (Object)" sending back broker data", (Throwable)exception);
                            }
                        }
                    }
                }
                catch (BrokerException brokerException) {
                    string = brokerException.getMessage();
                    n = brokerException.getStatusCode();
                    if (n != 410 && n != 404) {
                        this.logger.logStack(8, "B3100", (Object)"unknown status", (Throwable)brokerException);
                    } else {
                        this.logger.log(4, "Transaction " + transactionUID + " not found", (Throwable)brokerException);
                    }
                }
                catch (Throwable throwable) {
                    this.logger.logStack(8, "B3100", (Object)"exception processing verify transaction ", throwable);
                    string = throwable.toString();
                    n = 500;
                }
                if (n == 410) {
                    n = 404;
                }
                hashtable.put("JMQStatus", new Integer(n));
                if (string != null) {
                    hashtable.put("JMQReason", string);
                }
                IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)iMQConnection;
                if (IMQBasicConnection.getDumpPacket()) break block27;
                IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)iMQConnection;
                if (!IMQBasicConnection.getDumpOutPacket()) break block28;
            }
            hashtable.put("JMQReqID", packet.getSysMessageID().toString());
        }
        packet2.setProperties(hashtable);
        iMQConnection.sendControlMessage(packet2);
        return true;
    }
}

