/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service;

import com.sun.messaging.jmq.io.ClusterDiscoveryProtocol;
import com.sun.messaging.jmq.io.ServiceEntry;
import com.sun.messaging.jmq.io.ServiceTable;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.net.MQServerSocketFactory;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Hashtable;
import java.util.Properties;
import javax.net.ServerSocketFactory;

public class ClusterDiscoveryService
implements Runnable,
ConfigListener {
    public static final int CLUSTER_DISCOVERY_PORT = 0;
    private static final String PORT_PROPERTY = "imq.cluster_discovery.port";
    private static final String BACKLOG_PROPERTY = "imq.cluster_discovery.backlog";
    private static final String SERVICE_NAME = "cluster_discovery";
    private static boolean DEBUG = false;
    private static Logger logger = null;
    private static BrokerResources rb = null;
    private static BrokerConfig bc = null;
    private static ServerSocketFactory ssf = MQServerSocketFactory.getDefault();
    private ServiceTable st = null;
    private ServerSocket serverSocket = null;
    private String hostname = "???";
    private int port = 0;
    private int backlog = 100;

    public ClusterDiscoveryService(String string, String string2) {
        if (DEBUG) {
            logger.log(4, "Creating cluster discovery service.");
        }
        this.hostname = string2;
        if (string2 == null) {
            try {
                this.hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                logger.logStack(16, "ClusterDiscoveryService: initialization error", (Throwable)exception);
            }
        }
        this.st = new ServiceTable();
        this.st.setBrokerInstanceName(string);
        this.st.setBrokerVersion(Globals.getVersion().getProductVersion());
        logger = Globals.getLogger();
        rb = Globals.getBrokerResources();
        bc = Globals.getConfig();
        bc.addListener(PORT_PROPERTY, this);
        bc.addListener(BACKLOG_PROPERTY, this);
    }

    private String addressString(BrokerAddress brokerAddress) {
        String string = null;
        if (brokerAddress != null) {
            string = "portmapper@" + brokerAddress.toConfigString();
        }
        return string;
    }

    public void setActiveBroker(BrokerAddress brokerAddress) {
        if (DEBUG) {
            logger.log(4, "ClusterDiscoveryService: active broker = " + brokerAddress);
        }
        this.st.setActiveBroker(this.addressString(brokerAddress));
    }

    public void addSelfAddress(BrokerAddress brokerAddress) {
        this.addRemoteService(brokerAddress);
    }

    public void addRemoteService(BrokerAddress brokerAddress) {
        if (DEBUG) {
            logger.log(4, "ClusterDiscoveryService: New remote service = " + brokerAddress);
        }
        this.st.addRemoteService(this.addressString(brokerAddress));
    }

    public void removeRemoteService(BrokerAddress brokerAddress) {
        if (DEBUG) {
            logger.log(4, "ClusterDiscoveryService: Removing remote service = " + brokerAddress);
        }
        this.st.removeRemoteService(this.addressString(brokerAddress));
    }

    public synchronized void addService(String string, String string2, String string3, String string4) {
        ServiceEntry serviceEntry = new ServiceEntry();
        serviceEntry.setName(string);
        serviceEntry.setProtocol(string2);
        serviceEntry.setType(string3);
        serviceEntry.setAddress(string4);
        this.addService(string, serviceEntry);
    }

    public synchronized void updateServiceAddress(String string, String string2) {
        ServiceEntry serviceEntry;
        if (DEBUG) {
            logger.log(4, "ClusterDiscoveryService: Changing service:\n\tname = " + string + "\n\taddress = " + string2);
        }
        if ((serviceEntry = this.st.get(string)) != null) {
            serviceEntry.setAddress(string2);
        }
    }

    public synchronized void addService(String string, ServiceEntry serviceEntry) {
        if (DEBUG) {
            logger.log(4, "Adding service :\n\tname = " + serviceEntry.getName() + "\n\ttype = " + serviceEntry.getType() + "\n\tprotocol = " + serviceEntry.getProtocol() + "\n\taddress = " + serviceEntry.getAddress());
        }
        this.st.add(serviceEntry);
    }

    public synchronized void removeService(String string) {
        if (DEBUG) {
            logger.log(4, "Removing service : " + string);
        }
        this.st.remove(string);
    }

    public synchronized void addService(String string, String string2, String string3, int n, String string4) {
        if (string4 == null) {
            string4 = this.hostname;
        }
        String string5 = string + '@' + string4 + ":" + n;
        this.addService(string, string2, string3, string5);
    }

    public synchronized void updateServiceAddress(String string, String string2, int n) {
        if (string2 == null) {
            string2 = this.hostname;
        }
        String string3 = string + '@' + string2 + "-" + n;
        this.updateServiceAddress(string, string3);
    }

    public synchronized Hashtable getServices() {
        return this.st.getServices();
    }

    public synchronized String toString() {
        return this.st.toString();
    }

    private String selfAddress() {
        if (this.serverSocket != null) {
            return "cluster_discovery@" + this.hostname + ":" + this.serverSocket.getLocalPort();
        }
        return "cluster_discovery@" + this.hostname + ":" + this.port;
    }

    private static void sleep(int n) {
        try {
            Thread.sleep((long)n * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void init() throws PropertyUpdateException {
        String string = bc.getProperty(PORT_PROPERTY);
        if (string != null) {
            this.validate(PORT_PROPERTY, string);
            this.update(PORT_PROPERTY, string);
        }
        if ((string = bc.getProperty(BACKLOG_PROPERTY)) != null) {
            this.validate(BACKLOG_PROPERTY, string);
            this.update(BACKLOG_PROPERTY, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        Socket socket = null;
        if (this.serverSocket == null) {
            this.createServerSocket(this.port);
        }
        while (true) {
            if (this.serverSocket == null) {
                logger.log(32, "Could not start cluster discovery service. Exiting.");
                return;
            }
            try {
                socket = this.serverSocket.accept();
            }
            catch (SocketException socketException) {
                if (socketException instanceof BindException || socketException instanceof ConnectException || socketException instanceof NoRouteToHostException) {
                    logger.log(32, "Cluster discovery exception. Continuing.", (Throwable)socketException);
                    ClusterDiscoveryService.sleep(1);
                    continue;
                }
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.createServerSocket(this.port);
                continue;
            }
            catch (IOException iOException) {
                logger.log(32, "Cluster discovery exception. Continuing.", (Throwable)iOException);
                ClusterDiscoveryService.sleep(1);
                continue;
            }
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            Properties properties = ClusterDiscoveryProtocol.receiveRequest((InputStream)inputStream);
            String string = properties.getProperty("operation_type");
            if (string.equals("REQUEST")) {
                ClusterDiscoveryProtocol.sendResponse((ServiceTable)this.st, (OutputStream)outputStream);
            } else {
                logger.log(32, "Unknown cluster discovery request. Continuing.");
            }
            outputStream.close();
            inputStream.close();
            socket.close();
            Object var7_10 = null;
            try {
                socket.close();
            }
            catch (IOException iOException2) {}
            continue;
            {
                catch (IOException iOException) {
                    logger.log(32, "Cluster discovery exception. Continuing.", (Throwable)iOException);
                    var7_10 = null;
                    try {
                        socket.close();
                    }
                    catch (IOException iOException2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var7_10 = null;
                try {
                    socket.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void createServerSocket(int n) {
        try {
            this.serverSocket = ssf.createServerSocket(n, this.backlog);
            Globals.getPortMapper().addService(SERVICE_NAME, "tcp", "CLUSTER_DISCOVERY", this.serverSocket.getLocalPort(), null);
            this.addService(SERVICE_NAME, "tcp", "CLUSTER_DISCOVERY", this.selfAddress());
        }
        catch (BindException bindException) {
            logger.log(32, "B3068", (Object)SERVICE_NAME, (Object)new Integer(n));
            this.serverSocket = null;
            return;
        }
        catch (IOException iOException) {
            logger.log(32, "B3022", (Object)SERVICE_NAME, (Object)new Integer(n), (Throwable)iOException);
            this.serverSocket = null;
            return;
        }
        Object[] objectArray = new Object[]{SERVICE_NAME, "tcp [ " + n + ", " + this.backlog + " ]", new Integer(1), new Integer(1)};
        logger.log(8, "B1004", objectArray);
    }

    public synchronized void setPort(int n) {
        if (n == this.port) {
            return;
        }
        this.port = n;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    public synchronized void setBacklog(int n) {
        this.backlog = n;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void validate(String string, String string2) throws PropertyUpdateException {
        if (!string.equals(PORT_PROPERTY) && !string.equals(BACKLOG_PROPERTY)) {
            throw new PropertyUpdateException(rb.getString("B4028", string));
        }
        int n = this.getIntProperty(string, string2);
        if (string.equals(PORT_PROPERTY)) {
            if (n == this.port) {
                return;
            }
            try {
                ClusterDiscoveryService.canBind(n);
            }
            catch (BindException bindException) {
                throw new PropertyUpdateException(rb.getString("B3068", SERVICE_NAME, string2));
            }
            catch (IOException iOException) {
                throw new PropertyUpdateException(rb.getString("B3022", SERVICE_NAME, string2) + iOException.toString());
            }
        }
    }

    public boolean update(String string, String string2) {
        try {
            if (string.equals(PORT_PROPERTY)) {
                this.setPort(this.getIntProperty(string, string2));
            } else if (string.equals(BACKLOG_PROPERTY)) {
                this.setBacklog(this.getIntProperty(string, string2));
            }
        }
        catch (PropertyUpdateException propertyUpdateException) {
            // empty catch block
        }
        return true;
    }

    private static void canBind(int n) throws IOException {
        ServerSocket serverSocket = null;
        serverSocket = ssf.createServerSocket(n);
        serverSocket.close();
    }

    private int getIntProperty(String string, String string2) throws PropertyUpdateException {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PropertyUpdateException(rb.getString("B4027", string + "=" + string2));
        }
    }
}

