/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.timer;

import com.sun.messaging.jmq.util.log.Logger;
import java.util.logging.Level;

public class WakeupableTimer
implements Runnable {
    private static boolean DEBUG = false;
    private Logger logger = null;
    private java.util.logging.Logger jlogger = null;
    private String name = null;
    private long nexttime = 0L;
    private long repeatinterval = 0L;
    private Thread thr = null;
    private Runnable runner = null;
    private boolean valid = true;
    private boolean wakeup = false;
    private String startString = null;
    private String exitString = null;

    public void setLogger(Object object) {
        if (object instanceof Logger) {
            this.logger = (Logger)object;
            if (this.logger.getLevel() <= 4) {
                DEBUG = true;
            }
        } else if (object instanceof java.util.logging.Logger) {
            this.jlogger = (java.util.logging.Logger)object;
            if (this.jlogger.isLoggable(Level.FINE)) {
                DEBUG = true;
            }
        }
    }

    public WakeupableTimer(String string, Runnable runnable, long l, long l2, String string2, String string3, Object object) {
        this.name = string;
        this.nexttime = l + System.currentTimeMillis();
        this.repeatinterval = l2;
        this.runner = runnable;
        this.startString = string2;
        this.exitString = string3;
        this.setLogger(object);
        this.thr = new Thread((Runnable)this, string);
        this.thr.start();
    }

    public synchronized void wakeup() {
        this.wakeup = true;
        this.notify();
    }

    public void cancel() {
        this.valid = false;
        this.wakeup();
        this.thr.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.logInfo(this.startString);
        long l = System.currentTimeMillis();
        while (this.valid) {
            WakeupableTimer wakeupableTimer = this;
            synchronized (wakeupableTimer) {
                while (!this.wakeup && l < this.nexttime) {
                    try {
                        this.wait(this.nexttime - l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    l = System.currentTimeMillis();
                }
                if (!this.valid) {
                    break;
                }
                this.wakeup = false;
            }
            if (DEBUG) {
                this.logInfo(this.name + " run " + this.runner.getClass().getName());
            }
            this.runner.run();
            if (DEBUG) {
                this.logInfo(this.name + " completed run " + this.runner.getClass().getName());
            }
            if (!this.wakeup && this.repeatinterval == 0L) break;
            l = System.currentTimeMillis();
            this.nexttime = l + this.repeatinterval;
        }
        this.logInfo(this.exitString);
    }

    private void logInfo(String string) {
        if (this.logger != null) {
            this.logger.log(8, string);
        } else if (this.jlogger != null) {
            this.jlogger.log(Level.INFO, string);
        }
    }
}

