/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.jms.admin.cli.CreateJMSDestination;
import org.glassfish.jms.admin.cli.JMSDestination;
import org.glassfish.jms.admin.cli.JMSDestinationInfo;
import org.glassfish.jms.admin.cli.MQJMXConnectorInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-jmsdest")
@Scoped(value=PerLookup.class)
@I18n(value="list.jms.dests")
public class ListJMSDestinations
extends JMSDestination
implements AdminCommand {
    static Logger logger = LogDomains.getLogger(ListJMSDestinations.class, (String)"javax.enterprise.system.tools.admin");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJMSDestination.class);
    @Param(name="destType", optional=true)
    String destType;
    @Param(name="property", optional=true, separator=58)
    Properties props;
    @Param(primary=true, optional=true)
    String target = "server";
    @Inject
    ConnectorRuntime connectorRuntime;
    @Inject
    Domain domain;
    @Inject
    Configs configs;
    @Inject
    ServerContext serverContext;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.destType != null && !this.destType.equals("queue") && !this.destType.equals("topic")) {
            report.setMessage(localStrings.getLocalString("admin.mbeans.rmb.invalid_jms_desttype", this.destType));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            List list = this.listJMSDestinations(this.target, this.destType);
            if (list.isEmpty()) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(localStrings.getLocalString("nothingToList", "Nothing to list."));
            } else {
                for (JMSDestinationInfo destInfo : list) {
                    ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                    part.setMessage(destInfo.getDestinationName());
                }
            }
        }
        catch (Exception e) {
            logger.throwing(this.getClass().getName(), "ListJMSDestination", e);
            e.printStackTrace();
            report.setMessage(localStrings.getLocalString("list.jms.dest.fail", "Unable to list JMS Destinations") + " " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listJMSDestinations(String tgtName, String destType) throws Exception {
        logger.log(Level.FINE, "listJMSDestination ...");
        MQJMXConnectorInfo mqInfo = this.getMQJMXConnectorInfo(this.target, this.configs, this.serverContext, this.domain, this.connectorRuntime);
        try {
            MBeanServerConnection mbsc = mqInfo.getMQMBeanServerConnection();
            ObjectName on = new ObjectName("com.sun.messaging.jms.server:type=DestinationManager,subtype=Config");
            String[] signature = null;
            Object[] params = null;
            ObjectName[] dests = (ObjectName[])mbsc.invoke(on, "getDestinations", params, signature);
            if (dests != null && dests.length > 0) {
                ArrayList<JMSDestinationInfo> jmsdi = new ArrayList<JMSDestinationInfo>();
                for (int i = 0; i < dests.length; ++i) {
                    on = dests[i];
                    String jdiType = this.toStringLabel(on.getKeyProperty("desttype"));
                    String jdiName = on.getKeyProperty("name");
                    if (jdiName != null && jdiName.length() > 1) {
                        if (jdiName.indexOf(34) == 0) {
                            jdiName = jdiName.substring(1);
                        }
                        if (jdiName.lastIndexOf(34) == jdiName.length() - 1) {
                            jdiName = jdiName.substring(0, jdiName.lastIndexOf(34));
                        }
                    }
                    JMSDestinationInfo jdi = new JMSDestinationInfo(jdiName, jdiType);
                    if (destType == null) {
                        jmsdi.add(jdi);
                        continue;
                    }
                    if (!destType.equals("topic") && !destType.equals("queue") || !jdiType.equalsIgnoreCase(destType)) continue;
                    jmsdi.add(jdi);
                }
                ArrayList<JMSDestinationInfo> arrayList = jmsdi;
                return arrayList;
            }
        }
        catch (Exception e) {
            this.logAndHandleException(e, "admin.mbeans.rmb.error_listing_jms_dest");
        }
        finally {
            try {
                if (mqInfo != null) {
                    mqInfo.closeMQMBeanServerConnection();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return null;
    }

    private String toStringLabel(String type) {
        if (type.equals("q")) {
            return "queue";
        }
        if (type.equals("t")) {
            return "topic";
        }
        return "unknown";
    }
}

