/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.jmsserver.GlobalProperties;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceRestriction;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.ServiceRestrictionException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.ServiceType;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.Principal;
import java.util.Hashtable;

public abstract class PacketHandler {
    private static boolean DEBUG = false;
    protected final Logger logger = Globals.getLogger();

    public static boolean getDEBUG() {
        return DEBUG;
    }

    public abstract boolean handle(IMQConnection var1, Packet var2) throws BrokerException;

    public void handleForbidden(IMQConnection iMQConnection, Packet packet, int n) throws BrokerException {
        Packet packet2 = new Packet(iMQConnection.useDirectBuffers());
        if (DEBUG) {
            this.logger.log(4, "handle forbidden: sending " + PacketType.getString((int)n));
        }
        packet2.setPacketType(n);
        packet2.setConsumerID(packet.getConsumerID());
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put("JMQStatus", new Integer(403));
        packet2.setProperties(hashtable);
        iMQConnection.sendControlMessage(packet2);
    }

    public static void checkPermission(Packet packet, IMQConnection iMQConnection) throws AccessControlException, IOException, ClassNotFoundException, BrokerException {
        int n = packet.getPacketType();
        String string = PacketType.mapOperation((int)n);
        if (string == null) {
            return;
        }
        Hashtable hashtable = packet.getProperties();
        String string2 = (String)hashtable.get("JMQDestination");
        if (string2 == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "checkPermission() no JMQDestionation"));
        }
        Integer n2 = (Integer)hashtable.get("JMQDestType");
        if (n2 == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "checkPermission() no JMQDestType"));
        }
        int n3 = n2;
        PacketHandler.checkPermission(n, string, string2, n3, iMQConnection);
    }

    public static void checkPermission(int n, String string, String string2, int n2, IMQConnection iMQConnection) throws AccessControlException, BrokerException {
        int n3;
        String string3 = DestType.queueOrTopic((int)n2);
        if (string3 == null) {
            return;
        }
        Service service = iMQConnection.getService();
        if (!PacketHandler.checkIsNonAdminDest(iMQConnection, service, n3 = service.getServiceType(), string2)) {
            return;
        }
        String string4 = string2;
        if (n == 34) {
            if (!PacketHandler.checkForAutoCreate(string2, n2)) {
                return;
            }
            DestinationUID destinationUID = DestinationUID.getUID(string2, DestType.isQueue((int)n2));
            if (destinationUID == null) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "checkPermission() can't get destination uid for " + string2));
            }
            Destination destination = Destination.getDestination(destinationUID);
            if (destination != null && !destination.isAutoCreated()) {
                return;
            }
            string4 = null;
        }
        PacketHandler.checkPermission(iMQConnection, service, n3, string, string4, string3, string2);
        Globals.getAuditSession().destinationAuth(iMQConnection.getUserName(), iMQConnection.remoteHostString(), string3, string4, string, true);
    }

    private static boolean checkForAutoCreate(String string, int n) {
        return !(DestType.isQueue((int)n) ? !GlobalProperties.getGlobalProperties().AUTOCREATE_QUEUE : DestType.isTopic((int)n) && !GlobalProperties.getGlobalProperties().AUTOCREATE_TOPIC);
    }

    private static boolean checkIsNonAdminDest(IMQConnection iMQConnection, Service service, int n, String string) throws AccessControlException, BrokerException {
        if (!string.equals("__JMQAdmin")) {
            if (n == 1 && iMQConnection.getAccessController().isRestrictedAdmin()) {
                String string2 = Globals.getBrokerResources().getKString("B4102", string, service.getName());
                Globals.getLogger().log(16, string2);
                throw new AccessControlException(string2);
            }
            if (!string.equals("__JMQBridgeAdmin")) {
                return true;
            }
        }
        if (n == 1) {
            return false;
        }
        String string3 = "";
        Principal principal = iMQConnection.getAccessController().getAuthenticatedName();
        if (principal != null) {
            string3 = principal.getName();
        }
        Object[] objectArray = new String[]{string3, service.getName(), ServiceType.getServiceTypeString((int)n)};
        String string4 = Globals.getBrokerResources().getKString("B4076", objectArray);
        Globals.getLogger().log(16, string4);
        throw new AccessControlException(string4);
    }

    private static void checkPermission(IMQConnection iMQConnection, Service service, int n, String string, String string2, String string3, String string4) throws AccessControlException {
        try {
            iMQConnection.getAccessController().checkDestinationPermission(service.getName(), ServiceType.getServiceTypeString((int)n), string, string2, string3);
        }
        catch (AccessControlException accessControlException) {
            if (string2 != null) {
                Object[] objectArray = new String[]{string, string3, string2};
                String string5 = Globals.getBrokerResources().getKString("B2041", objectArray);
                Globals.getLogger().log(16, string5 + " - " + accessControlException.getMessage(), (Throwable)accessControlException);
            } else {
                Object[] objectArray = new String[]{string, string3, string4};
                String string6 = Globals.getBrokerResources().getKString("B2042", objectArray);
                Globals.getLogger().log(16, string6 + " - " + accessControlException.getMessage(), (Throwable)accessControlException);
            }
            throw accessControlException;
        }
    }

    public void checkServiceRestriction(Packet packet, IMQConnection iMQConnection) throws BrokerException, IOException, ClassNotFoundException {
        Service service = iMQConnection.getService();
        ServiceRestriction[] serviceRestrictionArray = service.getServiceRestrictions();
        if (serviceRestrictionArray == null) {
            return;
        }
        ServiceRestriction serviceRestriction = null;
        for (int i = 0; i < serviceRestrictionArray.length; ++i) {
            serviceRestriction = serviceRestrictionArray[i];
            if (serviceRestriction == ServiceRestriction.NO_SYNC_WITH_MASTERBROKER) {
                if (service.getServiceType() != 0) {
                    return;
                }
                int n = packet.getPacketType();
                if (n != 34 && n != 14 && n != 18) {
                    return;
                }
                Hashtable hashtable = packet.getProperties();
                String string = (String)hashtable.get("JMQDestination");
                int n2 = (Integer)hashtable.get("JMQDestType");
                if (n == 34) {
                    if (!PacketHandler.checkForAutoCreate(string, n2)) {
                        return;
                    }
                    DestinationUID destinationUID = DestinationUID.getUID(string, DestType.isQueue((int)n2));
                    Destination destination = Destination.getDestination(destinationUID);
                    if (destination != null) {
                        return;
                    }
                    if (DestType.isQueue((int)n2) && DestType.isTemporary((int)n2)) {
                        return;
                    }
                    Object[] objectArray = new String[]{Thread.currentThread().getName(), string, service.toString(), serviceRestriction.toString(true)};
                    String string2 = Globals.getBrokerResources().getKString("B4286", objectArray);
                    this.logger.log(16, string2);
                    if (this.waitForMasterBrokerSync(iMQConnection)) {
                        throw new ServiceRestrictionException(string2, 503);
                    }
                    return;
                }
                if (!DestType.isTopic((int)n2)) continue;
                if (n == 18) {
                    Object[] objectArray = new String[]{Thread.currentThread().getName(), string, service.toString(), serviceRestriction.toString(true)};
                    String string3 = Globals.getBrokerResources().getKString("B4287", objectArray);
                    this.logger.log(16, string3);
                    if (this.waitForMasterBrokerSync(iMQConnection)) {
                        throw new ServiceRestrictionException(string3, 503);
                    }
                    return;
                }
                Object[] objectArray = new String[]{Thread.currentThread().getName(), string, service.toString(), serviceRestriction.toString(true)};
                String string4 = Globals.getBrokerResources().getKString("B4288", objectArray);
                this.logger.log(16, string4);
                if (this.waitForMasterBrokerSync(iMQConnection)) {
                    throw new ServiceRestrictionException(string4, 503);
                }
                return;
            }
            throw new BrokerException(Globals.getBrokerResources().getString("B3100", "Unknown service restriction " + serviceRestriction + " on service " + service));
        }
    }

    private boolean waitForMasterBrokerSync(IMQConnection iMQConnection) {
        int n = 90;
        long l = (long)Globals.getConfig().getIntProperty("imq.cluster.nowaitForMasterBrokerTimeoutInSeconds", n) * 1000L;
        if (l == 0L) {
            return true;
        }
        long l2 = 5000L;
        long l3 = l < 0L || l > l2 ? l2 : l;
        long l4 = System.currentTimeMillis();
        long l5 = 0L;
        long l6 = 0L;
        Service service = iMQConnection.getService();
        ServiceRestriction[] serviceRestrictionArray = service.getServiceRestrictions();
        ServiceRestriction serviceRestriction = null;
        do {
            if ((serviceRestrictionArray = service.getServiceRestrictions()) == null) {
                return false;
            }
            boolean bl = false;
            for (int i = 0; i < serviceRestrictionArray.length; ++i) {
                serviceRestriction = serviceRestrictionArray[i];
                if (serviceRestriction != ServiceRestriction.NO_SYNC_WITH_MASTERBROKER) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
            if (iMQConnection.getConnectionState() >= 6) {
                return true;
            }
            if (l4 - l5 > 6L * l2) {
                this.logger.log(8, Globals.getBrokerResources().getKString("B1349", Thread.currentThread().getName(), "" + l3 / 1000L + "[" + l / 1000L + "]"));
                l5 = l4;
            }
            try {
                Thread.currentThread();
                Thread.sleep(l3);
            }
            catch (InterruptedException interruptedException) {
                this.logger.log(8, Globals.getBrokerResources().getKString("B1350", Thread.currentThread().getName()));
                return true;
            }
            l4 = System.currentTimeMillis();
            long l7 = l3 = l < 0L ? l2 : l - (l6 += l3);
            if (l3 <= l2) continue;
            l3 = l2;
        } while (l3 > 0L);
        return true;
    }
}

