/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.jmsspi;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.ConnectionFactory;
import com.sun.messaging.QueueConnectionFactory;
import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.admin.util.JMSObjFactory;
import com.sun.messaging.jmq.jmsclient.JMSXAQueueConnectionFactoryImpl;
import com.sun.messaging.jmq.jmsclient.JMSXATopicConnectionFactoryImpl;
import com.sun.messaging.jmq.jmsclient.JMSXAWrappedConnectionFactoryImpl;
import com.sun.messaging.jmq.jmsselector.InvalidJMSSelectorException;
import com.sun.messaging.jmq.jmsselector.JMSSelector;
import com.sun.messaging.jmq.jmsspi.JMSAdmin;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;

public class JMSAdminImpl
implements JMSAdmin,
ExceptionListener {
    private static AdminResources ar = Globals.getAdminResources();
    public static final long DEFAULT_TIMEOUT = 5000L;
    private String adminuserName = null;
    private String adminPassword = null;
    private String fallbackDBPassword = null;
    private String hadbPassword = null;
    private String mysqlPassword = null;
    private String keystorePassword = null;
    private String ldapPassword = null;
    String bridgeAdminPassword = null;
    private long timeout = 5000L;
    private QueueConnectionFactory qcf;
    private QueueConnection connection;
    private QueueSession session;
    private Queue requestQueue;
    private TemporaryQueue replyQueue;
    private QueueSender sender;
    protected QueueReceiver receiver;
    private AdministeredObject tmpDestination = null;
    private AdministeredObject tmpConnFactory = null;
    private boolean secureTransportUsed = false;
    protected static final transient String loggerName = "javax.resourceadapter.mqjmsra.lifecycle";
    protected static final transient Logger logger = Logger.getLogger("javax.resourceadapter.mqjmsra.lifecycle");

    protected JMSAdminImpl(Properties properties, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws JMSException {
        this.adminuserName = string;
        this.adminPassword = string2;
        this.fallbackDBPassword = string3;
        this.hadbPassword = string4;
        this.mysqlPassword = string5;
        this.keystorePassword = string6;
        this.ldapPassword = string7;
        this.bridgeAdminPassword = string8;
        this.createFactory(properties);
        String string9 = properties.getProperty("imqConnectionType", "");
        if (string9.equals("TLS") || string9.equals("SSL")) {
            this.secureTransportUsed = true;
        }
    }

    public String getVersion() {
        Version version = new Version();
        return version.getJMSAdminSpiVersion();
    }

    public Object createConnectionFactoryObject(int n, Map map) throws JMSException {
        Object object = null;
        Properties properties = this.getProperties(map);
        this.fillDefaultConnectionFactoryProperties(properties);
        if (n == 1) {
            object = JMSObjFactory.createTopicConnectionFactory(properties);
        } else if (n == 0) {
            object = JMSObjFactory.createQueueConnectionFactory(properties);
        } else {
            throw new JMSException(ar.getKString("A4015"));
        }
        return object;
    }

    public Object createXAConnectionFactoryObject(int n, Map map) throws JMSException {
        ConnectionFactory connectionFactory = null;
        Properties properties = this.getProperties(map);
        this.fillDefaultConnectionFactoryProperties(properties);
        if (n == 1) {
            connectionFactory = new JMSXATopicConnectionFactoryImpl();
            JMSAdminImpl.setProperties(connectionFactory, properties);
        } else if (n == 0) {
            connectionFactory = new JMSXAQueueConnectionFactoryImpl();
            JMSAdminImpl.setProperties(connectionFactory, properties);
        } else {
            throw new JMSException(ar.getKString("A4015"));
        }
        return connectionFactory;
    }

    public Object createDestinationObject(String string, int n, Map map) throws JMSException {
        Map map2 = map;
        if (map2 == null) {
            map2 = new Properties();
        }
        map2.put("imqDestinationName", string);
        return this.createDestinationObject(n, map2);
    }

    public Object createDestinationObject(int n, Map map) throws JMSException {
        if (map == null || map.get("imqDestinationName") == null) {
            throw new JMSException(ar.getKString("A4017"));
        }
        Object object = null;
        Properties properties = this.getProperties(map);
        if (n == 1) {
            object = JMSObjFactory.createTopic(properties);
        } else if (n == 0) {
            object = JMSObjFactory.createQueue(properties);
        } else {
            throw new JMSException(ar.getKString("A4015"));
        }
        return object;
    }

    public Object wrapJMSConnectionFactoryObject(Object object) throws JMSException {
        if (object instanceof XAQueueConnectionFactory) {
            return new JMSXAWrappedConnectionFactoryImpl((XAQueueConnectionFactory)object);
        }
        if (object instanceof XATopicConnectionFactory) {
            return new JMSXAWrappedConnectionFactoryImpl((XATopicConnectionFactory)object);
        }
        if (object instanceof javax.jms.QueueConnectionFactory) {
            return new JMSXAWrappedConnectionFactoryImpl((javax.jms.QueueConnectionFactory)object);
        }
        if (object instanceof TopicConnectionFactory) {
            return new JMSXAWrappedConnectionFactoryImpl((TopicConnectionFactory)object);
        }
        throw new JMSException(ar.getKString("A4016"));
    }

    public void validateJMSSelector(String string) throws JMSException {
        JMSSelector jMSSelector = new JMSSelector();
        try {
            jMSSelector.validateSelectorPattern(string);
        }
        catch (InvalidJMSSelectorException invalidJMSSelectorException) {
            throw new InvalidSelectorException(invalidJMSSelectorException.getMessage());
        }
        catch (Exception exception) {
            throw new JMSException(exception.getMessage());
        }
    }

    public String clientIDPropertyName() {
        return "imqConfiguredClientID";
    }

    public Map getAllDestinationObjectProperties(int n) throws JMSException {
        if (this.tmpDestination == null) {
            this.tmpDestination = (AdministeredObject)JMSObjFactory.createTopic(new Properties());
        }
        Properties properties = new Properties();
        Enumeration enumeration = this.tmpDestination.enumeratePropertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.tmpDestination.getPropertyLabel(string);
            properties.setProperty(string, string2);
        }
        return properties;
    }

    public Map getDisplayedDestinationObjectProperties(int n) throws JMSException {
        if (this.tmpDestination == null) {
            this.tmpDestination = (AdministeredObject)JMSObjFactory.createTopic(new Properties());
        }
        Properties properties = new Properties();
        String string = "imqDestinationName";
        String string2 = this.tmpDestination.getPropertyLabel(string);
        properties.setProperty(string, string2);
        return properties;
    }

    public Map getAllConnectionFactoryObjectProperies(int n) throws JMSException {
        if (this.tmpConnFactory == null) {
            this.tmpConnFactory = (AdministeredObject)JMSObjFactory.createTopicConnectionFactory(new Properties());
        }
        Properties properties = new Properties();
        Enumeration enumeration = this.tmpConnFactory.enumeratePropertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.tmpConnFactory.getPropertyLabel(string);
            properties.setProperty(string, string2);
        }
        return properties;
    }

    public Map getDisplayedConnectionFactoryObjectProperies(int n) throws JMSException {
        if (this.tmpConnFactory == null) {
            this.tmpConnFactory = (AdministeredObject)JMSObjFactory.createTopicConnectionFactory(new Properties());
        }
        Properties properties = new Properties();
        String string = "imqBrokerHostName";
        String string2 = this.tmpConnFactory.getPropertyLabel(string);
        properties.setProperty(string, string2);
        string = "imqBrokerHostPort";
        string2 = this.tmpConnFactory.getPropertyLabel(string);
        properties.setProperty(string, string2);
        string = "imqConfiguredClientID";
        string2 = this.tmpConnFactory.getPropertyLabel(string);
        properties.setProperty(string, string2);
        return properties;
    }

    public void connectToProvider() throws JMSException {
        this.connection = this.qcf.createQueueConnection(this.adminuserName, this.adminPassword);
        this.connection.setExceptionListener((ExceptionListener)this);
        this.connection.start();
        this.session = this.connection.createQueueSession(false, 2);
        this.requestQueue = this.session.createQueue("__JMQAdmin");
        this.replyQueue = this.session.createTemporaryQueue();
        this.sender = this.session.createSender(this.requestQueue);
        this.sender.setDeliveryMode(1);
        this.receiver = this.session.createReceiver((Queue)this.replyQueue);
        this.hello();
    }

    public void disconnectFromProvider() throws JMSException {
        block2: {
            this.sender.close();
            this.receiver.close();
            this.session.close();
            try {
                this.connection.close();
            }
            catch (JMSException jMSException) {
                if (this.secureTransportUsed) break block2;
                throw jMSException;
            }
        }
    }

    public void createProviderDestination(String string, int n, Map map) throws JMSException {
        ObjectMessage objectMessage = null;
        Message message = null;
        DestinationInfo destinationInfo = new DestinationInfo();
        destinationInfo.setName(string);
        String string2 = null;
        int n2 = JMSAdminImpl.getDestTypeMask(n, null);
        if (map != null) {
            if (map.containsKey("queueDeliveryPolicy")) {
                string2 = (String)map.get("queueDeliveryPolicy");
                n2 = JMSAdminImpl.getDestTypeMask(n, string2);
            }
            if (map.containsKey("maxNumActiveConsumers")) {
                Object var9_9 = null;
                String string3 = null;
                var9_9 = map.get("maxNumActiveConsumers");
                if (var9_9 != null) {
                    if (!(var9_9 instanceof String)) {
                        JMSException jMSException = new JMSException(ar.getString("A3163", DestType.toString(n2), string) + "\n" + ar.getString("A3164", "maxNumActiveConsumers"));
                        throw jMSException;
                    }
                    string3 = var9_9;
                    try {
                        destinationInfo.setMaxActiveConsumers(Integer.parseInt(string3));
                    }
                    catch (Exception exception) {
                        JMSException jMSException = new JMSException(ar.getString("A3163", DestType.toString(n2), string) + "\n" + ar.getString("A3107", string3, "maxNumActiveConsumers"));
                        throw jMSException;
                    }
                }
            }
        }
        destinationInfo.setType(n2);
        objectMessage = this.session.createObjectMessage();
        objectMessage.setJMSReplyTo((Destination)this.replyQueue);
        objectMessage.setIntProperty("JMQMessageType", 10);
        objectMessage.setObject((Serializable)destinationInfo);
        this.sender.send((Message)objectMessage);
        message = this.receiver.receive(this.timeout);
        message.acknowledge();
        this.checkReplyTypeStatus(message, 11, "CREATE_DESTINATION_REPLY");
    }

    public void deleteProviderDestination(String string, int n) throws JMSException {
        ObjectMessage objectMessage = null;
        Message message = null;
        objectMessage = this.session.createObjectMessage();
        objectMessage.setJMSReplyTo((Destination)this.replyQueue);
        objectMessage.setIntProperty("JMQMessageType", 12);
        objectMessage.setStringProperty("JMQDestination", string);
        objectMessage.setIntProperty("JMQDestType", JMSAdminImpl.getDestTypeMask(n, null));
        this.sender.send((Message)objectMessage);
        message = this.receiver.receive(this.timeout);
        message.acknowledge();
        this.checkReplyTypeStatus(message, 13, "DESTROY_DESTINATION_REPLY");
    }

    public String[][] getProviderDestinations() throws JMSException {
        ObjectMessage objectMessage = null;
        objectMessage = this.session.createObjectMessage();
        objectMessage.setJMSReplyTo((Destination)this.replyQueue);
        objectMessage.setIntProperty("JMQMessageType", 20);
        this.sender.send((Message)objectMessage);
        objectMessage = (ObjectMessage)this.receiver.receive(this.timeout);
        objectMessage.acknowledge();
        this.checkReplyTypeStatus((Message)objectMessage, 21, "GET_DESTINATIONS_REPLY");
        Serializable serializable = objectMessage.getObject();
        if (serializable != null && serializable instanceof Vector) {
            String[][] stringArray;
            int n;
            Vector vector = (Vector)serializable;
            Vector<String[][]> vector2 = new Vector<String[][]>();
            for (n = 0; n < vector.size(); ++n) {
                stringArray = (String[][])vector.elementAt(n);
                if ("__JMQAdmin".equals(stringArray.name) || "__JMQBridgeAdmin".equals(stringArray.name) || DestType.isInternal(stringArray.fulltype) || DestType.isTemporary(stringArray.type)) continue;
                vector2.add(stringArray);
            }
            n = vector2.size();
            stringArray = new String[2][n];
            for (int i = 0; i < n; ++i) {
                DestinationInfo destinationInfo = (DestinationInfo)vector2.get(i);
                stringArray[0][i] = destinationInfo.name;
                stringArray[1][i] = JMSAdminImpl.getDestinationType(destinationInfo.type);
            }
            return stringArray;
        }
        return null;
    }

    public void startProvider(String string, String[] stringArray, String string2) throws IOException, JMSException {
        String string3;
        String string4 = null;
        if (File.separator.equals("\\")) {
            string3 = string + File.separator + "imqbrokersvc.exe";
            string4 = "-console";
        } else {
            string3 = string + File.separator + "imqbrokerd";
        }
        String string5 = this.qcf.getProperty("imqBrokerHostPort");
        Vector<String> vector = new Vector<String>();
        vector.add(string3);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(stringArray[i]);
            }
        }
        if (string2 != null) {
            vector.add("-name");
            vector.add(string2);
        }
        if (string4 != null) {
            vector.add(string4);
        }
        vector.add("-port");
        vector.add(string5);
        vector.add("-silent");
        vector.add("-managed");
        vector.add("-read-stdin");
        String[] stringArray2 = vector.toArray(new String[0]);
        if (logger.isLoggable(Level.FINE)) {
            String string6 = "";
            for (int i = 0; i < stringArray2.length; ++i) {
                string6 = string6 + stringArray2[i] + " ";
            }
            logger.fine("MQJMSRA: Starting LOCAL broker with command line: " + string6);
        }
        this.launchAndWatch(stringArray2);
    }

    private void launchAndWatch(String[] stringArray) throws IOException {
        Process process = Runtime.getRuntime().exec(stringArray);
        BrokerWatcher brokerWatcher = new BrokerWatcher(process, stringArray);
        brokerWatcher.start();
        boolean bl = true;
        StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream(), bl, "Local broker: ");
        streamGobbler.start();
        bl = false;
        StreamGobbler streamGobbler2 = new StreamGobbler(process.getInputStream(), bl, "Local broker: ");
        streamGobbler2.start();
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(process.getOutputStream());
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            if (this.adminPassword != null) {
                bufferedWriter.write("imq.imqcmd.password=" + this.adminPassword);
                bufferedWriter.newLine();
            }
            if (this.fallbackDBPassword != null) {
                bufferedWriter.write("imq.persist.jdbc.password=" + this.fallbackDBPassword);
                bufferedWriter.newLine();
            }
            if (this.hadbPassword != null) {
                bufferedWriter.write("imq.persist.jdbc.hadb.password=" + this.hadbPassword);
                bufferedWriter.newLine();
            }
            if (this.mysqlPassword != null) {
                bufferedWriter.write("imq.persist.jdbc.mysql.password=" + this.mysqlPassword);
                bufferedWriter.newLine();
            }
            if (this.keystorePassword != null) {
                bufferedWriter.write("imq.keystore.password=" + this.keystorePassword);
                bufferedWriter.newLine();
            }
            if (this.ldapPassword != null) {
                bufferedWriter.write("imq.user_repository.ldap.password=" + this.ldapPassword);
                bufferedWriter.newLine();
            }
            if (this.bridgeAdminPassword != null) {
                bufferedWriter.write("imq.bridge.admin.password=" + this.bridgeAdminPassword);
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void pingProvider() throws JMSException {
        block2: {
            QueueConnection queueConnection = this.qcf.createQueueConnection(this.adminuserName, this.adminPassword);
            queueConnection.setExceptionListener((ExceptionListener)this);
            queueConnection.start();
            try {
                queueConnection.close();
            }
            catch (JMSException jMSException) {
                if (this.secureTransportUsed) break block2;
                throw jMSException;
            }
        }
    }

    public void pingProvider(String string, String string2, int n) throws JMSException {
        block3: {
            Properties properties = this.qcf.getConfiguration();
            QueueConnectionFactory queueConnectionFactory = new QueueConnectionFactory();
            queueConnectionFactory.setConnectionType("ADMIN");
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                String string4 = properties.getProperty(string3);
                if (string4 == null) continue;
                queueConnectionFactory.setProperty(string3, string4);
            }
            queueConnectionFactory.setProperty("imqBrokerHostPort", String.valueOf(n));
            QueueConnection queueConnection = queueConnectionFactory.createQueueConnection(string, string2);
            queueConnection.setExceptionListener((ExceptionListener)this);
            queueConnection.start();
            try {
                queueConnection.close();
            }
            catch (JMSException jMSException) {
                if (this.secureTransportUsed) break block3;
                throw jMSException;
            }
        }
    }

    private String getProviderPropertyValue(String string) throws JMSException {
        ObjectMessage objectMessage = null;
        ObjectMessage objectMessage2 = null;
        String string2 = null;
        objectMessage = this.session.createObjectMessage();
        objectMessage.setJMSReplyTo((Destination)this.replyQueue);
        objectMessage.setIntProperty("JMQMessageType", 54);
        this.sender.send((Message)objectMessage);
        objectMessage2 = (ObjectMessage)this.receiver.receive(this.timeout);
        objectMessage2.acknowledge();
        this.checkReplyTypeStatus((Message)objectMessage2, 55, "GET_BROKER_PROPS_REPLY");
        Serializable serializable = objectMessage2.getObject();
        if (serializable != null && serializable instanceof Properties) {
            Properties properties = (Properties)serializable;
            string2 = properties.getProperty(string);
        }
        return string2;
    }

    public String getProviderInstanceName() throws JMSException {
        return this.getProviderPropertyValue("imq.instancename");
    }

    public String getProviderVarHome() throws JMSException {
        return this.getProviderPropertyValue("imq.varhome");
    }

    public void shutdownProvider() throws JMSException {
        try {
            this.tryToShutdownProvider();
        }
        catch (JMSException jMSException) {
            if ("C4063".equals(jMSException.getErrorCode()) | "C4059".equals(jMSException.getErrorCode())) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.connectToProvider();
                this.tryToShutdownProvider();
            }
            throw jMSException;
        }
    }

    private void tryToShutdownProvider() throws JMSException {
        ObjectMessage objectMessage = this.session.createObjectMessage();
        objectMessage.setJMSReplyTo((Destination)this.replyQueue);
        objectMessage.setIntProperty("JMQMessageType", 38);
        this.sender.send((Message)objectMessage);
        Message message = this.receiver.receive(this.timeout);
        this.checkReplyTypeStatus(message, 39, "SHUTDOWN_REPLY");
    }

    public void restartProvider() throws JMSException {
        ObjectMessage objectMessage = null;
        Message message = null;
        objectMessage = this.session.createObjectMessage();
        objectMessage.setJMSReplyTo((Destination)this.replyQueue);
        objectMessage.setIntProperty("JMQMessageType", 38);
        objectMessage.setBooleanProperty("JMQRestart", true);
        this.sender.send((Message)objectMessage);
        message = this.receiver.receive(this.timeout);
        this.checkReplyTypeStatus(message, 39, "SHUTDOWN_REPLY");
    }

    public String getProviderHostName() throws JMSException {
        return this.qcf.getProperty("imqBrokerHostName");
    }

    public String getProviderHostPort() throws JMSException {
        return this.qcf.getProperty("imqBrokerHostPort");
    }

    public void deleteProviderInstance(String string, String string2, String string3) throws IOException, JMSException {
        int n = 0;
        boolean bl = false;
        String string4 = File.separator.equals("\\") ? string + File.separator + "imqbrokerd.exe" : string + File.separator + "imqbrokerd";
        String string5 = this.qcf.getProperty("imqBrokerHostPort");
        String string6 = string4;
        if (string2 != null) {
            string6 = string6 + " " + string2;
        }
        if (string3 != null) {
            string6 = string6 + " -name " + string3;
        }
        string6 = string6 + " -remove instance -silent -force";
        Process process = Runtime.getRuntime().exec(string6);
        process.getInputStream().close();
        process.getErrorStream().close();
        try {
            process.waitFor();
            n = process.exitValue();
        }
        catch (InterruptedException interruptedException) {
            bl = true;
        }
        if (bl) {
            throw new JMSException(ar.getKString("A4018", string3));
        }
        switch (n) {
            case 0: {
                break;
            }
            case 10: {
                throw new JMSException(ar.getKString("A4019", string3));
            }
            case 11: {
                throw new JMSException(ar.getKString("A4020", string3));
            }
            case 12: {
                throw new JMSException(ar.getKString("A4021", string3));
            }
            case 13: {
                throw new JMSException(ar.getKString("A4022", string3));
            }
            case 14: {
                throw new JMSException(ar.getKString("A4023", string3));
            }
            default: {
                throw new JMSException(ar.getKString("A4024", string3));
            }
        }
    }

    public void deleteProviderInstance(String string, String[] stringArray, String string2) throws IOException, JMSException {
        int n = 0;
        boolean bl = false;
        String string3 = File.separator.equals("\\") ? string + File.separator + "imqbrokerd.exe" : string + File.separator + "imqbrokerd";
        String string4 = this.qcf.getProperty("imqBrokerHostPort");
        Vector<String> vector = new Vector<String>();
        vector.add(string3);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(stringArray[i]);
            }
        }
        if (string2 != null) {
            vector.add("-name");
            vector.add(string2);
        }
        vector.add("-remove");
        vector.add("instance");
        vector.add("-silent");
        vector.add("-force");
        String[] stringArray2 = vector.toArray(new String[0]);
        Process process = Runtime.getRuntime().exec(stringArray2);
        process.getInputStream().close();
        process.getErrorStream().close();
        try {
            process.waitFor();
            n = process.exitValue();
        }
        catch (InterruptedException interruptedException) {
            bl = true;
        }
        if (bl) {
            throw new JMSException(ar.getKString("A4018", string2));
        }
        switch (n) {
            case 0: {
                break;
            }
            case 10: {
                throw new JMSException(ar.getKString("A4019", string2));
            }
            case 11: {
                throw new JMSException(ar.getKString("A4020", string2));
            }
            case 12: {
                throw new JMSException(ar.getKString("A4021", string2));
            }
            case 13: {
                throw new JMSException(ar.getKString("A4022", string2));
            }
            case 14: {
                throw new JMSException(ar.getKString("A4023", string2));
            }
            default: {
                throw new JMSException(ar.getKString("A4024", string2));
            }
        }
    }

    private void hello() throws JMSException {
        ObjectMessage objectMessage = null;
        Message message = null;
        objectMessage = this.session.createObjectMessage();
        objectMessage.setJMSReplyTo((Destination)this.replyQueue);
        objectMessage.setIntProperty("JMQMessageType", 28);
        this.sender.send((Message)objectMessage);
        message = this.receiver.receive(this.timeout);
        message.acknowledge();
        this.checkReplyTypeStatus(message, 29, "HELLO_REPLY");
    }

    private Properties getProperties(Map map) {
        Properties properties = null;
        if (map == null) {
            properties = new Properties();
        } else if (map instanceof Properties) {
            properties = (Properties)map;
        } else {
            properties = new Properties();
            for (Map.Entry entry : map.entrySet()) {
                properties.put(entry.getKey(), entry.getValue());
            }
        }
        return properties;
    }

    private static void setProperties(AdministeredObject administeredObject, Properties properties) throws JMSException {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string2 == null) continue;
            administeredObject.setProperty(string, string2);
        }
    }

    private void createFactory(Properties properties) throws JMSException {
        this.qcf = new QueueConnectionFactory();
        this.qcf.setConnectionType("ADMIN");
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string2 == null) continue;
            this.qcf.setProperty(string, string2);
        }
    }

    private void fillDefaultConnectionFactoryProperties(Properties properties) throws JMSException {
        String string;
        if (properties.getProperty("imqBrokerHostName") == null && (string = this.qcf.getProperty("imqBrokerHostName")) != null) {
            properties.setProperty("imqBrokerHostName", string);
        }
        if (properties.getProperty("imqBrokerHostPort") == null && (string = this.qcf.getProperty("imqBrokerHostPort")) != null) {
            properties.setProperty("imqBrokerHostPort", string);
        }
    }

    private static int getDestTypeMask(int n, String string) {
        int n2 = -1;
        if (n == 1) {
            n2 = 2;
        } else if (n == 0) {
            n2 = 1;
        }
        if (string == null) {
            return n2;
        }
        if (n == 0) {
            if (string.equals("s")) {
                n2 |= 0x100;
            } else if (string.equals("f")) {
                n2 |= 0x400;
            } else if (string.equals("r")) {
                n2 |= 0x200;
            }
        }
        return n2;
    }

    private static String getDestinationType(int n) {
        if (DestType.isTopic(n)) {
            return String.valueOf(1);
        }
        if (DestType.isQueue(n)) {
            return String.valueOf(0);
        }
        return String.valueOf(-1);
    }

    private void checkReplyTypeStatus(Message message, int n, String string) throws JMSException {
        int n2 = -1;
        int n3 = -1;
        if (message == null && n == 39) {
            return;
        }
        n2 = message.getIntProperty("JMQMessageType");
        n3 = message.getIntProperty("JMQStatus");
        if (n == n2 && n3 == 200) {
            return;
        }
        String string2 = null;
        try {
            string2 = message.getStringProperty("JMQErrorString");
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new JMSException(string2);
    }

    public void onException(JMSException jMSException) {
    }

    class StreamGobbler
    extends Thread {
        InputStream is;
        boolean isError;
        String prefix;

        StreamGobbler(InputStream inputStream, boolean bl, String string) {
            this.is = inputStream;
            this.isError = bl;
            this.prefix = string;
        }

        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.is);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = null;
                String string2 = this.prefix;
                int n = 0;
                while ((string = bufferedReader.readLine()) != null) {
                    if (++n > 1) {
                        string2 = string2 + "\n";
                    }
                    string2 = string2 + string;
                }
                if (n > 0) {
                    if (this.isError) {
                        logger.warning(string2);
                    } else {
                        logger.info(string2);
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    class BrokerWatcher
    extends Thread {
        Process p;
        String[] cmdLine;

        BrokerWatcher(Process process, String[] stringArray) {
            this.p = process;
            this.cmdLine = stringArray;
        }

        public void run() {
            logger.fine("BrokerWatcher started");
            try {
                int n = this.p.waitFor();
                logger.fine("BrokerWatcher: Broker returned with status" + n);
                if (n == 255) {
                    JMSAdminImpl.this.launchAndWatch(this.cmdLine);
                    logger.fine("BrokerWatcher terminating after restarting broker");
                }
                logger.fine("BrokerWatcher terminating after normal exit");
            }
            catch (InterruptedException interruptedException) {
                logger.warning("InterruptedException watching broker: " + interruptedException.getMessage());
            }
            catch (IOException iOException) {
                logger.warning("Error restarting broker: " + iOException.getMessage());
            }
        }
    }
}

