/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class GetDestinationsHandler
extends AdminCmdHandler {
    private static boolean DEBUG = GetDestinationsHandler.getDEBUG();

    public GetDestinationsHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        Object object;
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + "Getting destinations: " + hashtable);
        }
        Vector<DestinationInfo> vector = new Vector<DestinationInfo>();
        int n = 200;
        String string = null;
        String string2 = (String)hashtable.get("JMQDestination");
        Integer n2 = (Integer)hashtable.get("JMQDestType");
        assert (string2 == null || n2 != null);
        if (string2 != null) {
            try {
                object = Destination.getDestination(string2, DestType.isQueue((int)n2));
                if (object != null) {
                    if (DEBUG) {
                        ((Destination)object).debug();
                    }
                    vector.add(GetDestinationsHandler.getDestinationInfo((Destination)object));
                }
                string = this.rb.getString("B4017", string2);
                n = 404;
            }
            catch (Exception exception) {
                this.logger.log(32, "Internal Error ", (Throwable)exception);
                assert (false);
            }
        } else {
            object = Destination.getAllDestinations();
            while (object.hasNext()) {
                Destination destination = (Destination)object.next();
                DestinationInfo destinationInfo = GetDestinationsHandler.getDestinationInfo(destination);
                vector.add(destinationInfo);
            }
        }
        object = new Packet(iMQConnection.useDirectBuffers());
        object.setPacketType(5);
        GetDestinationsHandler.setProperties((Packet)object, 21, n, string);
        this.setBodyObject((Packet)object, vector);
        this.parent.sendReply(iMQConnection, packet, (Packet)object);
        return true;
    }

    public static DestinationInfo getDestinationInfo(Destination destination) {
        SizeString sizeString;
        DestinationInfo destinationInfo = new DestinationInfo();
        destinationInfo.nMessages = destination.size();
        destinationInfo.nMessageBytes = destination.byteSize();
        destinationInfo.nConsumers = destination.getConsumerCount();
        destinationInfo.nfConsumers = destination.getFailoverConsumerCount();
        destinationInfo.naConsumers = destination.getActiveConsumerCount();
        destinationInfo.nProducers = destination.getProducerCount();
        destinationInfo.autocreated = destination.isAutoCreated() || destination.isInternal() || destination.isDMQ() || destination.isAdmin();
        destinationInfo.destState = destination.getState();
        destinationInfo.name = destination.getDestinationName();
        destinationInfo.type = destination.getType() & 0xFFFFFF1F;
        destinationInfo.fulltype = destination.getType();
        destinationInfo.maxMessages = destination.getCapacity();
        if (destinationInfo.maxMessages < 0) {
            destinationInfo.maxMessages = 0;
        }
        long l = destinationInfo.maxMessageBytes = (sizeString = destination.getByteCapacity()) == null ? 0L : sizeString.getBytes();
        if (destinationInfo.maxMessageBytes < 0L) {
            destinationInfo.maxMessageBytes = 0L;
        }
        long l2 = destinationInfo.maxMessageSize = (sizeString = destination.getMaxByteSize()) == null ? 0L : sizeString.getBytes();
        if (destinationInfo.maxMessageSize < 0L) {
            destinationInfo.maxMessageSize = 0L;
        }
        destinationInfo.destScope = destination.getScope();
        destinationInfo.destLimitBehavior = destination.getLimitBehavior();
        destinationInfo.maxPrefetch = destination.getMaxPrefetch();
        destinationInfo.destCDP = destination.getClusterDeliveryPolicy();
        destinationInfo.maxActiveConsumers = destination.getMaxActiveConsumers();
        destinationInfo.maxFailoverConsumers = destination.getMaxFailoverConsumers();
        destinationInfo.maxProducers = destination.getMaxProducers();
        destinationInfo.maxNumSharedConsumers = destination.getMaxNumSharedConsumers();
        destinationInfo.sharedConsumerFlowLimit = destination.getSharedConsumerFlowLimit();
        destinationInfo.useDMQ = destination.getUseDMQ();
        destinationInfo.nUnackMessages = destination.getUnackSize();
        destinationInfo.nTxnMessages = destination.txnSize();
        destinationInfo.nTxnMessageBytes = destination.txnByteSize();
        destinationInfo.validateXMLSchemaEnabled = destination.validateXMLSchemaEnabled();
        destinationInfo.XMLSchemaUriList = destination.getXMLSchemaUriList();
        destinationInfo.reloadXMLSchemaOnFailure = destination.reloadXMLSchemaOnFailure();
        destinationInfo.nRemoteMessages = destination.getRemoteSize();
        destinationInfo.nRemoteMessageBytes = destination.getRemoteBytes();
        if (!destination.isQueue()) {
            Integer n;
            Integer n2;
            String string;
            DestinationUID destinationUID;
            Object object;
            Iterator iterator;
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            if (destinationInfo.nConsumers > 0) {
                iterator = destination.getConsumers();
                while (iterator.hasNext()) {
                    object = (Consumer)iterator.next();
                    if (!((Consumer)object).isWildcard()) continue;
                    destinationUID = ((Consumer)object).getDestinationUID();
                    string = destinationUID.getName();
                    n2 = (Integer)hashtable.get(string);
                    n = n2 == null ? new Integer(1) : new Integer(n2 + 1);
                    hashtable.put(string, n);
                }
            }
            if (hashtable.size() > 0) {
                destinationInfo.consumerWildcards = hashtable;
            }
            hashtable = new Hashtable();
            if (destinationInfo.nProducers > 0) {
                iterator = destination.getProducers();
                while (iterator.hasNext()) {
                    object = (Producer)iterator.next();
                    if (!((Producer)object).isWildcard()) continue;
                    destinationUID = ((Producer)object).getDestinationUID();
                    string = destinationUID.getName();
                    n2 = (Integer)hashtable.get(string);
                    n = n2 == null ? new Integer(1) : new Integer(n2 + 1);
                    hashtable.put(string, n);
                }
            }
            if (hashtable.size() > 0) {
                destinationInfo.producerWildcards = hashtable;
            }
        }
        return destinationInfo;
    }
}

