/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.inmemory;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class PropertiesStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private ConcurrentHashMap propMap = new ConcurrentHashMap(64);
    private File backingFile = null;

    PropertiesStore() {
    }

    void updateProperty(String string, Object object) throws BrokerException {
        try {
            boolean bl = false;
            if (object == null) {
                Object v = this.propMap.remove(string);
                bl = v != null;
            } else {
                this.propMap.put(string, object);
                bl = true;
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4112", (Object)string);
            throw new BrokerException(this.br.getString("B4112", string), runtimeException);
        }
    }

    Object getProperty(String string) throws BrokerException {
        return this.propMap.get(string);
    }

    String[] getPropertyNames() throws BrokerException {
        Set set = this.propMap.keySet();
        return set.toArray(new String[set.size()]);
    }

    Properties getProperties() throws BrokerException {
        Properties properties = new Properties();
        for (Map.Entry entry : this.propMap.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    void clearAll() {
        if (Store.getDEBUG()) {
            this.logger.log(1, "PropertiesStore.clearAll() called");
        }
        this.propMap.clear();
    }

    void close(boolean bl) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "PropertiesStore: closing, " + this.propMap.size() + " in-memory properties");
        }
        this.propMap.clear();
    }

    Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Properties", String.valueOf(this.propMap.size()));
        return hashtable;
    }

    void printInfo(PrintStream printStream) {
        printStream.println("\nProperties");
        printStream.println("----------");
        printStream.println("backing file: " + this.backingFile);
        Set set = this.propMap.entrySet();
        for (Map.Entry entry : set) {
            printStream.println((String)entry.getKey() + "=" + entry.getValue().toString());
        }
    }
}

