/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.DestinationName;
import java.util.Properties;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;

public abstract class Destination
extends AdministeredObject
implements javax.jms.Destination {
    private static final String defaultsBase = "Destination";

    public Destination() {
        super(defaultsBase);
    }

    public Destination(String string) throws InvalidDestinationException {
        super(defaultsBase);
        if (string == null || "".equals(string)) {
            String string2 = AdministeredObject.cr.getKString("C4050");
            throw new InvalidDestinationException(string2, "C4050");
        }
        if (this.isTemporary()) {
            this.configuration.put("imqDestinationName", string);
        } else if (DestinationName.isSyntaxValid(string)) {
            this.configuration.put("imqDestinationName", string);
        } else {
            String string3 = AdministeredObject.cr.getKString("C4050", string);
            throw new InvalidDestinationException(string3, "C4050");
        }
    }

    public String getName() {
        try {
            return super.getProperty("imqDestinationName");
        }
        catch (JMSException jMSException) {
            return "";
        }
    }

    public String getQueueName() throws JMSException {
        return this.getName();
    }

    public String getTopicName() throws JMSException {
        return this.getName();
    }

    public String toString() {
        return "GlassFish(tm) MQ Destination\ngetName():\t\t" + this.getName() + super.toString();
    }

    public abstract boolean isQueue();

    public abstract boolean isTemporary();

    public void setDefaultConfiguration() {
        this.configuration = new Properties();
        this.configurationTypes = new Properties();
        this.configurationLabels = new Properties();
        this.configuration.put("imqDestinationName", "Untitled_Destination_Object");
        this.configurationTypes.put("imqDestinationName", "java.lang.String");
        this.configurationLabels.put("imqDestinationName", "L0570");
        this.configuration.put("imqDestinationDescription", "A Description for the Destination Object");
        this.configurationTypes.put("imqDestinationDescription", "java.lang.String");
        this.configurationLabels.put("imqDestinationDescription", "L0571");
    }

    public Boolean validate_imqDestinationName(String string) {
        if (this.isTemporary()) {
            if (string != null && string.startsWith("temporary_destination://")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return new Boolean(DestinationName.isSyntaxValid(string));
    }
}

