/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.Properties;
import java.util.logging.Logger;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.jms.admin.cli.JMSDestination;
import org.glassfish.jms.admin.cli.MQJMXConnectorInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="create-jmsdest")
@Scoped(value=PerLookup.class)
@I18n(value="create.jms.dest")
@Cluster(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateJMSDestination
extends JMSDestination
implements AdminCommand {
    static Logger logger = LogDomains.getLogger(CreateJMSDestination.class, (String)"javax.enterprise.system.tools.admin");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJMSDestination.class);
    @Param(name="destType", shortName="T", optional=false)
    String destType;
    @Param(name="property", optional=true, separator=58)
    Properties props;
    @Param(name="dest_name", primary=true)
    String destName;
    @Param(optional=true)
    String target = "server";
    @Inject
    ConnectorRuntime connectorRuntime;
    @Inject
    Domain domain;
    @Inject(name="default-instance-name")
    Config config;
    @Inject
    ServerContext serverContext;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            this.validateJMSDestName(this.destName);
            this.validateJMSDestType(this.destType);
        }
        catch (IllegalArgumentException e) {
            report.setMessage(e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.destType.equals("queue")) {
            if (this.props == null) {
                this.props = new Properties();
            }
            if (!this.props.containsKey("maxNumActiveConsumers") && !this.props.containsKey("MaxNumActiveConsumers")) {
                this.props.put("MaxNumActiveConsumers", "-1");
            }
        }
        try {
            this.createJMSDestination();
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("create.jms.destination.CannotCreateJMSDest", "Unable to create JMS Destination."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJMSDestination() throws Exception {
        MQJMXConnectorInfo mqInfo = this.getMQJMXConnectorInfo(this.target, this.config, this.serverContext, this.domain, this.connectorRuntime);
        try {
            MBeanServerConnection mbsc = mqInfo.getMQMBeanServerConnection();
            ObjectName on = new ObjectName("com.sun.messaging.jms.server:type=DestinationManager,subtype=Config");
            String[] signature = null;
            AttributeList destAttrs = null;
            Object[] params = null;
            if (this.props != null) {
                destAttrs = this.convertProp2Attrs(this.props);
            }
            if (this.destType.equalsIgnoreCase("topic")) {
                this.destType = "t";
            } else if (this.destType.equalsIgnoreCase("queue")) {
                this.destType = "q";
            }
            if (destAttrs == null || destAttrs.size() == 0) {
                signature = new String[]{"java.lang.String", "java.lang.String"};
                params = new Object[]{this.destType, this.destName};
            } else {
                signature = new String[]{"java.lang.String", "java.lang.String", "javax.management.AttributeList"};
                params = new Object[]{this.destType, this.destName, destAttrs};
            }
            mbsc.invoke(on, "create", params, signature);
        }
        catch (Exception e) {
            this.logAndHandleException(e, "admin.mbeans.rmb.error_creating_jms_dest");
        }
        finally {
            try {
                if (mqInfo != null) {
                    mqInfo.closeMQMBeanServerConnection();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }
}

