/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.connectors.jms.system.ActiveJmsResourceAdapter;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.jms.admin.cli.JMSDestination;
import org.glassfish.jms.admin.cli.MQJMXConnectorInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="delete-jmsdest")
@Scoped(value=PerLookup.class)
@I18n(value="delete.jms.dest")
@Cluster(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class DeleteJMSDestination
extends JMSDestination
implements AdminCommand {
    static Logger logger = LogDomains.getLogger(ActiveJmsResourceAdapter.class, (String)"javax.enterprise.system.tools.admin");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteJMSDestination.class);
    @Param(name="destType", shortName="T", optional=false)
    String destType;
    @Param(name="dest_name", primary=true)
    String destName;
    @Param(optional=true)
    String target = "server";
    @Inject
    ConnectorRuntime connectorRuntime;
    @Inject
    Domain domain;
    @Inject(name="default-instance-name")
    Config config;
    @Inject
    ServerContext serverContext;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        logger.entering(this.getClass().getName(), "deleteJMSDestination", new Object[]{this.destName, this.destType});
        try {
            this.validateJMSDestName(this.destName);
            this.validateJMSDestType(this.destType);
        }
        catch (IllegalArgumentException e) {
            report.setMessage(e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            Object ret = this.deleteJMSDestination(this.destName, this.destType, this.target);
            return;
        }
        catch (Exception e) {
            logger.throwing(this.getClass().getName(), "deleteJMSDestination", e);
            report.setMessage(localStrings.getLocalString("delete.jms.dest.noJmsDelete", "Delete JMS Destination failed. Please verify if the JMS Destination specified for deletion exists"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object deleteJMSDestination(String destName, String destType, String tgtName) throws Exception {
        logger.log(Level.FINE, "deleteJMSDestination ...");
        MQJMXConnectorInfo mqInfo = this.getMQJMXConnectorInfo(this.target, this.config, this.serverContext, this.domain, this.connectorRuntime);
        try {
            MBeanServerConnection mbsc = mqInfo.getMQMBeanServerConnection();
            ObjectName on = new ObjectName("com.sun.messaging.jms.server:type=DestinationManager,subtype=Config");
            String[] signature = null;
            Object[] params = null;
            signature = new String[]{"java.lang.String", "java.lang.String"};
            if (destType.equalsIgnoreCase("topic")) {
                destType = "t";
            } else if (destType.equalsIgnoreCase("queue")) {
                destType = "q";
            }
            params = new Object[]{destType, destName};
            Object object = mbsc.invoke(on, "destroy", params, signature);
            return object;
        }
        catch (Exception e) {
            this.logAndHandleException(e, "admin.mbeans.rmb.error_deleting_jms_dest");
        }
        finally {
            try {
                if (mqInfo != null) {
                    mqInfo.closeMQMBeanServerConnection();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return null;
    }
}

