/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.MetricManager;
import com.sun.messaging.jmq.net.IPAddress;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.util.Hashtable;

public abstract class IMQBasicConnection
extends IMQConnection {
    String remoteConString = null;
    String remoteHostString = null;
    PacketRouter router = null;
    protected int[] pktsOut = new int[80];
    protected int[] pktsIn = new int[80];
    protected static final int NO_VERSION = 0;
    public static final int CURVERSION = 301;
    public int packetVersion = 0;
    public static final String CLIENT_ID = "client id";
    public static final String TRANSACTION_LIST = "transaction";
    public static final String TRANSACTION_IDMAP = "tidmap";
    public static final String TRANSACTION_CACHE = "txncache";
    public static final String USER_AGENT = "useragent";
    protected static boolean DEBUG = Globals.getConfig().getBooleanProperty("imq.packet.debug.info");
    protected static boolean DUMP_PACKET = Globals.getConfig().getBooleanProperty("imq.packet.debug.all");
    protected static boolean OUT_DUMP_PACKET = Globals.getConfig().getBooleanProperty("imq.packet.debug.out");
    protected static boolean IN_DUMP_PACKET = Globals.getConfig().getBooleanProperty("imq.packet.debug.in");
    protected static byte[] ipAddress = null;
    public boolean METRICS_ON = MetricManager.isEnabled();
    String localsvcstring = null;

    public static boolean getDumpPacket() {
        return DUMP_PACKET;
    }

    public static boolean getDumpInPacket() {
        return IN_DUMP_PACKET;
    }

    public static boolean getDumpOutPacket() {
        return OUT_DUMP_PACKET;
    }

    public static void dumpPacket(boolean bl) {
        DUMP_PACKET = bl;
    }

    public static void dumpInPacket(boolean bl) {
        IN_DUMP_PACKET = bl;
    }

    public static void dumpOutPacket(boolean bl) {
        OUT_DUMP_PACKET = bl;
    }

    public IMQBasicConnection(Service service, PacketRouter packetRouter) throws IOException, BrokerException {
        super(service);
        this.router = packetRouter;
    }

    public boolean setConnectionState(int n) {
        this.state = n;
        return true;
    }

    public void countInPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        if (packet.getPacketType() <= 6 && packet.getPacketType() >= 1) {
            this.counters.updateIn(1L, (long)packet.getPacketSize(), 1L, (long)packet.getPacketSize());
        } else {
            this.counters.updateIn(0L, 0L, 1L, (long)packet.getPacketSize());
        }
    }

    public void countOutPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        if (packet.getPacketType() <= 6 && packet.getPacketType() >= 1) {
            this.counters.updateOut(1L, (long)packet.getPacketSize(), 1L, (long)packet.getPacketSize());
        } else {
            this.counters.updateOut(0L, 0L, 1L, (long)packet.getPacketSize());
        }
    }

    public void flushControl(long l) {
    }

    public int getLocalPort() {
        return 0;
    }

    public void waitForRelease(long l) {
    }

    protected void sayGoodbye(int n, String string) {
        this.sayGoodbye(false, n, string);
    }

    protected void sayGoodbye(boolean bl, int n, String string) {
        Packet packet = new Packet(this.useDirectBuffers());
        packet.setPacketType(28);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("JMQExit", bl);
        hashtable.put("JMQGoodbyeReason", new Integer(n));
        hashtable.put("JMQGoodbyeReasonString", string);
        packet.setProperties(hashtable);
        this.sendControlMessage(packet);
    }

    protected void sendConsumerInfo(int n, String string, int n2, int n3) {
        if (this.state >= 6) {
            return;
        }
        Packet packet = new Packet(this.useDirectBuffers());
        packet.setPacketType(73);
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put("JMQRequestType", n);
        hashtable.put("JMQStatus", 200);
        packet.setProperties(hashtable);
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        hashtable2.put("JMQDestination", string);
        hashtable2.put("JMQDestType", n2);
        hashtable2.put("JMQConsumerInfoType", n3);
        DestinationUID destinationUID = null;
        try {
            destinationUID = DestinationUID.getUID(string, n2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(hashtable2);
            objectOutputStream.flush();
            byteArrayOutputStream.flush();
            packet.setMessageBody(byteArrayOutputStream.toByteArray());
            byteArrayOutputStream.close();
        }
        catch (Throwable throwable) {
            this.logger.log(16, "XXXI18N Error: Unable to send consumer info to client: " + destinationUID, throwable);
            return;
        }
        this.sendControlMessage(packet);
    }

    public boolean equals(Object object) {
        if (object instanceof ConnectionUID) {
            return object.equals((Object)this.getConnectionUID());
        }
        if (object instanceof Connection) {
            return ((Connection)object).getConnectionUID().equals((Object)this.getConnectionUID());
        }
        return false;
    }

    public String toString() {
        return "IMQConn[" + IMQBasicConnection.getConnectionStateString(this.state) + "," + this.getRemoteConnectionString() + "," + this.localsvcstring + "]";
    }

    public String toDebugString() {
        return super.toString() + " state: " + this.state;
    }

    public String remoteHostString() {
        if (this.remoteHostString == null) {
            try {
                InetAddress inetAddress = InetAddress.getByAddress(this.getRemoteIP());
                this.remoteHostString = inetAddress.getHostName();
            }
            catch (Exception exception) {
                this.remoteHostString = IPAddress.rawIPToString((byte[])this.getRemoteIP(), (boolean)true, (boolean)true);
            }
        }
        return this.remoteHostString;
    }

    public String getRemoteConnectionString() {
        Object object;
        String string;
        boolean bl;
        block6: {
            if (this.remoteConString != null) {
                return this.remoteConString;
            }
            bl = false;
            string = "???";
            if (this.state >= 4) {
                try {
                    object = this.getAuthenticatedName();
                    if (object != null) {
                        string = object.getName();
                        bl = true;
                    }
                }
                catch (BrokerException brokerException) {
                    if (!DEBUG) break block6;
                    this.logger.log(4, "Exception getting authentication name " + (Object)((Object)this.conId), (Throwable)brokerException);
                }
            }
        }
        object = string + "@" + "Direct2" + ":" + (Object)((Object)this.getConnectionUID());
        if (bl) {
            this.remoteConString = object;
        }
        return object;
    }

    protected String localServiceString() {
        if (this.localsvcstring != null) {
            return this.localsvcstring;
        }
        this.localsvcstring = this.service.getName();
        return this.localsvcstring;
    }

    static {
        try {
            ipAddress = InetAddress.getLocalHost().getAddress();
        }
        catch (Exception exception) {
            Globals.getLogger().log(8, "Internal Error, could not  retrieve local address ", (Object)ipAddress);
            ipAddress = new byte[0];
        }
    }
}

