/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import java.io.Serializable;

public class SizeString
implements Serializable {
    private static final long K = 1024L;
    private static final long M = 0x100000L;
    private static final long B = 1L;
    String str = null;
    long bytes = 0L;

    public SizeString(String string) throws NumberFormatException {
        this.setString(string);
    }

    public SizeString() throws NumberFormatException {
        this.setString("0b");
    }

    public SizeString(long l) {
        this.setKBytes(l);
    }

    public void setString(String string) throws NumberFormatException {
        this.str = string;
        long l = 1L;
        if (this.str == null) {
            this.str = null;
            this.bytes = 0L;
            return;
        }
        if (Character.isLetter(string.charAt(this.str.length() - 1))) {
            char c = string.charAt(this.str.length() - 1);
            string = this.str.substring(0, this.str.length() - 1);
            switch (c) {
                case 'M': 
                case 'm': {
                    l = 0x100000L;
                    break;
                }
                case 'K': 
                case 'k': {
                    l = 1024L;
                    break;
                }
                case 'B': 
                case 'b': {
                    l = 1L;
                    break;
                }
                default: {
                    throw new NumberFormatException("Unknown size " + c);
                }
            }
        }
        int n = new Integer(string);
        this.bytes = (long)n * l;
    }

    public String getString() {
        return this.str;
    }

    public String getByteString() {
        return this.bytes + "b";
    }

    public String getKByteString() {
        return this.getKBytes() + "K";
    }

    public String getMByteString() {
        return this.getMBytes() + "M";
    }

    public void setKBytes(long l) {
        this.str = String.valueOf(l) + "K";
        this.bytes = l * 1024L;
    }

    public void setMBytes(long l) {
        this.str = String.valueOf(l) + "M";
        this.bytes = l * 0x100000L;
    }

    public void setBytes(long l) {
        this.str = String.valueOf(l) + "b";
        this.bytes = l * 1L;
    }

    public long getBytes() {
        return this.bytes;
    }

    public long getKBytes() {
        return this.bytes == 0L ? 0L : this.bytes / 1024L;
    }

    public long getMBytes() {
        return this.bytes == 0L ? 0L : this.bytes / 0x100000L;
    }

    public String toString() {
        return this.getString();
    }

    public static void main(String[] stringArray) {
        try {
            System.err.println("## 100b");
            System.err.println(new SizeString("100b").toString());
            System.err.println(new SizeString("100b").getByteString());
            System.err.println(new SizeString("100b").getKByteString());
            System.err.println(new SizeString("100b").getMByteString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            System.err.println("## 100k");
            System.err.println(new SizeString("100k").toString());
            System.err.println(new SizeString("100k").getByteString());
            System.err.println(new SizeString("100k").getKByteString());
            System.err.println(new SizeString("100k").getMByteString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            System.err.println("## 100m");
            System.err.println(new SizeString("100m").toString());
            System.err.println(new SizeString("100m").getByteString());
            System.err.println(new SizeString("100m").getKByteString());
            System.err.println(new SizeString("100m").getMByteString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            new SizeString("100B").toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            new SizeString("100K").toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            new SizeString("100M").toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            new SizeString("100").toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            new SizeString("100L").toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

