/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="create-jms-host")
@Scoped(value=PerLookup.class)
@I18n(value="create.jms.host")
@Cluster(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateJMSHost
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJMSHost.class);
    @Param(name="mqHost", alias="host", defaultValue="localhost")
    String mqhost;
    @Param(name="mqPort", alias="port", defaultValue="7676")
    String mqport;
    @Param(name="mqUser", alias="adminUserName", defaultValue="admin")
    String mquser;
    @Param(name="mqPassword", alias="adminPassword", defaultValue="admin")
    String mqpassword;
    @Param(name="property", optional=true, separator=58)
    Properties props;
    @Param(optional=true)
    String target = "server";
    @Param(name="jms_host_name", alias="host", primary=true)
    String jmsHostName;
    @Inject(name="default-instance-name")
    Config config;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        com.sun.enterprise.config.serverbeans.Cluster cluster;
        ActionReport report = context.getActionReport();
        Server targetServer = this.domain.getServerNamed(this.target);
        if (targetServer != null) {
            this.config = this.domain.getConfigNamed(targetServer.getConfigRef());
        }
        if ((cluster = this.domain.getClusterNamed(this.target)) != null) {
            this.config = this.domain.getConfigNamed(cluster.getConfigRef());
        }
        if (this.jmsHostName == null) {
            report.setMessage(localStrings.getLocalString("create.jms.host.noJmsHost", "No JMS Host name specified."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        JmsService jmsservice = this.config.getJmsService();
        for (JmsHost jmsHost : jmsservice.getJmsHost()) {
            if (!this.jmsHostName.equals(jmsHost.getName())) continue;
            report.setMessage(localStrings.getLocalString("create.jms.host.duplicate", "A JMS Host named {0} already exists.", new Object[]{this.jmsHostName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<JmsService>(){

                public Object run(JmsService param) throws PropertyVetoException, TransactionFailure {
                    JmsHost jmsHost = (JmsHost)param.createChild(JmsHost.class);
                    jmsHost.setAdminPassword(CreateJMSHost.this.mqpassword);
                    jmsHost.setAdminUserName(CreateJMSHost.this.mquser);
                    jmsHost.setName(CreateJMSHost.this.jmsHostName);
                    jmsHost.setHost(CreateJMSHost.this.mqhost);
                    jmsHost.setPort(CreateJMSHost.this.mqport);
                    if (CreateJMSHost.this.props != null) {
                        for (Map.Entry<Object, Object> e : CreateJMSHost.this.props.entrySet()) {
                            Property prop = (Property)jmsHost.createChild(Property.class);
                            prop.setName((String)e.getKey());
                            prop.setValue((String)e.getValue());
                            jmsHost.getProperty().add(prop);
                        }
                    }
                    param.getJmsHost().add(jmsHost);
                    return jmsHost;
                }
            }, (ConfigBeanProxy)jmsservice);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("create.jms.host.fail", "Unable to create jms host {0}.", new Object[]{this.jmsHostName}) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
        report.setMessage(localStrings.getLocalString("create.jms.host.success", "Jms Host {0} created.", new Object[]{this.jmsHostName}));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

