/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.runtime.impl;

import com.sun.messaging.jmq.jmsclient.runtime.impl.DirectBrokerInstance;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQDirectService;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsservice.BrokerEventListener;
import com.sun.messaging.jmq.jmsservice.DirectBrokerConnection;
import com.sun.messaging.jmq.jmsservice.JMSBroker;
import com.sun.messaging.jmq.jmsservice.JMSDirectBroker;
import com.sun.messaging.jmq.jmsservice.JMSService;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.jms.JMSException;

public class BrokerInstanceImpl
implements DirectBrokerInstance {
    private static final String BROKER_PROCESS = "com.sun.messaging.jmq.jmsserver.BrokerProcess";
    private static final String DIRECT_BROKER_PROCESS2 = "com.sun.messaging.jmq.jmsserver.DualThreadDBP";
    private static final String DIRECT_BROKER_PROCESS = "com.sun.messaging.jmq.jmsserver.DirectBrokerProcess";
    private BrokerEventListener evlistener = null;
    private Properties props = null;
    private JMSBroker bkr = null;
    private boolean running = false;
    private boolean isShutdown = false;
    private static BrokerInstanceImpl soleInstance;
    private static boolean isDirect;
    public static volatile boolean isTwoThread;
    public static volatile boolean isTwoThreadSyncReplies;

    protected BrokerInstanceImpl() {
    }

    public static BrokerInstanceImpl getInstance() {
        return soleInstance;
    }

    public static synchronized BrokerInstanceImpl createInstance() throws IllegalAccessException {
        if (soleInstance == null) {
            soleInstance = new BrokerInstanceImpl();
        } else if (soleInstance.isShutdown()) {
            soleInstance = new BrokerInstanceImpl();
        } else {
            throw new IllegalAccessException("Cannot create broker instance.  A broker instance is already created.");
        }
        return soleInstance;
    }

    public BrokerEventListener getBrokerEventListener() {
        return this.evlistener;
    }

    public Properties getProperties() {
        return this.props;
    }

    public synchronized void init(Properties properties, BrokerEventListener brokerEventListener) {
        this.props = properties;
        this.evlistener = brokerEventListener;
        if (this.running) {
            throw new IllegalStateException("Cannot initialize while broker is in running state.");
        }
        try {
            this.getBroker();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Properties parseArgs(String[] stringArray) throws IllegalArgumentException {
        this.getBroker();
        return this.bkr.parseArgs(stringArray);
    }

    public void shutdown() {
        this.bkr.stop(true);
        this.isShutdown = true;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public void setShutdown(boolean bl) {
        this.isShutdown = bl;
    }

    public synchronized void start() {
        if (this.running) {
            return;
        }
        try {
            this.bkr.start(true, this.props, this.evlistener, false);
            this.running = true;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        this.bkr.stop(false);
        this.running = false;
    }

    public synchronized boolean isBrokerRunning() {
        return this.running;
    }

    public boolean isDirectMode() {
        return isDirect;
    }

    public DirectBrokerConnection createDirectConnection() throws JMSException {
        DirectBrokerConnection directBrokerConnection = null;
        if (isDirect) {
            directBrokerConnection = ((JMSDirectBroker)this.bkr).getConnection();
        }
        return directBrokerConnection;
    }

    private synchronized void getBroker() {
        try {
            if (this.bkr == null) {
                this.bkr = isDirect ? (isTwoThread ? (JMSBroker)Class.forName(DIRECT_BROKER_PROCESS2).newInstance() : (JMSBroker)Class.forName(DIRECT_BROKER_PROCESS).newInstance()) : (JMSBroker)Class.forName(BROKER_PROCESS).newInstance();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public JMSService getJMSService() {
        String string = "jmsdirect";
        ServiceManager serviceManager = Globals.getServiceManager();
        JMSService jMSService = this.getJMSService(string);
        if (jMSService != null) {
            return jMSService;
        }
        List list = serviceManager.getAllServiceNames();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            jMSService = this.getJMSService((String)iterator.next());
            if (jMSService == null) continue;
            return jMSService;
        }
        return null;
    }

    private JMSService getJMSService(String string) throws IllegalStateException {
        ServiceManager serviceManager = Globals.getServiceManager();
        if (serviceManager == null) {
            return null;
        }
        Service service = serviceManager.getService(string);
        if (service == null) {
            return null;
        }
        if (!(service instanceof IMQService)) {
            return null;
        }
        IMQService iMQService = (IMQService)service;
        if (!iMQService.isDirect()) {
            return null;
        }
        if (!(iMQService instanceof IMQDirectService)) {
            return null;
        }
        IMQDirectService iMQDirectService = (IMQDirectService)iMQService;
        return iMQDirectService;
    }

    public void setEmbeddedBrokerStartupMessage(String string) {
        this.bkr.setEmbeddedBrokerStartupMessage(string);
    }

    static {
        isDirect = true;
        isTwoThread = true;
        isTwoThreadSyncReplies = true;
        boolean bl = Boolean.getBoolean("imq.embed.broker.direct.disabled");
        if (bl) {
            isDirect = false;
        }
        isTwoThread = Boolean.valueOf(System.getProperty("imq.embed.broker.direct.twothread", "true"));
        isTwoThreadSyncReplies = Boolean.valueOf(System.getProperty("imq.embed.broker.direct.twothread.syncreplies", "true"));
    }
}

