/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.blc;

import com.sun.messaging.jmq.jmsclient.runtime.BrokerInstance;
import com.sun.messaging.jmq.jmsclient.runtime.ClientRuntime;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.jmsservice.BrokerEventListener;
import com.sun.messaging.jmq.jmsservice.JMSService;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EmbeddedBrokerRunner
implements BrokerEventListener {
    private Properties brokerProps = null;
    private BrokerInstance directBroker;
    private JMSService jmsservice = null;
    private static final transient String _className = "com.sun.messaging.jms.ra.EmbeddedBrokerRunner";
    protected static final transient String _lgrNameLifecycle = "javax.resourceadapter.mqjmsra.lifecycle";
    protected static final transient Logger _loggerL = Logger.getLogger("javax.resourceadapter.mqjmsra.lifecycle");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_EB";
    protected static final transient String _lgrMID_EET = "MQJMSRA_EB1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_EB1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_EB2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_EB3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_EB4001: ";

    public EmbeddedBrokerRunner(String string, String string2, String string3, int n, String string4, String string5, String string6, String string7, String string8, boolean bl, int n2, boolean bl2, boolean bl3, boolean bl4, Properties properties) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Object[] objectArray;
        if (_loggerL.isLoggable(Level.FINER)) {
            objectArray = new Object[]{string2, string3, Integer.toString(n), string4, string5, string6, string7, string8, new Boolean(bl), new Integer(n2), new Boolean(bl2), new Boolean(bl3), bl4, properties};
            _loggerL.entering(_className, "constructor()", objectArray);
        }
        objectArray = this.assembleBrokerArgs(string2, n, string4, string5, string6, string8, bl, n2, bl2, bl4);
        this.createTheInVMBrokerInstance();
        this.brokerProps = this.parseArgs((String[])objectArray);
        if (string3 != null && !"localhost".equals(string3)) {
            this.brokerProps.setProperty("imq.hostname", string3);
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string9 = (String)enumeration.nextElement();
            if (string9 == null) continue;
            String string10 = properties.getProperty(string9);
            this.brokerProps.setProperty(string9, string10);
        }
        this.logSysPropsInbrokerLog(properties);
    }

    private void logSysPropsInbrokerLog(Properties properties) {
        if (properties.isEmpty()) {
            return;
        }
        boolean bl = true;
        String string = "";
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = "";
            string3 = string2.endsWith("password") ? "*****" : properties.getProperty(string2);
            if (bl) {
                bl = false;
            } else {
                string = string + ", ";
            }
            string = string + string2 + "=" + string3;
        }
        this.directBroker.setEmbeddedBrokerStartupMessage("JMSRA BrokerProps: " + string);
    }

    private String[] assembleBrokerArgs(String string, int n, String string2, String string3, String string4, String string5, boolean bl, int n2, boolean bl2, boolean bl3) {
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        if (string5 != null && !"".equals(string5)) {
            stringArray = new StringTokenizer(string5, " ");
            while (stringArray.hasMoreTokens()) {
                String string6 = stringArray.nextToken();
                vector.add(string6);
            }
        }
        vector.add("-port");
        vector.add(Integer.toString(n));
        if (string != null) {
            vector.add("-name");
            vector.add(string);
        }
        if (!bl3) {
            vector.add("-nobind");
        }
        if (string2 != null) {
            vector.add("-imqhome");
            vector.add(string2);
        }
        if (string4 != null) {
            vector.add("-varhome");
            vector.add(string4);
        }
        if (string3 != null && !"".equals(string3)) {
            vector.add("-libhome");
            vector.add(string3);
        }
        if (bl) {
            if (bl2) {
                vector.add("-startRmiRegistry");
            } else {
                vector.add("-useRmiRegistry");
            }
            vector.add("-rmiRegistryPort");
            vector.add(Integer.toString(n2));
        }
        vector.add("-save");
        vector.add("-silent");
        stringArray = vector.toArray(new String[0]);
        return stringArray;
    }

    private void createTheInVMBrokerInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ClientRuntime clientRuntime = ClientRuntime.getRuntime();
        this.directBroker = clientRuntime.createBrokerInstance();
    }

    private Properties parseArgs(String[] stringArray) {
        return this.directBroker.parseArgs(stringArray);
    }

    public synchronized void init() {
        _loggerL.entering(_className, "init()");
        this.directBroker.init(this.brokerProps, this);
    }

    public synchronized void start() {
        _loggerL.entering(_className, "start()");
        _loggerL.config("MQJMSRA_EB1101: EB-start:brokerProps=" + this.brokerProps.toString());
        this.directBroker.start();
    }

    protected synchronized void stop() {
        _loggerL.entering(_className, "stop()");
        try {
            BrokerInstance brokerInstance = this.directBroker;
            brokerInstance.stop();
            brokerInstance.shutdown();
            this.directBroker = null;
        }
        catch (Exception exception) {
            _loggerL.severe("MQJMSRA_EB4001: stop:Exception on in-VM broker shutdown:msg=" + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public JMSService getJMSService() {
        if (this.jmsservice == null) {
            this.jmsservice = this.directBroker.getJMSService();
        }
        return this.jmsservice;
    }

    public void brokerEvent(BrokerEvent brokerEvent) {
        _loggerL.fine("MQJMSRA_EB1101: stateChanged:" + brokerEvent);
        if (brokerEvent.getType() == BrokerEvent.Type.SHUTDOWN) {
            this.directBroker = null;
        }
    }

    public boolean exitRequested(BrokerEvent brokerEvent, Throwable throwable) {
        return true;
    }
}

