/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.admin.MessageType;
import java.util.Hashtable;

public class ChangeClusterMasterBrokerHandler
extends AdminCmdHandler {
    private static boolean DEBUG = ChangeClusterMasterBrokerHandler.getDEBUG();

    public ChangeClusterMasterBrokerHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        int n = 200;
        String string = null;
        if (DEBUG) {
            this.logger.log(8, this.getClass().getName() + ": " + hashtable);
        }
        if (Globals.getHAEnabled()) {
            n = 412;
            string = this.rb.getKString("B3262", MessageType.getString((int)96));
            this.logger.log(32, string);
            this.sendReply(n, string, iMQConnection, packet);
            return true;
        }
        if (Globals.useSharedConfigRecord()) {
            n = 412;
            string = this.rb.getKString("B3271", MessageType.getString((int)96));
            this.logger.log(32, string);
            this.sendReply(n, string, iMQConnection, packet);
            return true;
        }
        try {
            BrokerMQAddress brokerMQAddress;
            if (!Globals.dynamicChangeMasterBrokerEnabled()) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4356"), 405);
            }
            String string2 = (String)hashtable.get("JMQClusterOldMasterBroker");
            String string3 = (String)hashtable.get("JMQClusterNewMasterBroker");
            if (string3 == null) {
                throw new IllegalArgumentException("null JMQClusterNewMasterBroker");
            }
            this.logger.log(8, Globals.getBrokerResources().getKString("B1382", MessageType.getString((int)96) + "[" + "JMQClusterNewMasterBroker" + "=" + string3 + ", " + "JMQClusterOldMasterBroker" + "=" + string2 + "]" + (Globals.isJMSRAManagedBroker() ? "JMSRA" : "")));
            Object v = hashtable.get("JMQJMSRAManagedBroker");
            if ((v == null || !Boolean.valueOf(v.toString()).booleanValue()) && Globals.isJMSRAManagedBroker()) {
                throw new IllegalAccessException(Globals.getBrokerResources().getKString("B4354"));
            }
            ClusterManager clusterManager = Globals.getClusterManager();
            BrokerMQAddress brokerMQAddress2 = (BrokerMQAddress)clusterManager.getMQAddress();
            BrokerMQAddress brokerMQAddress3 = brokerMQAddress = clusterManager.getMasterBroker() == null ? null : (BrokerMQAddress)clusterManager.getMasterBroker().getBrokerURL();
            if (brokerMQAddress == null) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4333"), 412);
            }
            BrokerMQAddress brokerMQAddress4 = BrokerMQAddress.createAddress(string3);
            if (brokerMQAddress4.equals((Object)brokerMQAddress)) {
                this.logger.log(8, Globals.getBrokerResources().getKString("B1379", (Object)brokerMQAddress4));
                this.sendReply(200, null, iMQConnection, packet);
                return true;
            }
            BrokerMQAddress brokerMQAddress5 = null;
            if (string2 != null) {
                brokerMQAddress5 = BrokerMQAddress.createAddress(string2);
                if (!brokerMQAddress5.equals((Object)brokerMQAddress)) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4337", brokerMQAddress5.toString(), (Object)brokerMQAddress), 412);
                }
            } else {
                brokerMQAddress5 = brokerMQAddress;
            }
            if (!brokerMQAddress2.equals((Object)brokerMQAddress)) {
                if (!Globals.isJMSRAManagedBroker()) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4339", brokerMQAddress.toString()), 405);
                }
                this.sendReply(200, null, iMQConnection, packet);
                return true;
            }
            Globals.getClusterBroadcast().changeMasterBroker(brokerMQAddress4, brokerMQAddress5);
            this.sendReply(200, null, iMQConnection, packet);
            return true;
        }
        catch (Exception exception) {
            n = 500;
            string = exception.getMessage();
            if (exception instanceof BrokerException) {
                n = ((BrokerException)exception).getStatusCode();
                string = string + "[" + Status.getString((int)n) + "]";
            }
            this.logger.logStack(32, string, (Throwable)exception);
            this.sendReply(n, string, iMQConnection, packet);
            return true;
        }
    }

    private void sendReply(int n, String string, IMQConnection iMQConnection, Packet packet) {
        Packet packet2 = new Packet(iMQConnection.useDirectBuffers());
        packet2.setPacketType(5);
        ChangeClusterMasterBrokerHandler.setProperties(packet2, 97, n, string);
        this.parent.sendReply(iMQConnection, packet, packet2);
    }
}

