/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JmsAvailability;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="configure-jms-cluster")
@Scoped(value=PerLookup.class)
@I18n(value="configure.jms.cluster")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
public class ConfigureJMSCluster
implements AdminCommand {
    private static final String SUPPORTED_DB_VENDORS = "oracle|postgressql|mysql|derby|db2";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConfigureJMSCluster.class);
    @Param(name="usemasterbroker", alias="mb", defaultValue="true")
    Boolean useMasterBroker;
    @Param(name="availability-enabled", alias="ae", defaultValue="false")
    Boolean availabilityEnabled;
    @Param(name="dbvendor", alias="db", optional=true)
    String dbvendor;
    @Param(name="dbuser", alias="user", optional=true)
    String dbuser;
    @Param(name="dbpassword", alias="password", optional=true)
    String dbpassword;
    @Param(name="jdbcurl", alias="url", optional=true)
    String jdbcurl;
    @Param(name="property", optional=true, separator=58)
    Properties props;
    @Param(primary=true)
    String clusterName;
    @Inject
    Domain domain;
    Config config;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Cluster cluster = this.domain.getClusterNamed(this.clusterName);
        if (cluster == null) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.invalidClusterName", "No Cluster by this name has been configured"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!Boolean.valueOf(this.useMasterBroker).booleanValue() || Boolean.valueOf(this.availabilityEnabled).booleanValue()) {
            if (this.dbvendor == null) {
                report.setMessage(localStrings.getLocalString("configure.jms.cluster.nodbvendor", "No DataBase vendor specified"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (this.jdbcurl == null) {
                report.setMessage(localStrings.getLocalString("configure.jms.cluster.nojdbcurl", "No JDBC URL specified"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (!this.isSupportedDbVendor()) {
                report.setMessage(localStrings.getLocalString("configure.jms.cluster.invaliddbvendor", "Invalid DB Vednor specified"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        if (this.availabilityEnabled.booleanValue() && this.useMasterBroker.booleanValue()) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.useMaterBroker", "Configuring an Enhanced MQ cluster. Ignoring the usemasterbroker option ..."));
        }
        this.config = this.domain.getConfigNamed(cluster.getConfigRef());
        JmsAvailability jmsAvailability = this.config.getAvailabilityService().getJmsAvailability();
        JmsService jmsservice = this.config.getJmsService();
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<JmsAvailability>(){

                public Object run(JmsAvailability param) throws PropertyVetoException, TransactionFailure {
                    param.setAvailabilityEnabled(ConfigureJMSCluster.this.availabilityEnabled.toString());
                    param.setDbVendor(ConfigureJMSCluster.this.dbvendor);
                    param.setDbUsername(ConfigureJMSCluster.this.dbuser);
                    param.setDbPassword(ConfigureJMSCluster.this.dbpassword);
                    param.setJdbcUrl(ConfigureJMSCluster.this.jdbcurl);
                    if (ConfigureJMSCluster.this.props != null) {
                        for (Map.Entry<Object, Object> e : ConfigureJMSCluster.this.props.entrySet()) {
                            Property prop = (Property)param.createChild(Property.class);
                            prop.setName((String)e.getKey());
                            prop.setValue((String)e.getValue());
                            param.getProperty().add(prop);
                        }
                    }
                    return param;
                }
            }, (ConfigBeanProxy)jmsAvailability);
            if (!this.availabilityEnabled.booleanValue() && this.useMasterBroker != null) {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<JmsService>(){

                    public Object run(JmsService param) throws PropertyVetoException, TransactionFailure {
                        param.setUseMasterBroker(ConfigureJMSCluster.this.useMasterBroker.toString());
                        return param;
                    }
                }, (ConfigBeanProxy)jmsservice);
            }
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("configure.jms.cluster.fail", "Unable to Configure JMS Cluster for cluster {0}.", new Object[]{this.clusterName}) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
        report.setMessage(localStrings.getLocalString("configure.jms.cluster.success", "JMS Cluster Configuration updated for Cluster {0}.", new Object[]{this.clusterName}));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private boolean isSupportedDbVendor() {
        if (this.dbvendor != null) {
            return SUPPORTED_DB_VENDORS.contains(this.dbvendor.toLowerCase());
        }
        return false;
    }
}

