/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.jms.system;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.connectors.jms.util.JmsRaUtil;
import java.util.List;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.PostStartup;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class JmsProviderLifecycle
implements PostStartup,
PostConstruct {
    private static final String JMS_EAGER_STARTUP = "org.glassfish.jms.EagerStartup";
    public static final String EMBEDDED = "EMBEDDED";
    public static final String LOCAL = "LOCAL";
    public static final String REMOTE = "REMOTE";
    public static final String JMS_SERVICE = "jms-service";
    @Inject
    Habitat habitat;

    public void postConstruct() {
        if (this.eagerStartupRequired()) {
            try {
                this.initializeBroker();
            }
            catch (ConnectorRuntimeException e) {
                e.printStackTrace();
                e.printStackTrace();
            }
        }
    }

    public void initializeBroker() throws ConnectorRuntimeException {
        String module = "jmsra";
        String loc = ConnectorsUtil.getSystemModuleLocation((String)module);
        ConnectorRuntime connectorRuntime = (ConnectorRuntime)this.habitat.getComponent(ConnectorRuntime.class);
        connectorRuntime.createActiveResourceAdapter(loc, module, null);
    }

    private boolean eagerStartupRequired() {
        String integrationMode = this.getJmsService().getType();
        if (REMOTE.equals(integrationMode)) {
            return false;
        }
        String jmsEagerStartup = System.getProperty(JMS_EAGER_STARTUP);
        if (this.isClustered() && !"false".equals(jmsEagerStartup)) {
            return true;
        }
        if (EMBEDDED.equals(integrationMode) && (jmsEagerStartup == null || "".equals(jmsEagerStartup) || "false".equals(jmsEagerStartup))) {
            return false;
        }
        if (EMBEDDED.equals(integrationMode) && "true".equals(jmsEagerStartup)) {
            return true;
        }
        if (LOCAL.equals(integrationMode) && "false".equals(jmsEagerStartup)) {
            return false;
        }
        return LOCAL.equals(integrationMode);
    }

    private boolean isClustered() {
        Domain domain = (Domain)Globals.get(Domain.class);
        Clusters clusters = domain.getClusters();
        if (clusters == null) {
            return false;
        }
        List clusterList = clusters.getCluster();
        String serverName = System.getProperty("com.sun.aas.instanceName");
        return JmsRaUtil.isClustered(clusterList, serverName);
    }

    private JmsService getJmsService() {
        return (JmsService)this.habitat.getComponent(JmsService.class);
    }
}

