/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.jms.system;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.connectors.jms.util.JmsRaUtil;
import java.util.List;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.PostStartup;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class JmsProviderLifecycle
implements PostStartup,
PostConstruct {
    private static final String JMS_EAGER_STARTUP = "org.glassfish.jms.EagerStartup";
    public static final String EMBEDDED = "EMBEDDED";
    public static final String LOCAL = "LOCAL";
    public static final String REMOTE = "REMOTE";
    public static final String JMS_SERVICE = "jms-service";
    @Inject
    Habitat habitat;

    public void postConstruct() {
        if (this.eagerStartupRequired()) {
            try {
                this.initializeBroker();
            }
            catch (ConnectorRuntimeException e) {
                e.printStackTrace();
                e.printStackTrace();
            }
        }
    }

    public void initializeBroker() throws ConnectorRuntimeException {
        String module = "jmsra";
        String loc = ConnectorsUtil.getSystemModuleLocation((String)module);
        ConnectorRuntime connectorRuntime = (ConnectorRuntime)this.habitat.getComponent(ConnectorRuntime.class);
        connectorRuntime.createActiveResourceAdapter(loc, module, null);
    }

    private boolean eagerStartupRequired() {
        JmsService jmsService = this.getJmsService();
        if (jmsService == null) {
            return false;
        }
        String integrationMode = jmsService.getType();
        List jmsHostList = jmsService.getJmsHost();
        String defaultJmsHostName = jmsService.getDefaultJmsHost();
        JmsHost defaultJmsHost = null;
        for (JmsHost host : jmsHostList) {
            if (defaultJmsHostName == null || !defaultJmsHostName.equals(host.getName())) continue;
            defaultJmsHost = host;
            break;
        }
        boolean jmsEagerStartup = false;
        boolean lazyInit = false;
        if (defaultJmsHost != null) {
            lazyInit = Boolean.parseBoolean(defaultJmsHost.getLazyInit());
        }
        if (REMOTE.equals(integrationMode)) {
            return false;
        }
        String jmsEagerStartupStr = System.getProperty(JMS_EAGER_STARTUP);
        if (jmsEagerStartupStr != null && !"".equals(jmsEagerStartupStr)) {
            jmsEagerStartup = Boolean.parseBoolean(jmsEagerStartupStr);
        }
        if (EMBEDDED.equals(integrationMode) && (!lazyInit || jmsEagerStartup)) {
            return true;
        }
        if (LOCAL.equals(integrationMode) && "false".equals(jmsEagerStartupStr)) {
            return false;
        }
        return LOCAL.equals(integrationMode);
    }

    private boolean isClustered() {
        Domain domain = (Domain)Globals.get(Domain.class);
        Clusters clusters = domain.getClusters();
        if (clusters == null) {
            return false;
        }
        List clusterList = clusters.getCluster();
        String serverName = System.getProperty("com.sun.aas.instanceName");
        return JmsRaUtil.isClustered(clusterList, serverName);
    }

    private JmsService getJmsService() {
        Domain domain = (Domain)Globals.get(Domain.class);
        String serverName = System.getProperty("com.sun.aas.instanceName");
        Server server = domain.getServerNamed(serverName);
        Config config = server.getConfig();
        return config.getJmsService();
    }
}

