/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterNewMasterBrokerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterNewMasterBrokerPrepareInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;

public class NewMasterBrokerHandler
extends GPacketHandler {
    private static boolean DEBUG = false;

    public NewMasterBrokerHandler(RaptorProtocol raptorProtocol) {
        super(raptorProtocol);
    }

    public void handle(BrokerAddress brokerAddress, GPacket gPacket) {
        if (DEBUG) {
            this.logger.log(4, "NewMasterBrokerHandler");
        }
        if (gPacket.getType() == 51) {
            this.handleNewMasterBrokerPrepare(brokerAddress, gPacket);
        } else if (gPacket.getType() == 52) {
            this.handleNewMasterBrokerPrepareReply(brokerAddress, gPacket);
        } else if (gPacket.getType() == 53) {
            this.handleNewMasterBroker(brokerAddress, gPacket);
        } else if (gPacket.getType() == 54) {
            this.handleNewMasterBrokerReply(brokerAddress, gPacket);
        } else {
            this.logger.log(16, "NewMasterBrokerHandler Internal error : Cannot handle this packet :" + gPacket.toLongString());
        }
    }

    private void handleNewMasterBrokerPrepare(BrokerAddress brokerAddress, GPacket gPacket) {
        Object[] objectArray;
        String string;
        int n;
        block4: {
            n = 200;
            string = null;
            try {
                this.p.receivedNewMasterBrokerPrepare(brokerAddress, gPacket);
            }
            catch (Exception exception) {
                n = 500;
                string = exception.getMessage();
                if (exception instanceof BrokerException) break block4;
                objectArray = new String[]{ProtocolGlobals.getPacketTypeDisplayString(gPacket.getType()), brokerAddress.toString(), exception.toString()};
                string = this.br.getKString("B3269", objectArray);
                this.logger.log(32, string);
            }
        }
        ClusterNewMasterBrokerPrepareInfo clusterNewMasterBrokerPrepareInfo = ClusterNewMasterBrokerPrepareInfo.newInstance(gPacket, this.c);
        objectArray = clusterNewMasterBrokerPrepareInfo.getReplyGPacket(n, string);
        try {
            this.c.unicast(brokerAddress, (GPacket)objectArray);
        }
        catch (Exception exception) {
            Object[] objectArray2 = new String[]{ProtocolGlobals.getPacketTypeDisplayString(52), brokerAddress.toString(), clusterNewMasterBrokerPrepareInfo.toString()};
            this.logger.logStack(32, this.br.getKString("B3192", objectArray2), (Throwable)exception);
        }
    }

    private void handleNewMasterBroker(BrokerAddress brokerAddress, GPacket gPacket) {
        Object[] objectArray;
        String string;
        int n;
        block4: {
            n = 200;
            string = null;
            try {
                this.p.receivedNewMasterBroker(brokerAddress, gPacket);
            }
            catch (Exception exception) {
                n = 500;
                string = exception.getMessage();
                if (exception instanceof BrokerException) break block4;
                objectArray = new String[]{ProtocolGlobals.getPacketTypeDisplayString(gPacket.getType()), brokerAddress.toString(), exception.toString()};
                string = this.br.getKString("B3269", objectArray);
                this.logger.log(32, string);
            }
        }
        ClusterNewMasterBrokerInfo clusterNewMasterBrokerInfo = ClusterNewMasterBrokerInfo.newInstance(gPacket, this.c);
        objectArray = clusterNewMasterBrokerInfo.getReplyGPacket(n, string);
        try {
            this.c.unicast(brokerAddress, (GPacket)objectArray);
        }
        catch (Exception exception) {
            Object[] objectArray2 = new String[]{ProtocolGlobals.getPacketTypeDisplayString(54), brokerAddress.toString(), clusterNewMasterBrokerInfo.toString()};
            this.logger.logStack(32, this.br.getKString("B3192", objectArray2), (Throwable)exception);
        }
    }

    private void handleNewMasterBrokerPrepareReply(BrokerAddress brokerAddress, GPacket gPacket) {
        this.p.receivedNewMasterBrokerPrepareReply(brokerAddress, gPacket);
    }

    private void handleNewMasterBrokerReply(BrokerAddress brokerAddress, GPacket gPacket) {
        this.p.receivedNewMasterBrokerReply(brokerAddress, gPacket);
    }
}

