/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.BaseDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.CommDBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.DBConnectionPool;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc.ShareConfigRecordDAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.sharecc.ShareConfigChangeStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Iterator;

public final class ShareConfigChangeDBManager
extends CommDBManager {
    static final String JDBC_PROP_PREFIX = "imq.cluster.sharecc.persist.jdbc";
    static final int LONGEST_TABLENAME_LEN = 11;
    private BrokerResources br = Globals.getBrokerResources();
    private String clusterID = null;
    private ShareConfigRecordDAOFactory daoFactory = null;
    private DBConnectionPool dbpool = null;
    private boolean storeInited = false;
    private static final Object classLock = ShareConfigChangeDBManager.class;
    private static ShareConfigChangeDBManager dbMgr = null;

    protected boolean getDEBUG() {
        return ShareConfigChangeStore.getDEBUG();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShareConfigChangeDBManager getDBManager() throws BrokerException {
        Object object = classLock;
        synchronized (object) {
            if (dbMgr == null) {
                dbMgr = new ShareConfigChangeDBManager();
                dbMgr.loadTableSchema();
                ShareConfigChangeDBManager.dbMgr.dbpool = new DBConnectionPool(dbMgr, "ccshare", true);
                dbMgr.initDBMetaData();
            }
        }
        return dbMgr;
    }

    protected String getJDBCPropPrefix() {
        return JDBC_PROP_PREFIX;
    }

    protected String getStoreTypeProp() {
        return "imq.cluster.sharecc.persist";
    }

    protected String getCreateStoreProp() {
        return "imq.cluster.sharecc.persistCreate";
    }

    protected boolean getCreateStorePropDefault() {
        return false;
    }

    protected String getLogStringTag() {
        return "[imq.cluster.sharecc.persist.jdbc]";
    }

    public String toString() {
        return "CCShareDBManger";
    }

    protected Connection getConnection() throws BrokerException {
        return this.dbpool.getConnection();
    }

    public void freeConnection(Connection connection, Throwable throwable) throws BrokerException {
        this.dbpool.freeConnection(connection, throwable);
    }

    protected void checkMaxTableNameLength(int n) throws BrokerException {
        if (n > 0) {
            int n2 = 11;
            if (this.isOracle()) {
                n2 += 4;
            }
            if (this.clusterID.length() + n2 + 1 > n) {
                Object[] objectArray = new Object[]{this.clusterID, n, n2 + 1};
                throw new BrokerException(this.br.getKString("B3179", objectArray));
            }
        }
    }

    protected boolean isStoreInited() {
        return this.storeInited;
    }

    protected void setStoreInited(boolean bl) {
        this.storeInited = bl;
    }

    private ShareConfigChangeDBManager() throws BrokerException {
        this.initDBManagerProps();
        this.initDBDriver();
    }

    protected void initTableSuffix() throws BrokerException {
        this.clusterID = Globals.getClusterID();
        if (this.clusterID == null || this.clusterID.length() == 0 || !Util.isAlphanumericString(this.clusterID)) {
            throw new BrokerException(this.br.getKString("B3178", this.clusterID));
        }
        this.tableSuffix = "C" + this.clusterID;
    }

    public Hashtable getDebugState() {
        Hashtable hashtable = super.getDebugState();
        hashtable.put("clusterID", "" + this.clusterID);
        hashtable.put(this.dbpool.toString(), this.dbpool.getDebugState());
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareConfigRecordDAOFactory getDAOFactory() {
        Object object = classLock;
        synchronized (object) {
            if (this.daoFactory == null) {
                this.daoFactory = new ShareConfigRecordDAOFactory();
            }
        }
        return this.daoFactory;
    }

    protected BaseDAO getFirstDAO() throws BrokerException {
        return (BaseDAO)this.getDAOFactory().getAllDAOs().get(0);
    }

    public Iterator allDAOIterator() throws BrokerException {
        return this.getDAOFactory().getAllDAOs().iterator();
    }

    String getClusterID() {
        return this.clusterID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        Object object = classLock;
        synchronized (object) {
            this.dbpool.close();
            super.close();
            dbMgr = null;
        }
    }

    public String[] getTableNames(int n) {
        return this.tableSchemas.keySet().toArray(new String[0]);
    }

    public int checkStoreExists(Connection connection) throws BrokerException {
        return super.checkStoreExists(connection, "45");
    }

    public boolean hasSupplementForCreateDrop(String string) {
        return true;
    }

    public void lockTable(Connection connection, boolean bl) throws BrokerException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeSQLObjects(ResultSet resultSet, Statement statement, Connection connection, Throwable throwable) throws BrokerException {
        try {
            block5: {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement == null) break block5;
                    statement.close();
                }
                catch (SQLException sQLException) {
                    throw new BrokerException(this.br.getKString("B3250", sQLException.toString()), sQLException);
                }
            }
            Object var7_5 = null;
            if (connection == null) return;
            this.freeConnection(connection, throwable);
            return;
        }
        catch (Throwable throwable2) {
            Object var7_6 = null;
            if (connection == null) throw throwable2;
            this.freeConnection(connection, throwable);
            throw throwable2;
        }
    }
}

