/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.persist.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConfigRecordDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigRecordDAOImpl
extends BaseDAOImpl
implements ConfigRecordDAO {
    protected String tableName;
    protected String insertSQL;
    protected String selectRecordsSinceSQL;
    protected String selectAllSQL;

    ConfigRecordDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        this.tableName = dBManager.getTableName("MQCREC41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("RECORD").append(", ").append("CREATED_TS").append(") VALUES ( ?, ? )").toString();
        this.selectRecordsSinceSQL = new StringBuffer(128).append("SELECT ").append("RECORD").append(", ").append("CREATED_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("CREATED_TS").append(" > ?").toString();
        this.selectAllSQL = new StringBuffer(128).append("SELECT ").append("RECORD").append(", ").append("CREATED_TS").append(" FROM ").append(this.tableName).toString();
    }

    @Override
    public final String getTableNamePrefix() {
        return "MQCREC41";
    }

    @Override
    public final String getTableName() {
        return this.tableName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void insert(Connection connection, byte[] byArray, long l) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        block12: {
            boolean bl = false;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.insertSQL);
                    Util.setBytes(preparedStatement, 1, byArray);
                    preparedStatement.setLong(2, l);
                    preparedStatement.executeUpdate();
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", (Throwable)sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4083", String.valueOf(l)), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4083", String.valueOf(l)), exception3);
                }
                Object var11_7 = null;
                if (!bl) break block12;
            }
            catch (Throwable throwable) {
                Object var11_8 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ChangeRecordInfo> getRecordsSince(Connection connection, long l) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        ArrayList<ChangeRecordInfo> arrayList;
        block15: {
            arrayList = new ArrayList<ChangeRecordInfo>();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectRecordsSinceSQL);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        try {
                            byte[] byArray = Util.readBytes(resultSet, 1);
                            arrayList.add(new ChangeRecordInfo(byArray, 0L));
                        }
                        catch (IOException iOException) {
                            IOException iOException2 = DBManager.wrapIOException("[" + this.selectRecordsSinceSQL + "]", iOException);
                            this.logger.logStack(32, "B4123", (Object)resultSet.getString(2), (Throwable)iOException2);
                        }
                    }
                    Object var12_14 = null;
                    if (!bl) break block15;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", (Throwable)sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectRecordsSinceSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4082"), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4082"), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return arrayList;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ChangeRecordInfo> getAllRecords(Connection connection) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        ArrayList<ChangeRecordInfo> arrayList;
        block15: {
            arrayList = new ArrayList<ChangeRecordInfo>();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllSQL);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        long l = -1L;
                        try {
                            l = resultSet.getLong(2);
                            byte[] byArray = Util.readBytes(resultSet, 1);
                            arrayList.add(new ChangeRecordInfo(byArray, l));
                        }
                        catch (IOException iOException) {
                            IOException iOException2 = DBManager.wrapIOException("[" + this.selectAllSQL + "]", iOException);
                            this.logger.logStack(32, "B4123", (Object)String.valueOf(l), (Throwable)iOException2);
                        }
                    }
                    Object var12_12 = null;
                    if (!bl) break block15;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", (Throwable)sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectAllSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4082"), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4082"), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return arrayList;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return arrayList;
    }

    @Override
    public HashMap getDebugInfo(Connection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = -1;
        try {
            n = this.getRowCount(null, null);
        }
        catch (Exception exception) {
            this.logger.log(32, exception.getMessage(), exception.getCause());
        }
        hashMap.put("Config Change Records(" + this.tableName + ")", String.valueOf(n));
        return hashMap;
    }
}

