/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.io.PortMapperEntry;
import com.sun.messaging.jmq.io.PortMapperTable;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.LockFile;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.net.MQServerSocketFactory;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.service.PortMapperClientHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;

public class PortMapper
implements Runnable,
ConfigListener,
PortMapperClientHandler {
    public static final int PORTMAPPER_DEFAULT_PORT = 7676;
    public static final String HOSTNAME_PROPERTY = "imq.portmapper.hostname";
    private static final String IMQHOSTNAME_PROPERTY = "imq.hostname";
    private static final String PORT_PROPERTY = "imq.portmapper.port";
    public static final String BIND_PROPERTY = "imq.portmapper.bind";
    private static final String BACKLOG_PROPERTY = "imq.portmapper.backlog";
    private static final String SOTIMEOUT_PROPERTY = "imq.portmapper.sotimeout";
    private static final String SOLINGER_PROPERTY = "imq.portmapper.solinger";
    static final String SERVICE_NAME = "portmapper";
    private static boolean DEBUG = false;
    private Logger logger = null;
    private BrokerResources rb = null;
    private BrokerConfig bc = Globals.getConfig();
    private PortMapperTable portMapTable = null;
    private ServerSocket serverSocket = null;
    private int port = 0;
    private boolean doBind = true;
    private int backlog = 100;
    private int sotimeout = 100;
    private int solinger = -1;
    private InetAddress bindAddr = null;
    private String hostname = null;
    private HashMap portmapperMap = null;
    private MQAddress mqaddress = null;
    private boolean running = true;
    private static MQServerSocketFactory ssf = (MQServerSocketFactory)MQServerSocketFactory.getDefault();

    public void updateProperties() {
        this.portmapperMap = new HashMap();
        if (Globals.getBrokerID() != null) {
            this.portmapperMap.put("brokerid", Globals.getBrokerID());
        }
        if (Globals.getBrokerSessionID() != null) {
            this.portmapperMap.put("sessionid", Globals.getBrokerSessionID().toString());
            String string = Globals.getConfig().getProperty("imq.home");
            if (string != null && !string.equals("")) {
                this.portmapperMap.put("imqhome", string);
            }
            if ((string = Globals.getConfig().getProperty("imq.varhome")) != null && !string.equals("")) {
                this.portmapperMap.put("imqvarhome", string);
            }
        }
        this.updateServiceProperties(SERVICE_NAME, this.portmapperMap);
    }

    public PortMapper(String string) {
        if (!this.bc.getBooleanProperty("imq.portmapper.reuseAddress", true)) {
            ssf.setReuseAddress(false);
        }
        this.portMapTable = new PortMapperTable();
        this.portMapTable.setBrokerInstanceName(string);
        this.portMapTable.setBrokerVersion(Globals.getVersion().getProductVersion());
        this.logger = Globals.getLogger();
        this.rb = Globals.getBrokerResources();
        this.addService(SERVICE_NAME, "tcp", "PORTMAPPER", this.port, this.portmapperMap);
        this.addService("cluster_discovery", "tcp", "CLUSTER_DISCOVERY", 0, null);
        this.bc.addListener(PORT_PROPERTY, this);
        this.bc.addListener(BACKLOG_PROPERTY, this);
    }

    public void destroy() {
        this.running = false;
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
            this.logger.logStack(8, "Error closing portmapper", (Throwable)iOException);
        }
        this.serverSocket = null;
    }

    public void setParameters(BrokerConfig brokerConfig) throws PropertyUpdateException {
        this.doBind = brokerConfig.getBooleanProperty(BIND_PROPERTY, true);
        String string = brokerConfig.getProperty(HOSTNAME_PROPERTY);
        if (string == null || string.trim().length() == 0) {
            string = brokerConfig.getProperty(IMQHOSTNAME_PROPERTY);
        }
        this.validate(HOSTNAME_PROPERTY, string);
        this.update(HOSTNAME_PROPERTY, string);
        string = brokerConfig.getProperty(PORT_PROPERTY);
        this.validate(PORT_PROPERTY, string);
        this.update(PORT_PROPERTY, string);
        string = brokerConfig.getProperty(BACKLOG_PROPERTY);
        this.validate(BACKLOG_PROPERTY, string);
        this.update(BACKLOG_PROPERTY, string);
        string = brokerConfig.getProperty(SOTIMEOUT_PROPERTY);
        if (string != null) {
            this.validate(SOTIMEOUT_PROPERTY, string);
            this.update(SOTIMEOUT_PROPERTY, string);
        }
        if ((string = brokerConfig.getProperty(SOLINGER_PROPERTY)) != null) {
            this.validate(SOLINGER_PROPERTY, string);
            this.update(SOLINGER_PROPERTY, string);
        }
    }

    private synchronized void setPort(int n) {
        if (n == this.port) {
            return;
        }
        this.port = n;
        this.addService(SERVICE_NAME, "tcp", "PORTMAPPER", n, this.portmapperMap);
        LockFile lockFile = LockFile.getCurrentLockFile();
        try {
            if (lockFile != null) {
                lockFile.updatePort(n);
            }
        }
        catch (IOException iOException) {
            this.logger.log(16, "B3088", (Throwable)iOException);
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    public synchronized void setHostname(String string) throws PropertyUpdateException {
        Object object;
        MQAddress mQAddress = null;
        try {
            object = string;
            if (string != null && string.equals("*")) {
                object = null;
            }
            mQAddress = MQAddress.getMQAddress((String)object, (int)this.getPort());
        }
        catch (Exception exception) {
            throw new PropertyUpdateException(2, string + ": " + exception.toString(), exception);
        }
        if (string == null || string.equals("*") || string.trim().length() == 0) {
            this.hostname = null;
            this.bindAddr = null;
            this.mqaddress = mQAddress;
            return;
        }
        if (string.equals(this.hostname)) {
            return;
        }
        try {
            if (Globals.isConfigForCluster()) {
                object = string;
                if (object != null && ((String)object).equals("localhost")) {
                    object = null;
                }
                this.bindAddr = BrokerMQAddress.resolveBindAddress((String)object, true);
                mQAddress = MQAddress.getMQAddress((String)this.bindAddr.getHostAddress(), (int)this.getPort());
            } else {
                this.bindAddr = InetAddress.getByName(string);
            }
        }
        catch (Exception exception) {
            throw new PropertyUpdateException(2, this.rb.getString("B3150", string), exception);
        }
        this.hostname = string;
        this.mqaddress = mQAddress;
        object = LockFile.getCurrentLockFile();
        try {
            if (object != null) {
                ((LockFile)object).updateHostname(this.mqaddress.getHostName());
            }
        }
        catch (IOException iOException) {
            this.logger.log(16, "B3088", (Throwable)iOException);
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public MQAddress getMQAddress() {
        return this.mqaddress;
    }

    public InetAddress getBindAddress() {
        return this.bindAddr;
    }

    public synchronized void setBacklog(int n) {
        this.backlog = n;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public synchronized void addService(String string, String string2, String string3, int n, HashMap hashMap) {
        PortMapperEntry portMapperEntry = new PortMapperEntry();
        portMapperEntry.setName(string);
        portMapperEntry.setProtocol(string2);
        portMapperEntry.setType(string3);
        portMapperEntry.setPort(n);
        if (hashMap != null) {
            portMapperEntry.addProperties(hashMap);
        }
        this.portMapTable.add(portMapperEntry);
    }

    public synchronized void updateServicePort(String string, int n) {
        PortMapperEntry portMapperEntry = this.portMapTable.get(string);
        if (portMapperEntry != null) {
            portMapperEntry.setPort(n);
        }
    }

    public synchronized void updateServiceProperties(String string, HashMap hashMap) {
        PortMapperEntry portMapperEntry = this.portMapTable.get(string);
        if (portMapperEntry != null) {
            portMapperEntry.addProperties(hashMap);
        }
    }

    public synchronized void addService(String string, PortMapperEntry portMapperEntry) {
        this.portMapTable.add(portMapperEntry);
    }

    public synchronized void removeService(String string) {
        this.portMapTable.remove(string);
    }

    public synchronized Map getServices() {
        return this.portMapTable.getServices();
    }

    public synchronized String toString() {
        return this.portMapTable.toString();
    }

    public synchronized void bind() {
        if (this.doBind) {
            this.serverSocket = this.createPortMapperServerSocket(this.port, this.bindAddr);
        }
    }

    public synchronized ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    private ServerSocket createPortMapperServerSocket(int n, InetAddress inetAddress) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = ssf.createServerSocket(n, this.backlog, inetAddress);
        }
        catch (BindException bindException) {
            this.logger.log(32, "B3068", (Object)SERVICE_NAME, (Object)new Integer(n));
            return null;
        }
        catch (IOException iOException) {
            this.logger.log(32, "B3022", (Object)SERVICE_NAME, (Object)new Integer(n), (Throwable)iOException);
            return null;
        }
        Object[] objectArray = new Object[]{SERVICE_NAME, "tcp [ " + n + ", " + this.backlog + ", " + (inetAddress != null ? inetAddress.getHostAddress() : "*") + " ]", new Integer(1), new Integer(1)};
        this.logger.log(8, "B1004", objectArray);
        return serverSocket;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        var1_1 = BrokerStateHandler.getRestartCode();
        var2_2 = this.rb.getKString("B0081");
        var3_3 = this.rb.getKString("B0079");
        var4_4 = null;
        var5_5 = false;
        try {
            if (this.serverSocket == null) {
                this.serverSocket = this.createPortMapperServerSocket(this.port, this.bindAddr);
            }
            if (PortMapper.DEBUG && this.serverSocket != null) {
                this.logger.log(4, "PortMapper: " + this.serverSocket + " " + MQServerSocketFactory.serverSocketToString((ServerSocket)this.serverSocket) + ", backlog=" + this.backlog + "");
            }
            var6_6 = true;
            while (this.running) {
                block51: {
                    if (this.serverSocket != null) break block51;
                    this.logger.log(32, "B3070");
                    var10_15 = null;
                    ** GOTO lbl115
                }
                try {
                    var4_4 = this.serverSocket.accept();
                    var6_6 = true;
                }
                catch (SocketException var7_9) {
                    block53: {
                        block52: {
                            if (var7_9 instanceof BindException || var7_9 instanceof ConnectException) break block52;
                            if (!(var7_9 instanceof NoRouteToHostException)) break block53;
                        }
                        this.logger.log(32, "B3069", (Throwable)var7_9);
                        PortMapper.sleep(1);
                        continue;
                    }
                    if (!this.running) ** GOTO lbl136
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException var8_13) {
                    }
                    catch (NullPointerException var8_14) {
                        if (!this.running) ** GOTO lbl136
                    }
                    this.serverSocket = this.createPortMapperServerSocket(this.port, this.bindAddr);
                    continue;
                    {
                    }
                }
                catch (IOException var7_10) {
                    this.logger.logStack(32, "B3069", (Throwable)var7_10);
                    PortMapper.sleep(1);
                    continue;
                }
                catch (OutOfMemoryError var7_11) {
                    if (this.running) {
                        if (var6_6) {
                            var6_6 = false;
                            Globals.handleGlobalError(var7_11, var3_3);
                            PortMapper.sleep(1);
                            continue;
                        }
                        Broker.getBroker().exit(var1_1, var2_2, BrokerEvent.Type.RESTART, null, false, false, true);
                        var10_16 = null;
                        try {
                            try {
                                if (var4_4 != null) {
                                    var4_4.close();
                                }
                                if (this.serverSocket != null) {
                                    this.serverSocket.close();
                                }
                            }
                            catch (IOException var11_21) {
                                // empty catch block
                            }
                            if (var5_5 && this.running) {
                                this.logger.log(32, var2_2);
                                Broker.getBroker().exit(var1_1, var2_2, BrokerEvent.Type.RESTART, null, false, false, true);
                            }
                            if (this.running == false) return;
                            this.logger.log(8, "B0082");
                            return;
                        }
                        catch (OutOfMemoryError var11_22) {
                            if (this.running == false) return;
                            Broker.getBroker().exit(var1_1, var2_2, BrokerEvent.Type.RESTART, null, false, false, true);
                        }
                        return;
                    }
                    ** GOTO lbl136
                }
                this.handleSocket(var4_4);
            }
            ** GOTO lbl136
        }
        catch (OutOfMemoryError var6_7) {
            var5_5 = true;
            throw var6_7;
        }
        {
            block56: {
                block55: {
                    catch (Throwable var9_27) {
                        block54: {
                            var10_18 = null;
                            ** try [egrp 4[TRYBLOCK] [13 : 409->501)] { 
lbl95:
                            // 1 sources

                            ** try [egrp 5[TRYBLOCK] [12 : 409->436)] { 
lbl96:
                            // 1 sources

                            if (var4_4 != null) {
                                var4_4.close();
                            }
                            if (this.serverSocket != null) {
                                this.serverSocket.close();
                            }
                            break block54;
lbl101:
                            // 1 sources

                            catch (IOException var11_25) {
                                // empty catch block
                            }
                        }
                        if (var5_5 && this.running) {
                            this.logger.log(32, var2_2);
                            Broker.getBroker().exit(var1_1, var2_2, BrokerEvent.Type.RESTART, null, false, false, true);
                        }
                        if (this.running == false) throw var9_27;
                        this.logger.log(8, "B0082");
                        throw var9_27;
lbl111:
                        // 1 sources

                        catch (OutOfMemoryError var11_26) {
                            if (this.running == false) throw var9_27;
                            Broker.getBroker().exit(var1_1, var2_2, BrokerEvent.Type.RESTART, null, false, false, true);
                        }
                        throw var9_27;
                    }
lbl115:
                    // 1 sources

                    ** try [egrp 4[TRYBLOCK] [13 : 409->501)] { 
lbl116:
                    // 1 sources

                    ** try [egrp 5[TRYBLOCK] [12 : 409->436)] { 
lbl117:
                    // 1 sources

                    if (var4_4 != null) {
                        var4_4.close();
                    }
                    if (this.serverSocket != null) {
                        this.serverSocket.close();
                    }
                    break block55;
lbl122:
                    // 1 sources

                    catch (IOException var11_19) {
                        // empty catch block
                    }
                }
                if (var5_5 && this.running) {
                    this.logger.log(32, var2_2);
                    Broker.getBroker().exit(var1_1, var2_2, BrokerEvent.Type.RESTART, null, false, false, true);
                }
                if (this.running == false) return;
                this.logger.log(8, "B0082");
                return;
lbl132:
                // 1 sources

                catch (OutOfMemoryError var11_20) {
                    if (this.running == false) return;
                    Broker.getBroker().exit(var1_1, var2_2, BrokerEvent.Type.RESTART, null, false, false, true);
                }
                return;
lbl136:
                // 4 sources

                var10_17 = null;
                try {}
                catch (OutOfMemoryError var11_24) {}
                if (this.running == false) return;
                Broker.getBroker().exit(var1_1, var2_2, BrokerEvent.Type.RESTART, null, false, false, true);
                return;
                ** try [egrp 5[TRYBLOCK] [12 : 409->436)] { 
lbl143:
                // 1 sources

                if (var4_4 != null) {
                    var4_4.close();
                }
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
                break block56;
lbl148:
                // 1 sources

                catch (IOException var11_23) {
                    // empty catch block
                }
            }
            if (var5_5 && this.running) {
                this.logger.log(32, var2_2);
                Broker.getBroker().exit(var1_1, var2_2, BrokerEvent.Type.RESTART, null, false, false, true);
            }
            if (this.running == false) return;
            this.logger.log(8, "B0082");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void handleSocket(Socket socket) {
        block26: {
            String string = this.rb.getKString("B0080");
            if (!socket.isConnected()) {
                this.logger.log(4, "PortMapper: accepted client connection (" + socket.toString() + ") that is" + " no longer connected. Ignoring.");
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            PortMapper portMapper = this;
            synchronized (portMapper) {
                socket.setSoTimeout(this.sotimeout);
                if (this.solinger > 0) {
                    socket.setSoLinger(true, this.solinger);
                }
                InputStream inputStream = socket.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string2 = "";
                try {
                    string2 = bufferedReader.readLine();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    // empty catch block
                }
                this.portMapTable.write(socket.getOutputStream());
                try {
                    int n = 0;
                    while (bufferedReader.readLine() != null && ++n < 5) {
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    // empty catch block
                }
            }
            Object var10_16 = null;
            try {
                socket.close();
            }
            catch (IOException iOException) {}
            break block26;
            {
                catch (IOException iOException) {
                    InetAddress inetAddress = socket.getInetAddress();
                    this.logger.logStack(16, "B3164", (Object)inetAddress.getHostAddress(), (Throwable)iOException);
                    Object var10_17 = null;
                    try {
                        socket.close();
                    }
                    catch (IOException iOException2) {}
                    break block26;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    if (!this.running) {
                        Object var10_18 = null;
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return;
                    }
                    this.logger.log(16, string);
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    Globals.handleGlobalError(outOfMemoryError, string);
                    PortMapper.sleep(1);
                    Object var10_19 = null;
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_20 = null;
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void handleRequest(SocketChannel socketChannel) {
        if (this.doBind) {
            throw new IllegalStateException("Should not call PortMapper.handleRequest() unless Broker has been started with the -noBind argument");
        }
        this.handleSocket(socketChannel.socket());
    }

    public void validate(String string, String string2) throws PropertyUpdateException {
        if (!(string.equals(PORT_PROPERTY) || string.equals(BACKLOG_PROPERTY) || string.equals(SOLINGER_PROPERTY) || string.equals(HOSTNAME_PROPERTY) || string.equals(SOTIMEOUT_PROPERTY))) {
            throw new PropertyUpdateException(this.rb.getString("B4028", string));
        }
        if (string.equals(HOSTNAME_PROPERTY)) {
            if (string2 == null || string2.trim().length() == 0 || string2.equals("*")) {
                return;
            }
            try {
                if (Globals.isConfigForCluster()) {
                    BrokerMQAddress.resolveBindAddress(string2, true);
                } else {
                    InetAddress.getByName(string2);
                }
            }
            catch (Exception exception) {
                throw new PropertyUpdateException(2, this.rb.getKString("B3151", string2, string) + ": " + exception.toString(), exception);
            }
            return;
        }
        int n = this.getIntProperty(string, string2);
        if (string.equals(PORT_PROPERTY)) {
            if (n == this.port) {
                return;
            }
            if (this.isDoBind()) {
                try {
                    PortMapper.canBind(n, this.bindAddr);
                }
                catch (BindException bindException) {
                    throw new PropertyUpdateException(this.rb.getKString("B3068", SERVICE_NAME, string2) + "\n" + bindException.toString());
                }
                catch (IOException iOException) {
                    throw new PropertyUpdateException(this.rb.getKString("B3022", SERVICE_NAME, string2) + "\n" + iOException.toString());
                }
            }
        }
    }

    public boolean update(String string, String string2) {
        try {
            if (string.equals(PORT_PROPERTY)) {
                this.setPort(this.getIntProperty(string, string2));
                if (this.mqaddress != null) {
                    this.mqaddress = MQAddress.getMQAddress((String)(this.mqaddress.getHostName() + ":" + this.getPort()));
                }
            } else if (string.equals(BACKLOG_PROPERTY)) {
                this.setBacklog(this.getIntProperty(string, string2));
            } else if (string.equals(SOTIMEOUT_PROPERTY)) {
                this.sotimeout = this.getIntProperty(string, string2);
            } else if (string.equals(SOLINGER_PROPERTY)) {
                this.solinger = this.getIntProperty(string, string2);
            } else {
                this.setHostname(string2);
            }
        }
        catch (Exception exception) {
            this.logger.log(32, this.rb.getString("B4027", string + "=" + string2), (Throwable)exception);
            return false;
        }
        return true;
    }

    public int getIntProperty(String string, String string2) throws PropertyUpdateException {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PropertyUpdateException(this.rb.getString("B4027", string + "=" + string2));
        }
    }

    public static void sleep(int n) {
        try {
            Thread.sleep((long)n * 1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void canBind(int n, InetAddress inetAddress) throws IOException {
        ServerSocket serverSocket = null;
        serverSocket = ssf.createServerSocket(n, 0, inetAddress);
        serverSocket.close();
    }

    public boolean isDoBind() {
        return this.doBind;
    }

    public static String getBrokerAtPort(String string, int n) throws IOException {
        InetAddress inetAddress = null;
        inetAddress = string == null ? InetAddress.getLocalHost() : InetAddress.getByName(string);
        String string2 = String.valueOf(101) + "\n";
        Socket socket = new Socket(inetAddress, n);
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        try {
            outputStream.write(string2.getBytes());
            outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PortMapperTable portMapperTable = new PortMapperTable();
        portMapperTable.read(inputStream);
        return portMapperTable.getBrokerInstanceName();
    }
}

