/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.connectors.jms.util.JmsRaUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.jms.admin.cli.JMSDestination;
import org.glassfish.jms.admin.cli.MQJMXConnectorInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="flush-jmsdest")
@Scoped(value=PerLookup.class)
@I18n(value="flush.jms.dest")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class FlushJMSDestination
extends JMSDestination
implements AdminCommand {
    static Logger logger = LogDomains.getLogger(FlushJMSDestination.class, (String)"javax.enterprise.system.tools.admin");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(FlushJMSDestination.class);
    private static final String DESTINATION_CONFIG_DOMAIN_TYPE = "com.sun.messaging.jms.server:type=Destination,subtype=Config";
    @Param(name="destType", shortName="T", optional=false)
    String destType;
    @Param(name="dest_name", primary=true)
    String destName;
    @Param(optional=true)
    String target = "server";
    @Inject
    ConnectorRuntime connectorRuntime;
    @Inject
    Domain domain;
    @Inject(name="default-instance-name")
    Config config;
    @Inject
    ServerContext serverContext;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        logger.entering(this.getClass().getName(), "flushJMSDestination", new Object[]{this.destName, this.destType});
        try {
            this.validateJMSDestName(this.destName);
            this.validateJMSDestType(this.destType);
        }
        catch (IllegalArgumentException e) {
            report.setMessage(e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            this.flushJMSDestination(this.destName, this.destType, this.target);
            return;
        }
        catch (Exception e) {
            logger.throwing(this.getClass().getName(), "flushJMSDestination", e);
            report.setMessage(localStrings.getLocalString("flush.jms.dest.failed", "Flush JMS Destination failed", new Object[]{e.getMessage()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
    }

    private void flushJMSDestination(String destName, String destType, String tgtName) throws Exception {
        logger.log(Level.FINE, "FlushJMSDestination ...");
        try {
            CommandTarget ctarget = this.getTypeForTarget(this.target);
            if (ctarget == CommandTarget.CLUSTER || ctarget == CommandTarget.CLUSTERED_INSTANCE) {
                boolean success = true;
                Cluster cluster = null;
                if (ctarget == CommandTarget.CLUSTER) {
                    cluster = ((Domain)Globals.get(Domain.class)).getClusterNamed(this.target);
                } else {
                    List clustersList = ((Domain)Globals.get(Domain.class)).getClusters().getCluster();
                    cluster = JmsRaUtil.getClusterForServer((List)clustersList, (String)this.target);
                }
                List servers = cluster.getInstances();
                for (int server = 0; server < servers.size(); ++server) {
                    try {
                        this.purgeJMSDestination(destName, destType, ((Server)servers.get(server)).getName());
                        continue;
                    }
                    catch (Exception e) {
                        success = false;
                        logger.log(Level.SEVERE, ((Server)servers.get(server)).getName());
                    }
                }
                if (!success) {
                    throw new Exception();
                }
            } else {
                this.purgeJMSDestination(destName, destType, tgtName);
            }
        }
        catch (Exception e) {
            logger.throwing(this.getClass().getName(), "flushJMSDestination", e);
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeJMSDestination(String destName, String destType, String tgtName) throws Exception {
        logger.log(Level.FINE, "purgeJMSDestination ...");
        MQJMXConnectorInfo mqInfo = this.getMQJMXConnectorInfo(this.target, this.config, this.serverContext, this.domain, this.connectorRuntime);
        try {
            MBeanServerConnection mbsc = mqInfo.getMQMBeanServerConnection();
            if (destType.equalsIgnoreCase("topic")) {
                destType = "t";
            } else if (destType.equalsIgnoreCase("queue")) {
                destType = "q";
            }
            ObjectName on = this.createDestinationConfig(destType, destName);
            String[] signature = null;
            Object[] params = null;
            mbsc.invoke(on, "purge", params, signature);
        }
        catch (Exception e) {
            this.logAndHandleException(e, "admin.mbeans.rmb.error_purging_jms_dest");
        }
        finally {
            try {
                if (mqInfo != null) {
                    mqInfo.closeMQMBeanServerConnection();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private ObjectName createDestinationConfig(String destinationType, String destinationName) throws MalformedObjectNameException, NullPointerException {
        String s = "com.sun.messaging.jms.server:type=Destination,subtype=Config,desttype=" + destinationType + ",name=" + ObjectName.quote(destinationName);
        ObjectName o = new ObjectName(s);
        return o;
    }
}

