/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.resource.common.PoolInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@Service(name="jms-ping")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="jms-ping")
public class JMSPing
implements AdminCommand {
    @Param(optional=true)
    String target = "server";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JMSPing.class);
    @Inject
    private ConnectorRuntime connectorRuntime;
    @Inject(name="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    @Inject
    CommandRunner commandRunner;

    public void execute(AdminCommandContext context) {
        Cluster cluster;
        ActionReport report = context.getActionReport();
        Server targetServer = this.domain.getServerNamed(this.target);
        if (targetServer != null) {
            this.config = this.domain.getConfigNamed(targetServer.getConfigRef());
        }
        if ((cluster = this.domain.getClusterNamed(this.target)) != null) {
            this.config = this.domain.getConfigNamed(cluster.getConfigRef());
        }
        JmsService jmsservice = this.config.getJmsService();
        String defaultJmshostStr = jmsservice.getDefaultJmsHost();
        JmsHost defaultJmsHost = null;
        for (JmsHost jmshost : jmsservice.getJmsHost()) {
            if (!defaultJmshostStr.equals(jmshost.getName())) continue;
            defaultJmsHost = jmshost;
        }
        String tmpJMSResource = "test_jms_adapter";
        ActionReport subReport = report.addSubActionsReport();
        this.createJMSResource(defaultJmsHost, subReport, tmpJMSResource);
        if (ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) {
            report.setMessage(localStrings.getLocalString("jms-ping.cannotCreateJMSResource", "Unable to create a temporary Connection Factory to the JMS Host"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            boolean value = this.pingConnectionPool(tmpJMSResource);
            if (!value) {
                report.setMessage(localStrings.getLocalString("jms-ping.pingConnectionPoolFailed", "Pinging to the JMS Host failed."));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            } else {
                report.setMessage(localStrings.getLocalString("jms-ping.pingConnectionPoolSuccess", "JMS-ping command executed successfully"));
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            }
        }
        catch (ResourceException e) {
            report.setMessage(localStrings.getLocalString("jms-ping.pingConnectionPoolException", "An exception occured while trying to ping the JMS Host.", new Object[]{e.getMessage()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        this.deleteJMSResource(subReport, tmpJMSResource);
        if (ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) {
            report.setMessage(localStrings.getLocalString("jms-ping.cannotdeleteJMSResource", "Unable to delete the temporary JMS Resource " + tmpJMSResource + ". Please delete this manually.", new Object[]{tmpJMSResource}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
    }

    void createJMSResource(JmsHost defaultJmsHost, ActionReport subReport, String tmpJMSResource) {
        String userName = defaultJmsHost.getAdminUserName();
        String password = defaultJmsHost.getAdminPassword();
        String host = defaultJmsHost.getHost();
        String port = defaultJmsHost.getPort();
        ParameterMap aoAttrList = new ParameterMap();
        Properties properties = new Properties();
        properties.put("imqDefaultUsername", userName);
        if (this.isPasswordAlias(password)) {
            properties.put("imqDefaultPassword", "\"" + password + "\"");
        } else {
            properties.put("imqDefaultPassword", password);
        }
        properties.put("AddressList", "\"mq://" + host + ":" + port + "\"");
        String propString = "";
        for (Map.Entry<Object, Object> prop : properties.entrySet()) {
            propString = propString + prop.getKey() + "=" + prop.getValue() + ":";
        }
        propString = propString.substring(0, propString.length());
        aoAttrList.set((Object)"property", (Object)propString);
        aoAttrList.set((Object)"restype", (Object)"javax.jms.QueueConnectionFactory");
        aoAttrList.set((Object)"DEFAULT", (Object)tmpJMSResource);
        aoAttrList.set((Object)"target", (Object)this.target);
        this.commandRunner.getCommandInvocation("create-jms-resource", subReport).parameters(aoAttrList).execute();
    }

    private boolean isPasswordAlias(String password) {
        return password != null && password.contains("${ALIAS");
    }

    boolean pingConnectionPool(String tmpJMSResource) throws ResourceException {
        PoolInfo poolInfo = new PoolInfo(tmpJMSResource);
        return this.connectorRuntime.pingConnectionPool(poolInfo);
    }

    void deleteJMSResource(ActionReport subReport, String tmpJMSResource) {
        ParameterMap aoAttrList = new ParameterMap();
        aoAttrList.set((Object)"DEFAULT", (Object)tmpJMSResource);
        aoAttrList.set((Object)"target", (Object)this.target);
        this.commandRunner.getCommandInvocation("delete-jms-resource", subReport).parameters(aoAttrList).execute();
    }
}

