/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core.cluster;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.core.cluster.RemoteTransactionAckEntry;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.AckEntryNotFoundException;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.ConsumerAlreadyAddedException;
import com.sun.messaging.jmq.jmsserver.util.MQThread;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Prioritized;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

class BrokerConsumers
implements Runnable,
EventListener {
    private static boolean DEBUG = false;
    private static boolean DEBUG_CLUSTER_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn");
    private static boolean DEBUG_CLUSTER_MSG = Globals.getConfig().getBooleanProperty("imq.cluster.debug.msg");
    Thread thr = null;
    Logger logger = Globals.getLogger();
    Protocol protocol = null;
    boolean valid = true;
    Set activeConsumers = Collections.synchronizedSet(new HashSet());
    Map consumers = Collections.synchronizedMap(new HashMap());
    Map listeners = Collections.synchronizedMap(new HashMap());
    private FaultInjection fi = null;
    public static int BTOBFLOW;
    Map deliveredMessages = new LinkedHashMap();
    Map pendingConsumerUIDs = Collections.synchronizedMap(new LinkedHashMap());
    Map cleanupList = new HashMap();
    private Object removeConsumerLock = new Object();

    public BrokerConsumers(Protocol protocol) {
        this.protocol = protocol;
        this.fi = FaultInjection.getInjection();
        MQThread mQThread = new MQThread(this, "Broker Monitor");
        mQThread.setDaemon(true);
        mQThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Object object2;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        ArrayList<Object> arrayList = null;
        Iterator<Object> iterator = this.deliveredMessages;
        synchronized (iterator) {
            arrayList = new ArrayList(this.deliveredMessages.values());
        }
        hashtable.put("CLUSTER_ROUTER:deliveredMessagesCount", arrayList.size());
        for (ackEntry serializable2 : arrayList) {
            object2 = serializable2.getSysMessageID();
            hashtable.put("[deliveredMessages]" + object2.toString(), serializable2.toString());
        }
        Map map = this.consumers;
        synchronized (map) {
            arrayList = new ArrayList(this.consumers.keySet());
        }
        hashtable.put("consumersCount", arrayList.size());
        for (ConsumerUID consumerUID : arrayList) {
            object2 = (Consumer)this.consumers.get(consumerUID);
            if (object2 instanceof Subscription) {
                hashtable.put("[consumers]" + consumerUID.toString(), "Subscription: " + object2);
                continue;
            }
            hashtable.put("[consumers]" + consumerUID.toString(), ((Consumer)object2).toString());
        }
        Set set = this.activeConsumers;
        synchronized (set) {
            arrayList = new ArrayList(this.activeConsumers);
        }
        hashtable.put("activeConsumersCount", arrayList.size());
        Vector<String> vector = new Vector<String>();
        for (Object object2 : arrayList) {
            if (object2 instanceof Subscription) {
                vector.add("Subscription: " + object2);
                continue;
            }
            vector.add(((Consumer)object2).toString());
        }
        hashtable.put("activeConsumers", vector);
        object2 = this.pendingConsumerUIDs;
        synchronized (object2) {
            arrayList = new ArrayList(this.pendingConsumerUIDs.keySet());
        }
        hashtable.put("pendingConsumerUIDsCount", arrayList.size());
        for (Object object2 : arrayList) {
            Map map2 = this.deliveredMessages;
            synchronized (map2) {
                Set set2 = (Set)this.pendingConsumerUIDs.get(object2);
                if (set2 == null) {
                    hashtable.put("[pendingConsumerUIDs]" + ((ConsumerUID)object2).toString(), "null");
                } else {
                    Vector vector2 = new Vector(set2);
                    if (vector2.size() == 0) {
                        hashtable.put("[pendingConsumerUIDs]" + ((ConsumerUID)object2).toString(), "none");
                    } else {
                        hashtable.put("[pendingConsumerUIDs]" + ((ConsumerUID)object2).toString(), vector2);
                    }
                }
            }
        }
        object2 = this.cleanupList;
        synchronized (object2) {
            arrayList = new ArrayList(this.cleanupList.keySet());
        }
        hashtable.put("cleanupListCount", arrayList.size());
        Vector<String> vector3 = new Vector<String>();
        for (Object object2 : arrayList) {
            vector3.add(((ConsumerUID)object2).toString());
        }
        hashtable.put("cleanupList", vector3);
        object2 = this.listeners;
        synchronized (object2) {
            arrayList = new ArrayList(this.listeners.keySet());
        }
        hashtable.put("listenersCount", arrayList.size());
        Vector<String> vector4 = new Vector<String>();
        for (Object object2 : arrayList) {
            vector4.add(((ConsumerUID)object2).toString());
        }
        hashtable.put("listeners", vector4);
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.valid = false;
        Set set = this.activeConsumers;
        synchronized (set) {
            this.activeConsumers.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventOccured(EventType eventType, Reason reason, Object object, Object object2, Object object3, Object object4) {
        if (eventType != EventType.BUSY_STATE_CHANGED) assert (false);
        Consumer consumer = (Consumer)object;
        Set set = this.activeConsumers;
        synchronized (set) {
            if (consumer.isBusy()) {
                this.activeConsumers.add(consumer);
            }
            this.activeConsumers.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void brokerDown(BrokerAddress brokerAddress) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "BrokerConsumers.brokerDown:" + brokerAddress);
        }
        HashSet<ConsumerUID> hashSet = new HashSet<ConsumerUID>();
        ConsumerUID consumerUID2 = null;
        Object object = this.consumers;
        synchronized (object) {
            for (ConsumerUID consumerUID2 : this.consumers.keySet()) {
                if (DEBUG) {
                    this.logger.log(8, "Check remote consumer " + consumerUID2 + " from " + consumerUID2.getBrokerAddress());
                }
                if (!brokerAddress.equals(consumerUID2.getBrokerAddress()) || brokerAddress.getBrokerSessionUID() != null && !brokerAddress.getBrokerSessionUID().equals((Object)consumerUID2.getBrokerAddress().getBrokerSessionUID())) continue;
                hashSet.add(consumerUID2);
            }
        }
        object = this.pendingConsumerUIDs;
        synchronized (object) {
            for (ConsumerUID consumerUID2 : this.pendingConsumerUIDs.keySet()) {
                if (DEBUG) {
                    this.logger.log(8, "Check closed remote consumer " + consumerUID2 + " from " + consumerUID2.getBrokerAddress());
                }
                if (!brokerAddress.equals(consumerUID2.getBrokerAddress()) || brokerAddress.getBrokerSessionUID() != null && !brokerAddress.getBrokerSessionUID().equals((Object)consumerUID2.getBrokerAddress().getBrokerSessionUID())) continue;
                hashSet.add(consumerUID2);
            }
        }
        for (ConsumerUID consumerUID2 : hashSet) {
            this.removeConsumer(consumerUID2, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forwardMessageToRemote(PacketReference packetReference, Collection collection) {
        for (Consumer consumer : collection) {
            ConsumerUID consumerUID = consumer.getStoredConsumerUID();
            ConsumerUID consumerUID2 = consumer.getConsumerUID();
            if (consumerUID2.isNoAck()) continue;
            Object object = this.removeConsumerLock;
            synchronized (object) {
                Object object2;
                if (this.consumers.get(consumerUID2) == null) {
                    if (DEBUG || DEBUG_CLUSTER_TXN || DEBUG_CLUSTER_MSG) {
                        Globals.getLogger().log(8, "BrokerConsumers.forwardMessageToRemote(): " + packetReference + ", ignore removed consumer: " + consumer);
                    }
                    try {
                        if (packetReference.acknowledged(consumerUID2, consumerUID, !consumerUID2.isDupsOK(), false)) {
                            object2 = Destination.getDestination(packetReference.getDestinationUID());
                            ((Destination)object2).removeMessage(packetReference.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                        }
                    }
                    catch (Exception exception) {
                        this.logger.logStack(16, "Unable to cleanup message " + packetReference.getSysMessageID() + " for closed consumer " + consumerUID2, (Throwable)exception);
                    }
                    continue;
                }
                object2 = new ackEntry(packetReference, consumerUID2, consumerUID);
                Map map = this.deliveredMessages;
                synchronized (map) {
                    this.deliveredMessages.put(object2, object2);
                }
            }
        }
        this.protocol.sendMessage(packetReference, collection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumers(ConnectionUID connectionUID) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "BrokerConsumers.removeConsumers for remote connection: " + (Object)((Object)connectionUID));
        }
        HashSet<ConsumerUID> hashSet = new HashSet<ConsumerUID>();
        ConsumerUID consumerUID2 = null;
        Object object = this.consumers;
        synchronized (object) {
            for (ConsumerUID consumerUID2 : this.consumers.keySet()) {
                if (!connectionUID.equals((Object)consumerUID2.getConnectionUID())) continue;
                hashSet.add(consumerUID2);
            }
        }
        object = this.pendingConsumerUIDs;
        synchronized (object) {
            for (ConsumerUID consumerUID2 : this.pendingConsumerUIDs.keySet()) {
                if (!connectionUID.equals((Object)consumerUID2.getConnectionUID())) continue;
                hashSet.add(consumerUID2);
            }
        }
        for (ConsumerUID consumerUID2 : hashSet) {
            this.removeConsumer(consumerUID2, true);
        }
    }

    public void removeConsumer(ConsumerUID consumerUID, boolean bl) throws BrokerException {
        this.removeConsumer(consumerUID, null, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumer(ConsumerUID consumerUID, Set set, boolean bl) throws BrokerException {
        LinkedHashSet<Object> linkedHashSet;
        if (DEBUG) {
            this.logger.log(8, "BrokerConsumers.removeConsumer:" + consumerUID + ", pending=" + (set == null ? "null" : Integer.valueOf(set.size())) + ", cleanup=" + bl);
        }
        Consumer consumer = null;
        Object object = this.removeConsumerLock;
        synchronized (object) {
            consumer = (Consumer)this.consumers.remove(consumerUID);
        }
        if (consumer == null && !bl) {
            return;
        }
        object = null;
        if (consumer != null) {
            consumer.pause("MultiBroker - removing consumer");
            object = Destination.getDestination(consumer.getDestinationUID());
            linkedHashSet = this.listeners.remove(consumerUID);
            if (linkedHashSet != null) {
                consumer.removeEventListener(linkedHashSet);
            }
            this.activeConsumers.remove(consumer);
        }
        linkedHashSet = new LinkedHashSet();
        LinkedHashSet<ackEntry> linkedHashSet2 = new LinkedHashSet<ackEntry>();
        LinkedHashSet<PacketReference> linkedHashSet3 = new LinkedHashSet<PacketReference>();
        Map map = this.deliveredMessages;
        synchronized (map) {
            PacketReference packetReference;
            if (consumer != null) {
                this.cleanupList.put(consumerUID, consumer.getParentList());
            }
            Prioritized prioritized = (Prioritized)this.cleanupList.get(consumerUID);
            if (DEBUG) {
                this.logger.log(8, "BrokerConsumers.removeConsumer:" + consumerUID + ", pending=" + set + ", cleanup=" + bl + ", cparent=" + prioritized);
            }
            Iterator<Object> iterator = this.deliveredMessages.values().iterator();
            while (iterator.hasNext()) {
                ackEntry ackEntry2 = (ackEntry)iterator.next();
                if (!ackEntry2.getConsumerUID().equals(consumerUID) || ackEntry2.getTUID() != null || set != null && !bl && set.contains(ackEntry2.getSysMessageID())) continue;
                if (DEBUG && DEBUG_CLUSTER_MSG) {
                    this.logger.log(4, "BrokerConsumers.removeConsumer:" + consumerUID + ", remove ackEntry=" + ackEntry2 + ", c=" + consumer);
                }
                iterator.remove();
                if (consumer != null) {
                    if (consumer.isFalconRemote()) {
                        ackEntry2.acknowledged(false);
                        continue;
                    }
                    packetReference = ackEntry2.getReference();
                    if (packetReference == null) continue;
                    packetReference.removeInDelivery(ackEntry2.getStoredConsumerUID());
                    linkedHashSet.add(packetReference);
                    continue;
                }
                packetReference = ackEntry2.getReference();
                if (packetReference != null) {
                    packetReference.removeInDelivery(ackEntry2.getStoredConsumerUID());
                }
                linkedHashSet2.add(ackEntry2);
            }
            for (ackEntry ackEntry2 : linkedHashSet2) {
                if (prioritized == null) {
                    ackEntry2.acknowledged(false);
                    continue;
                }
                packetReference = ackEntry2.getReference();
                if (packetReference == null) continue;
                linkedHashSet3.add(packetReference);
            }
            if (prioritized != null && linkedHashSet3.size() > 0) {
                prioritized.addAllOrdered(linkedHashSet3);
            }
            if (bl || set == null) {
                this.cleanupList.remove(consumerUID);
                this.pendingConsumerUIDs.remove(consumerUID);
            } else {
                this.pendingConsumerUIDs.put(consumerUID, set);
            }
        }
        if (consumer != null) {
            consumer.destroyConsumer(linkedHashSet, false, false);
            if (object != null) {
                ((Destination)object).removeConsumer(consumerUID, false);
            }
        }
    }

    private void cleanupPendingConsumerUID(ConsumerUID consumerUID, SysMessageID sysMessageID) {
        assert (Thread.holdsLock(this.deliveredMessages));
        Set set = (Set)this.pendingConsumerUIDs.get(consumerUID);
        if (set == null) {
            return;
        }
        set.remove(sysMessageID);
        if (set.isEmpty()) {
            this.pendingConsumerUIDs.remove(consumerUID);
            this.cleanupList.remove(consumerUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acknowledgeMessageFromRemote(int n, SysMessageID sysMessageID, ConsumerUID consumerUID, Map map) throws BrokerException {
        if (n == 0) {
            Consumer consumer = Consumer.getConsumer(consumerUID);
            if (consumer != null) {
                if (map != null) {
                    Integer n2 = (Integer)map.get("prefetch");
                    if (n2 != null) {
                        int n3 = Consumer.calcPrefetch(consumer, n2);
                        if (n3 < 0 || n3 > BTOBFLOW) {
                            n3 = BTOBFLOW;
                        }
                        consumer.resumeFlow(n3);
                    } else {
                        consumer.resumeFlow();
                    }
                } else {
                    consumer.resumeFlow();
                }
            }
            return true;
        }
        if (n == 5) {
            String string = null;
            String string2 = null;
            String string3 = null;
            if (map != null && ((string2 = (String)map.get("RB_RELEASE_MSG_INACTIVE")) != null || (string3 = (String)map.get("RB_RELEASE_MSG_ORPHAN")) != null || map.get("RC_RELEASE_MSG_INACTIVE") != null)) {
                string = string2 == null ? string3 : string2;
                String string4 = " for rollback remote transaction " + string;
                String string5 = "";
                if (string2 == null && string3 == null) {
                    string4 = " CLIENT_ACKNOWLEDGE recover";
                } else {
                    String string6 = string5 = string2 == null ? "orphaned" : "inactive";
                }
                if (DEBUG) {
                    this.logger.log(8, "Releasing message [" + consumerUID + ", " + sysMessageID + "](" + string5 + ")" + string4);
                }
                ackEntry ackEntry2 = new ackEntry(sysMessageID, consumerUID, null);
                ackEntry ackEntry3 = null;
                Object object = this.deliveredMessages;
                synchronized (object) {
                    ackEntry3 = (ackEntry)this.deliveredMessages.remove(ackEntry2);
                    this.cleanupPendingConsumerUID(consumerUID, sysMessageID);
                }
                if (ackEntry3 == null) {
                    if (DEBUG) {
                        this.logger.log(8, "Releasing message [" + consumerUID + ", " + sysMessageID + "](" + string5 + ")" + string4);
                    }
                    return true;
                }
                object = ackEntry3.getReference();
                if (object == null) {
                    if (DEBUG) {
                        this.logger.log(8, "Releasing message [" + ackEntry3 + "](" + string5 + ") ref null" + string4);
                    }
                    return true;
                }
                ConsumerUID consumerUID2 = ackEntry3.getStoredConsumerUID();
                ConsumerUID consumerUID3 = ackEntry3.getConsumerUID();
                if (consumerUID2 == null || consumerUID2 == consumerUID3) {
                    try {
                        if (((PacketReference)object).acknowledged(consumerUID3, consumerUID2, !consumerUID3.isDupsOK(), false)) {
                            Destination destination = Destination.getDestination(((PacketReference)object).getDestinationUID());
                            destination.removeMessage(((PacketReference)object).getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                        }
                    }
                    catch (Exception exception) {
                        this.logger.logStack(16, "Unable to cleanup message " + ((PacketReference)object).getSysMessageID() + string4, (Throwable)exception);
                    }
                    return true;
                }
                ((PacketReference)object).removeInDelivery(ackEntry3.getStoredConsumerUID());
                ((PacketReference)object).getDestination().forwardOrphanMessage((PacketReference)object, ackEntry3.getStoredConsumerUID());
                return true;
            }
            if (map != null && map.get("MSG_NOT_SENT_TO_REMOTE") != null && ((String)map.get("MSG_NOT_SENT_TO_REMOTE")).equals("true")) {
                ackEntry ackEntry4 = new ackEntry(sysMessageID, consumerUID, null);
                ackEntry ackEntry5 = null;
                Object object = this.deliveredMessages;
                synchronized (object) {
                    ackEntry5 = (ackEntry)this.deliveredMessages.get(ackEntry4);
                }
                if (ackEntry5 == null) {
                    return true;
                }
                object = ackEntry5.getReference();
                if (object == null || ((PacketReference)object).isDestroyed() || ((PacketReference)object).isInvalid()) {
                    if (DEBUG) {
                        this.logger.log(8, "Cleanup dead message (not remote delivered): " + ackEntry5);
                    }
                    Map map2 = this.deliveredMessages;
                    synchronized (map2) {
                        this.deliveredMessages.remove(ackEntry4);
                    }
                }
            }
            if (DEBUG) {
                this.logger.log(4, "got message ignored ack, can not process [" + sysMessageID + "," + consumerUID + "]" + n);
            }
            return true;
        }
        ackEntry ackEntry6 = new ackEntry(sysMessageID, consumerUID, null);
        Map map3 = this.deliveredMessages;
        synchronized (map3) {
            ackEntry ackEntry7 = (ackEntry)this.deliveredMessages.remove(ackEntry6);
            this.cleanupPendingConsumerUID(consumerUID, sysMessageID);
            if (n == 1) {
                if (ackEntry7 == null) {
                    return true;
                }
                return ackEntry7.acknowledged(false);
            }
            if (n == 7 || n == 6) {
                if (ackEntry7 != null && ackEntry7.getTUID() != null) {
                    this.logger.log(16, "Ignore mark message dead " + sysMessageID + " for it's prepared with TUID= " + ackEntry7.getTUID());
                    return false;
                }
                if (ackEntry7 == null && !consumerUID.equals(PacketReference.getQueueUID())) {
                    if (DEBUG || DEBUG_CLUSTER_TXN || DEBUG_CLUSTER_MSG) {
                        this.logger.log(8, "Mark dead message: entry not found:" + sysMessageID + "," + consumerUID);
                    }
                    return false;
                }
                this.removeRemoteDeadMessage(n, sysMessageID, consumerUID, map);
                if (ackEntry7 == null && consumerUID.equals(PacketReference.getQueueUID())) {
                    Iterator iterator = this.deliveredMessages.values().iterator();
                    int n4 = 0;
                    while (iterator.hasNext()) {
                        ackEntry ackEntry8 = (ackEntry)iterator.next();
                        if (ackEntry8.getTUID() != null || !ackEntry8.getConsumerUID().getBrokerAddress().equals(consumerUID.getBrokerAddress()) || !ackEntry8.getSysMessageID().equals((Object)sysMessageID)) continue;
                        ConsumerUID consumerUID4 = ackEntry8.getStoredConsumerUID();
                        ConsumerUID consumerUID5 = ackEntry8.getConsumerUID();
                        if (consumerUID4 != null && consumerUID4 != consumerUID5) continue;
                        if (DEBUG) {
                            this.logger.log(8, "Cleanup remote dead ack entries(" + n4++ + "th): " + ackEntry8);
                        }
                        iterator.remove();
                    }
                }
                return true;
            }
            this.logger.log(32, "Internal Error: ackMessageFromRemote: unexpetected ackType:" + n);
            return false;
        }
    }

    private boolean removeRemoteDeadMessage(int n, SysMessageID sysMessageID, ConsumerUID consumerUID, Map map) throws BrokerException {
        PacketReference packetReference = Destination.get(sysMessageID);
        if (packetReference == null) {
            return true;
        }
        Destination destination = packetReference.getDestination();
        if (destination == Destination.getDMQ()) {
            return true;
        }
        String string = null;
        Object var8_8 = null;
        Exception exception = null;
        Integer n2 = null;
        Integer n3 = null;
        String string2 = null;
        if (map != null) {
            string = (String)map.get("JMS_SUN_DMQ_UNDELIVERED_COMMENT");
            exception = (Exception)map.get("JMS_SUN_DMQ_UNDELIVERED_EXCEPTION");
            n2 = (Integer)map.get("JMQ_SUN_JMSQ_TempRedeliverCnt");
            n3 = (Integer)map.get("REASON");
            string2 = (String)map.get("JMS_SUN_DMQ_DEAD_BROKER");
        }
        RemoveReason removeReason = null;
        if (n == 6) {
            removeReason = RemoveReason.UNDELIVERABLE;
        } else {
            removeReason = RemoveReason.ERROR;
            if (n3 != null) {
                removeReason = RemoveReason.findReason(n3);
            }
        }
        if (string == null) {
            string = "none";
        }
        if (consumerUID.longValue() == 0L) {
            destination.removeMessage(sysMessageID, removeReason, map == null ? null : new Hashtable(map));
        } else if (packetReference.markDead(consumerUID, string, exception, removeReason, n2 == null ? 0 : n2, string2) && packetReference.isDead()) {
            try {
                destination.removeDeadMessage(packetReference);
            }
            catch (Exception exception2) {
                this.logger.log(16, "Unable to remove dead[" + (Object)((Object)removeReason) + ", " + string2 + "] message " + packetReference + "[" + consumerUID + "]: " + exception2.getMessage(), (Throwable)exception2);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void acknowledgeMessageFromRemote2P(int n, SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray, Map map, Long l, BrokerAddress brokerAddress) throws BrokerException {
        if (l == null) {
            throw new BrokerException("Internal Error: call with null txnID");
        }
        TransactionList transactionList = Globals.getTransactionList();
        TransactionUID transactionUID = new TransactionUID(l);
        if (n == 8) {
            TransactionAcknowledgement[] transactionAcknowledgementArray = new TransactionAcknowledgement[sysMessageIDArray.length];
            ackEntry ackEntry2 = null;
            ackEntry ackEntry3 = null;
            StringBuffer stringBuffer = new StringBuffer();
            AckEntryNotFoundException ackEntryNotFoundException = null;
            Map map2 = this.deliveredMessages;
            synchronized (map2) {
                void transactionState;
                boolean i = false;
                while (transactionState < sysMessageIDArray.length) {
                    Object object;
                    ackEntry2 = new ackEntry(sysMessageIDArray[transactionState], consumerUIDArray[transactionState], null);
                    ackEntry3 = (ackEntry)this.deliveredMessages.get(ackEntry2);
                    if (ackEntry3 == null) {
                        object = "[" + sysMessageIDArray[transactionState] + ":" + consumerUIDArray[transactionState] + "]TID=" + transactionUID + " not found, maybe rerouted";
                        if (ackEntryNotFoundException == null) {
                            ackEntryNotFoundException = new AckEntryNotFoundException((String)object);
                        }
                        ackEntryNotFoundException.addAckEntry(sysMessageIDArray[transactionState], consumerUIDArray[transactionState]);
                        this.logger.log(16, "[" + sysMessageIDArray[transactionState] + ":" + consumerUIDArray[transactionState] + "] not found for preparing remote transaction " + transactionUID + ", maybe rerouted");
                    } else if (ackEntry3.getTUID() != null) {
                        object = "[" + sysMessageIDArray[transactionState] + ":" + consumerUIDArray[transactionState] + "]TID=" + transactionUID + "  has been rerouted";
                        if (ackEntryNotFoundException == null) {
                            ackEntryNotFoundException = new AckEntryNotFoundException((String)object);
                        }
                        ackEntryNotFoundException.addAckEntry(sysMessageIDArray[transactionState], consumerUIDArray[transactionState]);
                        this.logger.log(16, "[" + sysMessageIDArray[transactionState] + ":" + consumerUIDArray[transactionState] + "] for preparing remote transaction " + transactionUID + " conflict with transaction " + ackEntry3.getTUID());
                    } else {
                        object = ackEntry3.getStoredConsumerUID();
                        transactionAcknowledgementArray[transactionState] = new TransactionAcknowledgement(sysMessageIDArray[transactionState], consumerUIDArray[transactionState], (ConsumerUID)object);
                        PacketReference packetReference = ackEntry3.getReference();
                        if (!((ConsumerUID)object).shouldStore() || packetReference != null && !packetReference.isPersistent()) {
                            transactionAcknowledgementArray[transactionState].setShouldStore(false);
                        }
                        if (DEBUG_CLUSTER_TXN) {
                            stringBuffer.append("\n\t" + transactionAcknowledgementArray[transactionState]);
                        }
                    }
                    ++transactionState;
                }
                if (ackEntryNotFoundException != null) {
                    throw ackEntryNotFoundException;
                }
                TransactionState object2 = new TransactionState();
                object2.setState(5);
                if (DEBUG_CLUSTER_TXN) {
                    this.logger.log(8, "Preparing remote transaction " + transactionUID + " from " + brokerAddress + stringBuffer.toString());
                }
                Globals.getTransactionList().logRemoteTransaction(transactionUID, object2, transactionAcknowledgementArray, brokerAddress, false, true, true);
                for (int j = 0; j < sysMessageIDArray.length; ++j) {
                    ackEntry2 = new ackEntry(sysMessageIDArray[j], consumerUIDArray[j], null);
                    ackEntry3 = (ackEntry)this.deliveredMessages.get(ackEntry2);
                    ackEntry3.setTUID(transactionUID);
                }
            }
            if (DEBUG_CLUSTER_TXN) {
                this.logger.log(8, "Prepared remote transaction " + transactionUID + " from " + brokerAddress + stringBuffer.toString());
            }
            return;
        }
        if (n == 9) {
            RemoteTransactionAckEntry remoteTransactionAckEntry;
            if (DEBUG_CLUSTER_TXN) {
                this.logger.log(8, "Rolling back remote transaction " + transactionUID + " from " + brokerAddress);
            }
            if (transactionList.getRemoteTransactionState(transactionUID) == null) {
                if (DEBUG_CLUSTER_TXN) {
                    this.logger.log(8, "Unknown remote transaction " + transactionUID + ", ignore");
                }
                return;
            }
            if (!transactionList.updateRemoteTransactionState(transactionUID, 7, false, false, true)) {
                return;
            }
            if (transactionList.getRecoveryRemoteTransactionAcks(transactionUID) != null) {
                this.rollbackRecoveryRemoteTransaction(transactionUID, brokerAddress);
            }
            if ((remoteTransactionAckEntry = transactionList.getRemoteTransactionAcks(transactionUID)) == null) {
                this.logger.log(8, Globals.getBrokerResources().getKString("B1309", transactionUID));
            } else if (remoteTransactionAckEntry.processed()) {
                this.logger.log(8, Globals.getBrokerResources().getKString("B1310", transactionUID));
            } else {
                Object object;
                ConsumerUID consumerUID;
                ConsumerUID consumerUID2;
                TransactionAcknowledgement[] transactionAcknowledgementArray = remoteTransactionAckEntry.getAcks();
                LinkedHashSet<TransactionAcknowledgement> linkedHashSet = new LinkedHashSet<TransactionAcknowledgement>();
                ackEntry ackEntry4 = null;
                ackEntry ackEntry5 = null;
                for (int i = 0; i < transactionAcknowledgementArray.length; ++i) {
                    SysMessageID bl2 = transactionAcknowledgementArray[i].getSysMessageID();
                    consumerUID2 = transactionAcknowledgementArray[i].getConsumerUID();
                    consumerUID = transactionAcknowledgementArray[i].getStoredConsumerUID();
                    if (consumerUID == null) {
                        consumerUID = consumerUID2;
                    }
                    object = this.deliveredMessages;
                    synchronized (object) {
                        ackEntry4 = new ackEntry(bl2, consumerUID2, null);
                        ackEntry5 = (ackEntry)this.deliveredMessages.get(ackEntry4);
                        if (ackEntry5 == null) {
                            if (DEBUG_CLUSTER_TXN) {
                                this.logger.log(8, "[" + bl2 + ":" + consumerUID2 + "] not found in rolling back remote transaction " + transactionUID);
                            }
                            continue;
                        }
                        if (ackEntry5.getTUID() == null || !ackEntry5.getTUID().equals(transactionUID)) {
                            if (DEBUG_CLUSTER_TXN) {
                                this.logger.log(8, "[" + bl2 + ":" + consumerUID2 + "] with TUID=" + ackEntry5.getTUID() + ", in rolling back remote transaction " + transactionUID);
                            }
                            continue;
                        }
                        if (this.consumers.get(consumerUID2) == null) {
                            this.deliveredMessages.remove(ackEntry4);
                            this.cleanupPendingConsumerUID(consumerUID2, bl2);
                            linkedHashSet.add(transactionAcknowledgementArray[i]);
                        } else {
                            ackEntry5.setTUID(null);
                        }
                        continue;
                    }
                }
                for (TransactionAcknowledgement exception : linkedHashSet) {
                    PacketReference packetReference;
                    consumerUID2 = exception.getSysMessageID();
                    consumerUID = exception.getConsumerUID();
                    object = exception.getStoredConsumerUID();
                    if (object == null) {
                        object = consumerUID;
                    }
                    if ((packetReference = Destination.get((SysMessageID)consumerUID2)) == null) {
                        if (!DEBUG_CLUSTER_TXN) continue;
                        this.logger.log(8, "[" + consumerUID2 + ":" + consumerUID + "] reference not found in rolling back remote transaction " + transactionUID);
                        continue;
                    }
                    packetReference.removeInDelivery((ConsumerUID)object);
                    packetReference.getDestination().forwardOrphanMessage(packetReference, (ConsumerUID)object);
                }
            }
            try {
                Globals.getTransactionList().removeRemoteTransactionAck(transactionUID);
            }
            catch (Exception exception) {
                this.logger.log(16, "Unable to remove transaction ack for rolledback transaction " + transactionUID + ": " + exception.getMessage());
            }
            try {
                Globals.getTransactionList().removeRemoteTransactionID(transactionUID, true);
            }
            catch (Exception exception) {
                this.logger.log(16, "Unable to remove rolledback remote transaction " + transactionUID + ": " + exception.getMessage());
            }
            return;
        }
        int n2 = 0;
        ArrayList<String> arrayList = null;
        ArrayList<SysMessageID> arrayList2 = null;
        ArrayList<Object> arrayList3 = null;
        if (n == 1) {
            ConsumerUID consumerUID;
            Object object;
            int n3;
            Object object2;
            RemoteTransactionAckEntry remoteTransactionAckEntry;
            if (DEBUG_CLUSTER_TXN) {
                this.logger.log(8, "Committing remote transaction " + transactionUID + " from " + brokerAddress);
            }
            if (!Globals.getTransactionList().updateRemoteTransactionState(transactionUID, 6, sysMessageIDArray == null, true, true)) {
                if (DEBUG_CLUSTER_TXN) {
                    this.logger.log(8, "Remote transaction " + transactionUID + " already committed, from " + brokerAddress);
                }
                return;
            }
            boolean bl = true;
            if (transactionList.getRecoveryRemoteTransactionAcks(transactionUID) != null) {
                bl = this.commitRecoveryRemoteTransaction(transactionUID, brokerAddress);
            }
            if ((remoteTransactionAckEntry = transactionList.getRemoteTransactionAcks(transactionUID)) == null) {
                this.logger.log(8, "No non-recovery transaction acks to process for committing remote transaction " + transactionUID);
            } else if (remoteTransactionAckEntry.processed()) {
                this.logger.log(8, "No more transaction acks to process for committing remote transaction " + transactionUID);
            } else {
                boolean iOException;
                boolean byteArrayOutputStream = false;
                object2 = remoteTransactionAckEntry.getAcks();
                for (n3 = 0; n3 < ((TransactionAcknowledgement[])object2).length; ++n3) {
                    Object object3;
                    object = object2[n3].getSysMessageID();
                    consumerUID = object2[n3].getConsumerUID();
                    if (sysMessageIDArray != null && !iOException && object.equals((Object)sysMessageIDArray[0]) && consumerUID.equals(consumerUIDArray[0])) {
                        iOException = true;
                    }
                    String string = null;
                    if (Globals.txnLogEnabled()) {
                        if (arrayList == null) {
                            arrayList = new ArrayList<String>();
                            arrayList2 = new ArrayList<SysMessageID>();
                            arrayList3 = new ArrayList<Object>();
                        }
                        if ((object3 = Destination.get(object)) != null && !((PacketReference)object3).isDestroyed() && !((PacketReference)object3).isInvalid()) {
                            Destination destination = Destination.getDestination(((PacketReference)object3).getDestinationUID());
                            string = destination.getUniqueName();
                        }
                    }
                    if (this.acknowledgeMessageFromRemote(n, (SysMessageID)object, consumerUID, map)) {
                        if (string == null) continue;
                        object3 = object2[n3].getStoredConsumerUID();
                        if (object3 == null) {
                            object3 = consumerUID;
                        }
                        ++n2;
                        arrayList.add(string);
                        arrayList2.add((SysMessageID)object);
                        arrayList3.add(object3);
                        continue;
                    }
                    bl = false;
                }
                if (Globals.isNewTxnLogEnabled()) {
                    Globals.getStore().loggedCommitWrittenToMessageStore(transactionUID, 2);
                }
                if (sysMessageIDArray != null && !iOException) {
                    this.logger.log(32, "Internal Error: [" + sysMessageIDArray[0] + ":" + consumerUIDArray[0] + "] not found in remote transaction " + transactionUID);
                    bl = false;
                }
            }
            if (bl) {
                try {
                    Globals.getTransactionList().removeRemoteTransactionAck(transactionUID);
                }
                catch (Exception exception) {
                    this.logger.logStack(16, "Unable to remove transaction ack for committed remote transaction " + transactionUID, (Throwable)exception);
                }
                try {
                    Globals.getTransactionList().removeRemoteTransactionID(transactionUID, true);
                }
                catch (Exception exception) {
                    this.logger.logStack(16, "Unable to remove committed remote transaction " + transactionUID, (Throwable)exception);
                }
            } else if (Globals.getHAEnabled()) {
                throw new BrokerException("Remote transaction processing incomplete, TUID=" + transactionUID);
            }
            try {
                if (Globals.txnLogEnabled() && n2 > 0) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2 * 72 + 12);
                    object2 = new DataOutputStream(byteArrayOutputStream);
                    ((DataOutputStream)object2).writeLong(transactionUID.longValue());
                    ((DataOutputStream)object2).writeInt(n2);
                    for (n3 = 0; n3 < n2; ++n3) {
                        object = (String)arrayList.get(n3);
                        ((DataOutputStream)object2).writeUTF((String)object);
                        consumerUID = (SysMessageID)arrayList2.get(n3);
                        consumerUID.writeID((DataOutput)object2);
                        long l2 = ((ConsumerUID)arrayList3.get(n3)).longValue();
                        ((DataOutputStream)object2).writeLong(l2);
                    }
                    ((FilterOutputStream)object2).close();
                    byteArrayOutputStream.close();
                    Globals.getStore().logTxn(2, byteArrayOutputStream.toByteArray());
                }
            }
            catch (IOException iOException) {
                Globals.getBrokerResources();
                this.logger.logStack(32, "B3100", (Object)"Got exception while writing to transaction log", (Throwable)iOException);
                throw new BrokerException("Internal Error: Got exception while writing to transaction log", iOException);
            }
            return;
        }
        throw new BrokerException("acknowledgeMessageFromRemotePriv:Unexpected ack type:" + n);
    }

    private void rollbackRecoveryRemoteTransaction(TransactionUID transactionUID, BrokerAddress brokerAddress) throws BrokerException {
        RemoteTransactionAckEntry[] remoteTransactionAckEntryArray;
        BrokerAddress brokerAddress2;
        this.logger.log(8, "Rolling back recovery remote transaction " + transactionUID + " from " + brokerAddress);
        TransactionList transactionList = Globals.getTransactionList();
        TransactionState transactionState = transactionList.getRemoteTransactionState(transactionUID);
        if (transactionState == null || transactionState.getState() != 7) {
            Globals.getBrokerResources();
            throw new BrokerException("B3100", "Unexpected broker state " + transactionState + " for processing Rolledback remote transaction " + transactionUID);
        }
        TransactionBroker transactionBroker = transactionList.getRemoteTransactionHomeBroker(transactionUID);
        BrokerAddress brokerAddress3 = brokerAddress2 = transactionBroker == null ? null : transactionBroker.getCurrentBrokerAddress();
        if (brokerAddress2 == null || !brokerAddress2.equals(brokerAddress)) {
            this.logger.log(16, "Rolledback remote transaction " + transactionUID + " home broker " + transactionBroker + " not " + brokerAddress);
        }
        if ((remoteTransactionAckEntryArray = transactionList.getRecoveryRemoteTransactionAcks(transactionUID)) == null) {
            this.logger.log(16, "No recovery transaction acks to process for rolling back remote transaction " + transactionUID);
            return;
        }
        for (int i = 0; i < remoteTransactionAckEntryArray.length; ++i) {
            if (remoteTransactionAckEntryArray[i].processed()) continue;
            TransactionAcknowledgement[] transactionAcknowledgementArray = remoteTransactionAckEntryArray[i].getAcks();
            for (int j = 0; j < transactionAcknowledgementArray.length; ++j) {
                PacketReference packetReference;
                SysMessageID sysMessageID = transactionAcknowledgementArray[j].getSysMessageID();
                ConsumerUID consumerUID = transactionAcknowledgementArray[j].getConsumerUID();
                ConsumerUID consumerUID2 = transactionAcknowledgementArray[j].getStoredConsumerUID();
                if (consumerUID2 == null) {
                    consumerUID2 = consumerUID;
                }
                if ((packetReference = Destination.get(sysMessageID)) == null) {
                    if (!DEBUG_CLUSTER_TXN) continue;
                    this.logger.log(8, "[" + sysMessageID + ":" + consumerUID + "] reference not found in rolling back recovery remote transaction " + transactionUID);
                    continue;
                }
                packetReference.getDestination().forwardOrphanMessage(packetReference, consumerUID2);
            }
        }
    }

    private boolean commitRecoveryRemoteTransaction(TransactionUID transactionUID, BrokerAddress brokerAddress) throws BrokerException {
        RemoteTransactionAckEntry[] remoteTransactionAckEntryArray;
        BrokerAddress brokerAddress2;
        this.logger.log(8, "Committing recovery remote transaction " + transactionUID + " from " + brokerAddress);
        TransactionList transactionList = Globals.getTransactionList();
        TransactionBroker transactionBroker = transactionList.getRemoteTransactionHomeBroker(transactionUID);
        BrokerAddress brokerAddress3 = brokerAddress2 = transactionBroker == null ? null : transactionBroker.getCurrentBrokerAddress();
        if (brokerAddress2 == null || !brokerAddress2.equals(brokerAddress)) {
            this.logger.log(16, "Committed remote transaction " + transactionUID + " home broker " + transactionBroker + " not " + brokerAddress);
        }
        if ((remoteTransactionAckEntryArray = transactionList.getRecoveryRemoteTransactionAcks(transactionUID)) == null) {
            this.logger.log(16, "No recovery transaction acks to process for committing remote transaction " + transactionUID);
            return true;
        }
        boolean bl = true;
        for (int i = 0; i < remoteTransactionAckEntryArray.length; ++i) {
            if (remoteTransactionAckEntryArray[i].processed()) continue;
            TransactionAcknowledgement[] transactionAcknowledgementArray = remoteTransactionAckEntryArray[i].getAcks();
            for (int j = 0; j < transactionAcknowledgementArray.length; ++j) {
                PacketReference packetReference;
                SysMessageID sysMessageID = transactionAcknowledgementArray[j].getSysMessageID();
                ConsumerUID consumerUID = transactionAcknowledgementArray[j].getConsumerUID();
                ConsumerUID consumerUID2 = transactionAcknowledgementArray[j].getStoredConsumerUID();
                if (consumerUID2 == null) {
                    consumerUID2 = consumerUID;
                }
                if ((packetReference = Destination.get(sysMessageID)) == null || packetReference.isDestroyed() || packetReference.isInvalid()) continue;
                try {
                    if (!packetReference.acknowledged(consumerUID, consumerUID2, true, true)) continue;
                    packetReference.getDestination().removeMessage(packetReference.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                    continue;
                }
                catch (Exception exception) {
                    bl = false;
                    Globals.getBrokerResources();
                    this.logger.logStack(32, "B3100", (Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsumer(Consumer consumer) throws BrokerException {
        int n;
        DestinationUID destinationUID;
        ConsumerUID consumerUID;
        if (DEBUG) {
            this.logger.log(8, "BrokerConsumers.addConsumer: " + consumer);
        }
        if (this.consumers.get(consumerUID = consumer.getConsumerUID()) != null) {
            String string = Globals.getBrokerResources().getKString("B1331", consumerUID, consumer.getDestinationUID());
            this.logger.log(8, string + " (CLUSTER_ROUTER)");
            throw new ConsumerAlreadyAddedException(string);
        }
        if (!(consumer instanceof Subscription)) {
            this.consumers.put(consumerUID, consumer);
            this.pendingConsumerUIDs.put(consumerUID, null);
            this.listeners.put(consumerUID, consumer.addEventListener(this, EventType.BUSY_STATE_CHANGED, null));
        }
        int n2 = (destinationUID = consumer.getDestinationUID()).isQueue() ? 1 : 2;
        Destination destination = null;
        try {
            if (destinationUID.isWildcard()) {
                destination = null;
            } else {
                for (n = 0; n < 2 && destination == null; ++n) {
                    destination = Destination.getDestination(destinationUID.getName(), n2, true, true);
                    try {
                        if (destination == null) continue;
                        destination.incrementRefCount();
                        break;
                    }
                    catch (BrokerException brokerException) {
                        destination = null;
                    }
                }
                if (destination == null) {
                    throw new BrokerException("Unable to attach to destination " + destinationUID);
                }
            }
        }
        catch (IOException iOException) {
            throw new BrokerException("Unable to autocreate destination " + destinationUID, iOException);
        }
        try {
            if (!consumer.getDestinationUID().isQueue() && !(consumer instanceof Subscription) && consumer.getSubscription() == null) {
                consumer.setFalconRemote(true);
            } else {
                int n3;
                int n4 = n = destination == null ? -1 : destination.getMaxPrefetch();
                if (n <= 0 || n > BTOBFLOW) {
                    n = BTOBFLOW;
                }
                if ((n3 = consumer.getRemotePrefetch()) == -1 || n3 > n) {
                    n3 = n;
                }
                consumer.setPrefetch(n3);
            }
            try {
                if (destination == null && consumer.getSubscription() == null) {
                    List list = Destination.findMatchingIDs(consumer.getDestinationUID());
                    if (!list.isEmpty()) {
                        for (DestinationUID destinationUID2 : list) {
                            Destination destination2 = Destination.getDestination(destinationUID2);
                            try {
                                destination2.addConsumer(consumer, false);
                            }
                            catch (ConsumerAlreadyAddedException consumerAlreadyAddedException) {
                                this.logger.log(8, consumerAlreadyAddedException.getMessage() + " (CLUSTER_ROUTER)");
                            }
                        }
                    }
                } else if (consumer.getSubscription() == null) {
                    try {
                        destination.addConsumer(consumer, false);
                    }
                    catch (ConsumerAlreadyAddedException consumerAlreadyAddedException) {
                        this.logger.log(8, consumerAlreadyAddedException.getMessage() + " (CLUSTER_ROUTER)");
                    }
                }
            }
            catch (SelectorFormatException selectorFormatException) {
                throw new BrokerException("unable to add destination " + destination, selectorFormatException);
            }
            if (!(consumer instanceof Subscription) && consumer.isBusy()) {
                Set set = this.activeConsumers;
                synchronized (set) {
                    this.activeConsumers.add(consumer);
                    this.activeConsumers.notify();
                }
            }
            Object var13_20 = null;
            if (destination != null) {
                destination.decrementRefCount();
            }
        }
        catch (Throwable throwable) {
            Object var13_21 = null;
            if (destination != null) {
                destination.decrementRefCount();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.valid) {
            Object object;
            Consumer consumer = null;
            Object object2 = this.activeConsumers;
            synchronized (object2) {
                while (this.valid && this.activeConsumers.isEmpty()) {
                    try {
                        this.activeConsumers.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.valid) {
                    object = this.activeConsumers.iterator();
                    consumer = (Consumer)object.next();
                    object.remove();
                    if (consumer.isBusy()) {
                        this.activeConsumers.add(consumer);
                    }
                }
            }
            if (consumer == null) continue;
            object2 = null;
            object = null;
            boolean bl = false;
            Object object3 = this.removeConsumerLock;
            synchronized (object3) {
                if (this.consumers.get(consumer.getConsumerUID()) == null) {
                    if (DEBUG || DEBUG_CLUSTER_TXN || DEBUG_CLUSTER_MSG) {
                        Globals.getLogger().log(8, "BrokerConsumers.run(): ignore removed consumer: " + consumer);
                    }
                    continue;
                }
                object2 = consumer.getAndFillNextPacket(null);
                if (object2 == null) {
                    continue;
                }
                object = new HashSet();
                ((HashSet)object).add(consumer);
                boolean bl2 = bl = ((PacketReference)object2).getMessageDeliveredAck(consumer.getConsumerUID()) || consumer.isPaused();
                if (!consumer.getConsumerUID().isNoAck()) {
                    ackEntry ackEntry2 = new ackEntry((PacketReference)object2, consumer.getConsumerUID(), consumer.getStoredConsumerUID());
                    Map map = this.deliveredMessages;
                    synchronized (map) {
                        this.deliveredMessages.put(ackEntry2, ackEntry2);
                        if (DEBUG && DEBUG_CLUSTER_MSG) {
                            this.logger.log(4, "deliveredMessages:" + ackEntry2);
                        }
                    }
                }
            }
            this.protocol.sendMessage((PacketReference)object2, (Collection)object, bl);
        }
    }

    static {
        if (!DEBUG) {
            DEBUG = DEBUG_CLUSTER_TXN || DEBUG_CLUSTER_MSG;
        }
        BTOBFLOW = Globals.getConfig().getIntProperty("imq.cluster.consumerFlowLimit", 1000);
    }

    class ackEntry {
        ConsumerUID uid = null;
        ConsumerUID storedcid = null;
        WeakReference pref = null;
        SysMessageID id = null;
        BrokerAddress address = null;
        TransactionUID tuid = null;

        public ackEntry(SysMessageID sysMessageID, ConsumerUID consumerUID, BrokerAddress brokerAddress) {
            assert (sysMessageID != null);
            assert (consumerUID != null);
            this.id = sysMessageID;
            this.uid = consumerUID;
            this.address = brokerAddress;
            this.pref = null;
        }

        public String toString() {
            return "" + this.id + "[" + this.uid + ", " + this.storedcid + "]TUID=" + this.tuid + ", address=" + this.address;
        }

        public void setTUID(TransactionUID transactionUID) {
            this.tuid = transactionUID;
        }

        public TransactionUID getTUID() {
            return this.tuid;
        }

        public BrokerAddress getBrokerAddress() {
            return this.address;
        }

        public ConsumerUID getConsumerUID() {
            return this.uid;
        }

        public ConsumerUID getStoredConsumerUID() {
            return this.storedcid;
        }

        public SysMessageID getSysMessageID() {
            return this.id;
        }

        public PacketReference getReference() {
            return (PacketReference)this.pref.get();
        }

        public ackEntry(PacketReference packetReference, ConsumerUID consumerUID, ConsumerUID consumerUID2) {
            this.pref = new WeakReference<PacketReference>(packetReference);
            this.id = packetReference.getSysMessageID();
            this.storedcid = consumerUID2;
            this.uid = consumerUID;
        }

        public boolean acknowledged(boolean bl) {
            assert (this.pref != null);
            PacketReference packetReference = (PacketReference)this.pref.get();
            boolean bl2 = true;
            try {
                if (packetReference == null) {
                    packetReference = Destination.get(this.id);
                }
                if (packetReference == null) {
                    return true;
                }
                if (packetReference.acknowledged(this.uid, this.storedcid, !this.uid.isDupsOK(), bl)) {
                    if (this.tuid != null && ((BrokerConsumers)BrokerConsumers.this).fi.FAULT_INJECTION) {
                        BrokerConsumers.this.fi.checkFaultAndExit("msg.remote_ack.home.c.txncommit.1_7", null, 2, false);
                    }
                    Destination destination = Destination.getDestination(packetReference.getDestinationUID());
                    destination.removeMessage(packetReference.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                }
            }
            catch (Exception exception) {
                BrokerConsumers.this.logger.logStack(16, "Unable to process acknowledgement:[" + this.id + "," + this.uid + "]", (Throwable)exception);
                bl2 = false;
            }
            return bl2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ackEntry)) {
                return false;
            }
            ackEntry ackEntry2 = (ackEntry)object;
            return this.uid.equals(ackEntry2.uid) && this.id.equals((Object)ackEntry2.id);
        }

        public int hashCode() {
            return this.id.hashCode() * 15 + this.uid.hashCode();
        }
    }
}

