/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.jms.system;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.connectors.jms.system.ActiveJmsResourceAdapter;
import com.sun.enterprise.connectors.jms.system.MQAddressList;
import com.sun.enterprise.connectors.jms.util.JmsRaUtil;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
public class JMSConfigListener
implements ConfigListener {
    @Inject
    private JmsService jmsservice;
    @Inject
    private Servers servers;
    private ActiveJmsResourceAdapter aresourceAdapter;
    private static final Logger _logger = LogDomains.getLogger(JMSConfigListener.class, (String)"javax.enterprise.resource.jms");
    private static StringManager sm = StringManager.getManager(JMSConfigListener.class);

    public void setActiveResourceAdapter(ActiveJmsResourceAdapter aresourceAdapter) {
        this.aresourceAdapter = aresourceAdapter;
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        _logger.log(Level.FINE, "In JMSConfigListener - received config event");
        Domain domain = (Domain)Globals.get(Domain.class);
        String jmsProviderPort = null;
        ServerContext serverContext = (ServerContext)Globals.get(ServerContext.class);
        Server thisServer = domain.getServerNamed(serverContext.getInstanceName());
        if (thisServer.isDas() || thisServer.getCluster() == null) {
            _logger.log(Level.INFO, "JMSConfigListerner server is either das or a stand-alone instance - hence ignoring");
            return null;
        }
        for (int i = 0; i < events.length; ++i) {
            PropertyChangeEvent event = events[i];
            String eventName = event.getPropertyName();
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            _logger.log(Level.FINE, "In JMSConfigListener " + eventName + oldValue + newValue);
            if (oldValue != null && oldValue.equals(newValue)) {
                _logger.log(Level.FINE, "Event " + eventName + " did not change existing value of " + oldValue);
                continue;
            }
            if ("JMS_PROVIDER_PORT".equals(newValue)) {
                PropertyChangeEvent nextevent = events[i + 1];
                jmsProviderPort = (String)nextevent.getNewValue();
            }
            if (event.getSource() instanceof JmsService && eventName.equals("master-broker")) {
                String oldMB = oldValue.toString();
                String newMB = newValue.toString();
                _logger.log(Level.FINE, "Got JmsService Master Broker change event " + event.getSource() + " " + eventName + " " + oldMB + " " + newMB);
                Server newMBServer = domain.getServerNamed(newMB);
                if (newMBServer != null) {
                    Node node = domain.getNodeNamed(newMBServer.getNodeRef());
                    String newMasterBrokerPort = JmsRaUtil.getJMSPropertyValue(newMBServer);
                    if (newMasterBrokerPort == null) {
                        newMasterBrokerPort = this.getDefaultJmsHost(this.jmsservice).getPort();
                    }
                    String newMasterBrokerHost = node.getNodeHost();
                    this.aresourceAdapter.setMasterBroker(newMasterBrokerHost + ":" + newMasterBrokerPort);
                }
            }
            if (eventName.equals("server-ref")) {
                String newServerRef;
                String oldServerRef = oldValue != null ? oldValue.toString() : null;
                String string = newServerRef = newValue != null ? newValue.toString() : null;
                if (oldServerRef != null && newServerRef == null) {
                    _logger.log(Level.FINE, "Got Cluster change event for server_ref" + event.getSource() + " " + eventName + " " + oldServerRef + " " + newServerRef);
                    String url = this.getBrokerList();
                    this.aresourceAdapter.setClusterBrokerList(url);
                    break;
                }
            }
            if (!(event.getSource() instanceof Server)) continue;
            _logger.log(Level.FINE, "In JMSConfigListener - recieved cluster event " + event.getSource());
            Server changedServer = (Server)event.getSource();
            if (thisServer.isDas()) {
                return null;
            }
            if (jmsProviderPort == null) continue;
            String nodeName = changedServer.getNodeRef();
            String nodeHost = null;
            if (nodeName != null) {
                nodeHost = domain.getNodeNamed(nodeName).getNodeHost();
            }
            String url = this.getBrokerList();
            url = url + ",mq://" + nodeHost + ":" + jmsProviderPort;
            this.aresourceAdapter.setClusterBrokerList(url);
            break;
        }
        return null;
    }

    private String getBrokerList() {
        MQAddressList addressList = new MQAddressList();
        try {
            addressList.setup(true);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "failed to create addresslist " + ex.getLocalizedMessage());
            ex.printStackTrace();
        }
        return addressList.toString();
    }

    private JmsHost getDefaultJmsHost(JmsService jmsService) {
        JmsHost jmsHost = null;
        String defaultJmsHostName = jmsService.getDefaultJmsHost();
        List jmsHostsList = jmsService.getJmsHost();
        for (int i = 0; i < jmsHostsList.size(); ++i) {
            JmsHost tmpJmsHost = (JmsHost)jmsHostsList.get(i);
            if (tmpJmsHost == null || !tmpJmsHost.getName().equals(defaultJmsHostName)) continue;
            jmsHost = tmpJmsHost;
        }
        if (jmsHost == null && jmsHostsList.size() > 0) {
            jmsHost = (JmsHost)jmsHostsList.get(0);
        }
        return jmsHost;
    }
}

