/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth.file;

import com.sun.messaging.jmq.auth.api.server.model.UserRepository;
import com.sun.messaging.jmq.auth.jaas.MQAdminGroup;
import com.sun.messaging.jmq.auth.jaas.MQGroup;
import com.sun.messaging.jmq.auth.jaas.MQUser;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.util.MD5;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.security.auth.Refreshable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

public class JMQFileUserRepository
implements UserRepository {
    public static final String TYPE = "file";
    public static final String PROP_FILENAME_SUFFIX = "file.filename";
    public static final String PROP_DIRPATH_SUFFIX = "file.dirpath";
    public static final String DEFAULT_PW_FILENAME = "passwd";
    private static boolean DEBUG = false;
    private transient Logger logger = Globals.getLogger();
    private static String ADMINGROUP = "admin";
    private String authType;
    private Properties authProps = null;

    public String getType() {
        return TYPE;
    }

    public void open(String string, Properties properties, Refreshable refreshable) throws LoginException {
        this.authType = string;
        this.authProps = properties;
    }

    public Subject findMatch(String string, Object object, Object object2, String string2) throws LoginException {
        if (string2 == null || !string2.equals("basic") && !string2.equals("digest")) {
            String string3 = string2 == null ? "null" : string2;
            Object[] objectArray = new String[]{string3, this.authType, this.getType(), "basic:digest"};
            throw new LoginException(Globals.getBrokerResources().getKString("B4079", objectArray));
        }
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        try {
            this.loadUserTable(hashMap, hashMap2);
        }
        catch (IOException iOException) {
            this.logger.logStack(32, iOException.getMessage(), (Throwable)iOException);
            hashMap = null;
            hashMap2 = null;
            throw new LoginException(iOException.getMessage());
        }
        Subject subject = null;
        if (string2.equals("basic")) {
            subject = this.basicFindMatch(string, (String)object, hashMap, hashMap2);
        } else if (string2.equals("digest")) {
            subject = this.digestFindMatch(string, (String)object, (String)object2, hashMap, hashMap2);
        }
        hashMap = null;
        hashMap2 = null;
        return subject;
    }

    private Subject basicFindMatch(String string, String string2, HashMap hashMap, HashMap hashMap2) throws LoginException {
        if (DEBUG) {
            this.logger.log(8, "basic matching[" + string + ":" + string2 + "]");
        }
        Subject subject = null;
        String string3 = (String)hashMap.get(string);
        if (string3 != null && string3.equals(MD5.getHashString((String)(string + ":" + string2)))) {
            subject = this.getSubject(string, hashMap2);
        }
        return subject;
    }

    private Subject digestFindMatch(String string, String string2, String string3, HashMap hashMap, HashMap hashMap2) throws LoginException {
        String string4;
        if (DEBUG) {
            this.logger.log(8, "digest matching " + string + "[" + string2 + ":" + string3 + "]");
        }
        Subject subject = null;
        String string5 = (String)hashMap.get(string);
        if (string5 != null && string2.equals(string4 = MD5.getHashString((String)(string5 + ":" + string3)))) {
            subject = this.getSubject(string, hashMap2);
        }
        return subject;
    }

    private Subject getSubject(String string, HashMap hashMap) {
        Subject subject = null;
        final String string2 = (String)hashMap.get(string);
        if (string2 != null && !string2.trim().equals("")) {
            final String string3 = string;
            subject = (Subject)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Subject subject = new Subject();
                    subject.getPrincipals().add(new MQUser(string3));
                    subject.getPrincipals().add(new MQGroup(string2));
                    if (string2.equals(ADMINGROUP)) {
                        subject.getPrincipals().add(new MQAdminGroup(ADMINGROUP));
                    }
                    return subject;
                }
            });
        }
        return subject;
    }

    private void loadUserTable(HashMap hashMap, HashMap hashMap2) throws IOException {
        String string = this.authProps.getProperty("imq.authentication." + this.authType + ".user_repository");
        if (string == null) {
            throw new IOException(Globals.getBrokerResources().getKString("B4041", this.authType));
        }
        if (!string.equals(TYPE)) {
            Object[] objectArray = new String[]{string, TYPE, this.getClass().getName()};
            throw new IOException(Globals.getBrokerResources().getKString("B4070", objectArray));
        }
        File file = JMQFileUserRepository.getPasswordFile(this.authProps);
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF8");
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ":", false);
                if (stringTokenizer.hasMoreTokens()) {
                    string6 = stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string5 = stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                }
                if (DEBUG) {
                    this.logger.log(8, "passwd entry " + string6 + ":" + string5 + ":" + string4 + ":" + string3);
                }
                if (string6 == null || string5 == null || string4 == null || string3 == null || !string3.equals("1")) continue;
                hashMap.put(string6, string5);
                hashMap2.put(string6, string4);
            }
            bufferedReader.close();
            inputStreamReader.close();
        }
        catch (IOException iOException) {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            IOException iOException3 = new IOException(Globals.getBrokerResources().getKString("B3052", file.toString(), iOException.getMessage()));
            iOException3.initCause(iOException);
            throw iOException3;
        }
    }

    public Refreshable getCacheData() {
        return null;
    }

    public void close() throws LoginException {
    }

    public static File getPasswordFile(Properties properties) {
        String string = properties.getProperty("imq.user_repository.file.dirpath", Globals.getInstanceEtcDir());
        string = StringUtil.expandVariables((String)string, (Properties)properties);
        String string2 = properties.getProperty("imq.user_repository.file.filename", DEFAULT_PW_FILENAME);
        String string3 = string + File.separator + string2;
        return new File(string3);
    }
}

