/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerStateDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MessageDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class OracleMessageDAOImpl
extends MessageDAOImpl {
    OracleMessageDAOImpl() throws BrokerException {
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("MESSAGE_SIZE").append(", ").append("STORE_SESSION_ID").append(", ").append("DESTINATION_ID").append(", ").append("TRANSACTION_ID").append(", ").append("CREATED_TS").append(", ").append("MESSAGE").append(") VALUES ( ?, ?, ?, ?, ?, ?, EMPTY_BLOB() )").toString();
        this.updateDestinationSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("DESTINATION_ID").append(" = ?, ").append("MESSAGE_SIZE").append(" = ? ").append(" WHERE ").append("ID").append(" = ?").toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insert(Connection connection, String string, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, long l, long l2, boolean bl) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        boolean bl2;
        block24: {
            block22: {
                block23: {
                    bl2 = false;
                    preparedStatement = null;
                    exception = null;
                    try {
                        try {
                            DBManager dBManager = DBManager.getDBManager();
                            if (!dBManager.isOracleDriver()) {
                                super.insert(connection, string, packet, consumerUIDArray, nArray, l, l2, bl);
                                Object var25_14 = null;
                                if (!bl2) break block22;
                                break block23;
                            }
                            if (connection == null) {
                                connection = dBManager.getConnection(false);
                                bl2 = true;
                            }
                            SysMessageID sysMessageID = packet.getSysMessageID();
                            String string2 = sysMessageID.getUniqueName();
                            int n = packet.getPacketSize();
                            long l3 = packet.getTransactionID();
                            if (string == null) {
                                string = DestinationUID.getUniqueString(packet.getDestination(), packet.getIsQueue());
                            }
                            if (bl) {
                                if (this.hasMessage(connection, string2)) {
                                    throw new BrokerException(this.br.getKString("B3008", string2, string));
                                }
                                dBManager.getDAOFactory().getDestinationDAO().checkDestination(connection, string);
                            }
                            String string3 = this.insertSQL;
                            try {
                                preparedStatement = connection.prepareStatement(string3);
                                preparedStatement.setString(1, string2);
                                preparedStatement.setInt(2, n);
                                preparedStatement.setLong(3, l);
                                preparedStatement.setString(4, string);
                                Util.setLong(preparedStatement, 5, l3 == 0L ? -1L : l3);
                                preparedStatement.setLong(6, l2);
                                preparedStatement.executeUpdate();
                                preparedStatement.close();
                                string3 = this.selectForUpdateSQL;
                                preparedStatement = connection.prepareStatement(string3);
                                preparedStatement.setString(1, string2);
                                ResultSet resultSet = preparedStatement.executeQuery();
                                resultSet.next();
                                Blob blob = resultSet.getBlob(1);
                                resultSet.close();
                                preparedStatement.close();
                                OutputStream outputStream = Util.OracleBLOB_getBinaryOutputStream(blob);
                                packet.writePacket(outputStream);
                                outputStream.close();
                                if (consumerUIDArray != null) {
                                    dBManager.getDAOFactory().getConsumerStateDAO().insert(connection, string, sysMessageID, consumerUIDArray, nArray, false);
                                }
                                if (bl2) {
                                    connection.commit();
                                }
                                break block24;
                            }
                            catch (Exception exception2) {
                                Exception exception3;
                                exception = exception2;
                                try {
                                    if (connection != null && !connection.getAutoCommit()) {
                                        connection.rollback();
                                    }
                                }
                                catch (SQLException sQLException) {
                                    this.logger.log(32, "B4080", (Throwable)sQLException);
                                }
                                if (exception2 instanceof BrokerException) {
                                    throw (BrokerException)exception2;
                                }
                                if (exception2 instanceof IOException) {
                                    exception3 = DBManager.wrapIOException("[" + this.insertSQL + "]", (IOException)exception2);
                                    throw new BrokerException(this.br.getKString("B4004", string2), exception3);
                                }
                                if (exception2 instanceof SQLException) {
                                    exception3 = DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)exception2);
                                    throw new BrokerException(this.br.getKString("B4004", string2), exception3);
                                }
                                exception3 = exception2;
                                throw new BrokerException(this.br.getKString("B4004", string2), exception3);
                            }
                        }
                        catch (BrokerException brokerException) {
                            exception = brokerException;
                            throw brokerException;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var25_16 = null;
                        if (bl2) {
                            Util.close(null, preparedStatement, connection, exception);
                            throw throwable;
                        }
                        Util.close(null, preparedStatement, null, exception);
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection, exception);
                return;
            }
            Util.close(null, preparedStatement, null, exception);
            return;
        }
        Object var25_15 = null;
        if (bl2) {
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void moveMessage(Connection connection, Packet packet, DestinationUID destinationUID, DestinationUID destinationUID2, ConsumerUID[] consumerUIDArray, int[] nArray) throws IOException, BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        boolean bl;
        block18: {
            block16: {
                block17: {
                    SysMessageID sysMessageID = (SysMessageID)packet.getSysMessageID().clone();
                    String string = sysMessageID.getUniqueName();
                    int n = packet.getPacketSize();
                    bl = false;
                    preparedStatement = null;
                    String string2 = this.selectForUpdateSQL;
                    exception = null;
                    try {
                        try {
                            DBManager dBManager = DBManager.getDBManager();
                            if (!dBManager.isOracleDriver()) {
                                super.moveMessage(connection, packet, destinationUID, destinationUID2, consumerUIDArray, nArray);
                                Object var20_16 = null;
                                if (!bl) break block16;
                                break block17;
                            }
                            if (connection == null) {
                                connection = dBManager.getConnection(false);
                                bl = true;
                            }
                            preparedStatement = connection.prepareStatement(string2);
                            preparedStatement.setString(1, string);
                            ResultSet resultSet = preparedStatement.executeQuery();
                            if (!resultSet.next()) {
                                throw new BrokerException(this.br.getKString("B3007", string, destinationUID), 404);
                            }
                            Blob blob = resultSet.getBlob(1);
                            resultSet.close();
                            preparedStatement.close();
                            OutputStream outputStream = Util.OracleBLOB_getBinaryOutputStream(blob);
                            packet.writePacket(outputStream);
                            outputStream.close();
                            string2 = this.updateDestinationSQL;
                            preparedStatement = connection.prepareStatement(string2);
                            preparedStatement.setString(1, destinationUID2.toString());
                            preparedStatement.setInt(2, n);
                            preparedStatement.setString(3, string);
                            preparedStatement.executeUpdate();
                            ConsumerStateDAO consumerStateDAO = dBManager.getDAOFactory().getConsumerStateDAO();
                            consumerStateDAO.deleteByMessageID(connection, sysMessageID);
                            if (consumerUIDArray != null || nArray != null) {
                                consumerStateDAO.insert(connection, destinationUID2.toString(), sysMessageID, consumerUIDArray, nArray, false);
                            }
                            if (bl) {
                                connection.commit();
                            }
                            break block18;
                        }
                        catch (Exception exception2) {
                            exception = exception2;
                            try {
                                if (connection != null && !connection.getAutoCommit()) {
                                    connection.rollback();
                                }
                            }
                            catch (SQLException sQLException) {
                                this.logger.log(32, "B4080", (Throwable)sQLException);
                            }
                            if (exception2 instanceof BrokerException) {
                                throw (BrokerException)exception2;
                            }
                            Exception exception3 = exception2 instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateDestinationSQL + "]", (SQLException)exception2) : exception2;
                            Object[] objectArray = new Object[]{string, destinationUID, destinationUID2};
                            throw new BrokerException(this.br.getKString("B4187", objectArray), exception3);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var20_18 = null;
                        if (bl) {
                            Util.close(null, preparedStatement, connection, exception);
                            throw throwable;
                        }
                        Util.close(null, preparedStatement, null, exception);
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection, exception);
                return;
            }
            Util.close(null, preparedStatement, null, exception);
            return;
        }
        Object var20_17 = null;
        if (bl) {
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }
}

